/*
 * Decompiled with CFR 0.152.
 */
package bluedart.utils;

import bluedart.client.fx.FXDisney;
import bluedart.client.fx.FXWindWaker;
import bluedart.proxy.Proxies;
import bluedart.proxy.ProxyCommon;
import bluedart.utils.DartUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import java.util.Random;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.particle.EntityFireworkStarterFX;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;

public class FXUtils {
    public static Random rand = new Random();

    public static void makeEnderEffects(Entity entity, double prevX, double prevY, double prevZ, int number, boolean sound) {
        World world = entity.field_70170_p;
        if (!Proxies.common.isSimulating(world)) {
            for (int i = 0; i < number; ++i) {
                double var19 = (double)i / ((double)number - 1.0);
                float var21 = (ProxyCommon.rand.nextFloat() - 0.5f) * 0.2f;
                float var22 = (ProxyCommon.rand.nextFloat() - 0.5f) * 0.2f;
                float var23 = (ProxyCommon.rand.nextFloat() - 0.5f) * 0.2f;
                double var24 = prevX + (entity.field_70165_t - prevX) * var19 + (ProxyCommon.rand.nextDouble() - 0.5) * (double)entity.field_70130_N * 2.0;
                double var26 = prevY + (entity.field_70163_u - prevY) * var19 + ProxyCommon.rand.nextDouble() * (double)entity.field_70131_O;
                double var28 = prevZ + (entity.field_70161_v - prevZ) * var19 + (ProxyCommon.rand.nextDouble() - 0.5) * (double)entity.field_70130_N * 2.0;
                world.func_72869_a("portal", var24, var26, var28, (double)var21, (double)var22, (double)var23);
            }
        } else if (sound) {
            world.func_72908_a(prevX, prevY, prevZ, "mob.endermen.portal", 2.0f, DartUtils.randomPitch());
            world.func_72956_a(entity, "mob.endermen.portal", 2.0f, DartUtils.randomPitch());
        }
    }

    public static void makeEnderEffects(Entity entity, double posX, double posY, double posZ, double prevX, double prevY, double prevZ, int number, boolean sound) {
        if (!Proxies.common.isSimulating(entity.field_70170_p)) {
            for (int i = 0; i < number; ++i) {
                double var19 = (double)i / ((double)number - 1.0);
                float var21 = (ProxyCommon.rand.nextFloat() - 0.5f) * 0.2f;
                float var22 = (ProxyCommon.rand.nextFloat() - 0.5f) * 0.2f;
                float var23 = (ProxyCommon.rand.nextFloat() - 0.5f) * 0.2f;
                double var24 = prevX + (posX - prevX) * var19 + (ProxyCommon.rand.nextDouble() - 0.5) * (double)entity.field_70130_N * 2.0;
                double var26 = prevY + (posY - prevY) * var19 + ProxyCommon.rand.nextDouble() * (double)entity.field_70131_O;
                double var28 = prevZ + (posZ - prevZ) * var19 + (ProxyCommon.rand.nextDouble() - 0.5) * (double)entity.field_70130_N * 2.0;
                entity.field_70170_p.func_72869_a("portal", var24, var26, var28, (double)var21, (double)var22, (double)var23);
            }
        } else if (sound) {
            entity.field_70170_p.func_72908_a(prevX, prevY, prevZ, "mob.endermen.portal", 2.0f, 1.0f);
            entity.field_70170_p.func_72956_a(entity, "mob.endermen.portal", 2.0f, 1.0f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void makeChangeEffects(World world, double x2, double y2, double z2, int type, int particles) {
        float modifier = 0.5f;
        float velModifier = 1.0f;
        EffectRenderer renderer = Proxies.common.getClientInstance().field_71452_i;
        for (int i = 0; i < particles; ++i) {
            float x = (float)(x2 + (double)(ProxyCommon.rand.nextFloat() * modifier) - (double)(modifier / 2.0f));
            float y = (float)(y2 + (double)(ProxyCommon.rand.nextFloat() * modifier) - (double)(modifier / 2.0f));
            float z = (float)(z2 + (double)(ProxyCommon.rand.nextFloat() * modifier) - (double)(modifier / 2.0f));
            renderer.func_78873_a((EntityFX)new FXWindWaker(world, x, y, z, 0xFFFFFF, type));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void makeWingEffects(World world, double x, double y, double z, int particles) {
        EffectRenderer renderer = Proxies.common.getClientInstance().field_71452_i;
        float modifier = 1.0f;
        for (int i = 0; i < particles; ++i) {
            float x2 = (float)(x + (double)(ProxyCommon.rand.nextFloat() * modifier));
            float y2 = (float)(y + (double)(ProxyCommon.rand.nextFloat() * modifier));
            float z2 = (float)(z + (double)(ProxyCommon.rand.nextFloat() * modifier));
            renderer.func_78873_a((EntityFX)new FXWindWaker(world, x2, y2, z2, 58623, 0));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void makeSkateEffects(World world, double x, double y, double z, int particles) {
        EffectRenderer renderer = Proxies.common.getClientInstance().field_71452_i;
        float modifier = 1.0f;
        for (int i = 0; i < particles; ++i) {
            float x2 = (float)(x + (double)(ProxyCommon.rand.nextFloat() * modifier));
            float y2 = (float)(y + (double)(ProxyCommon.rand.nextFloat() * modifier));
            float z2 = (float)(z + (double)(ProxyCommon.rand.nextFloat() * modifier));
            renderer.func_78873_a((EntityFX)new FXWindWaker(world, x2, y2, z2, 58623, 3));
        }
    }

    public static void spawnFlameFX(World world, int x, int y, int z) {
        for (int i = 0; i < 10; ++i) {
            float posX = (float)x + world.field_73012_v.nextFloat() * 1.0f;
            float posY = (float)y + world.field_73012_v.nextFloat() * 1.0f;
            float posZ = (float)z + world.field_73012_v.nextFloat() * 1.0f;
            world.func_72869_a("flame", (double)posX, (double)posY, (double)posZ, 0.0, 0.0, 0.0);
        }
    }

    public static void makeBreakFX(World world, int x, int y, int z) {
        for (int i = 0; i < 10; ++i) {
            float posX = (float)x + world.field_73012_v.nextFloat() * 1.0f;
            float posY = (float)y + world.field_73012_v.nextFloat() * 1.0f;
            float posZ = (float)z + world.field_73012_v.nextFloat() * 1.0f;
            world.func_72869_a("portal", (double)posX, (double)posY, (double)posZ, 0.0, 0.0, 0.0);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawTexturedQuad(int par1, int par2, int par3, int par4, int par5, int par6, double zLevel) {
        float var7 = 0.0039063f;
        float var8 = 0.0039063f;
        Tessellator tessy = Tessellator.field_78398_a;
        tessy.func_78382_b();
        tessy.func_78374_a((double)(par1 + 0), (double)(par2 + par6), zLevel, (double)((float)(par3 + 0) * var7), (double)((float)(par4 + par6) * var8));
        tessy.func_78374_a((double)(par1 + par5), (double)(par2 + par6), zLevel, (double)((float)(par3 + par5) * var7), (double)((float)(par4 + par6) * var8));
        tessy.func_78374_a((double)(par1 + par5), (double)(par2 + 0), zLevel, (double)((float)(par3 + par5) * var7), (double)((float)(par4 + 0) * var8));
        tessy.func_78374_a((double)(par1 + 0), (double)(par2 + 0), zLevel, (double)((float)(par3 + 0) * var7), (double)((float)(par4 + 0) * var8));
        tessy.func_78381_a();
    }

    @SideOnly(value=Side.CLIENT)
    public static void makeShiny(World world, double x, double y, double z, int type, int color, int num, boolean add) {
        EffectRenderer renderer = Proxies.common.getClientInstance().field_71452_i;
        double offset = 0.0;
        if (add) {
            offset += 0.5;
        }
        for (int i = 0; i < num; ++i) {
            FXDisney fx = new FXDisney(world, x + offset + world.field_73012_v.nextDouble() - world.field_73012_v.nextDouble(), y + world.field_73012_v.nextDouble() - world.field_73012_v.nextDouble(), z + offset + world.field_73012_v.nextDouble() - world.field_73012_v.nextDouble(), color, type);
            renderer.func_78873_a((EntityFX)fx);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void randomFireworkAt(World world, int x, int y, int z) {
        EffectRenderer renderer = Proxies.common.getClientInstance().field_71452_i;
        NBTTagCompound comp = new NBTTagCompound();
        NBTTagList fireworks = new NBTTagList();
        for (int i = 0; i < world.field_73012_v.nextInt(5) + 1; ++i) {
            NBTTagCompound tempComp = new NBTTagCompound();
            tempComp.func_74757_a("Flicker", world.field_73012_v.nextBoolean());
            tempComp.func_74757_a("Trails", world.field_73012_v.nextBoolean());
            tempComp.func_74783_a("Colors", FXUtils.randomColorArray());
            tempComp.func_74783_a("FadeColors", FXUtils.randomColorArray());
            fireworks.func_74742_a((NBTBase)tempComp);
        }
        comp.func_74782_a("Explosions", (NBTBase)fireworks);
        EntityFireworkStarterFX fx = new EntityFireworkStarterFX(world, (double)x, (double)y, (double)z, 0.0, 0.0, 0.0, renderer, comp);
        renderer.func_78873_a((EntityFX)fx);
    }

    @SideOnly(value=Side.CLIENT)
    public static void wrathAt(World world, int x, int y, int z) {
        EntityLightningBolt bolt = new EntityLightningBolt(world, (double)x, (double)y, (double)z);
        world.func_72838_d((Entity)bolt);
    }

    public static int[] randomColorArray() {
        int size = 16;
        int[] colors = new int[size];
        for (int i = 0; i < size; ++i) {
            colors[i] = FXUtils.randomColor();
        }
        return colors;
    }

    public static int randomColor() {
        int color = (int)((float)rand.nextInt(256) * (rand.nextFloat() * 0.2f + 0.9f)) << 16 | (int)((float)rand.nextInt(256) * (rand.nextFloat() * 0.2f + 0.9f)) << 8 | (int)((float)rand.nextInt(256) * (rand.nextFloat() * 0.2f + 0.9f));
        System.out.println("Color: " + color);
        return color;
    }

    public static int randomParticleColor() {
        int color = Color.yellow.getRGB();
        switch (rand.nextInt(6)) {
            case 0: {
                color = Color.blue.getRGB();
                break;
            }
            case 1: {
                color = Color.pink.getRGB();
                break;
            }
            case 2: {
                color = Color.red.getRGB();
                break;
            }
            case 3: {
                color = Color.magenta.getRGB();
                break;
            }
            case 4: {
                color = Color.green.getRGB();
            }
        }
        return color;
    }
}

