/*
 * Decompiled with CFR 0.152.
 */
package bluedart.utils;

import bluedart.api.DartAPI;
import bluedart.api.ForceTransmutation;
import bluedart.api.IForceUpgradable;
import bluedart.api.IForceUpgrade;
import bluedart.api.IForceWildCard;
import bluedart.api.ISocketableTool;
import bluedart.block.DartBlock;
import bluedart.client.ticker.WingMeter;
import bluedart.core.Config;
import bluedart.core.Constants;
import bluedart.core.network.DartPacket;
import bluedart.core.network.FXPacket;
import bluedart.entity.EntityEnderTot;
import bluedart.entity.EntityInvincibleItem;
import bluedart.gui.CraftingContainer;
import bluedart.item.DartItem;
import bluedart.item.ElectricTool;
import bluedart.item.ItemForceArmor;
import bluedart.item.ItemForceFlask;
import bluedart.item.tool.ItemForceBelt;
import bluedart.item.tool.ItemForcePack;
import bluedart.item.tool.ItemLootBag;
import bluedart.item.tool.ItemMemberCard;
import bluedart.proxy.Proxies;
import bluedart.proxy.ProxyCommon;
import bluedart.utils.InventoryUtils;
import bluedart.utils.ItemInventory;
import bluedart.utils.SocketHelper;
import bluedart.utils.UpgradeHelper;
import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.tools.IToolWrench;
import com.google.common.base.Objects;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.network.PacketDispatcher;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.recipe.Recipes;
import ic2.core.Ic2Items;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.liquids.LiquidContainerRegistry;
import net.minecraftforge.liquids.LiquidStack;
import thermalexpansion.api.crafting.CraftingManagers;
import thermalexpansion.api.crafting.IPulverizerRecipe;
import thermalexpansion.api.crafting.ISawmillRecipe;

public class DartUtils {
    public static Random rand = new Random();

    public static String enchantName(int num) {
        switch (num) {
            case 1: {
                return " I";
            }
            case 2: {
                return " II";
            }
            case 3: {
                return " III";
            }
            case 4: {
                return " IV";
            }
            case 5: {
                return " V";
            }
            case 6: {
                return " VI";
            }
            case 7: {
                return " VII";
            }
            case 8: {
                return " VIII";
            }
        }
        return "";
    }

    public static boolean addItemStackToInventory(IInventory inv, ItemStack stack) {
        ItemStack invStack;
        int i;
        for (i = 0; i < inv.func_70302_i_(); ++i) {
            int defecit;
            if (!inv.func_94041_b(i, stack) || !DartUtils.areStacksSame(invStack = inv.func_70301_a(i), stack) || (defecit = invStack.func_77976_d() - invStack.field_77994_a) <= 0) continue;
            if (stack.field_77994_a > defecit) {
                invStack.field_77994_a += defecit;
                stack.field_77994_a -= defecit;
                continue;
            }
            invStack.field_77994_a += stack.field_77994_a;
            stack.field_77994_a = 0;
            return true;
        }
        for (i = 0; i < inv.func_70302_i_(); ++i) {
            if (!inv.func_94041_b(i, stack) || (invStack = inv.func_70301_a(i)) != null) continue;
            inv.func_70299_a(i, stack.func_77946_l());
            stack.field_77994_a = 0;
            return true;
        }
        return false;
    }

    public static boolean areStacksSame(ItemStack stack1, ItemStack stack2) {
        if (stack1 == null || stack2 == null) {
            return false;
        }
        return stack1.field_77993_c == stack2.field_77993_c && stack1.func_77960_j() == stack2.func_77960_j() && Objects.equal((Object)stack1.func_77978_p(), (Object)stack2.func_77978_p());
    }

    public static NBTTagCompound getRandomLootBag(int tier) {
        if (tier > 3) {
            tier = 3;
        }
        if (tier < 1) {
            tier = 1;
        }
        ItemStack loot = new ItemStack((Item)DartItem.lootBag);
        loot.func_77982_d(new NBTTagCompound());
        NBTTagCompound comp = loot.func_77978_p();
        comp.func_74768_a("size", 8);
        NBTTagList contents = new NBTTagList();
        for (int i = 0; i < 8; ++i) {
            NBTTagCompound itemComp = new NBTTagCompound();
            itemComp.func_74774_a("Slot", (byte)i);
            contents.func_74742_a((NBTBase)itemComp);
        }
        comp.func_74782_a("contents", (NBTBase)contents);
        ItemInventory inv = new ItemInventory(8, loot);
        String[][] types = new String[][]{{"bonusChest", "villageBlacksmith"}, {"dungeonChest", "strongholdCrossing", "pyramidDesertyChest", "pyramidJungleChest"}, {"mineshaftCorridor", "strongholdCorridor", "strongholdLibrary"}};
        int num = 5 + rand.nextInt(1 + tier);
        for (int i = 0; i < num; ++i) {
            if (i >= inv.func_70302_i_()) continue;
            ItemStack tempStack = null;
            while ((tempStack = ChestGenHooks.getOneItem((String)types[tier - 1][rand.nextInt(types[tier - 1].length)], (Random)rand)).func_77973_b() instanceof ItemLootBag) {
            }
            inv.func_70299_a(i, tempStack);
        }
        inv.save();
        return loot.func_77978_p();
    }

    public static boolean blacklistTile(String name) {
        try {
            Class<?> blacklist = Class.forName(name);
            DartAPI.blacklistTile(blacklist);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }

    public static void baneEntity(EntityLiving entity) {
        if (entity instanceof EntityEnderman || entity instanceof EntityCreeper) {
            // empty if block
        }
        if (entity instanceof EntityEnderTot) {
            // empty if block
        }
    }

    public static boolean isAllowedInPack(ItemStack stack) {
        if (stack == null) {
            return true;
        }
        if (DartItem.packBlacklist != null && DartItem.packBlacklist.size() > 0) {
            for (ItemStack tempStack : DartItem.packBlacklist) {
                if (tempStack == null || tempStack.field_77993_c != stack.field_77993_c) continue;
                return false;
            }
        }
        return true;
    }

    public static int getMcColor(int color) {
        switch (color) {
            case 0: {
                return 0x333333;
            }
            case 1: {
                return Color.red.getRGB();
            }
            case 2: {
                return Color.green.getRGB();
            }
            case 3: {
                return 7230260;
            }
            case 4: {
                return Color.blue.getRGB();
            }
            case 5: {
                return 7030712;
            }
            case 6: {
                return Color.cyan.getRGB();
            }
            case 7: {
                return Color.lightGray.getRGB();
            }
            case 8: {
                return Color.gray.getRGB();
            }
            case 9: {
                return Color.pink.getRGB();
            }
            case 10: {
                return 10410051;
            }
            case 11: 
            case 16: {
                return Color.yellow.getRGB();
            }
            case 12: {
                return 5351668;
            }
            case 13: {
                return Color.magenta.getRGB();
            }
            case 14: {
                return Color.orange.getRGB();
            }
            case 15: {
                return Color.white.getRGB();
            }
        }
        return 0;
    }

    public static boolean isWildCard(ItemStack stack) {
        return DartUtils.getWildCard(stack) != null;
    }

    public static IForceWildCard getWildCard(ItemStack stack) {
        IForceWildCard card = null;
        if (DartAPI.wildCards != null && DartAPI.wildCards.size() > 0) {
            for (IForceWildCard check : DartAPI.wildCards) {
                if ((stack == null || check.ignoreMeta() || !ItemStack.func_77989_b((ItemStack)check.getInput(), (ItemStack)new ItemStack(stack.func_77973_b(), 1, stack.func_77960_j()))) && (!check.ignoreMeta() || stack.field_77993_c != check.getInput().field_77993_c)) continue;
                card = check;
                break;
            }
        }
        return card;
    }

    public static boolean isUpgradeValidForWildCard(IForceUpgrade upgrade, ItemStack stack) {
        IForceWildCard card = DartUtils.getWildCard(stack);
        if (card != null && card.getUpgrades() != null && card.getUpgrades().length > 0) {
            for (IForceUpgrade upCheck : card.getUpgrades()) {
                if (!upCheck.equals(upgrade)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isBlockOre(int blockID) {
        if (blockID == Block.field_71949_H.field_71990_ca || blockID == Block.field_71941_G.field_71990_ca || blockID == Block.field_72073_aw.field_71990_ca || blockID == Block.field_71947_N.field_71990_ca || blockID == Block.field_71950_I.field_71990_ca) {
            return true;
        }
        if (blockID == DartBlock.powerOre.field_71990_ca) {
            return true;
        }
        return Loader.isModLoaded((String)"IC2") && (blockID == Ic2Items.copperOre.field_77993_c || blockID == Ic2Items.tinOre.field_77993_c || blockID == Ic2Items.uraniumOre.field_77993_c);
    }

    public static boolean isDrill(ItemStack stack) {
        if (DartItem.miningDrill == null || DartItem.diamondDrill == null || DartItem.chainsaw == null) {
            return false;
        }
        return stack.field_77993_c == DartItem.miningDrill.field_77993_c || stack.field_77993_c == DartItem.diamondDrill.field_77993_c || stack.field_77993_c == DartItem.chainsaw.field_77993_c;
    }

    public static NBTTagCompound simulateEnchant(int type, int level) {
        NBTTagCompound realEnch = new NBTTagCompound();
        realEnch.func_74777_a("id", (short)type);
        realEnch.func_74777_a("lvl", (short)level);
        return realEnch;
    }

    public static int canPlayerUseFlask(EntityPlayer player, boolean use) {
        for (int i = 0; i < 9; ++i) {
            ItemStack tempStack = player.field_71071_by.field_70462_a[i];
            if (tempStack == null || !(tempStack.func_77973_b() instanceof ItemForceBelt)) continue;
            ItemInventory inv = new ItemInventory(8, tempStack);
            for (int j = 0; j < inv.func_70302_i_(); ++j) {
                ItemStack checkStack = inv.func_70301_a(j);
                if (checkStack == null || !(checkStack.func_77973_b() instanceof ItemForceFlask)) continue;
                if (use) {
                    inv.func_70298_a(j, 1);
                    inv.onGuiSaved(player);
                }
                return 2;
            }
        }
        if (player.field_71071_by.func_70450_e(DartItem.forceFlask.field_77779_bT)) {
            if (use) {
                player.field_71071_by.func_70435_d(DartItem.forceFlask.field_77779_bT);
            }
            return 1;
        }
        return 0;
    }

    public static void damageForceArmor(EntityPlayer player, int damage) {
        for (int i = 0; i < damage; ++i) {
            int slot = 0;
            for (ItemStack armor : player.field_71071_by.field_70460_b) {
                if (armor != null && armor.func_77973_b() instanceof ItemForceArmor) {
                    NBTTagCompound upgrades = UpgradeHelper.getUpgradeCompound(armor);
                    if (upgrades.func_74764_b("Charge") || upgrades.func_74764_b("Charge2")) {
                        ItemForceArmor eItem = (ItemForceArmor)armor.func_77973_b();
                        eItem.discharge(armor, 100, 2, true, false);
                    } else {
                        if (armor.func_77958_k() > armor.func_77960_j()) {
                            armor.func_77972_a(1, (EntityLiving)player);
                        }
                        if (armor.func_77960_j() >= armor.func_77958_k()) {
                            player.func_70669_a(armor);
                            MinecraftForge.EVENT_BUS.post((Event)new PlayerDestroyItemEvent(player, armor.func_77946_l()));
                            player.field_71071_by.field_70460_b[slot] = null;
                            player.field_70170_p.func_72956_a((Entity)player, "random.break", 1.0f, DartUtils.randomPitch());
                        }
                    }
                }
                ++slot;
            }
        }
    }

    public static int getItemCountInInventory(EntityPlayer player, ItemStack stack) {
        if (player == null || stack == null) {
            return 0;
        }
        int count = 0;
        for (ItemStack check : player.field_71071_by.field_70462_a) {
            if (check == null || check.field_77993_c != stack.field_77993_c || check.func_77960_j() != stack.func_77960_j()) continue;
            count += check.field_77994_a;
        }
        return count;
    }

    public static ArrayList retrieveCards(ItemInventory inv) {
        ArrayList<ItemStack> cards = new ArrayList<ItemStack>();
        if (inv != null && inv.func_70302_i_() > 0) {
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack tempStack = inv.func_70301_a(i);
                if (tempStack == null || !(tempStack.func_77973_b() instanceof ItemMemberCard) || !tempStack.func_77942_o()) continue;
                cards.add(tempStack);
            }
        }
        return cards;
    }

    public static void damageTool(EntityPlayer player, ItemStack stack, int damage) {
        if (stack.func_77981_g() || player == null || stack == null || damage == 0) {
            return;
        }
        if (stack.func_77973_b() instanceof IElectricItem && Loader.isModLoaded((String)"IC2")) {
            for (int i = 0; i < damage; ++i) {
                if (!(stack.func_77973_b() instanceof ElectricTool) || ElectricItem.use(stack, ((ElectricTool)stack.func_77973_b()).getOperationCost(stack), player)) continue;
                return;
            }
        } else {
            for (int i = 0; i < damage; ++i) {
                NBTTagCompound upgrades = UpgradeHelper.getUpgradeCompound(stack);
                if (upgrades.func_74764_b("Sturdy") && (float)upgrades.func_74762_e("Sturdy") * 0.25f > player.field_70170_p.field_73012_v.nextFloat()) continue;
                if (stack != null && stack.field_77994_a > 0 && stack.func_77960_j() <= stack.func_77958_k()) {
                    stack.func_77972_a(1, (EntityLiving)player);
                }
                if (stack == null || stack.field_77994_a != 0 && stack.func_77960_j() <= stack.func_77958_k()) continue;
                if (player.func_71045_bC() != null) {
                    try {
                        player.func_71028_bD();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                return;
            }
        }
    }

    public static ItemStack bottleEntity(Entity victim) {
        String entityName = EntityList.func_75621_b((Entity)victim);
        if (entityName == null) {
            return null;
        }
        ItemStack bottleStack = new ItemStack((Item)DartItem.entityBottle);
        NBTTagCompound bottleComp = new NBTTagCompound();
        victim.func_70109_d(bottleComp);
        bottleComp.func_82580_o("CanPickUpLoot");
        bottleComp.func_82580_o("OnGround");
        bottleComp.func_82580_o("PersistenceRequired");
        bottleComp.func_82580_o("Dimension");
        bottleComp.func_82580_o("PortalCooldown");
        bottleComp.func_82580_o("UUIDLeast");
        bottleComp.func_82580_o("UUIDMost");
        bottleComp.func_82580_o("DropChances");
        bottleComp.func_82580_o("Motion");
        bottleComp.func_82580_o("Pos");
        bottleComp.func_82580_o("Rotation");
        NBTTagDouble dummyDouble = new NBTTagDouble("", 0.0);
        NBTTagFloat dummyFloat = new NBTTagFloat("", 0.0f);
        NBTTagList motion = new NBTTagList();
        motion.func_74742_a(dummyDouble.func_74737_b());
        motion.func_74742_a(dummyDouble.func_74737_b());
        motion.func_74742_a(dummyDouble.func_74737_b());
        NBTTagList rot = new NBTTagList();
        rot.func_74742_a(dummyFloat.func_74737_b());
        rot.func_74742_a(dummyFloat.func_74737_b());
        bottleComp.func_74782_a("Pos", motion.func_74737_b());
        bottleComp.func_74782_a("Motion", motion.func_74737_b());
        bottleComp.func_74782_a("Rotation", rot.func_74737_b());
        bottleComp.func_74778_a("id", entityName);
        bottleComp.func_74778_a("dartName", victim.func_70023_ak());
        bottleStack.func_77982_d(bottleComp);
        return bottleStack;
    }

    public static void dropInvincibleItem(ItemStack stack, World world, double x, double y, double z) {
        if (stack != null && Proxies.common.isSimulating(world)) {
            float xRand = ProxyCommon.rand.nextFloat() * 0.2f + 0.1f;
            float yRand = ProxyCommon.rand.nextFloat() * 0.8f + 0.1f;
            float zRand = ProxyCommon.rand.nextFloat() * 0.2f + 0.1f;
            while (stack.field_77994_a > 0) {
                int randInt = ProxyCommon.rand.nextInt(21) + 10;
                if (randInt > stack.field_77994_a) {
                    randInt = stack.field_77994_a;
                }
                stack.field_77994_a -= randInt;
                EntityInvincibleItem droppedItem = new EntityInvincibleItem(world, (float)x + xRand, (float)y + yRand, (float)z + zRand, new ItemStack(stack.field_77993_c, randInt, stack.func_77960_j()));
                if (stack.func_77942_o()) {
                    droppedItem.func_92059_d().func_77982_d((NBTTagCompound)stack.func_77978_p().func_74737_b());
                }
                float modifier = 0.025f;
                droppedItem.field_70159_w = (float)ProxyCommon.rand.nextGaussian() * modifier;
                droppedItem.field_70181_x = (float)ProxyCommon.rand.nextGaussian() * modifier + 0.2f;
                droppedItem.field_70179_y = (float)ProxyCommon.rand.nextGaussian() * modifier;
                droppedItem.field_70293_c = 10;
                world.func_72838_d((Entity)droppedItem);
            }
        }
    }

    public static void dropItem(ItemStack stack, World world, double x, double y, double z) {
        if (stack != null && Proxies.common.isSimulating(world)) {
            float xRand = ProxyCommon.rand.nextFloat() * 0.2f + 0.1f;
            float yRand = ProxyCommon.rand.nextFloat() * 0.8f + 0.1f;
            float zRand = ProxyCommon.rand.nextFloat() * 0.2f + 0.1f;
            while (stack.field_77994_a > 0) {
                int randInt = ProxyCommon.rand.nextInt(21) + 10;
                if (randInt > stack.field_77994_a) {
                    randInt = stack.field_77994_a;
                }
                stack.field_77994_a -= randInt;
                EntityItem droppedItem = new EntityItem(world, (double)((float)x + xRand), (double)((float)y + yRand), (double)((float)z + zRand), new ItemStack(stack.field_77993_c, randInt, stack.func_77960_j()));
                if (stack.func_77942_o()) {
                    droppedItem.func_92059_d().func_77982_d((NBTTagCompound)stack.func_77978_p().func_74737_b());
                }
                float modifier = 0.025f;
                droppedItem.field_70159_w = (float)ProxyCommon.rand.nextGaussian() * modifier;
                droppedItem.field_70181_x = (float)ProxyCommon.rand.nextGaussian() * modifier + 0.2f;
                droppedItem.field_70179_y = (float)ProxyCommon.rand.nextGaussian() * modifier;
                droppedItem.field_70293_c = 10;
                world.func_72838_d((Entity)droppedItem);
            }
        }
    }

    public static void teleportEntity(EntityLiving entity, float teleportRange, float teleportHeight) {
        if (entity == null) {
            return;
        }
        double newPosX = entity.field_70165_t + entity.func_70681_au().nextDouble() * (double)teleportRange - 0.5 * (double)teleportRange;
        double newPosY = entity.field_70163_u + entity.func_70681_au().nextDouble() * (double)teleportHeight - 0.5 * (double)teleportHeight;
        double newPosZ = entity.field_70161_v + entity.func_70681_au().nextDouble() * (double)teleportRange - 0.5 * (double)teleportRange;
        double prevX = entity.field_70165_t;
        double prevY = entity.field_70163_u;
        double prevZ = entity.field_70161_v;
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            while (player.field_70170_p.func_72798_a((int)newPosX, (int)newPosY, (int)newPosZ) != 0) {
                newPosY += 1.0;
            }
            player.func_70634_a(newPosX, newPosY, newPosZ);
            return;
        }
        entity.func_70107_b(newPosX, newPosY, newPosZ);
    }

    public static void disableFlight(EntityPlayer player, NBTTagCompound dartTag) {
        player.field_71075_bZ.field_75101_c = false;
        player.field_71075_bZ.field_75100_b = false;
        dartTag.func_74757_a("isFlying", false);
        player.field_70143_R = 0.0f;
        PacketDispatcher.sendPacketToServer((Packet)new DartPacket(23).getPacket());
    }

    public static boolean performCraft(EntityPlayer player, ItemInventory pack, ItemInventory card) {
        int i;
        ItemStack result = null;
        InventoryCrafting inv = new InventoryCrafting((Container)new CraftingContainer(), 3, 3);
        for (i = 0; i < 9; ++i) {
            inv.func_70299_a(i, card.func_70301_a(i));
        }
        result = CraftingManager.func_77594_a().func_82787_a(inv, player.field_70170_p);
        if (result == null) {
            return false;
        }
        boolean hasCrafted = false;
        while (pack.storeItemStack(result) > -1 || pack.getFirstEmptyStack() > -1) {
            for (i = 0; i < 9; ++i) {
                ItemStack tempStack = card.func_70301_a(i);
                if (tempStack == null) continue;
                boolean found = false;
                for (int j = 0; j < pack.func_70302_i_(); ++j) {
                    ItemStack packStack = pack.func_70301_a(j);
                    if (packStack == null || !InventoryUtils.isItemEquivalent(packStack, tempStack) || packStack.field_77994_a > packStack.func_77976_d()) continue;
                    ItemStack contains = packStack.func_77946_l();
                    pack.func_70298_a(j, 1);
                    if (pack.func_70301_a(j) == null && contains.func_77973_b().func_77634_r()) {
                        pack.func_70299_a(j, contains.func_77973_b().getContainerItemStack(contains));
                    }
                    found = true;
                    break;
                }
                if (found) continue;
                return hasCrafted;
            }
            ItemStack addStack = result.func_77946_l();
            pack.addItemToInventory(addStack);
            pack.save();
            hasCrafted = true;
            if (addStack.field_77994_a <= 0) continue;
            DartUtils.dropItem(addStack, player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v);
        }
        return hasCrafted;
    }

    public static boolean performTrans(EntityPlayer player, ItemInventory pack, ItemInventory card) {
        boolean changed = false;
        for (int i = 0; i < card.func_70302_i_(); ++i) {
            ForceTransmutation trans;
            ItemStack cardStack = card.func_70301_a(i);
            if (cardStack == null || (trans = ForceTransmutation.getTransmutable(cardStack)) == null || trans.getOutput() == null) continue;
            for (int j = 0; j < pack.func_70302_i_(); ++j) {
                ForceTransmutation check;
                ItemStack packStack = pack.func_70301_a(j);
                if (packStack == null || packStack.field_77993_c != cardStack.field_77993_c || packStack.func_77960_j() != cardStack.func_77960_j() && cardStack.func_77960_j() != 0 || (check = ForceTransmutation.getTransmutable(packStack)) == null || check.getOutput() == null) continue;
                ItemStack toAdd = check.getOutput().func_77946_l();
                for (int remaining = packStack.field_77994_a; remaining > 0 && (pack.storeItemStack(toAdd.func_77946_l()) > -1 || pack.getFirstEmptyStack() > -1); --remaining) {
                    ItemStack addCopy = toAdd.func_77946_l();
                    pack.func_70298_a(j, 1);
                    pack.addItemToInventory(addCopy);
                    pack.save();
                    changed = true;
                    if (addCopy.field_77994_a <= 0) continue;
                    DartUtils.dropItem(addCopy, player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v);
                }
            }
        }
        return changed;
    }

    public static boolean canUpgrade(ItemStack stack) {
        NBTTagCompound upComp;
        if (stack == null || DartUtils.hasDartUpgrade(stack) && !(stack.func_77973_b() instanceof ItemForcePack)) {
            return false;
        }
        if ((stack.func_77973_b() instanceof ItemForceArmor || stack.func_77973_b() instanceof ItemMemberCard) && !(upComp = UpgradeHelper.getUpgradeCompound(stack)).func_82582_d()) {
            return false;
        }
        return stack.func_77973_b() instanceof IForceUpgradable || DartUtils.isWildCard(stack);
    }

    public static boolean hasDartUpgrade(ItemStack stack) {
        NBTTagCompound comp;
        return stack != null && stack.func_77942_o() && ((comp = stack.func_77978_p()).func_74764_b("upgrades") || comp.func_74764_b("ench"));
    }

    public static void setMotionWithModifier(EntityPlayer player, Entity victim, float modifier) {
        victim.field_70159_w = -MathHelper.func_76126_a((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(player.field_70125_A / 180.0f * (float)Math.PI)) * modifier;
        victim.field_70179_y = MathHelper.func_76134_b((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(player.field_70125_A / 180.0f * (float)Math.PI)) * modifier;
        victim.field_70181_x = (double)(-MathHelper.func_76126_a((float)(player.field_70125_A / 180.0f * (float)Math.PI)) * modifier + 0.33f) + 0.25;
    }

    public static void performFlight(ItemStack stack, World world, EntityPlayer player) {
        float modifier = Config.flightModifier;
        player.field_70159_w = -MathHelper.func_76126_a((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(player.field_70125_A / 180.0f * (float)Math.PI)) * modifier;
        player.field_70179_y = MathHelper.func_76134_b((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(player.field_70125_A / 180.0f * (float)Math.PI)) * modifier;
        player.field_70181_x = (double)(-MathHelper.func_76126_a((float)(player.field_70125_A / 180.0f * (float)Math.PI)) * modifier + 0.33f) + 0.25;
        if (!Proxies.common.isSimulating(world)) {
            PacketDispatcher.sendPacketToServer((Packet)new FXPacket(8, player.field_70165_t, player.field_70163_u, player.field_70161_v).getPacket());
            WingMeter.shouldDraw = true;
        }
    }

    public static void lightArrowed(EntityLiving entity) {
        System.out.println("Do light arrow calculation: " + entity);
        entity.func_70097_a(new DamageSource("Light"){

            public String func_76360_b(EntityLiving player) {
                if (player instanceof EntityPlayer) {
                    return ((EntityPlayer)player).field_71092_bJ + " was debugged to death.";
                }
                return "";
            }
        }, entity.func_70667_aM());
    }

    public static void iceArrowed(EntityLiving entity) {
        System.out.println("Do ice arrow calculation: " + entity);
    }

    public static void dropXPAt(World world, double x, double y, double z, int amt, int step) {
    }

    public static boolean isBlockWood(World world, int x, int y, int z) {
        if (!world.func_72899_e(x, y, z)) {
            return false;
        }
        Block block = Block.field_71973_m[world.func_72798_a(x, y, z)];
        if (block == null) {
            return false;
        }
        Material mat = block.field_72018_cp;
        if (mat == null) {
            return false;
        }
        return mat == Material.field_76245_d;
    }

    public static boolean grindWood(EntityPlayer player, int x, int y, int z, ItemStack stack) {
        if (!Loader.isModLoaded((String)"ThermalExpansion") || !Config.TEIntegration) {
            return false;
        }
        World world = player.field_70170_p;
        Block block = Block.field_71973_m[world.func_72798_a(x, y, z)];
        ArrayList drops = block.getBlockDropped(world, x, y, z, world.func_72805_g(x, y, z), 0);
        ArrayList<ItemStack> toDrop = new ArrayList<ItemStack>();
        boolean hasGrind = false;
        for (ItemStack tempStack : drops) {
            block9: {
                Object product = null;
                try {
                    ISawmillRecipe[] recipes = CraftingManagers.sawmillManager.getRecipeList();
                    if (recipes == null) break block9;
                    for (ISawmillRecipe recipeCheck : recipes) {
                        if (!ItemStack.func_77989_b((ItemStack)recipeCheck.getInput(), (ItemStack)tempStack)) continue;
                        toDrop.add(recipeCheck.getPrimaryOutput().func_77946_l());
                        if (recipeCheck.getSecondaryOutputChance() >= ProxyCommon.rand.nextInt(100)) {
                            toDrop.add(recipeCheck.getSecondaryOutput());
                        }
                        hasGrind = true;
                        break;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (hasGrind) continue;
            toDrop.add(tempStack);
        }
        if (!hasGrind) {
            return false;
        }
        world.func_94571_i(x, y, z);
        if (Proxies.common.isSimulating(world)) {
            world.func_72908_a((double)x, (double)y, (double)z, "bluedart.brickBreak", 1.0f, DartUtils.randomPitch());
            PacketDispatcher.sendPacketToAllAround((double)x, (double)y, (double)z, (double)30.0, (int)world.func_72912_H().func_76076_i(), (Packet)new FXPacket(6, x, y, z).getPacket());
            for (ItemStack dropStack : toDrop) {
                DartUtils.dropItem(dropStack, world, x, y, z);
            }
        }
        DartUtils.damageTool(player, stack, 2);
        return true;
    }

    public static boolean breakWood(EntityPlayer player, int x, int y, int z, ItemStack stack) {
        World world = player.field_70170_p;
        if (!DartUtils.isBlockWood(world, x, y, z)) {
            return false;
        }
        NBTTagCompound upgrades = null;
        upgrades = stack.func_77973_b() instanceof ISocketableTool ? SocketHelper.getSocketCompound(stack) : stack.func_77978_p().func_74775_l("upgrades");
        if (upgrades == null) {
            return false;
        }
        boolean smelt = upgrades.func_74764_b("Heat");
        boolean grind = upgrades.func_74764_b("Grinding");
        Block block = Block.field_71973_m[world.func_72798_a(x, y, z)];
        ArrayList drops = block.getBlockDropped(world, x, y, z, world.func_72805_g(x, y, z), 0);
        ArrayList<ItemStack> toDrop = new ArrayList<ItemStack>();
        boolean hasSmelt = false;
        boolean hasGrind = false;
        for (ItemStack tempStack : drops) {
            ItemStack product = null;
            if (grind && Loader.isModLoaded((String)"ThermalExpansion") && Config.TEIntegration) {
                ISawmillRecipe[] recipes = CraftingManagers.sawmillManager.getRecipeList();
                if (recipes != null) {
                    for (ISawmillRecipe recipeCheck : recipes) {
                        if (!ItemStack.func_77989_b((ItemStack)recipeCheck.getInput(), (ItemStack)tempStack)) continue;
                        toDrop.add(recipeCheck.getPrimaryOutput().func_77946_l());
                        if (recipeCheck.getSecondaryOutputChance() >= ProxyCommon.rand.nextInt(100)) {
                            toDrop.add(recipeCheck.getSecondaryOutput());
                        }
                        hasGrind = true;
                        break;
                    }
                }
                if (hasGrind) continue;
                toDrop.add(tempStack);
                continue;
            }
            if (smelt) {
                product = FurnaceRecipes.func_77602_a().getSmeltingResult(tempStack);
            }
            if (product != null) {
                toDrop.add(new ItemStack(product.func_77973_b(), product.field_77994_a, product.func_77960_j()));
                hasSmelt = true;
                continue;
            }
            toDrop.add(tempStack);
        }
        world.func_94571_i(x, y, z);
        if (Proxies.common.isSimulating(world)) {
            world.func_72908_a((double)x, (double)y, (double)z, "bluedart.fly", 1.0f, world.field_73012_v.nextFloat() * 0.5f + 0.9f);
            for (ItemStack dropStack : toDrop) {
                DartUtils.dropItem(dropStack, world, x, y, z);
            }
        }
        int damage = 2;
        if (hasSmelt) {
            damage += 2;
        }
        if (hasGrind) {
            damage += 2;
        }
        DartUtils.damageTool(player, stack, damage);
        return true;
    }

    public static boolean smeltBlock(World world, ItemStack stack, EntityPlayer player, int x, int y, int z) {
        Block block = Block.field_71973_m[world.func_72798_a(x, y, z)];
        ArrayList drops = block.getBlockDropped(world, x, y, z, world.func_72805_g(x, y, z), EnchantmentHelper.func_77517_e((EntityLiving)player));
        ArrayList<ItemStack> toDrop = new ArrayList<ItemStack>();
        boolean hasSmelt = false;
        int xp = 0;
        if (block.field_71990_ca == Block.field_71950_I.field_71990_ca) {
            xp += world.field_73012_v.nextInt(6);
        }
        for (ItemStack tempStack : drops) {
            ItemStack product = null;
            try {
                product = FurnaceRecipes.func_77602_a().getSmeltingResult(tempStack);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (product != null) {
                toDrop.add(new ItemStack(product.func_77973_b(), product.field_77994_a, product.func_77960_j()));
                hasSmelt = true;
                xp += (int)FurnaceRecipes.func_77602_a().getExperience(tempStack) * 2;
                continue;
            }
            toDrop.add(tempStack);
        }
        if (!hasSmelt) {
            return false;
        }
        world.func_94571_i(x, y, z);
        if (Proxies.common.isSimulating(world)) {
            for (ItemStack dropStack : toDrop) {
                DartUtils.dropItem(dropStack, world, x, y, z);
            }
            world.func_72908_a((double)x, (double)y, (double)z, "bluedart.ignite", 5.0f, DartUtils.randomPitch());
            PacketDispatcher.sendPacketToAllAround((double)x, (double)y, (double)z, (double)30.0, (int)player.field_71093_bK, (Packet)new FXPacket(16, x, y, z).getPacket());
            if (xp > 0) {
                DartUtils.dropXPAt(world, x, y, z, xp, xp / 3);
            }
        }
        DartUtils.damageTool(player, stack, 2);
        return true;
    }

    public static boolean grindBlock(World world, ItemStack stack, EntityPlayer player, int x, int y, int z) {
        Block block = Block.field_71973_m[world.func_72798_a(x, y, z)];
        NBTTagCompound upgrades = null;
        upgrades = stack.func_77973_b() instanceof ISocketableTool ? SocketHelper.getSocketCompound(stack) : UpgradeHelper.getUpgradeCompound(stack);
        ArrayList drops = block.getBlockDropped(world, x, y, z, world.func_72805_g(x, y, z), EnchantmentHelper.func_77517_e((EntityLiving)player));
        ArrayList<ItemStack> toDrop = new ArrayList<ItemStack>();
        boolean hasGrind = false;
        boolean hasSmelt = false;
        int xp = 0;
        if (block.field_71990_ca == Block.field_71950_I.field_71990_ca) {
            xp += world.field_73012_v.nextInt(6);
        }
        if (drops != null && drops.size() > 0) {
            for (ItemStack tempStack : drops) {
                ItemStack product2;
                ItemStack product;
                block28: {
                    product = null;
                    if (Config.TEIntegration && Loader.isModLoaded((String)"ThermalExpansion")) {
                        try {
                            IPulverizerRecipe[] recipes = CraftingManagers.pulverizerManager.getRecipeList();
                            if (recipes == null || recipes.length <= 0) break block28;
                            for (IPulverizerRecipe recipe : recipes) {
                                if (recipe == null || !recipe.getInput().func_77969_a(tempStack)) continue;
                                product = recipe.getPrimaryOutput();
                                if (recipe.getSecondaryOutput() != null) {
                                    if (recipe.getSecondaryOutputChance() + upgrades.func_74762_e("Luck") * 10 > ProxyCommon.rand.nextInt(100) + 1) {
                                        ItemStack tempSmeltStack = null;
                                        if (upgrades.func_74764_b("Heat") && FurnaceRecipes.func_77602_a().getSmeltingResult(recipe.getSecondaryOutput()) != null) {
                                            tempSmeltStack = FurnaceRecipes.func_77602_a().getSmeltingResult(recipe.getSecondaryOutput()).func_77946_l();
                                        }
                                        if (tempSmeltStack != null) {
                                            toDrop.add(new ItemStack(tempSmeltStack.func_77973_b(), tempSmeltStack.field_77994_a * recipe.getSecondaryOutput().field_77994_a, tempSmeltStack.func_77960_j()));
                                            hasSmelt = true;
                                        } else {
                                            toDrop.add(recipe.getSecondaryOutput().func_77946_l());
                                        }
                                    }
                                }
                                break;
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                if (product == null && Config.IC2Integration && Loader.isModLoaded((String)"IC2")) {
                    try {
                        product = ((ItemStack)Recipes.macerator.getOutputFor(tempStack, true)).func_77946_l();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (product != null) {
                    hasGrind = true;
                    if (upgrades.func_74764_b("Heat")) {
                        product2 = null;
                        if (FurnaceRecipes.func_77602_a().getSmeltingResult(product) != null) {
                            product2 = FurnaceRecipes.func_77602_a().getSmeltingResult(product).func_77946_l();
                        }
                        if (product2 != null) {
                            product2.field_77994_a *= product.field_77994_a;
                            toDrop.add(new ItemStack(product2.func_77973_b(), product2.field_77994_a, product2.func_77960_j()));
                            hasSmelt = true;
                            xp += (int)FurnaceRecipes.func_77602_a().getExperience(product) * 2;
                            continue;
                        }
                    }
                    toDrop.add(product);
                    continue;
                }
                if (upgrades.func_74764_b("Heat") && (product2 = FurnaceRecipes.func_77602_a().getSmeltingResult(tempStack)) != null) {
                    toDrop.add(new ItemStack(product2.func_77973_b(), product2.field_77994_a, product2.func_77960_j()));
                    hasSmelt = true;
                    xp += (int)FurnaceRecipes.func_77602_a().getExperience(tempStack) * 2;
                    continue;
                }
                toDrop.add(tempStack);
            }
        }
        if (!hasGrind && !hasSmelt) {
            return false;
        }
        world.func_94571_i(x, y, z);
        if (Proxies.common.isSimulating(world)) {
            for (ItemStack dropStack : toDrop) {
                DartUtils.dropItem(dropStack, world, x, y, z);
            }
            if (xp > 0) {
                DartUtils.dropXPAt(world, x, y, z, xp, xp / 3);
            }
            if (hasSmelt) {
                world.func_72956_a((Entity)player, "bluedart.ignite", 5.0f, DartUtils.randomPitch());
                PacketDispatcher.sendPacketToAllAround((double)x, (double)y, (double)z, (double)30.0, (int)player.field_71093_bK, (Packet)new FXPacket(16, x, y, z).getPacket());
            } else {
                world.func_72956_a((Entity)player, "bluedart.brickBreak", 1.0f, 1.0f);
                PacketDispatcher.sendPacketToAllAround((double)x, (double)y, (double)z, (double)30.0, (int)player.field_71093_bK, (Packet)new FXPacket(17, x, y, z).getPacket());
            }
        }
        int damage = 1;
        if (hasSmelt) {
            damage += 2;
        }
        if (hasGrind) {
            damage += 2;
        }
        DartUtils.damageTool(player, stack, damage);
        return true;
    }

    public static float randomPitch() {
        return rand.nextFloat() * 0.25f + 0.85f;
    }

    public static int randomColor() {
        return DartUtils.getMcColor(rand.nextInt(16));
    }

    public static TileEntity getBlockTileEntityOnSide(World world, int i, int j, int k, ForgeDirection side) {
        return world.func_72796_p(DartUtils.getXOnSide(i, side), DartUtils.getYOnSide(j, side), DartUtils.getZOnSide(k, side));
    }

    public static boolean blockExistsOnSide(World world, int x, int y, int z, ForgeDirection side) {
        return world.func_72899_e(DartUtils.getXOnSide(x, side), DartUtils.getYOnSide(y, side), DartUtils.getZOnSide(z, side));
    }

    public static int getYOnSide(int y, ForgeDirection side) {
        switch (side.ordinal()) {
            case 1: {
                return y + 1;
            }
            case 2: {
                return y - 1;
            }
        }
        return y;
    }

    public static int getXOnSide(int x, ForgeDirection side) {
        switch (side.ordinal()) {
            case 3: {
                return x + 1;
            }
            case 4: {
                return x - 1;
            }
        }
        return x;
    }

    public static int getZOnSide(int z, ForgeDirection side) {
        switch (side.ordinal()) {
            case 5: {
                return z - 1;
            }
            case 6: {
                return z + 1;
            }
        }
        return z;
    }

    public static boolean isPoweredTile(TileEntity tile) {
        if (tile instanceof IPowerReceptor) {
            IPowerProvider provider = ((IPowerReceptor)tile).getPowerProvider();
            return provider != null;
        }
        return false;
    }

    public static boolean isHoldingContainer(EntityPlayer player) {
        ItemStack theContainer = player.func_71045_bC();
        return LiquidContainerRegistry.isContainer((ItemStack)theContainer);
    }

    public static boolean isHoldingWrench(EntityPlayer player) {
        if (player.func_71045_bC() == null) {
            return false;
        }
        Item equipped = player.func_71045_bC().func_77973_b();
        return equipped instanceof IToolWrench;
    }

    public static boolean isForceContainer(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        LiquidStack liquid = LiquidContainerRegistry.getLiquidForFilledItem((ItemStack)stack);
        if (liquid != null && liquid.itemID == DartItem.liquidForce.field_77779_bT) {
            return true;
        }
        return stack.field_77993_c == DartItem.gemForce.field_77779_bT || stack.field_77993_c == DartItem.forceShard.field_77779_bT;
    }

    public static boolean isBadnik(String name) {
        for (String check : Constants.BADNIKS) {
            if (!check.equals(name)) continue;
            return true;
        }
        return false;
    }
}

