/*
 * Decompiled with CFR 0.152.
 */
package bluedart.transport;

import bluedart.DartCraft;
import bluedart.api.ForceTransmutation;
import bluedart.core.network.FXPacket;
import bluedart.item.tool.ItemMemberCard;
import bluedart.proxy.Proxies;
import bluedart.transport.PipeIconProvider;
import bluedart.transport.PipeLogicForce;
import bluedart.utils.DartUtils;
import bluedart.utils.InventoryUtils;
import bluedart.utils.ItemInventory;
import bluedart.utils.UpgradeHelper;
import buildcraft.api.core.IIconProvider;
import buildcraft.api.core.Position;
import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.PowerFramework;
import buildcraft.api.transport.IPipedItem;
import buildcraft.core.EntityPassiveItem;
import buildcraft.core.utils.Utils;
import buildcraft.transport.EntityData;
import buildcraft.transport.IItemTravelingHook;
import buildcraft.transport.IPipeTransportItemsHook;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeTransport;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.pipes.PipeLogic;
import cpw.mods.fml.common.network.PacketDispatcher;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.LinkedList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.oredict.OreDictionary;

public class PipeItemsForce
extends Pipe
implements IPipeTransportItemsHook,
IItemTravelingHook {
    public float baseSpeed = 0.01f;
    public float modifier = 90.0f;
    public boolean hasCard;
    public ForgeDirection lastDirection;
    private IPowerProvider powerProvider;
    private int[] entitiesDropped = new int[32];
    private int entitiesDroppedIndex = 0;

    public PipeItemsForce(int itemID) {
        super((PipeTransport)new PipeTransportItems(), (PipeLogic)new PipeLogicForce(), itemID);
        for (int i = 0; i < this.entitiesDropped.length; ++i) {
            this.entitiesDropped[i] = -1;
        }
        this.powerProvider = PowerFramework.currentFramework.createPowerProvider();
        this.powerProvider.configure(25, 1, 64, 1, 256);
        this.powerProvider.configurePowerPerdition(1, 1);
        ((PipeTransportItems)this.transport).travelHook = this;
    }

    public IIconProvider getIconProvider() {
        return PipeIconProvider.instance;
    }

    public int getIconIndex(ForgeDirection direction) {
        if (this.hasCard) {
            return 1;
        }
        return 0;
    }

    public LinkedList filterPossibleMovements(LinkedList possibleOrientations, Position pos, IPipedItem item) {
        return possibleOrientations;
    }

    public void entityEntered(IPipedItem item, ForgeDirection orientation) {
        item.setSpeed(Math.min(Math.max(this.baseSpeed, item.getSpeed()) * 2.0f, this.baseSpeed * this.modifier));
    }

    public void readjustSpeed(IPipedItem item) {
        item.setSpeed(Math.min(Math.max(this.baseSpeed, item.getSpeed()) * 2.0f, this.baseSpeed * this.modifier));
    }

    public void dropContents() {
        super.dropContents();
        if (this.logic != null && this.logic instanceof PipeLogicForce) {
            PipeLogicForce inv = (PipeLogicForce)this.logic;
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                DartUtils.dropItem(inv.func_70301_a(i), this.worldObj, this.xCoord, this.yCoord, this.zCoord);
            }
        }
    }

    public void updateCard(boolean active) {
        boolean hadCard = this.hasCard;
        this.hasCard = active;
        if (Proxies.common.isSimulating(this.worldObj) && hadCard != this.hasCard) {
            this.worldObj.func_72845_h(this.xCoord, this.yCoord, this.zCoord);
            this.worldObj.func_72938_d(this.xCoord, this.zCoord).func_76630_e();
            this.container.scheduleRenderUpdate();
        }
    }

    public void onEntityCollidedWithBlock(Entity entity) {
        super.onEntityCollidedWithBlock(entity);
        if (entity.field_70128_L) {
            return;
        }
        if (this.canSuck(entity, 0)) {
            this.pullItemIntoPipe(entity, 0);
        }
    }

    public boolean canSuck(Entity entity, int distance) {
        if (!entity.func_70089_S()) {
            return false;
        }
        if (entity instanceof EntityItem) {
            EntityItem item = (EntityItem)entity;
            if (item.func_92059_d().field_77994_a <= 0) {
                return false;
            }
            for (int i = 0; i < this.entitiesDropped.length; ++i) {
                if (item.field_70157_k != this.entitiesDropped[i]) continue;
                return false;
            }
            return this.powerProvider.useEnergy(1.0f, distance, false) >= (float)distance;
        }
        if (entity instanceof EntityArrow) {
            return this.powerProvider.useEnergy(1.0f, distance, false) >= (float)distance;
        }
        return false;
    }

    public void onDropped(EntityItem item) {
        this.entitiesDroppedIndex = this.entitiesDroppedIndex + 1 >= this.entitiesDropped.length ? 0 : ++this.entitiesDroppedIndex;
        this.entitiesDropped[this.entitiesDroppedIndex] = item.field_70157_k;
    }

    public void pullItemIntoPipe(Entity entity, int distance) {
        if (!Proxies.common.isSimulating(this.worldObj)) {
            return;
        }
        ForgeDirection orientation = this.getOpenOrientation().getOpposite();
        if (orientation != ForgeDirection.UNKNOWN) {
            this.worldObj.func_72956_a(entity, "bluedart.fly", 0.25f, DartUtils.randomPitch());
            PacketDispatcher.sendPacketToAllAround((double)this.xCoord, (double)this.yCoord, (double)this.zCoord, (double)30.0, (int)entity.field_71093_bK, (Packet)new FXPacket(27, this.xCoord, this.yCoord, this.zCoord).getPacket());
            ItemStack stack = null;
            double speed = 0.01f;
            if (entity instanceof EntityItem) {
                EntityItem item = (EntityItem)entity;
                ItemStack contained = item.func_92059_d();
                float energyUsed = this.powerProvider.useEnergy(distance, contained.field_77994_a * distance, true);
                if (distance == 0 || energyUsed / (float)distance == (float)contained.field_77994_a) {
                    stack = contained;
                    entity.field_70170_p.func_72900_e(entity);
                } else {
                    stack = contained.func_77979_a((int)(energyUsed / (float)distance));
                }
                speed = Math.sqrt(item.field_70159_w * item.field_70159_w + item.field_70181_x * item.field_70181_x + item.field_70179_y * item.field_70179_y);
                speed = speed / 2.0 - 0.05;
                if (speed < 0.01) {
                    speed = 0.01;
                }
            } else if (entity instanceof EntityArrow) {
                this.powerProvider.useEnergy(distance, distance, true);
                stack = new ItemStack(Item.field_77704_l, 1);
                entity.field_70170_p.func_72900_e(entity);
            }
            EntityPassiveItem passive = new EntityPassiveItem(this.worldObj, (double)this.xCoord + 0.5, (double)((float)this.yCoord + Utils.getPipeFloorOf(stack)), (double)this.zCoord + 0.5, stack);
            passive.setSpeed((float)speed);
            ((PipeTransportItems)this.transport).entityEntering((IPipedItem)passive, orientation);
        }
    }

    public void drop(PipeTransportItems pipe, EntityData data) {
    }

    public void centerReached(PipeTransportItems pipe, EntityData data) {
        if (!Proxies.common.isSimulating(this.worldObj)) {
            return;
        }
        this.lastDirection = data.output;
        try {
            if (this.logic instanceof PipeLogicForce) {
                PipeLogicForce force;
                PipeLogicForce pipeInv = force = (PipeLogicForce)this.logic;
                ItemStack cardStack = pipeInv.func_70301_a(0);
                ItemStack stack = data.item.getItemStack();
                if (stack == null) {
                    return;
                }
                if (cardStack != null && cardStack.func_77942_o() && cardStack.func_77973_b() instanceof ItemMemberCard) {
                    NBTTagCompound upgrades = UpgradeHelper.getUpgradeCompound(cardStack);
                    ItemInventory inv = new ItemInventory(upgrades.func_74764_b("Craft") || upgrades.func_74764_b("Force") ? 9 : 16, cardStack);
                    if (upgrades.func_74764_b("Craft")) {
                        for (int i = 0; i < inv.func_70302_i_(); ++i) {
                            ItemStack invStack = inv.func_70301_a(i);
                            if (invStack == null) continue;
                            if (InventoryUtils.isItemEquivalent(invStack, stack) && DartUtils.addItemStackToInventory(pipeInv, stack)) {
                                ((PipeTransportItems)this.transport).scheduleRemoval(data.item);
                            }
                            force.attemptCraft();
                        }
                    } else if (upgrades.func_74764_b("Force")) {
                        for (int i = 0; i < inv.func_70302_i_(); ++i) {
                            ForceTransmutation trans;
                            ItemStack transStack = inv.func_70301_a(i);
                            if (transStack == null || (trans = ForceTransmutation.getTransmutable(transStack)) == null || trans.getOutput() == null || stack.field_77993_c != transStack.field_77993_c || stack.func_77960_j() != transStack.func_77960_j() && transStack.func_77960_j() != 0) continue;
                            ForceTransmutation itemTrans = ForceTransmutation.getTransmutable(stack);
                            ItemStack finalStack = itemTrans.getOutput().func_77946_l();
                            finalStack.field_77994_a *= stack.field_77994_a;
                            data.item.setItemStack(finalStack);
                            this.worldObj.func_72908_a((double)this.xCoord, (double)this.yCoord, (double)this.zCoord, "bluedart.magic", 0.25f, DartUtils.randomPitch());
                            PacketDispatcher.sendPacketToAllAround((double)this.xCoord, (double)this.yCoord, (double)this.zCoord, (double)30.0, (int)pipe.worldObj.func_72912_H().func_76076_i(), (Packet)new FXPacket(20, this.xCoord, this.yCoord, this.zCoord).getPacket());
                        }
                    } else if (upgrades.func_74764_b("Forge")) {
                        if (OreDictionary.getOreID((ItemStack)stack) < 0) {
                            return;
                        }
                        for (int i = 0; i < inv.func_70302_i_(); ++i) {
                            ArrayList ores;
                            int id;
                            ItemStack tempStack = inv.func_70301_a(i);
                            if (tempStack == null || (id = OreDictionary.getOreID((ItemStack)tempStack)) < 0 || OreDictionary.itemMatches((ItemStack)stack, (ItemStack)tempStack, (boolean)false) || (ores = OreDictionary.getOres((Integer)id)) == null || ores.size() < 2) continue;
                            for (int j = 0; j < ores.size(); ++j) {
                                ItemStack oreStack = (ItemStack)ores.get(j);
                                if (!OreDictionary.itemMatches((ItemStack)oreStack, (ItemStack)stack, (boolean)false)) continue;
                                ItemStack bufferStack = stack.func_77946_l();
                                data.item.setItemStack(new ItemStack(tempStack.field_77993_c, stack.field_77994_a, tempStack.func_77960_j()));
                                if (bufferStack.func_77942_o()) {
                                    data.item.getItemStack().func_77982_d((NBTTagCompound)bufferStack.func_77978_p().func_74737_b());
                                }
                                this.worldObj.func_72908_a((double)this.xCoord, (double)this.yCoord, (double)this.zCoord, "bluedart.magic", 0.25f, DartUtils.randomPitch());
                                PacketDispatcher.sendPacketToAllAround((double)this.xCoord, (double)this.yCoord, (double)this.zCoord, (double)30.0, (int)pipe.worldObj.func_72912_H().func_76076_i(), (Packet)new FXPacket(20, this.xCoord, this.yCoord, this.zCoord).getPacket());
                                return;
                            }
                        }
                    } else {
                        boolean found = false;
                        for (int i = 0; i < inv.func_70302_i_(); ++i) {
                            if (!OreDictionary.itemMatches((ItemStack)stack, (ItemStack)inv.func_70301_a(i), (boolean)false)) continue;
                            found = true;
                            break;
                        }
                        if (!found) {
                            data.output = data.input.getOpposite();
                        }
                    }
                }
            }
        }
        catch (ConcurrentModificationException e) {
            DartCraft.dartLog.info("ConcurrentModificationException in pipe, for some annoying reason.");
        }
    }

    public void endReached(PipeTransportItems pipe, EntityData data, TileEntity tile) {
    }
}

