/*
 * Decompiled with CFR 0.152.
 */
package bluedart.tile;

import bluedart.api.DartAPI;
import bluedart.api.ForceUpgradeManager;
import bluedart.api.IForceUpgradable;
import bluedart.api.IForceUpgrade;
import bluedart.api.IForceUpgradeMaterial;
import bluedart.api.IForceWildCard;
import bluedart.core.Config;
import bluedart.core.network.FXPacket;
import bluedart.integration.SoulShardsIntegration;
import bluedart.integration.ThaumCraftIntegration;
import bluedart.item.DartItem;
import bluedart.item.ItemForceArmor;
import bluedart.item.ItemForceTome;
import bluedart.item.ItemUpgradeCore;
import bluedart.item.tool.ItemForceAxe;
import bluedart.item.tool.ItemForceBow;
import bluedart.item.tool.ItemForcePack;
import bluedart.item.tool.ItemForcePickaxe;
import bluedart.item.tool.ItemForceRod;
import bluedart.item.tool.ItemForceSpade;
import bluedart.item.tool.ItemForceSword;
import bluedart.item.tool.ItemMemberCard;
import bluedart.proxy.Proxies;
import bluedart.utils.DartUtils;
import bluedart.utils.ItemInventory;
import bluedart.utils.MyPowerProvider;
import bluedart.utils.TomeUtils;
import bluedart.utils.UpgradeHelper;
import buildcraft.api.gates.IAction;
import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.core.IMachine;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidEvent;
import net.minecraftforge.liquids.LiquidStack;

public class TileEntityForceInfuser
extends TileEntity
implements IInventory,
ISidedInventory,
ILiquidTank,
ITankContainer,
IMachine,
IPowerReceptor {
    public int progress = 0;
    public int totalProgress = 0;
    public ItemStack[] inventoryContents = new ItemStack[11];
    public boolean isActive;
    public boolean hasTome;
    private boolean tierNeedsUpdate = false;
    private ItemStack prevBook = null;
    private int currentMJ = 0;
    private int currentLiquid = 0;
    public LiquidStack liquid;
    public int capacity;
    private int tankPressure;
    public int canUpgrade = 0;
    public MyPowerProvider provider;
    public static final int MAX_LEVEL = 10000;
    public static final int maxEnergy = 25000;
    private final int MJPerT = 5;
    private int lastCheck;
    public float bookRotation;
    public float bookRotation2;
    public float bookRotationPrev;
    public float pageFlip;
    public float pageFlipPrev;
    public float bookSpread;
    public float bookSpreadPrev;
    public float tempFloat;
    public int bookInt;

    public TileEntityForceInfuser() {
        this.liquid = new LiquidStack(DartItem.liquidForce.field_77779_bT, 0);
        this.capacity = 10000;
        this.provider = new MyPowerProvider();
        this.provider.configure(this.MJPerT * 5, 25000);
        this.lastCheck = 0;
    }

    public void func_70316_g() {
        ItemStack gemSlot;
        super.func_70316_g();
        if (!Proxies.common.isSimulating(this.field_70331_k)) {
            this.updateAnimation();
            return;
        }
        if (this.hasTome != this.hasTome() || this.isActive && this.progress <= 0 || !this.isActive && this.progress > 0) {
            this.hasTome = this.hasTome();
            this.isActive = this.progress > 0;
            this.sendUpdatePacket(Side.CLIENT);
        }
        if ((gemSlot = this.inventoryContents[1]) != null && DartUtils.isForceContainer(gemSlot) && this.getLiquid() != null && this.getLiquid().amount <= this.capacity - 1000) {
            this.fill(new LiquidStack((Item)DartItem.liquidForce, 1000), true);
            if (gemSlot.func_77973_b() == DartItem.forceBucket) {
                this.inventoryContents[1] = new ItemStack(Item.field_77788_aw, 1);
            } else {
                NBTTagCompound tome;
                if (this.inventoryContents[1].func_77973_b() == DartItem.forceShard && this.hasTome() && (tome = this.inventoryContents[0].func_77978_p()) != null) {
                    tome.func_74768_a("bonus", tome.func_74762_e("bonus") + 10);
                }
                --this.inventoryContents[1].field_77994_a;
                if (this.inventoryContents[1].field_77994_a == 0) {
                    this.inventoryContents[1] = null;
                }
            }
        }
        if (this.totalProgress == 0) {
            int n = this.canUpgrade = this.canUpgrade() ? 1 : 0;
        }
        if (this.totalProgress > 0) {
            ++this.progress;
            this.provider.setEnergyStored(this.provider.getEnergyStored() - 5.0f);
            if (this.progress == this.totalProgress || this.canUpgrade != 1) {
                this.progress = 0;
                this.totalProgress = 0;
                if (this.canUpgrade == 1) {
                    this.doUpgrade();
                }
            }
        }
    }

    private void updateAnimation() {
        float var7;
        this.bookSpreadPrev = this.bookSpread;
        this.bookRotationPrev = this.bookRotation2;
        EntityPlayer var1 = this.field_70331_k.func_72977_a((double)((float)this.field_70329_l + 0.5f), (double)((float)this.field_70330_m + 0.5f), (double)((float)this.field_70327_n + 0.5f), 3.0);
        if (var1 != null) {
            double var2 = var1.field_70165_t - (double)((float)this.field_70329_l + 0.5f);
            double var4 = var1.field_70161_v - (double)((float)this.field_70327_n + 0.5f);
            this.bookRotation = (float)Math.atan2(var4, var2);
            this.bookSpread += 0.1f;
            if (this.bookSpread < 0.5f || this.field_70331_k.field_73012_v.nextInt(40) == 0) {
                float var6 = this.bookInt;
                do {
                    this.bookInt += this.field_70331_k.field_73012_v.nextInt(4) - this.field_70331_k.field_73012_v.nextInt(4);
                } while (var6 == (float)this.bookInt);
            }
        } else {
            this.bookRotation += 0.02f;
            this.bookSpread -= 0.1f;
        }
        while (this.bookRotation2 >= 3.141593f) {
            this.bookRotation2 -= 6.283186f;
        }
        while (this.bookRotation2 < -3.141593f) {
            this.bookRotation2 += 6.283186f;
        }
        while (this.bookRotation >= 3.141593f) {
            this.bookRotation -= 6.283186f;
        }
        while (this.bookRotation < -3.141593f) {
            this.bookRotation += 6.283186f;
        }
        for (var7 = this.bookRotation - this.bookRotation2; var7 >= 3.141593f; var7 -= 6.283186f) {
        }
        while (var7 < -3.141593f) {
            var7 += 6.283186f;
        }
        this.bookRotation2 += var7 * 0.4f;
        if (this.bookSpread < 0.0f) {
            this.bookSpread = 0.0f;
        }
        if (this.bookSpread > 1.0f) {
            this.bookSpread = 1.0f;
        }
        this.pageFlipPrev = this.pageFlip;
        float var3 = ((float)this.bookInt - this.pageFlip) * 0.4f;
        float var8 = 0.2f;
        if (var3 < -var8) {
            var3 = -var8;
        }
        if (var3 > var8) {
            var3 = var8;
        }
        this.tempFloat += (var3 - this.tempFloat) * 0.9f;
        this.pageFlip += this.tempFloat;
    }

    public boolean hasTome() {
        return this.inventoryContents[0] != null && this.inventoryContents[0].func_77973_b() instanceof ItemForceTome;
    }

    public int getActiveTier() {
        if (!this.hasTome()) {
            return 0;
        }
        return TomeUtils.getTier(TomeUtils.getPoints(this.inventoryContents[0]));
    }

    public void func_70307_a(NBTTagCompound comp) {
        super.func_70307_a(comp);
        NBTTagList contentList = comp.func_74761_m("Items");
        this.inventoryContents = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < contentList.func_74745_c(); ++i) {
            NBTTagCompound tempEntry = (NBTTagCompound)contentList.func_74743_b(i);
            byte tempByte = tempEntry.func_74771_c("Slot");
            if (tempByte < 0 || tempByte >= this.inventoryContents.length) continue;
            this.inventoryContents[tempByte] = ItemStack.func_77949_a((NBTTagCompound)tempEntry);
        }
        this.liquid = new LiquidStack(DartItem.liquidForce.field_77779_bT, comp.func_74762_e("tankLevel"));
        this.provider.setEnergyStored(comp.func_74760_g("energyLevel"));
        this.progress = comp.func_74762_e("progress");
        this.totalProgress = comp.func_74762_e("totalProgress");
        this.currentMJ = comp.func_74762_e("currentMJ");
        this.currentLiquid = comp.func_74762_e("currentLiquid");
        this.prevBook = this.inventoryContents[0];
        this.isActive = comp.func_74767_n("isActive");
        this.hasTome = comp.func_74767_n("hasTome");
        if (this.progress > 0) {
            this.go();
        }
    }

    public void func_70310_b(NBTTagCompound comp) {
        super.func_70310_b(comp);
        if (this.liquid != null) {
            comp.func_74768_a("tankLevel", this.getLiquid().amount);
        }
        if (this.provider != null) {
            comp.func_74776_a("energyLevel", this.provider.getEnergyStored());
        }
        comp.func_74768_a("progress", this.progress);
        comp.func_74768_a("totalProgress", this.totalProgress);
        comp.func_74768_a("currentMJ", this.currentMJ);
        comp.func_74768_a("currentLiquid", this.currentLiquid);
        comp.func_74757_a("isActive", this.isActive);
        comp.func_74757_a("hasTome", this.hasTome);
        NBTTagList contentList = new NBTTagList();
        for (int i = 0; i < this.inventoryContents.length; ++i) {
            if (this.inventoryContents[i] == null) continue;
            NBTTagCompound tempEntry = new NBTTagCompound();
            tempEntry.func_74774_a("Slot", (byte)i);
            this.inventoryContents[i].func_77955_b(tempEntry);
            contentList.func_74742_a((NBTBase)tempEntry);
        }
        comp.func_74782_a("Items", (NBTBase)contentList);
    }

    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.provider.setEnergyStored(j);
                break;
            }
            case 1: {
                this.progress = j;
                break;
            }
            case 2: {
                this.liquid.amount = j;
            }
        }
    }

    public int func_70302_i_() {
        return 11;
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventoryContents[slot];
    }

    public ItemStack func_70298_a(int par1, int par2) {
        if (this.inventoryContents[par1] != null) {
            if (this.inventoryContents[par1].field_77994_a <= par2) {
                ItemStack var3 = this.inventoryContents[par1];
                this.inventoryContents[par1] = null;
                this.func_70296_d();
                return var3;
            }
            ItemStack var3 = this.inventoryContents[par1].func_77979_a(par2);
            if (this.inventoryContents[par1].field_77994_a == 0) {
                this.inventoryContents[par1] = null;
            }
            this.func_70296_d();
            return var3;
        }
        return null;
    }

    public ItemStack func_70304_b(int par1) {
        if (this.inventoryContents[par1] != null) {
            ItemStack var2 = this.inventoryContents[par1];
            this.inventoryContents[par1] = null;
            return var2;
        }
        return null;
    }

    public void func_70299_a(int par1, ItemStack par2ItemStack) {
        this.inventoryContents[par1] = par2ItemStack;
        if (par2ItemStack != null && par2ItemStack.field_77994_a > this.func_70297_j_()) {
            par2ItemStack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (this.inventoryContents == null || this.tierNeedsUpdate) {
            return;
        }
        if (this.prevBook == null && this.inventoryContents[0] == null) {
            return;
        }
        if (this.prevBook == null & this.inventoryContents[0] != null || this.prevBook != null && this.inventoryContents[0] == null) {
            this.prevBook = this.inventoryContents[0];
            this.checkTierContents();
            return;
        }
        if (!this.prevBook.equals(this.inventoryContents[0])) {
            this.prevBook = this.inventoryContents[0];
            this.checkTierContents();
            return;
        }
    }

    public Packet func_70319_e() {
        NBTTagCompound comp = new NBTTagCompound();
        this.func_70310_b(comp);
        Packet132TileEntityData pack = new Packet132TileEntityData(this.field_70329_l, this.field_70330_m, this.field_70327_n, 0, comp);
        return pack;
    }

    public void onDataPacket(INetworkManager net, Packet132TileEntityData pkt) {
        if (pkt != null && pkt.field_73331_e != null) {
            this.func_70307_a(pkt.field_73331_e);
        }
    }

    public void sendUpdatePacket(Side side) {
        if (Proxies.common.isSimulating(this.field_70331_k) && side == Side.CLIENT) {
            PacketDispatcher.sendPacketToAllPlayers((Packet)this.func_70319_e());
        } else if (!Proxies.common.isSimulating(this.field_70331_k) && side == Side.SERVER) {
            PacketDispatcher.sendPacketToServer((Packet)this.func_70319_e());
        }
    }

    private void checkTierContents() {
        int tier = this.getActiveTier();
        for (int i = 0; i < 8; ++i) {
            IForceUpgradeMaterial mat;
            if (this.inventoryContents[i + 2] == null) continue;
            boolean shouldDrop = false;
            if (tier + 1 < i) {
                shouldDrop = true;
            }
            if ((mat = DartAPI.fum.getMaterialFromItemStack(this.inventoryContents[i + 2])) != null && tier < DartAPI.fum.getFromID(mat.getUpgradeID()).getTier()) {
                shouldDrop = true;
            }
            if (!shouldDrop) continue;
            DartUtils.dropItem(this.inventoryContents[i + 2], this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
            this.inventoryContents[i + 2] = null;
        }
        if (tier < 7 && this.inventoryContents[10] != null) {
            DartUtils.dropItem(this.inventoryContents[10], this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
            this.inventoryContents[10] = null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canUpgrade() {
        if (!DartUtils.canUpgrade(this.inventoryContents[2])) {
            return false;
        }
        float modifier = 0.0f;
        boolean hasUpgrade = false;
        boolean hasCharge = false;
        boolean hasEnder = false;
        boolean hasRepair = false;
        boolean hasSturdy = false;
        int storage = 0;
        int totalTypes = 0;
        ArrayList<Integer> types = new ArrayList<Integer>();
        for (int i = 3; i < 11; ++i) {
            IForceUpgrade upgrade;
            IForceUpgradeMaterial mat;
            block25: {
                block26: {
                    if (this.inventoryContents[i] == null) continue;
                    mat = DartAPI.fum.getMaterialFromItemStack(this.inventoryContents[i]);
                    upgrade = null;
                    if (mat != null) {
                        upgrade = DartAPI.fum.getFromID(mat.getUpgradeID());
                    }
                    if (upgrade == null) return false;
                    if (upgrade.equals(ForceUpgradeManager.WING) && !Config.wingEnabled) {
                        return false;
                    }
                    if (types.contains(new Integer(upgrade.getID()))) break block25;
                    types.add(new Integer(upgrade.getID()));
                    if (upgrade.getID() != ForceUpgradeManager.REPAIR.getID()) {
                        ++totalTypes;
                    } else {
                        hasRepair = true;
                    }
                    if (upgrade.getID() == ForceUpgradeManager.CHARGE.getID()) break block26;
                    if (upgrade.getID() != ForceUpgradeManager.CHARGE2.getID()) break block25;
                }
                hasCharge = true;
            }
            if (this.inventoryContents[2].func_77973_b() instanceof IForceUpgradable) {
                if (!DartAPI.fum.isUpgradeValid(upgrade, (IForceUpgradable)this.inventoryContents[2].func_77973_b())) return false;
                hasUpgrade = true;
                modifier += mat.getEfficiency();
            } else {
                if (!DartUtils.isUpgradeValidForWildCard(upgrade, this.inventoryContents[2])) return false;
                hasUpgrade = true;
                modifier += mat.getEfficiency();
            }
            if (!(this.inventoryContents[2].func_77973_b() instanceof ItemForcePack)) continue;
            if (upgrade == ForceUpgradeManager.STORAGE) {
                ++storage;
            }
            if (upgrade == ForceUpgradeManager.ENDER) {
                hasEnder = true;
            }
            if (upgrade != ForceUpgradeManager.STURDY) continue;
            hasSturdy = true;
        }
        if (!hasUpgrade) return false;
        if (this.inventoryContents[2].func_77973_b() instanceof ItemForcePack) {
            if (!this.inventoryContents[2].func_77942_o()) {
                return false;
            }
            if (storage > 0) {
                if (hasEnder) return false;
                if (hasSturdy) {
                    return false;
                }
            }
            if (UpgradeHelper.getUpgradeCompound(this.inventoryContents[2]).func_74764_b("Sturdy") && hasSturdy) {
                return false;
            }
            int size = this.inventoryContents[2].func_77978_p().func_74762_e("size") + 8 * storage;
            if (size > 40) {
                return false;
            }
            if ((size - Config.packSize) / 8 > this.getActiveTier() - 1) {
                return false;
            }
        }
        if (this.inventoryContents[2].func_77973_b() instanceof ItemUpgradeCore && totalTypes > 1) {
            return false;
        }
        if (this.inventoryContents[2].func_77973_b() instanceof ItemForceTome && totalTypes > 1) {
            return false;
        }
        if (this.inventoryContents[2].func_77973_b() instanceof ItemForceRod && totalTypes > 1) {
            return false;
        }
        if (this.inventoryContents[2].func_77973_b() instanceof ItemMemberCard && totalTypes > 1) {
            return false;
        }
        if (hasCharge && hasRepair) {
            return false;
        }
        this.currentMJ = (int)this.energyUsed(modifier);
        this.currentLiquid = this.liquidUsed(modifier);
        if (!(this.provider.getEnergyStored() >= this.energyUsed(modifier))) return false;
        if (this.liquid.amount < this.liquidUsed(modifier)) return false;
        return true;
    }

    public float energyUsed(float efficiency) {
        return efficiency * 500.0f;
    }

    public int liquidUsed(float efficiency) {
        return (int)(efficiency * 200.0f);
    }

    public void go() {
        if (!this.canUpgrade()) {
            return;
        }
        this.totalProgress = this.currentMJ / this.MJPerT / (this.getActiveTier() >= 7 ? 2 : 1);
    }

    public void doUpgrade() {
        this.liquid.amount -= this.currentLiquid;
        ItemStack product = this.inventoryContents[2].func_77946_l();
        HashMap<String, Integer> upgrades = new HashMap<String, Integer>();
        boolean hasUnique = false;
        int bonusXp = 0;
        for (int i = 3; i < 11; ++i) {
            if (this.inventoryContents[i] == null) continue;
            IForceUpgradeMaterial mat = DartAPI.fum.getMaterialFromItemStack(this.inventoryContents[i]);
            if (mat == null) {
                return;
            }
            IForceUpgrade upgrade = DartAPI.fum.getFromID(mat.getUpgradeID());
            bonusXp += ((int)((float)mat.getBonus() / 5.0f * mat.getEfficiency()) + upgrade.getTier() * 5) / 2 + 1;
            if (upgrades.containsKey(upgrade.getName())) {
                int newLevel = (Integer)upgrades.get(upgrade.getName()) + 1;
                if (newLevel > upgrade.getMaxLevel()) continue;
                upgrades.put(upgrade.getName(), new Integer(newLevel));
                continue;
            }
            upgrades.put(upgrade.getName(), new Integer(1));
        }
        NBTTagCompound comp = new NBTTagCompound();
        NBTTagCompound upgradeComp = new NBTTagCompound();
        NBTTagList realEnchants = new NBTTagList();
        boolean hasRealEnchant = false;
        boolean dropXP = false;
        if (upgrades.size() > 0) {
            for (Map.Entry item : upgrades.entrySet()) {
                if (this.hasTome()) {
                    NBTTagCompound tome = this.inventoryContents[0].func_77978_p();
                    if (tome != null) {
                        int tomeXP = TomeUtils.getPoints(this.inventoryContents[0]);
                        if (tomeXP < 2400) {
                            tome.func_74768_a((String)item.getKey(), tome.func_74762_e((String)item.getKey()) + 1);
                        } else {
                            dropXP = true;
                        }
                    } else {
                        dropXP = true;
                    }
                } else {
                    dropXP = true;
                }
                upgradeComp.func_74768_a((String)item.getKey(), ((Integer)item.getValue()).intValue());
                if (((String)item.getKey()).equals("Luck")) {
                    if (product.func_77973_b() instanceof ItemForcePickaxe || product.func_77973_b() instanceof ItemForceSpade || product.func_77973_b() instanceof ItemForceAxe) {
                        realEnchants.func_74742_a((NBTBase)this.simulateEnchant(35, (Integer)item.getValue()));
                        hasRealEnchant = true;
                    }
                    if (product.func_77973_b() instanceof ItemForceSword) {
                        realEnchants.func_74742_a((NBTBase)this.simulateEnchant(21, (Integer)item.getValue()));
                        hasRealEnchant = true;
                    }
                }
                if (((String)item.getKey()).equals("Heat")) {
                    if (product.func_77973_b() instanceof ItemForceSword) {
                        realEnchants.func_74742_a((NBTBase)this.simulateEnchant(20, (Integer)item.getValue()));
                        hasRealEnchant = true;
                    }
                    if (product.func_77973_b() instanceof ItemForceBow) {
                        realEnchants.func_74742_a((NBTBase)this.simulateEnchant(50, (Integer)item.getValue()));
                        hasRealEnchant = true;
                    }
                }
                if (((String)item.getKey()).equals("Touch")) {
                    realEnchants.func_74742_a((NBTBase)this.simulateEnchant(33, 1));
                    hasRealEnchant = true;
                }
                if (((String)item.getKey()).equals("Sturdy") && product.func_77973_b().field_77779_bT != Item.field_77760_aL.field_77779_bT) {
                    realEnchants.func_74742_a((NBTBase)this.simulateEnchant(34, (Integer)item.getValue()));
                    hasRealEnchant = true;
                }
                if (((String)item.getKey()).equals("Force") && product.func_77973_b() instanceof ItemForceSword) {
                    realEnchants.func_74742_a((NBTBase)this.simulateEnchant(19, (Integer)item.getValue()));
                    hasRealEnchant = true;
                }
                if (((String)item.getKey()).equals("Damage")) {
                    if (product.func_77973_b() instanceof ItemForceSword) {
                        realEnchants.func_74742_a((NBTBase)this.simulateEnchant(16, (Integer)item.getValue() * 2));
                        hasRealEnchant = true;
                    }
                    if (product.func_77973_b() instanceof ItemForceBow) {
                        realEnchants.func_74742_a((NBTBase)this.simulateEnchant(48, (Integer)item.getValue()));
                        hasRealEnchant = true;
                    }
                }
                if (((String)item.getKey()).equals("Light") && product.func_77973_b() instanceof ItemForceSword) {
                    realEnchants.func_74742_a((NBTBase)this.simulateEnchant(17, (Integer)item.getValue()));
                    hasRealEnchant = true;
                }
                if (((String)item.getKey()).equals("Repair") && ThaumCraftIntegration.enchRepair != null) {
                    realEnchants.func_74742_a((NBTBase)this.simulateEnchant(ThaumCraftIntegration.enchRepair.field_77352_x, (Integer)item.getValue()));
                    hasRealEnchant = true;
                }
                if (!((String)item.getKey()).equals("Soul") || SoulShardsIntegration.soulStealing == null) continue;
                realEnchants.func_74742_a((NBTBase)this.simulateEnchant(SoulShardsIntegration.soulStealing.field_77352_x, (Integer)item.getValue()));
                hasRealEnchant = true;
            }
        }
        IForceWildCard wildCard = DartUtils.getWildCard(product);
        if (product.func_77973_b() instanceof ItemForcePack) {
            int size = product.func_77978_p().func_74762_e("size");
            if (upgrades.containsKey("Holding")) {
                if ((size += (Integer)upgrades.get("Holding") * 8) % 8 != 0) {
                    size -= size % 8;
                }
                if (size > 40) {
                    size = 40;
                }
                product.func_77978_p().func_74768_a("size", size);
            } else if (upgrades.containsKey("Sturdy")) {
                if (!product.func_77978_p().func_74764_b("upgrades")) {
                    product.func_77978_p().func_74766_a("upgrades", new NBTTagCompound());
                }
                UpgradeHelper.getUpgradeCompound(product).func_74768_a("Sturdy", 1);
            } else if (upgrades.containsKey("Ender")) {
                ItemInventory inv = new ItemInventory(product.func_77978_p().func_74762_e("size"), product);
                if (inv != null) {
                    for (int i = 0; i < inv.func_70302_i_(); ++i) {
                        ItemStack dropStack = inv.func_70301_a(i);
                        if (dropStack == null) continue;
                        DartUtils.dropItem(dropStack, this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
                    }
                }
                product = new ItemStack((Item)DartItem.enderPack, 1);
            }
        } else if (product.func_77973_b() instanceof ItemForceArmor || product.func_77973_b() instanceof ItemMemberCard) {
            if (!product.func_77942_o()) {
                product.func_77982_d(new NBTTagCompound());
            }
            product.func_77978_p().func_74766_a("upgrades", upgradeComp);
        } else if (wildCard != null && wildCard.hasOutput()) {
            product = wildCard.getOutput();
            if (DartItem.diamondDrill != null && DartItem.diamondDrill.field_77993_c == wildCard.getInput().field_77993_c && Proxies.common.isSimulating(this.field_70331_k)) {
                DartUtils.dropItem(new ItemStack(Item.field_77702_n, 3), this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
            }
        } else {
            if (hasRealEnchant && !(product.func_77973_b() instanceof ItemUpgradeCore)) {
                comp.func_74782_a("ench", (NBTBase)realEnchants);
            }
            comp.func_74766_a("upgrades", upgradeComp);
            product.func_77982_d(comp);
        }
        for (int i = 3; i < 11; ++i) {
            this.inventoryContents[i] = null;
        }
        this.inventoryContents[2] = product;
        this.inventoryContents[2].field_77994_a = 1;
        if (dropXP && Proxies.common.isSimulating(this.field_70331_k)) {
            DartUtils.dropXPAt(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, bonusXp, 10);
        }
        this.field_70331_k.func_72908_a((double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n, "bluedart.magic", 1.0f, DartUtils.randomPitch());
        PacketDispatcher.sendPacketToAllAround((double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n, (double)30.0, (int)this.field_70331_k.func_72912_H().func_76076_i(), (Packet)new FXPacket(20, this.field_70329_l, this.field_70330_m, this.field_70327_n).getPacket());
    }

    private NBTTagCompound simulateEnchant(int type, int level) {
        NBTTagCompound realEnch = new NBTTagCompound();
        realEnch.func_74777_a("id", (short)type);
        realEnch.func_74777_a("lvl", (short)level);
        return realEnch;
    }

    public String func_70303_b() {
        return "Force Infuser";
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer var1) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public LiquidStack getLiquid() {
        return this.liquid;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int fill(LiquidStack resource, boolean doFill) {
        if (resource == null || resource.itemID <= 0) {
            return 0;
        }
        if (this.liquid == null || this.liquid.itemID <= 0) {
            if (resource.amount <= this.capacity) {
                if (doFill) {
                    this.liquid = resource.copy();
                }
                return resource.amount;
            }
            if (doFill) {
                this.liquid = resource.copy();
                this.liquid.amount = this.capacity;
                LiquidEvent.fireEvent((LiquidEvent)new LiquidEvent.LiquidFillingEvent(this.liquid, this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, (ILiquidTank)this));
            }
            return this.capacity;
        }
        if (!this.liquid.isLiquidEqual(resource)) {
            return 0;
        }
        int space = this.capacity - this.liquid.amount;
        if (resource.amount <= space) {
            if (doFill) {
                this.liquid.amount += resource.amount;
            }
            return resource.amount;
        }
        if (doFill) {
            this.liquid.amount = this.capacity;
        }
        return space;
    }

    public LiquidStack drain(int maxDrain, boolean doDrain) {
        if (this.liquid == null || this.liquid.itemID <= 0 || this.liquid.amount <= 0) {
            return null;
        }
        int used = maxDrain;
        if (this.liquid.amount < used) {
            used = this.liquid.amount;
        }
        if (doDrain) {
            this.liquid.amount -= used;
        }
        LiquidStack drained = new LiquidStack(this.liquid.itemID, used, this.liquid.itemMeta);
        if (this.liquid.amount < 0) {
            this.liquid.amount = 0;
        }
        if (doDrain) {
            LiquidEvent.fireEvent((LiquidEvent)new LiquidEvent.LiquidDrainingEvent(drained, this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, (ILiquidTank)this));
        }
        return drained;
    }

    public int getTankPressure() {
        return this.tankPressure;
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        return this.fill(0, resource, doFill);
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        return this.fill(resource, doFill);
    }

    public LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.drain(0, maxDrain, doDrain);
    }

    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        return this.drain(maxDrain, doDrain);
    }

    public ILiquidTank[] getTanks(ForgeDirection direction) {
        return new ILiquidTank[]{this};
    }

    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        return this;
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public boolean manageLiquids() {
        return true;
    }

    @Override
    public boolean manageSolids() {
        return false;
    }

    public boolean allowAction(IAction e) {
        return false;
    }

    @Override
    public void setPowerProvider(IPowerProvider provider) {
    }

    @Override
    public IPowerProvider getPowerProvider() {
        return this.provider;
    }

    @Override
    public void doWork() {
    }

    @Override
    public int powerRequest(ForgeDirection from) {
        if (this.isActive()) {
            return (int)Math.ceil(Math.min((float)this.getPowerProvider().getMaxEnergyReceived(), (float)this.getPowerProvider().getMaxEnergyStored() - this.getPowerProvider().getEnergyStored()));
        }
        return 0;
    }

    public boolean func_94042_c() {
        return false;
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        return false;
    }

    public int[] func_94128_d(int var1) {
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
    }

    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        System.out.println("Side: " + j);
        return false;
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return false;
    }
}

