/*
 * Decompiled with CFR 0.152.
 */
package bluedart.tile;

import bluedart.api.EngineLiquid;
import bluedart.api.ForceEngineLiquids;
import bluedart.item.DartItem;
import bluedart.proxy.Proxies;
import bluedart.utils.DartUtils;
import bluedart.utils.MyPowerProvider;
import bluedart.utils.UtilsBlock;
import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.transport.IPipeConnection;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidContainerRegistry;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.liquids.LiquidTank;

public class TileEntityForceEngine
extends TileEntity
implements IPipeConnection,
IPowerReceptor,
ITankContainer,
IInventory {
    public static final int MAX_STORED = 25000;
    public static final int MAX_LIQUID = 10000;
    public static final int MAX_CYCLE_ENERGY = 250;
    public InventoryBasic liquidInventory;
    public ItemStack liquidSlot;
    public MyPowerProvider provider = new MyPowerProvider();
    public byte facing;
    public boolean isActive;
    public boolean isShutdown;
    public boolean canCycle;
    public boolean stageCycle;
    public float fuelMJ;
    public float cycleProgress;
    public int fuelLossCycle;
    public int throttleLossCycle;
    public int packetTime;
    public LiquidTank fuelTank;
    public LiquidTank throttleTank;

    public TileEntityForceEngine() {
        this.provider.configure(0, 25000);
        this.fuelTank = new LiquidTank(10000);
        this.throttleTank = new LiquidTank(10000);
        this.throttleLossCycle = 0;
        this.fuelLossCycle = 0;
        this.liquidInventory = new InventoryBasic("forceEngine.stacks", false, 2);
        this.liquidInventory.func_70299_a(0, (ItemStack)null);
        this.liquidInventory.func_70299_a(1, (ItemStack)null);
    }

    public float getEnergy() {
        return this.provider.getEnergyStored();
    }

    @Override
    public void setPowerProvider(IPowerProvider provider) {
    }

    @Override
    public IPowerProvider getPowerProvider() {
        return this.provider;
    }

    @Override
    public void doWork() {
    }

    @Override
    public boolean isPipeConnected(ForgeDirection with) {
        return with.ordinal() != this.facing;
    }

    public byte getFacing() {
        return this.facing;
    }

    public float getCycleProgress() {
        return this.cycleProgress;
    }

    public boolean setFacing(int i) {
        if (i >= 0 && i < 6) {
            this.facing = (byte)i;
            return true;
        }
        return false;
    }

    public boolean rotateBlock() {
        for (int i = this.facing + 1; i < this.facing + 6; ++i) {
            int[] coords = UtilsBlock.getAdjacentCoordinatesForSide(this.field_70329_l, this.field_70330_m, this.field_70327_n, i % 6);
            TileEntity tile = this.field_70331_k.func_72796_p(coords[0], coords[1], coords[2]);
            if (!DartUtils.isPoweredTile(tile)) continue;
            this.facing = (byte)(i % 6);
            this.sendUpdatePacket(Side.CLIENT);
            return true;
        }
        return false;
    }

    public int getLightValue() {
        return this.isActive ? 7 : 0;
    }

    protected boolean canCycle() {
        int[] coords = UtilsBlock.getAdjacentCoordinatesForSide(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.facing);
        TileEntity tile = this.field_70331_k.func_72796_p(coords[0], coords[1], coords[2]);
        this.canCycle = tile != null && tile instanceof IPowerReceptor;
        return this.canCycle;
    }

    protected boolean canProcess() {
        return this.fuelTank.getLiquid() != null && this.fuelTank.getLiquid().amount > 0;
    }

    public float getEnergyPerProcess() {
        if (this.fuelTank.getLiquid() == null) {
            return 0.0f;
        }
        EngineLiquid fuel = ForceEngineLiquids.getEngineLiquid(this.fuelTank.getLiquid());
        EngineLiquid throttle = null;
        if (this.throttleTank.getLiquid() != null) {
            throttle = ForceEngineLiquids.getEngineLiquid(this.throttleTank.getLiquid());
        }
        if (fuel == null) {
            return 0.0f;
        }
        float energy = fuel.getModifier();
        if (throttle != null) {
            energy *= throttle.getModifier();
        }
        return energy;
    }

    private void doLoss() {
        if (this.fuelTank.getLiquid() == null) {
            return;
        }
        EngineLiquid fuel = ForceEngineLiquids.getEngineLiquid(this.fuelTank.getLiquid());
        EngineLiquid throttle = null;
        if (this.throttleTank.getLiquid() != null) {
            throttle = ForceEngineLiquids.getEngineLiquid(this.throttleTank.getLiquid());
        }
        if (fuel != null) {
            ++this.fuelLossCycle;
            if (this.fuelLossCycle >= fuel.getBurnTime() / 1000) {
                this.fuelTank.getLiquid().amount = this.fuelTank.getLiquid().amount - (1000 / fuel.getBurnTime() > 0 ? 1000 / fuel.getBurnTime() : 1);
                this.fuelLossCycle = 0;
            }
        }
        if (throttle != null) {
            ++this.throttleLossCycle;
            if (this.throttleLossCycle >= throttle.getBurnTime() / 1000) {
                this.throttleTank.getLiquid().amount = this.throttleTank.getLiquid().amount - (1000 / throttle.getBurnTime() > 0 ? 1000 / throttle.getBurnTime() : 1);
                this.throttleLossCycle = 0;
            }
        }
        if (this.fuelTank.getLiquid() != null && this.fuelTank.getLiquid().amount <= 0) {
            this.fuelTank.setLiquid((LiquidStack)null);
        }
        if (this.throttleTank.getLiquid() != null && this.throttleTank.getLiquid().amount <= 0) {
            this.throttleTank.setLiquid((LiquidStack)null);
        }
    }

    public void processActive() {
        if (this.fuelMJ <= 0.0f) {
            this.fuelMJ += this.getEnergyPerProcess();
            this.doLoss();
        }
        if (this.fuelMJ > 0.0f) {
            float energyToAdd = this.getEnergyPerProcess();
            this.provider.addEnergy(energyToAdd);
            this.fuelMJ -= energyToAdd;
        }
    }

    public Packet func_70319_e() {
        NBTTagCompound comp = new NBTTagCompound();
        this.func_70310_b(comp);
        Packet132TileEntityData pack = new Packet132TileEntityData(this.field_70329_l, this.field_70330_m, this.field_70327_n, 0, comp);
        return pack;
    }

    public void onDataPacket(INetworkManager net, Packet132TileEntityData pkt) {
        if (pkt != null && pkt.field_73331_e != null) {
            this.func_70307_a(pkt.field_73331_e);
            this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            this.field_70331_k.func_72969_x(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
    }

    public void sendUpdatePacket(Side side) {
        this.packetTime = 0;
        if (Proxies.common.isSimulating(this.field_70331_k) && side == Side.CLIENT) {
            PacketDispatcher.sendPacketToAllPlayers((Packet)this.func_70319_e());
            this.field_70331_k.func_72969_x(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        } else if (!Proxies.common.isSimulating(this.field_70331_k) && side == Side.SERVER) {
            PacketDispatcher.sendPacketToServer((Packet)this.func_70319_e());
        }
    }

    public void sendGuiNetworkData(Container container, ICrafting craft) {
        int throttleMeta = 0;
        int throttleID = 0;
        int throttleAmount = 0;
        int fuelMeta = 0;
        int fuelID = 0;
        int fuelAmount = 0;
        if (this.fuelTank.getLiquid() != null) {
            fuelID = this.fuelTank.getLiquid().itemID;
            fuelMeta = this.fuelTank.getLiquid().itemMeta;
            fuelAmount = this.fuelTank.getLiquid().amount;
        }
        if (this.throttleTank.getLiquid() != null) {
            throttleID = this.throttleTank.getLiquid().itemID;
            throttleMeta = this.throttleTank.getLiquid().itemMeta;
            throttleAmount = this.throttleTank.getLiquid().amount;
        }
        craft.func_71112_a(container, 0, fuelID);
        craft.func_71112_a(container, 1, fuelMeta);
        craft.func_71112_a(container, 2, fuelAmount);
        craft.func_71112_a(container, 3, throttleID);
        craft.func_71112_a(container, 4, throttleMeta);
        craft.func_71112_a(container, 5, throttleAmount);
        if (craft instanceof Player && Proxies.common.isSimulating(this.field_70331_k)) {
            PacketDispatcher.sendPacketToPlayer((Packet)this.func_70319_e(), (Player)((Player)craft));
        }
    }

    public void receiveGuiNetworkData(int i, int j) {
        LiquidStack tempStack = this.fuelTank.getLiquid();
        LiquidStack tempStack2 = this.throttleTank.getLiquid();
        switch (i) {
            case 0: {
                if (this.fuelTank.getLiquid() != null) {
                    this.fuelTank.setLiquid(new LiquidStack(j, tempStack.amount, tempStack.itemMeta));
                    break;
                }
                this.fuelTank.setLiquid(new LiquidStack(j, 0));
                break;
            }
            case 1: {
                if (this.fuelTank.getLiquid() != null) {
                    this.fuelTank.setLiquid(new LiquidStack(tempStack.itemID, tempStack.amount, j));
                    break;
                }
                this.fuelTank.setLiquid(new LiquidStack(0, 0, j));
                break;
            }
            case 2: {
                if (this.fuelTank.getLiquid() != null) {
                    this.fuelTank.getLiquid().amount = j;
                    break;
                }
                this.fuelTank.setLiquid(new LiquidStack(0, j));
                break;
            }
            case 3: {
                if (this.throttleTank.getLiquid() != null) {
                    this.throttleTank.setLiquid(new LiquidStack(j, tempStack2.amount, tempStack2.itemMeta));
                    break;
                }
                this.throttleTank.setLiquid(new LiquidStack(j, 0));
                break;
            }
            case 4: {
                if (this.throttleTank.getLiquid() != null) {
                    this.throttleTank.setLiquid(new LiquidStack(tempStack2.itemID, tempStack2.amount, j));
                    break;
                }
                this.throttleTank.setLiquid(new LiquidStack(0, 0, j));
                break;
            }
            case 5: {
                if (this.throttleTank.getLiquid() != null) {
                    this.throttleTank.getLiquid().amount = j;
                    break;
                }
                this.throttleTank.setLiquid(new LiquidStack(0, j));
            }
        }
    }

    protected void transferEnergy() {
        int[] coords = UtilsBlock.getAdjacentCoordinatesForSide(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.facing);
        TileEntity tile = this.field_70331_k.func_72796_p(coords[0], coords[1], coords[2]);
        if (DartUtils.isPoweredTile(tile)) {
            IPowerProvider tilePP = ((IPowerReceptor)tile).getPowerProvider();
            float energyMax = Math.min((float)tilePP.getMaxEnergyStored() - tilePP.getEnergyStored(), 250.0f);
            float energy = this.provider.useEnergy(0.0f, energyMax, true);
            tilePP.receiveEnergy(energy, ForgeDirection.VALID_DIRECTIONS[this.facing].getOpposite());
        }
    }

    public void func_70316_g() {
        ItemStack temp;
        EngineLiquid tempEngineStack;
        LiquidStack tempStack;
        if (!Proxies.common.isSimulating(this.field_70331_k)) {
            if (this.cycleProgress > 0.0f || this.isActive && this.canCycle) {
                this.cycleProgress += 0.04f;
                if (this.cycleProgress >= 1.0f) {
                    this.cycleProgress = 0.0f;
                }
            }
            return;
        }
        if (this.liquidInventory.func_70301_a(0) != null) {
            tempStack = LiquidContainerRegistry.getLiquidForFilledItem((ItemStack)this.liquidInventory.func_70301_a(0));
            if (tempStack != null && (tempEngineStack = ForceEngineLiquids.getEngineLiquid(tempStack)) != null && (this.fuelTank.getLiquid() == null || this.fuelTank.getLiquid().itemID == tempStack.itemID && this.fuelTank.getLiquid().itemMeta == tempStack.itemMeta) && (this.fuelTank.getLiquid() == null || 10000 >= this.fuelTank.getLiquid().amount + tempStack.amount)) {
                this.fuelTank.fill(tempStack, true);
                temp = this.liquidInventory.func_70301_a(0);
                if (temp.field_77994_a == 1 && temp.func_77973_b().func_77634_r()) {
                    this.liquidInventory.func_70299_a(0, temp.func_77973_b().getContainerItemStack(temp));
                } else {
                    this.liquidInventory.func_70298_a(0, 1);
                }
            }
            if (this.liquidInventory.func_70301_a(0) != null && this.liquidInventory.func_70301_a((int)0).field_77993_c == DartItem.gemForce.field_77779_bT && (this.fuelTank.getLiquid() == null || 10000 >= this.fuelTank.getLiquid().amount + 1000)) {
                this.fuelTank.fill(DartItem.liquidStack, true);
                this.liquidInventory.func_70298_a(0, 1);
            }
        }
        if (this.liquidInventory.func_70301_a(1) != null && (tempStack = LiquidContainerRegistry.getLiquidForFilledItem((ItemStack)this.liquidInventory.func_70301_a(1))) != null && (tempEngineStack = ForceEngineLiquids.getEngineLiquid(tempStack)) != null && (this.throttleTank.getLiquid() == null || this.throttleTank.getLiquid().itemID == tempStack.itemID && this.throttleTank.getLiquid().itemMeta == tempStack.itemMeta) && (this.throttleTank.getLiquid() == null || 10000 >= this.throttleTank.getLiquid().amount + tempStack.amount)) {
            this.throttleTank.fill(tempStack, true);
            temp = this.liquidInventory.func_70301_a(1);
            if (temp.field_77994_a == 1 && temp.func_77973_b().func_77634_r()) {
                this.liquidInventory.func_70299_a(1, temp.func_77973_b().getContainerItemStack(temp));
            } else {
                this.liquidInventory.func_70298_a(1, 1);
            }
        }
        if (this.cycleProgress > 0.0f || this.isActive && this.canCycle) {
            this.cycleProgress += 0.04f;
            if (this.cycleProgress >= 1.0f) {
                this.cycleProgress = 0.0f;
                this.stageCycle = false;
            } else if ((double)this.cycleProgress >= 0.5 && !this.stageCycle) {
                this.transferEnergy();
                this.stageCycle = true;
            }
        }
        boolean curActive = this.isActive;
        boolean curCycle = this.canCycle;
        if (this.field_70331_k.func_72864_z(this.field_70329_l, this.field_70330_m, this.field_70327_n) && this.canCycle()) {
            if (this.canProcess()) {
                this.isActive = true;
                this.processActive();
            } else {
                this.isActive = false;
            }
        } else {
            this.isActive = false;
        }
        if (curActive != this.isActive || curCycle != this.canCycle) {
            this.sendUpdatePacket(Side.CLIENT);
        }
    }

    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        try {
            this.provider.setEnergyStored(data.func_74760_g("stored"));
            if (Float.isNaN(this.provider.getEnergyStored())) {
                this.provider.setEnergyStored(0.0f);
            }
        }
        catch (Exception e) {
            this.provider.setEnergyStored(0.0f);
        }
        this.facing = data.func_74771_c("facing");
        this.isActive = data.func_74767_n("active");
        this.fuelMJ = data.func_74760_g("fuelMJ");
        this.canCycle = data.func_74767_n("cycle");
        if (data.func_74764_b("fuel")) {
            this.fuelTank.setLiquid(LiquidStack.loadLiquidStackFromNBT((NBTTagCompound)data.func_74775_l("fuel")));
        }
        if (data.func_74764_b("throttle")) {
            this.throttleTank.setLiquid(LiquidStack.loadLiquidStackFromNBT((NBTTagCompound)data.func_74775_l("throttle")));
        }
        if (data.func_74764_b("fuelSlot")) {
            this.liquidInventory.func_70299_a(0, ItemStack.func_77949_a((NBTTagCompound)data.func_74775_l("fuelSlot")));
        } else {
            this.liquidInventory.func_70299_a(0, (ItemStack)null);
        }
        if (data.func_74764_b("throttleSlot")) {
            this.liquidInventory.func_70299_a(1, ItemStack.func_77949_a((NBTTagCompound)data.func_74775_l("throttleSlot")));
        } else {
            this.liquidInventory.func_70299_a(1, (ItemStack)null);
        }
    }

    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        data.func_74776_a("stored", this.provider.getEnergyStored());
        data.func_74774_a("facing", this.facing);
        data.func_74757_a("active", this.isActive);
        data.func_74776_a("fuelMJ", this.fuelMJ);
        data.func_74757_a("cycle", this.canCycle);
        if (this.fuelTank.getLiquid() != null) {
            data.func_74766_a("fuel", this.fuelTank.getLiquid().writeToNBT(new NBTTagCompound()));
        }
        if (this.throttleTank.getLiquid() != null) {
            data.func_74766_a("throttle", this.throttleTank.getLiquid().writeToNBT(new NBTTagCompound()));
        }
        if (this.liquidInventory.func_70301_a(0) != null) {
            data.func_74766_a("fuelSlot", this.liquidInventory.func_70301_a(0).func_77955_b(new NBTTagCompound()));
        }
        if (this.liquidInventory.func_70301_a(1) != null) {
            data.func_74766_a("throttleSlot", this.liquidInventory.func_70301_a(1).func_77955_b(new NBTTagCompound()));
        }
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        if (ForceEngineLiquids.isFuel(resource)) {
            int filled = this.fuelTank.fill(resource, doFill);
            return filled;
        }
        if (ForceEngineLiquids.isThrottle(resource)) {
            int filled = this.throttleTank.fill(resource, doFill);
            return filled;
        }
        return 0;
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        return 0;
    }

    public LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        return null;
    }

    public ILiquidTank[] getTanks(ForgeDirection direction) {
        return new LiquidTank[]{this.fuelTank, this.throttleTank};
    }

    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        switch (direction) {
            case UP: {
                return this.fuelTank;
            }
            case DOWN: {
                return this.throttleTank;
            }
        }
        return null;
    }

    @Override
    public int powerRequest(ForgeDirection from) {
        return 0;
    }

    public int func_70302_i_() {
        return this.liquidInventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int i) {
        return this.liquidInventory.func_70301_a(i);
    }

    public ItemStack func_70298_a(int i, int j) {
        return this.liquidInventory.func_70298_a(i, j);
    }

    public ItemStack func_70304_b(int i) {
        return this.liquidInventory.func_70304_b(i);
    }

    public void func_70299_a(int i, ItemStack stack) {
        this.liquidInventory.func_70299_a(i, stack);
    }

    public String func_70303_b() {
        return this.liquidInventory.func_70303_b();
    }

    public boolean func_94042_c() {
        return this.liquidInventory.func_94042_c();
    }

    public int func_70297_j_() {
        return this.liquidInventory.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.liquidInventory.func_70300_a(player);
    }

    public void func_70295_k_() {
        this.liquidInventory.func_70295_k_();
    }

    public void func_70305_f() {
        this.liquidInventory.func_70305_f();
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        switch (i) {
            case 0: {
                return ForceEngineLiquids.isFuel(LiquidContainerRegistry.getLiquidForFilledItem((ItemStack)stack));
            }
            case 1: {
                return ForceEngineLiquids.isThrottle(LiquidContainerRegistry.getLiquidForFilledItem((ItemStack)stack));
            }
        }
        return false;
    }
}

