/*
 * Decompiled with CFR 0.152.
 */
package bluedart.tile;

import bluedart.proxy.Proxies;
import bluedart.proxy.ProxyCommon;
import bluedart.tile.BlockPattern;
import bluedart.utils.DartUtils;
import buildcraft.api.core.SafeTimeTracker;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.ForgeDirection;

public abstract class MultiBlock
extends TileEntity {
    private static final int UNKNOWN_STATE_RECHECK = 256;
    private static final int NETWORK_RECHECK = 64;
    private static final int NEIGHBOR_CHECK = 32;
    protected boolean isMaster;
    private byte patternX;
    private byte patternY;
    private byte patternZ;
    private boolean checkNeighbors = true;
    private boolean tested;
    private boolean requestPacket;
    protected int update = ProxyCommon.rand.nextInt();
    private SafeTimeTracker timeTracker = new SafeTimeTracker();
    private MultiBlockState state;
    private MultiBlock masterBlock;
    private BlockPattern currentPattern;
    private final List patterns;
    private final MultiBlock[] neighbors = new MultiBlock[6];
    private int id;

    public MultiBlock(List patterns, int id) {
        this.patterns = patterns;
        this.id = id;
        this.currentPattern = (BlockPattern)patterns.get(0);
        this.tested = FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT;
    }

    protected void onPatternLock(BlockPattern pattern) {
    }

    public final char getPatternMarker() {
        if (this.currentPattern == null || !this.isStructureValid()) {
            return 'O';
        }
        return this.currentPattern.getPatternMarker(this.patternX, this.patternY, this.patternZ);
    }

    public final int getPatternPositionX() {
        return this.patternX;
    }

    public final int getPatternPositionY() {
        return this.patternY;
    }

    public final int getPatternPositionZ() {
        return this.patternZ;
    }

    private void setPatternPosition(byte x, byte y, byte z) {
        this.patternX = x;
        this.patternY = y;
        this.patternZ = z;
    }

    public final void setPattern(BlockPattern pattern) {
        this.currentPattern = pattern;
        this.onPatternLock(pattern);
    }

    public final BlockPattern getPattern() {
        return this.currentPattern;
    }

    public final byte getPatternIndex() {
        return (byte)this.patterns.indexOf(this.currentPattern);
    }

    protected int getMaxRecursionDepth() {
        return 12;
    }

    public final boolean canUpdate() {
        return true;
    }

    public void func_70316_g() {
        super.func_70316_g();
        ++this.update;
        if (!Proxies.common.isSimulating(this.field_70331_k)) {
            if (this.update % 32 == 0) {
                this.grabNeighbors(this.checkNeighbors);
            }
            if (!(this.tested || this.state == MultiBlockState.UNKNOWN && this.update % 256 != 0)) {
                this.testIfMasterBlock();
            }
        } else if (this.requestPacket && this.timeTracker.markTimeIfDelay(this.field_70331_k, 64L)) {
            this.requestPacket = false;
        }
    }

    private void testIfMasterBlock() {
        this.state = this.getMasterBlockState();
        this.tested = true;
        if (this.state == MultiBlockState.UNKNOWN) {
            this.tested = false;
        } else if (this.state == MultiBlockState.VALID) {
            this.isMaster = true;
            byte by = this.currentPattern.getPatternWidthX();
            byte by2 = this.currentPattern.getPatternWidthZ();
            byte by3 = this.currentPattern.getPatternHeight();
            int xOffset = this.field_70329_l - this.currentPattern.getMasterOffsetX();
            int yOffset = this.field_70330_m - this.currentPattern.getMasterOffsetY();
            int zOffset = this.field_70327_n - this.currentPattern.getMasterOffsetZ();
            for (byte px = 0; px < by; px = (byte)((byte)(px + 1))) {
                for (byte py = 0; py < by3; py = (byte)((byte)(py + 1))) {
                    for (byte pz = 0; pz < by2; pz = (byte)((byte)(pz + 1))) {
                        char marker = this.currentPattern.getPatternMarker(px, py, pz);
                        if (this.isMapPositionOtherBlock(marker)) continue;
                        int x = px + xOffset;
                        int y = py + yOffset;
                        int z = pz + zOffset;
                        TileEntity tile = this.field_70331_k.func_72796_p(x, y, z);
                        if (tile instanceof MultiBlock) {
                            MultiBlock multiBlock = (MultiBlock)tile;
                            multiBlock.masterBlock = this;
                            multiBlock.tested = true;
                            multiBlock.checkNeighbors = true;
                            multiBlock.setPattern(this.currentPattern);
                            multiBlock.setPatternPosition(px, py, pz);
                            multiBlock.markBlockForUpdate();
                            continue;
                        }
                        return;
                    }
                }
            }
        } else {
            if (this.isMaster) {
                this.onMasterReset();
                this.markBlockForUpdate();
            }
            this.isMaster = false;
        }
    }

    protected void onMasterReset() {
    }

    protected boolean isMapPositionOtherBlock(char mapPos) {
        switch (mapPos) {
            case 'A': 
            case 'O': {
                return true;
            }
        }
        return false;
    }

    protected boolean isMapPositionValid(int i, int j, int k, char mapPos) {
        int id = this.field_70331_k.func_72798_a(i, j, k);
        switch (mapPos) {
            case 'O': {
                if (id != this.id || this.field_70331_k.func_72805_g(i, j, k) != this.func_70322_n()) break;
                return false;
            }
            case 'B': 
            case 'W': {
                if (id == this.id && this.field_70331_k.func_72805_g(i, j, k) == this.func_70322_n()) break;
                return false;
            }
            case 'A': {
                if (this.field_70331_k.func_72799_c(i, j, k)) break;
                return false;
            }
        }
        return true;
    }

    private MultiBlockState getMasterBlockState() {
        for (BlockPattern map : this.patterns) {
            boolean valid = true;
            int xWidth = map.getPatternWidthX();
            int zWidth = map.getPatternWidthZ();
            int height = map.getPatternHeight();
            int xOffset = this.field_70329_l - map.getMasterOffsetX();
            int yOffset = this.field_70330_m - map.getMasterOffsetY();
            int zOffset = this.field_70327_n - map.getMasterOffsetZ();
            for (int x = 0; x < xWidth && valid; ++x) {
                block2: for (int y = 0; y < height && valid; ++y) {
                    for (int z = 0; z < zWidth; ++z) {
                        int xx = x + xOffset;
                        int yy = y + yOffset;
                        int zz = z + zOffset;
                        if (!this.field_70331_k.func_72899_e(xx, yy, zz)) {
                            return MultiBlockState.UNKNOWN;
                        }
                        if (this.isMapPositionValid(xx, yy, zz, map.getPatternMarker(x, y, z))) continue;
                        valid = false;
                        continue block2;
                    }
                }
            }
            if (!valid) continue;
            AxisAlignedBB entityCheckBounds = map.getEntityCheckBounds(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            if (entityCheckBounds != null && !this.field_70331_k.func_72872_a(Entity.class, entityCheckBounds).isEmpty()) {
                return MultiBlockState.INVALID;
            }
            this.currentPattern = map;
            return MultiBlockState.VALID;
        }
        return MultiBlockState.INVALID;
    }

    private void grabNeighbors(boolean check) {
        if (check) {
            this.checkNeighbors = false;
            for (int side = 0; side < 6; ++side) {
                this.neighbors[side] = null;
                ForgeDirection dir = ForgeDirection.getOrientation((int)side);
                if (!DartUtils.blockExistsOnSide(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, dir)) {
                    this.checkNeighbors = true;
                    continue;
                }
                TileEntity tile = DartUtils.getBlockTileEntityOnSide(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, dir);
                if (tile == null || !this.isStructureTile(tile)) continue;
                this.neighbors[side] = (MultiBlock)tile;
            }
        }
    }

    public void onBlockAdded() {
        if (!Proxies.common.isSimulating(this.field_70331_k)) {
            return;
        }
        this.grabNeighbors(true);
        this.onBlockChange();
    }

    public void onBlockRemoval() {
        if (!Proxies.common.isSimulating(this.field_70331_k)) {
            return;
        }
        this.onBlockChange();
        this.isMaster = false;
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (!Proxies.common.isSimulating(this.field_70331_k)) {
            return;
        }
        this.tested = false;
        if (this.masterBlock != null) {
            this.masterBlock.tested = false;
        }
    }

    private void onBlockChange() {
        for (int side = 0; side < 6; ++side) {
            MultiBlock tile = this.neighbors[side];
            if (tile == null) continue;
            tile.grabNeighbors(true);
            tile.onBlockChange(this.getMaxRecursionDepth());
        }
    }

    private void onBlockChange(int depth) {
        if (--depth < 0) {
            return;
        }
        if (this.tested) {
            this.tested = false;
            for (int side = 0; side < 6; ++side) {
                MultiBlock tile = this.neighbors[side];
                if (tile != null && !tile.func_70320_p()) {
                    MultiBlock mBlock = tile.getMasterBlock();
                    if (mBlock == null) {
                        tile.onBlockChange(depth);
                        continue;
                    }
                    mBlock.grabNeighbors(true);
                    mBlock.onBlockChange(this.getMaxRecursionDepth());
                    continue;
                }
                this.neighbors[side] = null;
            }
        }
    }

    protected boolean isStructureTile(TileEntity tile) {
        return tile.getClass() == ((Object)((Object)this)).getClass();
    }

    public void func_70296_d() {
        MultiBlock mBlock;
        super.func_70296_d();
        if (!this.isMaster && (mBlock = this.getMasterBlock()) != null) {
            mBlock.func_70296_d();
        }
    }

    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        data.func_74757_a("master", this.isMaster);
    }

    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        this.isMaster = data.func_74767_n("master");
    }

    public void writePacketData(DataOutputStream data) throws IOException {
        MultiBlock m = this.getMasterBlock();
        data.writeBoolean(m != null);
        if (m != null) {
            byte patternIndex = (byte)this.patterns.indexOf(this.currentPattern);
            data.writeByte(patternIndex);
            data.writeByte(this.patternX);
            data.writeByte(this.patternY);
            data.writeByte(this.patternZ);
        }
    }

    public void readPacketData(DataInputStream data) throws IOException {
        this.requestPacket = false;
        boolean needsUpdate = false;
        boolean hasMaster = data.readBoolean();
        if (hasMaster) {
            BlockPattern pat;
            byte patternIndex = data.readByte();
            if (patternIndex >= 0 && patternIndex < this.patterns.size()) {
                this.setPattern((BlockPattern)this.patterns.get(patternIndex));
            }
            byte pX = data.readByte();
            byte pY = data.readByte();
            byte pZ = data.readByte();
            if (this.patternX != pX || this.patternY != pY || this.patternZ != pZ) {
                this.patternX = pX;
                this.patternY = pY;
                this.patternZ = pZ;
                needsUpdate = true;
            }
            this.isMaster = pX == (pat = this.getPattern()).getMasterOffsetX() && pY == pat.getMasterOffsetY() && pZ == pat.getMasterOffsetZ();
            int masterX = pat.getMasterRelativeX(this.field_70329_l, pX);
            int masterY = pat.getMasterRelativeY(this.field_70330_m, pY);
            int masterZ = pat.getMasterRelativeZ(this.field_70327_n, pZ);
            TileEntity tile = null;
            if (this.field_70331_k != null) {
                tile = this.field_70331_k.func_72796_p(masterX, masterY, masterZ);
            }
            if (tile != null && this.masterBlock != tile && this.isStructureTile(tile)) {
                needsUpdate = true;
                this.masterBlock = (MultiBlock)tile;
            }
            if (this.getMasterBlock() == null) {
                this.requestPacket = true;
            }
        } else if (this.masterBlock != null) {
            needsUpdate = true;
            this.masterBlock = null;
            this.isMaster = false;
        }
        if (needsUpdate) {
            this.markBlockForUpdate();
        }
    }

    public final boolean isMaster() {
        return this.isMaster;
    }

    public final void setMaster(boolean m) {
        this.isMaster = m;
    }

    public final void retestMasterBlock() {
        MultiBlock mBlock;
        if (!this.isMaster && (mBlock = this.getMasterBlock()) != null) {
            mBlock.retestMasterBlock();
        }
        this.tested = false;
    }

    public final boolean isStructureValid() {
        return this.masterBlock != null && this.masterBlock.tested && this.masterBlock.isMaster && !this.masterBlock.func_70320_p();
    }

    public final MultiBlock getMasterBlock() {
        if (this.masterBlock != null && !this.isStructureValid()) {
            this.masterBlock = null;
            this.markBlockForUpdate();
        }
        return this.masterBlock;
    }

    public boolean canCreatureSpawn(EnumCreatureType type) {
        return false;
    }

    public void markBlockForUpdate() {
        this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    private static enum MultiBlockState {
        VALID,
        INVALID,
        UNKNOWN;

    }
}

