/*
 * Decompiled with CFR 0.152.
 */
package bluedart.item.tool;

import bluedart.DartCraft;
import bluedart.api.DartAPI;
import bluedart.api.ForceUpgradeManager;
import bluedart.api.ISocketableTool;
import bluedart.block.DartBlock;
import bluedart.client.TabDart;
import bluedart.core.Config;
import bluedart.core.network.DartPacket;
import bluedart.core.network.TreeFXPacket;
import bluedart.item.ElectricTool;
import bluedart.proxy.Proxies;
import bluedart.proxy.ProxyCommon;
import bluedart.utils.DartUtils;
import bluedart.utils.SocketHelper;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.ElectricItem;
import ic2.core.Ic2Items;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.EnumToolMaterial;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.packet.Packet;
import net.minecraft.stats.StatList;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumHelper;
import net.minecraftforge.common.IShearable;

public class ItemPowerSaw
extends ElectricTool
implements ISocketableTool {
    private static int damage = 10;
    private static float efficiency = 10.0f;
    private static int toolLevel = 10;
    public static EnumToolMaterial material = EnumHelper.addToolMaterial((String)"FORCE", (int)toolLevel, (int)512, (float)efficiency, (int)damage, (int)0);

    public ItemPowerSaw(int id) {
        super(id, material, 50);
        this.maxCharge = 15000;
        this.transferLimit = 100;
        this.tier = 1;
        this.field_77864_a = 12.0f;
        this.field_77865_bY = 1;
        this.func_77637_a(TabDart.instance);
        this.func_77655_b("powerSaw");
        this.loadMinables();
    }

    public void loadMinables() {
        this.mineableBlocks.add(Block.field_71988_x);
        this.mineableBlocks.add(Block.field_72093_an);
        this.mineableBlocks.add(Block.field_71951_J);
        this.mineableBlocks.add(Block.field_72077_au);
        this.mineableBlocks.add(Block.field_71952_K);
        this.mineableBlocks.add(Block.field_71955_W);
        this.mineableBlocks.add(DartBlock.forceLog);
        this.mineableBlocks.add(DartBlock.forceLeaves);
        if (Loader.isModLoaded((String)"IC2")) {
            if (Ic2Items.crop != null) {
                this.mineableBlocks.add(Block.field_71973_m[Ic2Items.crop.field_77993_c]);
            }
            if (Ic2Items.rubberLeaves != null) {
                this.mineableBlocks.add(Block.field_71973_m[Ic2Items.rubberLeaves.field_77993_c]);
            }
        }
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean thing) {
        NBTTagCompound upgrades = SocketHelper.getSocketCompound(stack);
        if (upgrades.func_74764_b("Force")) {
            list.add("Force");
        }
        if (upgrades.func_74764_b("Wing")) {
            list.add("Wing");
        }
        if (upgrades.func_74764_b("Lumberjack")) {
            list.add("Lumberjack");
        }
        if (upgrades.func_74764_b("Grinding")) {
            list.add("Grinding");
        }
        if (upgrades.func_74764_b("Heat")) {
            list.add("Heat");
        }
        if (upgrades.func_74764_b("Speed")) {
            list.add("Speed" + DartUtils.enchantName(upgrades.func_74762_e("Speed")));
        }
        if (upgrades.func_74764_b("Damage")) {
            list.add("Damage" + DartUtils.enchantName(upgrades.func_74762_e("Damage")));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.uncommon;
    }

    public boolean func_77636_d(ItemStack stack) {
        return false;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int par4, boolean par5) {
        NBTTagCompound comp;
        super.func_77663_a(stack, world, entity, par4, par5);
        if (!Proxies.common.isSimulating(world)) {
            return;
        }
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (!(comp = stack.func_77978_p()).func_74764_b("contents")) {
            this.initializeCompound(comp);
        }
        if (!comp.func_74764_b("ID")) {
            comp.func_74768_a("ID", ProxyCommon.rand.nextInt());
        }
    }

    private void initializeCompound(NBTTagCompound comp) {
        NBTTagList contents = new NBTTagList();
        for (int i = 0; i < this.socketCount(); ++i) {
            NBTTagCompound itemComp = new NBTTagCompound();
            itemComp.func_74774_a("Slot", (byte)i);
            contents.func_74742_a((NBTBase)itemComp);
        }
        comp.func_74782_a("contents", (NBTBase)contents);
        comp.func_74768_a("size", this.socketCount());
    }

    @Override
    public boolean func_77644_a(ItemStack stack, EntityLiving victim, EntityLiving player) {
        if (!Loader.isModLoaded((String)"IC2")) {
            return false;
        }
        if (ElectricItem.use(stack, this.operationEnergyCost, (EntityPlayer)player) && ElectricItem.use(stack, this.operationEnergyCost, (EntityPlayer)player)) {
            NBTTagCompound upgrades = SocketHelper.getSocketCompound(stack);
            if (upgrades.func_74764_b("Heat")) {
                victim.func_70015_d(5 * upgrades.func_74762_e("Heat"));
            }
            victim.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)player)), this.getAttackStrength(stack));
        } else {
            victim.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)player)), 1);
        }
        return false;
    }

    public int getAttackStrength(ItemStack stack) {
        NBTTagCompound upgrades = SocketHelper.getSocketCompound(stack);
        int damage = 10;
        if (upgrades.func_74764_b("Damage")) {
            damage += upgrades.func_74762_e("Damage") * 2;
        }
        return damage;
    }

    @Override
    public boolean func_77641_a(Block block) {
        if (block.field_72018_cp == Material.field_76245_d || block.field_72018_cp == Material.field_76268_x || block.field_72018_cp == Material.field_76257_i) {
            return true;
        }
        return super.func_77641_a(block);
    }

    public boolean onBlockStartBreak(ItemStack stack, int x, int y, int z, EntityPlayer player) {
        IShearable target;
        if (!Proxies.common.isSimulating(player.field_70170_p)) {
            return false;
        }
        World world = player.field_70170_p;
        int brokenID = world.func_72798_a(x, y, z);
        Block tempBlock = Block.field_71973_m[brokenID];
        if (Block.field_71973_m[brokenID] != null && Block.field_71973_m[brokenID] instanceof IShearable && (target = (IShearable)Block.field_71973_m[brokenID]).isShearable(stack, player.field_70170_p, x, y, z) && ElectricItem.use(stack, this.operationEnergyCost, player) && ElectricItem.use(stack, this.operationEnergyCost, player)) {
            ArrayList drops = target.onSheared(stack, player.field_70170_p, x, y, z, EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)stack));
            for (ItemStack stack2 : drops) {
                float f = 0.7f;
                double d = (double)(field_77697_d.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d1 = (double)(field_77697_d.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d2 = (double)(field_77697_d.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                EntityItem entityitem = new EntityItem(player.field_70170_p, (double)x + d, (double)y + d1, (double)z + d2, stack2);
                entityitem.field_70293_c = 10;
                player.field_70170_p.func_72838_d((Entity)entityitem);
            }
            player.func_71064_a(StatList.field_75934_C[brokenID], 1);
            return false;
        }
        NBTTagCompound upgrades = SocketHelper.getSocketCompound(stack);
        if (!(!upgrades.func_74764_b("Grinding") || upgrades.func_74764_b("Lumberjack") && DartUtils.isBlockWood(world, x, y + 1, z) || player.func_70093_af() || !this.func_77641_a(tempBlock))) {
            return DartUtils.grindWood(player, x, y, z, stack);
        }
        if (!(!upgrades.func_74764_b("Heat") || upgrades.func_74764_b("Lumberjack") && DartUtils.isBlockWood(world, x, y + 1, z) || player.func_70093_af() || !this.func_77641_a(tempBlock))) {
            return DartUtils.smeltBlock(world, stack, player, x, y, z);
        }
        return false;
    }

    @Override
    public boolean func_77660_a(ItemStack stack, World world, int id, int x, int y, int z, EntityLiving entity) {
        if (!Loader.isModLoaded((String)"IC2") || !Proxies.common.isSimulating(world)) {
            return false;
        }
        if (!(entity instanceof EntityPlayer)) {
            return false;
        }
        EntityPlayer player = (EntityPlayer)entity;
        Material mat = world.func_72803_f(x, y, z);
        if (mat == Material.field_76257_i) {
            return false;
        }
        NBTTagCompound upgrades = SocketHelper.getSocketCompound(stack);
        if (upgrades.func_74764_b("Lumberjack") && DartUtils.isBlockWood(world, x, y + 1, z) && !player.func_70093_af()) {
            int xCoord = x;
            int yCoord = y;
            int zCoord = z;
            int number = 0;
            block0: while (DartUtils.isBlockWood(world, xCoord, yCoord, zCoord)) {
                for (int i = -3; i < 4; ++i) {
                    for (int j = -3; j < 4; ++j) {
                        if (!DartUtils.isBlockWood(world, xCoord + i, yCoord, zCoord + j)) continue;
                        if (DartUtils.breakWood(player, xCoord + i, yCoord, zCoord + j, stack)) {
                            ++number;
                        }
                        if (!ElectricItem.canUse(stack, this.getOperationCost(stack) * 2)) break block0;
                    }
                }
                ++yCoord;
            }
            PacketDispatcher.sendPacketToAllAround((double)x, (double)y, (double)z, (double)40.0, (int)world.func_72912_H().func_76076_i(), (Packet)new TreeFXPacket(x, y, z, number).getPacket());
        } else {
            DartUtils.damageTool(player, stack, 1);
        }
        return false;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (player.func_70093_af() && player.field_70122_E) {
            NBTTagCompound dartTag = player.getEntityData().func_74775_l("DartCraft");
            dartTag.func_74768_a("toOpen", stack.func_77978_p().func_74762_e("ID"));
            if (Proxies.common.isSimulating(world)) {
                player.openGui((Object)DartCraft.instance, 6, world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
            }
            return stack;
        }
        player.func_71008_a(stack, this.func_77626_a(stack));
        NBTTagCompound upgrades = SocketHelper.getSocketCompound(stack);
        if (Config.wingEnabled && upgrades.func_74764_b("Wing")) {
            NBTTagCompound dartTag = player.getEntityData().func_74775_l("DartCraft");
            int flight = dartTag.func_74762_e("flight");
            if (Proxies.common.isSpaceDown() && flight >= 100) {
                DartUtils.performFlight(stack, player.field_70170_p, player);
                if ((flight -= 100) < 0) {
                    flight = 0;
                }
                if (!dartTag.func_74767_n("isFlying") && flight > 0 && Proxies.common.isShiftDown()) {
                    dartTag.func_74757_a("isFlying", true);
                    dartTag.func_74757_a("wasFlying", player.field_71075_bZ.field_75101_c);
                    player.field_71075_bZ.field_75100_b = true;
                    player.field_71075_bZ.field_75101_c = true;
                    PacketDispatcher.sendPacketToServer((Packet)new DartPacket(22).getPacket());
                }
                if (!player.field_71075_bZ.field_75098_d) {
                    player.getEntityData().func_74775_l("DartCraft").func_74768_a("flight", flight);
                }
            }
        }
        return stack;
    }

    public EnumAction func_77661_b(ItemStack par1ItemStack) {
        return EnumAction.block;
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 72000;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IconRegister reggie) {
        this.field_77791_bV = reggie.func_94245_a("Dartcraft:powerSaw");
    }

    @Override
    public int socketCount() {
        return 3;
    }

    @Override
    public int[] validSockets() {
        ForceUpgradeManager fum = DartAPI.fum;
        int[] nArray = new int[10];
        nArray[0] = ForceUpgradeManager.FORCE.getID();
        nArray[1] = ForceUpgradeManager.LUCK.getID();
        nArray[2] = ForceUpgradeManager.MINING.getID();
        nArray[3] = ForceUpgradeManager.GRINDING.getID();
        nArray[4] = ForceUpgradeManager.HEAT.getID();
        nArray[5] = ForceUpgradeManager.DAMAGE.getID();
        nArray[6] = ForceUpgradeManager.WING.getID();
        nArray[7] = ForceUpgradeManager.LUMBERJACK.getID();
        nArray[8] = ForceUpgradeManager.BANE.getID();
        nArray[9] = ForceUpgradeManager.BLEED.getID();
        return nArray;
    }
}

