/*
 * Decompiled with CFR 0.152.
 */
package bluedart.item.tool;

import bluedart.DartCraft;
import bluedart.api.DartAPI;
import bluedart.api.ForceUpgradeManager;
import bluedart.api.ISocketableTool;
import bluedart.client.TabDart;
import bluedart.item.ElectricTool;
import bluedart.proxy.Proxies;
import bluedart.proxy.ProxyCommon;
import bluedart.utils.DartUtils;
import bluedart.utils.SocketHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSand;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.EnumToolMaterial;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumHelper;

public class ItemPowerDrill
extends ElectricTool
implements ISocketableTool {
    private static int damage = 0;
    private static float efficiency = 10.0f;
    private static int toolLevel = 10;
    public static EnumToolMaterial material = EnumHelper.addToolMaterial((String)"FORCE", (int)toolLevel, (int)512, (float)efficiency, (int)damage, (int)0);

    public ItemPowerDrill(int id) {
        super(id, material, 50);
        this.field_77864_a = 10.0f;
        this.func_77656_e(27);
        this.func_77625_d(1);
        this.maxCharge = 15000;
        this.transferLimit = 100;
        this.tier = 1;
        this.field_77865_bY = 0;
        this.func_77637_a(TabDart.instance);
        this.func_77655_b("powerDrill");
        this.load();
    }

    public void load() {
        this.mineableBlocks.add(Block.field_71978_w);
        this.mineableBlocks.add(Block.field_72079_ak);
        this.mineableBlocks.add(Block.field_72085_aj);
        this.mineableBlocks.add(Block.field_72057_aH);
        this.mineableBlocks.add(Block.field_71981_t);
        this.mineableBlocks.add(Block.field_71957_Q);
        this.mineableBlocks.add(Block.field_72088_bQ);
        this.mineableBlocks.add(Block.field_72087_ao);
        this.mineableBlocks.add(Block.field_71949_H);
        this.mineableBlocks.add(Block.field_72083_ai);
        this.mineableBlocks.add(Block.field_71950_I);
        this.mineableBlocks.add(Block.field_72105_ah);
        this.mineableBlocks.add(Block.field_71941_G);
        this.mineableBlocks.add(Block.field_72073_aw);
        this.mineableBlocks.add(Block.field_72071_ax);
        this.mineableBlocks.add(Block.field_72036_aT);
        this.mineableBlocks.add(Block.field_72012_bb);
        this.mineableBlocks.add(Block.field_71947_N);
        this.mineableBlocks.add(Block.field_71948_O);
        this.mineableBlocks.add(Block.field_72047_aN);
        this.mineableBlocks.add(Block.field_72048_aO);
        this.mineableBlocks.add(Block.field_72081_al);
        this.mineableBlocks.add(Block.field_71992_bw);
        this.mineableBlocks.add(Block.field_72014_bd);
        this.mineableBlocks.add(Block.field_71980_u);
        this.mineableBlocks.add(Block.field_71979_v);
        this.mineableBlocks.add(Block.field_71994_by);
        this.mineableBlocks.add(Block.field_71939_E);
        this.mineableBlocks.add(Block.field_71940_F);
        this.mineableBlocks.add(Block.field_72037_aS);
        this.mineableBlocks.add(Block.field_72039_aU);
        this.mineableBlocks.add(Block.field_72041_aW);
        this.mineableBlocks.add(Block.field_72050_aA);
        this.mineableBlocks.add(Block.field_72007_bm);
        this.mineableBlocks.add(Block.field_71995_bx);
        this.mineableBlocks.add(Block.field_72033_bA);
        this.mineableBlocks.add(Block.field_72100_bC);
        this.mineableBlocks.add(Block.field_72013_bc);
        this.mineableBlocks.add(Block.field_82510_ck);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean thing) {
        NBTTagCompound upgrades = SocketHelper.getSocketCompound(stack);
        if (upgrades.func_74764_b("Force")) {
            list.add("Force");
        }
        if (upgrades.func_74764_b("Grinding")) {
            list.add("Grinding");
        }
        if (upgrades.func_74764_b("Heat")) {
            list.add("Heat");
        }
        if (upgrades.func_74764_b("Speed")) {
            list.add("Speed" + DartUtils.enchantName(upgrades.func_74762_e("Speed")));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.uncommon;
    }

    public boolean func_77636_d(ItemStack stack) {
        return false;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int par4, boolean par5) {
        NBTTagCompound comp;
        super.func_77663_a(stack, world, entity, par4, par5);
        if (!Proxies.common.isSimulating(world)) {
            return;
        }
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (!(comp = stack.func_77978_p()).func_74764_b("contents")) {
            this.initializeCompound(comp);
        }
        if (!comp.func_74764_b("ID")) {
            comp.func_74768_a("ID", ProxyCommon.rand.nextInt());
        }
    }

    private void initializeCompound(NBTTagCompound comp) {
        NBTTagList contents = new NBTTagList();
        for (int i = 0; i < this.socketCount(); ++i) {
            NBTTagCompound itemComp = new NBTTagCompound();
            itemComp.func_74774_a("Slot", (byte)i);
            contents.func_74742_a((NBTBase)itemComp);
        }
        comp.func_74782_a("contents", (NBTBase)contents);
        comp.func_74768_a("size", this.socketCount());
    }

    @Override
    public boolean func_77641_a(Block block) {
        if (block.field_72018_cp == Material.field_76246_e || block.field_72018_cp == Material.field_76243_f || block instanceof BlockSand || this.mineableBlocks.contains(block)) {
            return true;
        }
        return super.func_77641_a(block);
    }

    public boolean onBlockStartBreak(ItemStack stack, int x, int y, int z, EntityPlayer player) {
        World world = player.field_70170_p;
        int brokenID = world.func_72798_a(x, y, z);
        Block tempBlock = Block.field_71973_m[brokenID];
        boolean force = false;
        if (!this.func_77641_a(tempBlock)) {
            return false;
        }
        if (stack.func_77942_o() && stack.func_77978_p().func_74767_n("active")) {
            force = true;
        }
        if (force) {
            for (int i = -1; i < 2; ++i) {
                for (int j = -1; j < 2; ++j) {
                    for (int k = -1; k < 2; ++k) {
                        if (i == 0 && j == 0 && k == 0) continue;
                        if (stack != null && stack.func_77960_j() < stack.func_77958_k()) {
                            this.tryBlock(stack, x + i, y + j, z + k, player, false);
                            continue;
                        }
                        return false;
                    }
                }
            }
        }
        if (stack != null && stack.func_77960_j() < stack.func_77958_k()) {
            return this.tryBlock(stack, x, y, z, player, true);
        }
        return false;
    }

    private boolean tryBlock(ItemStack stack, int x, int y, int z, EntityPlayer player, boolean mustSmelt) {
        World world = player.field_70170_p;
        int brokenID = world.func_72798_a(x, y, z);
        if (brokenID == 0) {
            return false;
        }
        Block tempBlock = Block.field_71973_m[brokenID];
        NBTTagCompound upgrades = SocketHelper.getSocketCompound(stack);
        boolean smelted = false;
        if (upgrades.func_74764_b("Heat") && !upgrades.func_74764_b("Grinding") && !player.func_70093_af() && this.func_77641_a(tempBlock)) {
            smelted = DartUtils.smeltBlock(world, stack, player, x, y, z);
        }
        if (!smelted && upgrades.func_74764_b("Grinding") && !player.func_70093_af() && this.func_77641_a(tempBlock)) {
            return DartUtils.grindBlock(world, stack, player, x, y, z);
        }
        if (!mustSmelt && !smelted && this.func_77641_a(tempBlock) && tempBlock.func_71934_m(world, x, y, z) > 0.0f && world.func_72796_p(x, y, z) == null) {
            Block.field_71973_m[world.func_72798_a(x, y, z)].func_71893_a(world, player, x, y, z, world.func_72805_g(x, y, z));
            world.func_94571_i(x, y, z);
            DartUtils.damageTool(player, stack, 1);
        }
        return smelted;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (player.func_70093_af()) {
            NBTTagCompound dartTag = player.getEntityData().func_74775_l("DartCraft");
            dartTag.func_74768_a("toOpen", stack.func_77978_p().func_74762_e("ID"));
            if (Proxies.common.isSimulating(world)) {
                player.openGui((Object)DartCraft.instance, 6, world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
            }
        } else {
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            stack.func_77978_p().func_74757_a("active", !stack.func_77978_p().func_74767_n("active"));
            if (!Proxies.common.isSimulating(world)) {
                if (stack.func_77978_p().func_74767_n("active")) {
                    player.func_70006_a("Area mode activated.");
                } else {
                    player.func_70006_a("Area mode deactivated");
                }
            }
        }
        return stack;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IconRegister reggie) {
        this.field_77791_bV = reggie.func_94245_a("Dartcraft:powerDrill");
    }

    @Override
    public int socketCount() {
        return 3;
    }

    @Override
    public int[] validSockets() {
        ForceUpgradeManager fum = DartAPI.fum;
        int[] nArray = new int[6];
        nArray[0] = ForceUpgradeManager.FORCE.getID();
        nArray[1] = ForceUpgradeManager.LUCK.getID();
        nArray[2] = ForceUpgradeManager.MINING.getID();
        nArray[3] = ForceUpgradeManager.GRINDING.getID();
        nArray[4] = ForceUpgradeManager.HEAT.getID();
        nArray[5] = ForceUpgradeManager.TOUCH.getID();
        return nArray;
    }
}

