/*
 * Decompiled with CFR 0.152.
 */
package bluedart.item.tool;

import bluedart.DartCraft;
import bluedart.api.DartAPI;
import bluedart.api.ForceUpgradeManager;
import bluedart.api.IForceUpgradable;
import bluedart.client.IconDirectory;
import bluedart.client.TabDart;
import bluedart.item.DartItem;
import bluedart.proxy.Proxies;
import bluedart.utils.UpgradeHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.Icon;
import net.minecraft.world.World;

public class ItemMemberCard
extends DartItem
implements IForceUpgradable {
    public static final int SIZE = 16;

    public ItemMemberCard(int id) {
        super(id);
        this.func_77625_d(1);
        this.func_77637_a(TabDart.instance);
        this.setUnlocalizedName("memberCard");
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int par4, boolean par5) {
        if (!stack.func_77942_o()) {
            this.initCompound(stack);
        }
        if (!stack.func_77978_p().func_74764_b("ID")) {
            stack.func_77978_p().func_74768_a("ID", new Random().nextInt());
        }
    }

    private void initCompound(ItemStack stack) {
        NBTTagCompound comp = new NBTTagCompound();
        NBTTagList contents = new NBTTagList();
        for (int i = 0; i < 16; ++i) {
            NBTTagCompound itemComp = new NBTTagCompound();
            itemComp.func_74774_a("Slot", (byte)i);
            contents.func_74742_a((NBTBase)itemComp);
        }
        comp.func_74782_a("contents", (NBTBase)contents);
        stack.func_77982_d(comp);
    }

    public String func_77628_j(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return super.func_77628_j(stack);
        }
        String name = stack.func_77978_p().func_74779_i("name");
        if (name != null && !name.equals("")) {
            return name;
        }
        return super.func_77628_j(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    public Icon getIcon(ItemStack stack, int pass) {
        NBTTagCompound upgrades = UpgradeHelper.getUpgradeCompound(stack);
        if (upgrades.func_74764_b("Craft")) {
            return IconDirectory.cards[1];
        }
        if (upgrades.func_74764_b("Force")) {
            return IconDirectory.cards[2];
        }
        if (upgrades.func_74764_b("Forge")) {
            return IconDirectory.cards[3];
        }
        return super.getIcon(stack, pass);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IconRegister reggie) {
        for (int i = 0; i < 4; ++i) {
            IconDirectory.cards[i] = reggie.func_94245_a("Dartcraft:memberCard" + i);
        }
        this.field_77791_bV = IconDirectory.cards[0];
    }

    public boolean func_77651_p() {
        return true;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (stack.func_77942_o()) {
            NBTTagCompound dartTag = player.getEntityData().func_74775_l("DartCraft");
            dartTag.func_74768_a("toOpen", stack.func_77978_p().func_74762_e("ID"));
            NBTTagCompound upgrades = UpgradeHelper.getUpgradeCompound(stack);
            if (!Proxies.common.isSimulating(world) && player.func_70093_af()) {
                player.openGui((Object)DartCraft.instance, 13, world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
            }
            if (Proxies.common.isSimulating(world) && !player.func_70093_af()) {
                player.openGui((Object)DartCraft.instance, 12, world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
            }
        }
        return stack;
    }

    @Override
    public int[] validUpgrades() {
        ForceUpgradeManager fum = DartAPI.fum;
        int[] nArray = new int[3];
        nArray[0] = ForceUpgradeManager.CRAFT.getID();
        nArray[1] = ForceUpgradeManager.FORCE.getID();
        nArray[2] = ForceUpgradeManager.FORGE.getID();
        return nArray;
    }
}

