/*
 * Decompiled with CFR 0.152.
 */
package bluedart.item.tool;

import bluedart.api.DartAPI;
import bluedart.api.ForceUpgradeManager;
import bluedart.api.IBreakable;
import bluedart.api.IForceUpgradable;
import bluedart.client.IconDirectory;
import bluedart.client.TabDart;
import bluedart.core.Config;
import bluedart.core.network.DartPacket;
import bluedart.integration.ThaumCraftIntegration;
import bluedart.item.DartItem;
import bluedart.proxy.Proxies;
import bluedart.utils.DartUtils;
import bluedart.utils.FXUtils;
import bluedart.utils.UpgradeHelper;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.EnumToolMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.util.Icon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumHelper;
import thaumcraft.api.IVisRepairable;

public class ItemForceSword
extends ItemSword
implements IBreakable,
IForceUpgradable,
IVisRepairable {
    private static int damage = 3;
    private static float efficiency = 5.0f;
    private static int toolLevel = 2;
    public static EnumToolMaterial material = EnumHelper.addToolMaterial((String)"FORCE", (int)toolLevel, (int)512, (float)efficiency, (int)damage, (int)50);

    public ItemForceSword(int id) {
        super(id, material);
        this.func_77637_a(TabDart.instance);
    }

    public boolean func_77660_a(ItemStack item, World world, int par2, int par3, int par4, int par5, EntityLiving entity) {
        return true;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        player.func_71008_a(stack, this.func_77626_a(stack));
        NBTTagCompound upgrades = UpgradeHelper.getUpgradeCompound(stack);
        boolean teleported = false;
        if (Config.enderEnabled && upgrades.func_74764_b("Ender") && player.func_70093_af() && (teleported = this.performTeleport(stack, world, player))) {
            stack.func_77972_a(1, (EntityLiving)player);
        }
        if (!teleported && Config.wingEnabled && upgrades.func_74764_b("Wing")) {
            NBTTagCompound dartTag = player.getEntityData().func_74775_l("DartCraft");
            int flight = dartTag.func_74762_e("flight");
            if (Proxies.common.isSpaceDown() && flight >= 100) {
                DartUtils.performFlight(stack, player.field_70170_p, player);
                if ((flight -= 100) < 0) {
                    flight = 0;
                }
                if (!dartTag.func_74767_n("isFlying") && flight > 0 && (player.func_70093_af() || Proxies.common.isShiftDown())) {
                    dartTag.func_74757_a("isFlying", true);
                    dartTag.func_74757_a("wasFlying", player.field_71075_bZ.field_75101_c);
                    player.field_71075_bZ.field_75100_b = true;
                    player.field_71075_bZ.field_75101_c = true;
                    PacketDispatcher.sendPacketToServer((Packet)new DartPacket(22).getPacket());
                }
                if (!player.field_71075_bZ.field_75098_d) {
                    player.getEntityData().func_74775_l("DartCraft").func_74768_a("flight", flight);
                }
            }
        }
        return stack;
    }

    public boolean performTeleport(ItemStack stack, World world, EntityPlayer player) {
        int checked;
        double newPosX = player.field_70165_t;
        double newPosY = player.field_70163_u + (double)player.func_70047_e();
        double newPosZ = player.field_70161_v;
        int teleportLength = 64;
        for (checked = 0; world.func_72798_a((int)Math.floor(newPosX), (int)Math.floor(newPosY), (int)Math.floor(newPosZ)) == 0 && checked < teleportLength; ++checked) {
            newPosX += (double)(-MathHelper.func_76126_a((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(player.field_70125_A / 180.0f * (float)Math.PI)));
            newPosY += (double)(-MathHelper.func_76126_a((float)(player.field_70125_A / 180.0f * (float)Math.PI)));
            newPosZ += (double)(MathHelper.func_76134_b((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(player.field_70125_A / 180.0f * (float)Math.PI)));
        }
        if (checked >= teleportLength) {
            return false;
        }
        double prevX = player.field_70165_t;
        double prevY = player.field_70163_u;
        double prevZ = player.field_70161_v;
        while (player.field_70170_p.func_72804_r((int)newPosX, (int)newPosY, (int)newPosZ)) {
            newPosY += (double)player.func_70047_e() / 2.0;
        }
        if (Proxies.common.isSimulating(world)) {
            player.func_70634_a(newPosX, newPosY + (double)player.func_70047_e() / 2.0, newPosZ);
        }
        FXUtils.makeEnderEffects((Entity)player, prevX, prevY, prevZ, 128, true);
        return true;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean thing) {
        NBTTagCompound upgrades;
        if (stack.func_77942_o() && (upgrades = stack.func_77978_p().func_74775_l("upgrades")) != null) {
            if (upgrades.func_74764_b("Ender") && upgrades.func_74764_b("Wing")) {
                list.add("\u00a7bWing");
            }
            if (upgrades.func_74764_b("Bane")) {
                list.add("\u00a7cBane");
            }
            if (upgrades.func_74764_b("Bleed")) {
                list.add("\u00a74Bleeding" + DartUtils.enchantName(upgrades.func_74762_e("Bleed")));
            }
        }
    }

    public String func_77628_j(ItemStack stack) {
        NBTTagCompound upgrades = UpgradeHelper.getUpgradeCompound(stack);
        if (upgrades.func_74764_b("Ender")) {
            return "Ender Sword";
        }
        if (upgrades.func_74764_b("Wing")) {
            return "Wing Sword";
        }
        if (upgrades.func_74764_b("Heat")) {
            return "Heat Sword";
        }
        return super.func_77628_j(stack);
    }

    public boolean func_77636_d(ItemStack stack) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("upgrades")) {
            NBTTagCompound upgrades = stack.func_77978_p().func_74775_l("upgrades");
            if (upgrades.func_74764_b("Ender")) {
                return EnumRarity.epic;
            }
            if (upgrades.func_74764_b("Wing")) {
                return EnumRarity.rare;
            }
            if (upgrades.func_74764_b("Heat")) {
                return EnumRarity.uncommon;
            }
        }
        return EnumRarity.common;
    }

    public float func_77638_a(ItemStack item, Block block) {
        return block.field_71990_ca == Block.field_71955_W.field_71990_ca ? 15.0f : 1.75f;
    }

    public boolean func_77651_p() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    public Icon getIcon(ItemStack stack, int pass) {
        NBTTagCompound upgrades;
        if (stack.func_77942_o() && (upgrades = stack.func_77978_p().func_74775_l("upgrades")) != null) {
            if (upgrades.func_74764_b("Ender")) {
                return IconDirectory.enderSword;
            }
            if (upgrades.func_74764_b("Wing")) {
                return IconDirectory.wingSword;
            }
            if (upgrades.func_74764_b("Heat")) {
                return IconDirectory.heatSword;
            }
        }
        return this.field_77791_bV;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IconRegister reggie) {
        IconDirectory.forceSword = reggie.func_94245_a("Dartcraft:forceSword");
        IconDirectory.heatSword = reggie.func_94245_a("Dartcraft:heatSword");
        IconDirectory.wingSword = reggie.func_94245_a("Dartcraft:wingSword");
        IconDirectory.enderSword = reggie.func_94245_a("Dartcraft:enderSword");
        this.field_77791_bV = IconDirectory.forceSword;
    }

    @Override
    public ItemStack itemReturned() {
        return new ItemStack((Item)DartItem.forceShard);
    }

    @Override
    public int[] validUpgrades() {
        ForceUpgradeManager fum = DartAPI.fum;
        int[] nArray = new int[11];
        nArray[0] = ForceUpgradeManager.DAMAGE.getID();
        nArray[1] = ForceUpgradeManager.HEAT.getID();
        nArray[2] = ForceUpgradeManager.LUCK.getID();
        nArray[3] = ForceUpgradeManager.WING.getID();
        nArray[4] = ForceUpgradeManager.BANE.getID();
        nArray[5] = ForceUpgradeManager.LIGHT.getID();
        nArray[6] = ForceUpgradeManager.BLEED.getID();
        nArray[7] = ForceUpgradeManager.FORCE.getID();
        nArray[8] = ForceUpgradeManager.REPAIR.getID();
        nArray[9] = ForceUpgradeManager.SOUL.getID();
        nArray[10] = ForceUpgradeManager.ENDER.getID();
        return nArray;
    }

    @Override
    public void doRepair(ItemStack stack, Entity entity) {
        ThaumCraftIntegration.doRepair(stack, entity);
    }
}

