/*
 * Decompiled with CFR 0.152.
 */
package bluedart.item.tool;

import bluedart.api.DartAPI;
import bluedart.api.ForceUpgradeManager;
import bluedart.api.IBreakable;
import bluedart.api.IForceUpgradable;
import bluedart.client.IconDirectory;
import bluedart.client.TabDart;
import bluedart.integration.ThaumCraftIntegration;
import bluedart.item.DartItem;
import bluedart.proxy.Proxies;
import bluedart.utils.DartUtils;
import bluedart.utils.UpgradeHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.EnumToolMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumHelper;
import thaumcraft.api.IVisRepairable;

public class ItemForceSpade
extends ItemSpade
implements IBreakable,
IForceUpgradable,
IVisRepairable {
    private static int damage = 1;
    private static float efficiency = 4.0f;
    private static int toolLevel = 10;
    public static EnumToolMaterial material = EnumHelper.addToolMaterial((String)"FORCE", (int)toolLevel, (int)512, (float)efficiency, (int)damage, (int)50);

    public ItemForceSpade(int id) {
        super(id, material);
        this.func_77637_a(TabDart.instance);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean thing) {
        NBTTagCompound upgrades;
        if (stack.func_77942_o() && (upgrades = stack.func_77978_p().func_74775_l("upgrades")) != null) {
            if (upgrades.func_74764_b("Grinding")) {
                list.add("\u00a73Grinding");
            }
            if (upgrades.func_74764_b("Speed")) {
                list.add("\u00a7fSpeed" + DartUtils.enchantName(upgrades.func_74762_e("Speed")));
            }
        }
    }

    public String func_77628_j(ItemStack stack) {
        NBTTagCompound upgrades = UpgradeHelper.getUpgradeCompound(stack);
        if (upgrades.func_74764_b("Heat")) {
            return "Heat Shovel";
        }
        return super.func_77628_j(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack stack) {
        NBTTagCompound upgrades;
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("upgrades") && (upgrades = stack.func_77978_p().func_74775_l("upgrades")).func_74764_b("Heat")) {
            return EnumRarity.uncommon;
        }
        return EnumRarity.common;
    }

    public boolean func_77636_d(ItemStack stack) {
        return false;
    }

    public boolean onBlockStartBreak(ItemStack stack, int x, int y, int z, EntityPlayer player) {
        World world = player.field_70170_p;
        int brokenID = world.func_72798_a(x, y, z);
        Block tempBlock = Block.field_71973_m[brokenID];
        boolean force = false;
        if (!this.func_77641_a(tempBlock)) {
            return false;
        }
        if (stack.func_77942_o() && stack.func_77978_p().func_74767_n("active")) {
            force = true;
        }
        if (force) {
            for (int i = -1; i < 2; ++i) {
                for (int j = -1; j < 2; ++j) {
                    for (int k = -1; k < 2; ++k) {
                        if (i == 0 && j == 0 && k == 0) continue;
                        if (stack != null && stack.func_77960_j() < stack.func_77958_k()) {
                            this.tryBlock(stack, x + i, y + j, z + k, player, false);
                            continue;
                        }
                        return false;
                    }
                }
            }
        }
        if (stack != null && stack.func_77960_j() < stack.func_77958_k()) {
            return this.tryBlock(stack, x, y, z, player, true);
        }
        return false;
    }

    private boolean tryBlock(ItemStack stack, int x, int y, int z, EntityPlayer player, boolean mustSmelt) {
        World world = player.field_70170_p;
        int brokenID = world.func_72798_a(x, y, z);
        if (brokenID == 0) {
            return false;
        }
        Block tempBlock = Block.field_71973_m[brokenID];
        NBTTagCompound upgrades = UpgradeHelper.getUpgradeCompound(stack);
        boolean smelted = false;
        if (upgrades.func_74764_b("Heat") && !upgrades.func_74764_b("Grinding") && !player.func_70093_af() && this.func_77641_a(tempBlock)) {
            smelted = DartUtils.smeltBlock(world, stack, player, x, y, z);
        }
        if (!smelted && upgrades.func_74764_b("Grinding") && !player.func_70093_af() && this.func_77641_a(tempBlock)) {
            return DartUtils.grindBlock(world, stack, player, x, y, z);
        }
        if (!mustSmelt && !smelted && this.func_77641_a(tempBlock) && tempBlock.func_71934_m(world, x, y, z) > 0.0f && world.func_72796_p(x, y, z) == null) {
            Block.field_71973_m[world.func_72798_a(x, y, z)].func_71893_a(world, player, x, y, z, world.func_72805_g(x, y, z));
            world.func_94571_i(x, y, z);
            DartUtils.damageTool(player, stack, 1);
        }
        return smelted;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (player.func_70093_af()) {
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            stack.func_77978_p().func_74757_a("active", !stack.func_77978_p().func_74767_n("active"));
            if (!Proxies.common.isSimulating(world)) {
                if (stack.func_77978_p().func_74767_n("active")) {
                    player.func_70006_a("Area mode activated.");
                } else {
                    player.func_70006_a("Area mode deactivated");
                }
            }
        }
        return stack;
    }

    public float func_77638_a(ItemStack stack, Block block) {
        boolean isProperMaterial;
        float modifier = 1.0f;
        boolean bl = isProperMaterial = block.field_72018_cp == Material.field_76267_y || block.field_72018_cp == Material.field_76258_w || block.field_72018_cp == Material.field_76248_c || block.field_72018_cp == Material.field_76251_o || block.field_72018_cp == Material.field_76259_v || block.field_72018_cp == Material.field_76247_b;
        if (stack.func_77942_o() && isProperMaterial) {
            NBTTagCompound upgrades = stack.func_77978_p().func_74775_l("upgrades");
            if (upgrades.func_74764_b("Speed")) {
                modifier = 1.0f + 0.75f * (float)upgrades.func_74762_e("Speed");
            }
            if (stack.func_77978_p().func_74767_n("active")) {
                modifier /= 9.0f;
            }
        }
        if (isProperMaterial) {
            return efficiency * modifier;
        }
        return 1.0f;
    }

    public boolean func_77641_a(Block block) {
        return block.field_72018_cp == Material.field_76267_y || block.field_72018_cp == Material.field_76258_w || block.field_72018_cp == Material.field_76248_c || block.field_72018_cp == Material.field_76251_o || block.field_72018_cp == Material.field_76259_v || block.field_72018_cp == Material.field_76247_b;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    public Icon getIcon(ItemStack stack, int pass) {
        NBTTagCompound upgrades;
        if (stack.func_77942_o() && (upgrades = stack.func_77978_p().func_74775_l("upgrades")) != null && upgrades.func_74764_b("Heat")) {
            return IconDirectory.heatSpade;
        }
        return this.field_77791_bV;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IconRegister reggie) {
        IconDirectory.forceSpade = reggie.func_94245_a("Dartcraft:forceSpade");
        IconDirectory.heatSpade = reggie.func_94245_a("Dartcraft:heatSpade");
        this.field_77791_bV = IconDirectory.forceSpade;
    }

    @Override
    public ItemStack itemReturned() {
        return new ItemStack((Item)DartItem.forceShard);
    }

    @Override
    public int[] validUpgrades() {
        ForceUpgradeManager fum = DartAPI.fum;
        int[] nArray = new int[7];
        nArray[0] = ForceUpgradeManager.HEAT.getID();
        nArray[1] = ForceUpgradeManager.MINING.getID();
        nArray[2] = ForceUpgradeManager.LUCK.getID();
        nArray[3] = ForceUpgradeManager.TOUCH.getID();
        nArray[4] = ForceUpgradeManager.STURDY.getID();
        nArray[5] = ForceUpgradeManager.GRINDING.getID();
        nArray[6] = ForceUpgradeManager.REPAIR.getID();
        return nArray;
    }

    @Override
    public void doRepair(ItemStack stack, Entity entity) {
        ThaumCraftIntegration.doRepair(stack, entity);
    }
}

