/*
 * Decompiled with CFR 0.152.
 */
package bluedart.item.tool;

import bluedart.api.DartAPI;
import bluedart.api.ForceUpgradeManager;
import bluedart.api.IBreakable;
import bluedart.api.IForceUpgradable;
import bluedart.client.IconDirectory;
import bluedart.client.TabDart;
import bluedart.core.Constants;
import bluedart.integration.ThaumCraftIntegration;
import bluedart.item.DartItem;
import bluedart.utils.DartUtils;
import bluedart.utils.UpgradeHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;
import thaumcraft.api.IVisRepairable;

public class ItemForceShears
extends ItemShears
implements IBreakable,
IForceUpgradable,
IVisRepairable {
    private EnumRarity rarity;

    public ItemForceShears(int id) {
        super(id);
        this.func_77656_e(332);
        this.func_77637_a(TabDart.instance);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean bool) {
        NBTTagCompound upgrades;
        if (stack.func_77942_o() && (upgrades = stack.func_77978_p().func_74775_l("upgrades")) != null) {
            if (upgrades.func_74764_b("Grinding")) {
                list.add("\u00a73Grinding");
            }
            if (upgrades.func_74764_b("Rainbow")) {
                list.add("\u00a7bRain\u00a7ebow");
            }
            if (upgrades.func_74764_b("Luck")) {
                list.add("\u00a7bLuck" + DartUtils.enchantName(upgrades.func_74762_e("Luck")));
            }
        }
    }

    public String func_77628_j(ItemStack stack) {
        NBTTagCompound upgrades = UpgradeHelper.getUpgradeCompound(stack);
        if (upgrades.func_74764_b("Heat")) {
            return "Heat Shears";
        }
        return super.func_77628_j(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack stack) {
        NBTTagCompound upgrades;
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("upgrades") && (upgrades = stack.func_77978_p().func_74775_l("upgrades")).func_74764_b("Heat")) {
            return EnumRarity.uncommon;
        }
        return EnumRarity.common;
    }

    public boolean func_77636_d(ItemStack stack) {
        return false;
    }

    public int func_77619_b() {
        return 50;
    }

    public String getTextureFile() {
        return Constants.ITEMS_PNG;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    public Icon getIcon(ItemStack stack, int pass) {
        NBTTagCompound upgrades;
        if (stack.func_77942_o() && (upgrades = stack.func_77978_p().func_74775_l("upgrades")) != null && upgrades.func_74764_b("Heat")) {
            return IconDirectory.heatShears;
        }
        return this.field_77791_bV;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IconRegister reggie) {
        IconDirectory.forceShears = reggie.func_94245_a("Dartcraft:forceShears");
        IconDirectory.heatShears = reggie.func_94245_a("Dartcraft:heatShears");
        this.field_77791_bV = IconDirectory.forceShears;
    }

    @Override
    public int[] validUpgrades() {
        ForceUpgradeManager fum = DartAPI.fum;
        int[] nArray = new int[5];
        nArray[0] = ForceUpgradeManager.HEAT.getID();
        nArray[1] = ForceUpgradeManager.RAINBOW.getID();
        nArray[2] = ForceUpgradeManager.LUCK.getID();
        nArray[3] = ForceUpgradeManager.GRINDING.getID();
        nArray[4] = ForceUpgradeManager.REPAIR.getID();
        return nArray;
    }

    @Override
    public ItemStack itemReturned() {
        return new ItemStack((Item)DartItem.forceShard);
    }

    @Override
    public void doRepair(ItemStack stack, Entity entity) {
        ThaumCraftIntegration.doRepair(stack, entity);
    }
}

