/*
 * Decompiled with CFR 0.152.
 */
package bluedart.item.tool;

import bluedart.DartCraft;
import bluedart.api.DartAPI;
import bluedart.api.ForceTransmutation;
import bluedart.api.ForceUpgradeManager;
import bluedart.api.IBreakable;
import bluedart.api.IForceUpgradable;
import bluedart.block.DartBlock;
import bluedart.client.IconDirectory;
import bluedart.core.Config;
import bluedart.core.network.FXEnderPacket;
import bluedart.core.network.FXPacket;
import bluedart.entity.EntityInvincibleItem;
import bluedart.integration.ThaumCraftIntegration;
import bluedart.item.DartItem;
import bluedart.item.ItemForceArmor;
import bluedart.proxy.Proxies;
import bluedart.utils.DartUtils;
import bluedart.utils.FXUtils;
import bluedart.utils.UpgradeHelper;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.packet.Packet;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import thaumcraft.api.IVisRepairable;

public class ItemForceRod
extends DartItem
implements IBreakable,
IForceUpgradable,
IVisRepairable {
    public ItemForceRod(int id) {
        super(id);
        this.setUnlocalizedName("forceRod");
        this.func_77625_d(1);
        this.func_77656_e(50);
        this.func_77627_a(false);
        this.func_77664_n();
        this.setNoRepair();
    }

    public String func_77628_j(ItemStack stack) {
        NBTTagCompound upgrades = UpgradeHelper.getUpgradeCompound(stack);
        if (upgrades.func_74764_b("Speed")) {
            return "Rod of Speed" + DartUtils.enchantName(upgrades.func_74762_e("Speed"));
        }
        if (upgrades.func_74764_b("Holding")) {
            return "Rod of Holding";
        }
        if (upgrades.func_74764_b("Sight")) {
            return "Rod of Vision";
        }
        if (upgrades.func_74764_b("Heat")) {
            return "Rod of Fire Resistance";
        }
        if (upgrades.func_74764_b("Healing")) {
            return "Rod of Restoration" + (upgrades.func_74762_e("Healing") > 1 ? " Mk2" : "");
        }
        if (upgrades.func_74764_b("Ender")) {
            return "Rod of Return";
        }
        if (upgrades.func_74764_b("Camo")) {
            return "Rod of Invisibility";
        }
        return super.func_77628_j(stack);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean thing) {
        NBTTagCompound enderComp;
        NBTTagCompound upgrades = UpgradeHelper.getUpgradeCompound(stack);
        if (upgrades.func_74764_b("Ender") && (enderComp = stack.func_77978_p()).func_74767_n("init")) {
            String name = enderComp.func_74779_i("name");
            if (name != null && !Proxies.common.isShiftDown()) {
                list.add(name);
            } else {
                list.add("Dimension: " + enderComp.func_74762_e("dim"));
                list.add("Loc: X: " + (int)enderComp.func_74769_h("x") + " Y: " + (int)enderComp.func_74769_h("y") + " Z: " + (int)enderComp.func_74769_h("z"));
            }
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int par4, boolean par5) {
        if (!Proxies.common.isSimulating(world)) {
            return;
        }
    }

    private void initializeCompound(NBTTagCompound comp) {
        NBTTagList contents = new NBTTagList();
        NBTTagCompound itemComp = new NBTTagCompound();
        itemComp.func_74774_a("Slot", (byte)0);
        contents.func_74742_a((NBTBase)itemComp);
        comp.func_74782_a("contents", (NBTBase)contents);
    }

    public boolean func_77651_p() {
        return true;
    }

    public boolean func_77636_d(ItemStack stack) {
        return false;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        boolean canTransmute;
        NBTTagCompound upgrades = UpgradeHelper.getUpgradeCompound(stack);
        if (player.func_70093_af() && upgrades.func_74764_b("Ender")) {
            if (!Proxies.common.isSimulating(world)) {
                player.openGui((Object)DartCraft.instance, 8, world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
            }
            return stack;
        }
        if (!Proxies.common.isSimulating(world)) {
            return stack;
        }
        NBTTagCompound dartTag = player.getEntityData().func_74775_l("DartCraft");
        boolean bl = canTransmute = dartTag.func_74762_e("lastTransmute") <= 0;
        if (upgrades.func_74764_b("Speed")) {
            int level;
            int level2 = level = upgrades.func_74762_e("Speed") - 1;
            int time = 0;
            if (level > 2) {
                level = 2;
            }
            if (level < 0) {
                level = 0;
            }
            PotionEffect effect = player.func_70660_b(Potion.field_76424_c);
            PotionEffect effect2 = player.func_70660_b(Potion.field_76422_e);
            PotionEffect effect3 = player.func_70660_b(Potion.field_76430_j);
            if (effect != null) {
                time = effect.func_76459_b();
            }
            if ((time += 200) < 750) {
                player.func_70690_d(new PotionEffect(Potion.field_76424_c.func_76396_c(), time, level, true));
                player.func_70690_d(new PotionEffect(Potion.field_76422_e.func_76396_c(), time, level2, true));
                player.func_70690_d(new PotionEffect(Potion.field_76430_j.func_76396_c(), time, level, true));
                stack.func_77972_a(1, (EntityLiving)player);
            }
            return stack;
        }
        if (upgrades.func_74764_b("Camo")) {
            int time = 0;
            PotionEffect effect = player.func_70660_b(Potion.field_76441_p);
            if (effect != null) {
                time = effect.func_76459_b();
            }
            if ((time += 600) < 2250) {
                player.func_70690_d(new PotionEffect(Potion.field_76441_p.func_76396_c(), time, 0, true));
                stack.func_77972_a(1, (EntityLiving)player);
            }
            return stack;
        }
        if (upgrades.func_74764_b("Heat")) {
            int time = 0;
            PotionEffect effect = player.func_70660_b(Potion.field_76426_n);
            if (effect != null) {
                time = effect.func_76459_b();
            }
            if ((time += 400) < 1500) {
                player.func_70690_d(new PotionEffect(Potion.field_76426_n.func_76396_c(), time, 0, true));
                player.func_70066_B();
                stack.func_77972_a(1, (EntityLiving)player);
            } else if (player.func_70027_ad()) {
                player.func_70066_B();
                stack.func_77972_a(1, (EntityLiving)player);
            }
            return stack;
        }
        if (upgrades.func_74764_b("Healing")) {
            int level = upgrades.func_74762_e("Healing") - 1;
            int time = 0;
            if (level > 1) {
                level = 1;
            }
            if (level < 0) {
                level = 0;
            }
            player.func_70691_i((level + 1) * 2);
            PotionEffect effect = player.func_70660_b(Potion.field_76428_l);
            if (effect != null) {
                time = effect.func_76459_b();
            }
            if ((time += 100) < 375) {
                player.func_70690_d(new PotionEffect(Potion.field_76428_l.func_76396_c(), time, level, true));
                stack.func_77972_a(1, (EntityLiving)player);
            }
            return stack;
        }
        if (upgrades.func_74764_b("Sight")) {
            int time = 0;
            PotionEffect effect = player.func_70660_b(Potion.field_76439_r);
            if (effect != null) {
                time = effect.func_76459_b();
            }
            if ((time += 1200) < 3600) {
                player.func_70690_d(new PotionEffect(Potion.field_76439_r.func_76396_c(), time, 0, true));
                stack.func_77972_a(1, (EntityLiving)player);
            }
            return stack;
        }
        if (upgrades.func_74764_b("Ender")) {
            NBTTagCompound enderComp = stack.func_77978_p();
            if (enderComp == null || !enderComp.func_74767_n("init")) {
                player.func_70006_a("This rod has not been initialized.");
                return stack;
            }
            double tpX = enderComp.func_74769_h("x");
            double tpY = enderComp.func_74769_h("y");
            double tpZ = enderComp.func_74769_h("z");
            int tpDim = enderComp.func_74762_e("dim");
            if (tpDim == player.field_71093_bK) {
                double prevX = player.field_70165_t;
                double prevY = player.field_70163_u;
                double prevZ = player.field_70161_v;
                double distance = player.func_70011_f(tpX, tpY, tpZ);
                player.func_70634_a(tpX, tpY, tpZ);
                FXUtils.makeEnderEffects((Entity)player, prevX, prevY, prevZ, 0, true);
                PacketDispatcher.sendPacketToAllAround((double)prevX, (double)prevY, (double)prevZ, (double)30.0, (int)player.field_71093_bK, (Packet)new FXEnderPacket(player.field_70165_t, player.field_70163_u, player.field_70161_v, prevX, prevY, prevZ, 128).getPacket());
                if (distance > 30.0) {
                    PacketDispatcher.sendPacketToAllAround((double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v, (double)30.0, (int)player.field_71093_bK, (Packet)new FXEnderPacket(player.field_70165_t, player.field_70163_u, player.field_70161_v, prevX, prevY, prevZ, (int)distance * 100).getPacket());
                }
                if (distance > 250.0) {
                    stack.func_77972_a(1, (EntityLiving)player);
                }
            } else {
                player.func_70006_a("This rod is bound to another dimension.");
            }
        }
        double newPosX = player.field_70165_t;
        double newPosY = player.field_70163_u + (double)player.func_70047_e();
        double newPosZ = player.field_70161_v;
        double xIncr = -MathHelper.func_76126_a((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(player.field_70125_A / 180.0f * (float)Math.PI));
        double yIncr = -MathHelper.func_76126_a((float)(player.field_70125_A / 180.0f * (float)Math.PI));
        double zIncr = MathHelper.func_76134_b((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(player.field_70125_A / 180.0f * (float)Math.PI));
        int reach = 16;
        for (int checked = 0; checked < reach; ++checked) {
            int id = world.func_72798_a((int)Math.floor(newPosX), (int)Math.floor(newPosY), (int)Math.floor(newPosZ));
            Block block = Block.field_71973_m[id];
            if (id != 0 && (block == null || block.func_71926_d() || id == Block.field_71987_y.field_71990_ca || id == Block.field_72067_ar.field_71990_ca)) break;
            AxisAlignedBB bb = AxisAlignedBB.func_72330_a((double)(newPosX - 0.5), (double)(newPosY - 0.5), (double)(newPosZ - 0.5), (double)(newPosX + 0.5), (double)(newPosY + 0.5), (double)(newPosZ + 0.5));
            if (canTransmute && upgrades.func_74764_b("Holding")) {
                int canUse = DartUtils.canPlayerUseFlask(player, false);
                EntityLiving victim = null;
                victim = (EntityLiving)world.func_72857_a(EntityLiving.class, bb, (Entity)player);
                if (victim != null && !(victim instanceof EntityPlayer)) {
                    if (!Config.holdingEnabled && !player.field_71092_bJ.equalsIgnoreCase("bluedartpro")) {
                        player.func_70006_a("Bottling of entities disabled on this server.");
                        return stack;
                    }
                    if (!(!Config.bottlePassiveOnly || player.field_71092_bJ.equalsIgnoreCase("bluedartpro") || victim instanceof EntityAnimal || victim instanceof EntityVillager || victim instanceof EntityBat)) {
                        player.func_70006_a("This server only allows bottling of passive entities.");
                        return stack;
                    }
                    if (DartAPI.isEntityBlacklisted(victim.getClass()) && !player.field_71092_bJ.equalsIgnoreCase("bluedartpro")) {
                        player.func_70006_a("Entity is blacklisted for bottling.");
                        return stack;
                    }
                    if (canUse > 0) {
                        DartUtils.canPlayerUseFlask(player, true);
                        ItemStack bottleStack = DartUtils.bottleEntity((Entity)victim);
                        world.func_72956_a((Entity)victim, "bluedart.magic", 1.0f, DartUtils.randomPitch());
                        PacketDispatcher.sendPacketToAllAround((double)victim.field_70165_t, (double)victim.field_70163_u, (double)victim.field_70161_v, (double)30.0, (int)victim.field_71093_bK, (Packet)new FXPacket(21, victim.field_70165_t, victim.field_70163_u, victim.field_70161_v).getPacket());
                        DartUtils.dropInvincibleItem(bottleStack, world, victim.field_70165_t, victim.field_70163_u, victim.field_70161_v);
                        world.func_72900_e((Entity)victim);
                        victim = null;
                        stack.func_77972_a(1, (EntityLiving)player);
                        dartTag.func_74768_a("lastTransmute", 10);
                    }
                    return stack;
                }
            }
            EntityItem item = (EntityItem)world.func_72857_a(EntityItem.class, bb, (Entity)player);
            ItemStack tomeStack = null;
            if (item != null) {
                tomeStack = item.func_92059_d();
            }
            if (canTransmute && tomeStack != null && !upgrades.func_74764_b("Holding") && !upgrades.func_74764_b("Ender")) {
                NBTTagCompound comp;
                if (tomeStack.field_77993_c == DartItem.forceTome.field_77779_bT && (comp = tomeStack.func_77978_p()) != null && comp.func_74762_e("type") == 2 && comp.func_74762_e("stored") >= 50) {
                    int number = comp.func_74762_e("stored") / 50;
                    this.itemChange(item);
                    world.func_72900_e((Entity)item);
                    for (int i = 0; i < number; ++i) {
                        DartUtils.dropItem(new ItemStack(DartItem.upgradeCore), world, item.field_70165_t, item.field_70163_u, item.field_70161_v);
                    }
                    item = null;
                    stack.func_77972_a(1, (EntityLiving)player);
                    dartTag.func_74768_a("lastTransmute", 10);
                    return stack;
                }
                if (tomeStack.field_77993_c == DartItem.inertCore.field_77779_bT) {
                    EntityInvincibleItem burning;
                    if (!(item instanceof EntityInvincibleItem) || !(burning = (EntityInvincibleItem)item).func_70027_ad()) break;
                    for (int i = -1; i < 2; ++i) {
                        for (int j = -1; j < 2; ++j) {
                            int blockID = world.func_72798_a((int)burning.field_70165_t + i, (int)burning.field_70163_u, (int)burning.field_70161_v + j);
                            if (blockID != Block.field_72067_ar.field_71990_ca) continue;
                            world.func_94571_i((int)burning.field_70165_t + i, (int)burning.field_70163_u, (int)burning.field_70161_v + j);
                        }
                    }
                    EntityWither wither = new EntityWither(world);
                    ItemStack bottledWither = DartUtils.bottleEntity((Entity)wither);
                    if (bottledWither != null) {
                        this.itemChange(item);
                        world.func_72900_e((Entity)item);
                        DartUtils.dropInvincibleItem(bottledWither, world, item.field_70165_t, item.field_70163_u, item.field_70161_v);
                        dartTag.func_74768_a("lastTransmute", 10);
                        item = null;
                        stack.func_77972_a(1, (EntityLiving)player);
                        return stack;
                    }
                }
                if (tomeStack.field_77993_c == Item.field_92105_bW.field_77779_bT) {
                    int exp = 1;
                    if (tomeStack.func_77942_o() && tomeStack.func_77978_p().func_74764_b("StoredEnchantments")) {
                        NBTTagList enchants = tomeStack.func_77978_p().func_74761_m("StoredEnchantments");
                        for (NBTBase ench : enchants.field_74747_a) {
                            if (ench == null || !(ench instanceof NBTTagCompound)) continue;
                            NBTTagCompound enchComp = (NBTTagCompound)ench;
                            exp += enchComp.func_74765_d("lvl");
                        }
                    }
                    world.func_72900_e((Entity)item);
                    this.itemChange(item);
                    for (int i = 0; i < exp; ++i) {
                        DartUtils.dropItem(new ItemStack(Item.field_77809_bD), world, item.field_70165_t, item.field_70163_u, item.field_70161_v);
                    }
                    dartTag.func_74768_a("lastTransmute", 10);
                    stack.func_77972_a(1, (EntityLiving)player);
                    return stack;
                }
                if (tomeStack.func_77973_b() instanceof ItemForceArmor && tomeStack.func_77942_o()) {
                    ArrayList<ItemStack> toDrop = new ArrayList<ItemStack>();
                    NBTTagCompound armorUpgrades = UpgradeHelper.getUpgradeCompound(tomeStack);
                    if (armorUpgrades.func_74764_b("Charge") || armorUpgrades.func_74764_b("Charge2")) {
                        ItemStack dropStack;
                        int i;
                        ItemForceArmor armor = (ItemForceArmor)tomeStack.func_77973_b();
                        int charge = tomeStack.func_77978_p().func_74762_e("charge");
                        int crystals = armor.getMaxCharge(tomeStack) / 100000;
                        int batteries = (armor.getMaxCharge(tomeStack) - crystals * 100000) / 10000;
                        if (DartItem.IC2Crystal != null && crystals > 0) {
                            for (i = 0; i < crystals; ++i) {
                                if (charge >= 100000) {
                                    dropStack = new ItemStack(DartItem.IC2Crystal.func_77973_b());
                                    dropStack.func_77982_d(new NBTTagCompound());
                                    dropStack.func_77978_p().func_74768_a("charge", 100000);
                                    toDrop.add(dropStack);
                                    charge -= 100000;
                                    continue;
                                }
                                dropStack = new ItemStack(DartItem.IC2Crystal.func_77973_b());
                                dropStack.func_77982_d(new NBTTagCompound());
                                dropStack.func_77978_p().func_74768_a("charge", charge);
                                toDrop.add(dropStack);
                                charge = 0;
                            }
                        }
                        if (DartItem.IC2Battery != null && batteries > 0) {
                            for (i = 0; i < batteries; ++i) {
                                if (charge >= 10000) {
                                    dropStack = new ItemStack(DartItem.IC2Battery.func_77973_b());
                                    dropStack.func_77982_d(new NBTTagCompound());
                                    dropStack.func_77978_p().func_74768_a("charge", 10000);
                                    toDrop.add(dropStack);
                                    charge -= 10000;
                                    continue;
                                }
                                dropStack = new ItemStack(DartItem.IC2Battery.func_77973_b());
                                dropStack.func_77982_d(new NBTTagCompound());
                                dropStack.func_77978_p().func_74768_a("charge", charge);
                                toDrop.add(dropStack);
                                charge = 0;
                            }
                        }
                    }
                    ItemStack newArmor = item.func_92059_d().func_77946_l();
                    newArmor.func_77978_p().func_82580_o("upgrades");
                    newArmor.func_77978_p().func_82580_o("charge");
                    world.func_72900_e((Entity)item);
                    if (toDrop.size() > 0) {
                        for (ItemStack dropstack : toDrop) {
                            DartUtils.dropItem(dropstack, world, item.field_70165_t, item.field_70163_u, item.field_70161_v);
                        }
                    }
                    this.itemChange(item);
                    EntityItem newItem = new EntityItem(world, item.field_70165_t, item.field_70163_u, item.field_70161_v, newArmor);
                    world.func_72838_d((Entity)newItem);
                    dartTag.func_74768_a("lastTransmute", 10);
                    stack.func_77972_a(1, (EntityLiving)player);
                    return stack;
                }
                ForceTransmutation trans = ForceTransmutation.getTransmutable(tomeStack);
                if (trans != null && trans.getOutput() != null) {
                    if (tomeStack.field_77994_a - 1 > stack.func_77958_k() - stack.func_77960_j()) {
                        player.func_70006_a("This rod's durability is too low to do that.");
                        return stack;
                    }
                    this.itemChange(item);
                    ItemStack dropStack = trans.getOutput().func_77946_l();
                    dropStack.field_77994_a = tomeStack.field_77994_a * dropStack.field_77994_a;
                    world.func_72900_e((Entity)item);
                    for (int i = 0; i < dropStack.field_77994_a; ++i) {
                        ItemStack tempStack = new ItemStack(dropStack.func_77973_b(), 1, dropStack.func_77960_j());
                        if (dropStack.func_77942_o()) {
                            tempStack.func_77982_d((NBTTagCompound)dropStack.func_77978_p().func_74737_b());
                        }
                        DartUtils.dropItem(tempStack, world, item.field_70165_t, item.field_70163_u, item.field_70161_v);
                    }
                    stack.func_77972_a(tomeStack.field_77994_a, (EntityLiving)player);
                    dartTag.func_74768_a("lastTransmute", 10);
                    item = null;
                    return stack;
                }
            }
            newPosX += xIncr;
            newPosY += yIncr;
            newPosZ += zIncr;
        }
        if (upgrades.func_74764_b("Holding") || upgrades.func_74764_b("Ender")) {
            return stack;
        }
        int x = (int)Math.floor(newPosX);
        int y = (int)Math.floor(newPosY);
        int z = (int)Math.floor(newPosZ);
        boolean hasChange = false;
        int id2 = world.func_72798_a(x, y, z);
        if (id2 == Block.field_72089_ap.field_71990_ca) {
            if (Proxies.common.isSimulating(world)) {
                int direction = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
                world.func_72832_d(x, y, z, DartBlock.blockInfuser.field_71990_ca, direction, 2);
            }
            stack.func_77972_a(1, (EntityLiving)player);
            hasChange = true;
        }
        if (id2 == Block.field_71987_y.field_71990_ca) {
            if (Proxies.common.isSimulating(world)) {
                world.func_72832_d(x, y, z, DartBlock.forceSapling.field_71990_ca, 0, 2);
            }
            stack.func_77972_a(1, (EntityLiving)player);
            hasChange = true;
        }
        if (id2 == Block.field_72006_bl.field_71990_ca) {
            if (Proxies.common.isSimulating(world)) {
                world.func_94571_i(x, y, z);
                DartUtils.dropItem(new ItemStack(Item.field_77754_aU), world, x, y, z);
            }
            stack.func_77972_a(1, (EntityLiving)player);
            hasChange = true;
        }
        if (id2 == Block.field_72067_ar.field_71990_ca) {
            if (Proxies.common.isSimulating(world)) {
                world.func_94571_i(x, y, z);
                DartUtils.dropItem(new ItemStack((Block)Block.field_72067_ar), world, x, y, z);
            }
            stack.func_77972_a(1, (EntityLiving)player);
            hasChange = true;
        }
        if (hasChange && Proxies.common.isSimulating(world)) {
            PacketDispatcher.sendPacketToAllAround((double)x, (double)y, (double)z, (double)30.0, (int)player.field_71093_bK, (Packet)new FXPacket(20, x, y, z).getPacket());
            world.func_72956_a((Entity)player, "bluedart.magic", 1.0f, DartUtils.randomPitch());
        }
        return stack;
    }

    private void itemChange(EntityItem item) {
        item.field_70170_p.func_72956_a((Entity)item, "bluedart.magic", 1.0f, DartUtils.randomPitch());
        PacketDispatcher.sendPacketToAllAround((double)item.field_70165_t, (double)item.field_70163_u, (double)item.field_70161_v, (double)30.0, (int)item.field_71093_bK, (Packet)new FXPacket(21, item.field_70165_t, item.field_70163_u, item.field_70161_v).getPacket());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("upgrades")) {
            NBTTagCompound upgrades = stack.func_77978_p().func_74775_l("upgrades");
            if (upgrades.func_74764_b("Ender") || upgrades.func_74764_b("Camo")) {
                return EnumRarity.epic;
            }
            if (upgrades.func_74764_b("Healing") || upgrades.func_74764_b("Wing") || upgrades.func_74764_b("Sight")) {
                return EnumRarity.rare;
            }
        }
        return EnumRarity.uncommon;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    public Icon getIcon(ItemStack stack, int pass) {
        NBTTagCompound upgrades;
        if (stack.func_77942_o() && (upgrades = stack.func_77978_p().func_74775_l("upgrades")) != null) {
            if (upgrades.func_74764_b("Wing") || upgrades.func_74764_b("Healing") || upgrades.func_74764_b("Speed") || upgrades.func_74764_b("Sight")) {
                return IconDirectory.rods[1];
            }
            if (upgrades.func_74764_b("Heat")) {
                return IconDirectory.rods[2];
            }
            if (upgrades.func_74764_b("Ender") || upgrades.func_74764_b("Camo")) {
                return IconDirectory.rods[3];
            }
        }
        return this.field_77791_bV;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IconRegister reggie) {
        for (int i = 0; i < 4; ++i) {
            IconDirectory.rods[i] = reggie.func_94245_a("Dartcraft:forceRod" + i);
        }
        this.field_77791_bV = IconDirectory.rods[0];
        IconDirectory.dummy = reggie.func_94245_a("Dartcraft:dummy");
        IconDirectory.noSlot = reggie.func_94245_a("Dartcraft:noSlot");
    }

    @Override
    public ItemStack itemReturned() {
        return new ItemStack((Item)DartItem.forceShard);
    }

    @Override
    public int[] validUpgrades() {
        ForceUpgradeManager fum = DartAPI.fum;
        int[] nArray = new int[8];
        nArray[0] = ForceUpgradeManager.MINING.getID();
        nArray[1] = ForceUpgradeManager.HEALING.getID();
        nArray[2] = ForceUpgradeManager.HEAT.getID();
        nArray[3] = ForceUpgradeManager.STORAGE.getID();
        nArray[4] = ForceUpgradeManager.ENDER.getID();
        nArray[5] = ForceUpgradeManager.CAMO.getID();
        nArray[6] = ForceUpgradeManager.REPAIR.getID();
        nArray[7] = ForceUpgradeManager.SIGHT.getID();
        return nArray;
    }

    @Override
    public void doRepair(ItemStack stack, Entity entity) {
        ThaumCraftIntegration.doRepair(stack, entity);
    }
}

