/*
 * Decompiled with CFR 0.152.
 */
package bluedart.item.tool;

import bluedart.DartCraft;
import bluedart.api.ForceUpgradeManager;
import bluedart.api.IForceUpgradable;
import bluedart.client.IconDirectory;
import bluedart.core.Config;
import bluedart.entity.EntityInvincibleItem;
import bluedart.item.DartItem;
import bluedart.item.tool.ItemMemberCard;
import bluedart.proxy.Proxies;
import bluedart.utils.DartUtils;
import bluedart.utils.ItemInventory;
import bluedart.utils.UpgradeHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;

public class ItemForcePack
extends DartItem
implements IForceUpgradable {
    public static final int maxPackSize = 40;

    public ItemForcePack(int id) {
        super(id);
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.func_77656_e(0);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack item, EntityPlayer player, List list, boolean bool) {
        if (!item.func_77942_o()) {
            return;
        }
        NBTTagCompound comp = item.func_77978_p();
        if (list.size() > 2 && list.get(2) != null) {
            list.remove(2);
        }
        if (list.size() > 1 && list.get(1) != null) {
            list.remove(1);
        }
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add("" + this.filledSlots(item) + "/" + comp.func_74762_e("size") + " slots");
        }
    }

    private int filledSlots(ItemStack stack) {
        NBTTagCompound comp = stack.func_77978_p();
        if (comp == null) {
            return 0;
        }
        NBTTagList list = comp.func_74761_m("contents");
        if (list == null) {
            return 0;
        }
        int returnVal = 0;
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tempComp;
            ItemStack tempStack;
            if (!(list.func_74743_b(i) instanceof NBTTagCompound) || (tempStack = ItemStack.func_77949_a((NBTTagCompound)(tempComp = (NBTTagCompound)list.func_74743_b(i)))) == null) continue;
            ++returnVal;
        }
        return returnVal;
    }

    public Icon func_77617_a(int meta) {
        if (meta > 0 && meta < 16) {
            return IconDirectory.packs[meta];
        }
        return this.field_77791_bV;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IconRegister reggie) {
        for (int i = 0; i < 16; ++i) {
            IconDirectory.packs[i] = reggie.func_94245_a("Dartcraft:forcePack" + i);
        }
        this.field_77791_bV = IconDirectory.packs[0];
    }

    public String func_77628_j(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return super.func_77628_j(stack);
        }
        String name = stack.func_77978_p().func_74779_i("name");
        if (name != null && !name.equals("")) {
            return name;
        }
        return super.func_77628_j(stack);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int par4, boolean par5) {
        if (!stack.func_77942_o()) {
            this.initCompound(stack);
        }
        if (!stack.func_77978_p().func_74764_b("ID")) {
            stack.func_77978_p().func_74768_a("ID", new Random().nextInt());
        }
    }

    private void initCompound(ItemStack stack) {
        NBTTagCompound comp = new NBTTagCompound();
        comp.func_74768_a("size", Config.packSize);
        NBTTagList contents = new NBTTagList();
        int i = 0;
        while (true) {
            if (i >= 40) break;
            NBTTagCompound itemComp = new NBTTagCompound();
            itemComp.func_74774_a("Slot", (byte)i);
            contents.func_74742_a((NBTBase)itemComp);
            ++i;
        }
        comp.func_74782_a("contents", (NBTBase)contents);
        stack.func_77982_d(comp);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77633_a(int id, CreativeTabs tabs, List itemList) {
        ItemStack stack = new ItemStack((Item)this, 1, 11);
        itemList.add(stack);
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (player.func_70093_af()) {
            player.openGui((Object)DartCraft.instance, 2, world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        } else if (stack.func_77942_o()) {
            NBTTagCompound dartTag = player.getEntityData().func_74775_l("DartCraft");
            dartTag.func_74768_a("toOpen", stack.func_77978_p().func_74762_e("ID"));
            if (Proxies.common.isSimulating(world)) {
                player.openGui((Object)DartCraft.instance, 1, world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
            }
        }
        return stack;
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        int i;
        int j;
        if (!Proxies.common.isSimulating(world) || !stack.func_77942_o()) {
            return false;
        }
        TileEntity tile = world.func_72796_p(x, y, z);
        if (!(tile instanceof IInventory)) {
            return false;
        }
        ItemInventory packInv = new ItemInventory(stack.func_77978_p().func_74762_e("size"), stack);
        ArrayList<ItemStack> toTake = new ArrayList<ItemStack>();
        ArrayList<ItemStack> toStore = new ArrayList<ItemStack>();
        for (int i2 = 0; i2 < packInv.func_70302_i_(); ++i2) {
            ItemStack cardStack = packInv.func_70301_a(i2);
            if (cardStack == null || !(cardStack.func_77973_b() instanceof ItemMemberCard) || !cardStack.func_77942_o()) continue;
            int size = UpgradeHelper.getUpgradeCompound(cardStack).func_74764_b("Craft") ? 9 : 16;
            ItemInventory cardInv = new ItemInventory(size, cardStack);
            block5: for (j = 0; j < cardInv.func_70302_i_(); ++j) {
                ItemStack tempStack = cardInv.func_70301_a(j);
                if (tempStack == null || !tempStack.func_77942_o()) continue;
                switch (tempStack.func_77978_p().func_74771_c("mode")) {
                    case 1: {
                        toStore.add(new ItemStack(tempStack.func_77973_b(), 1, tempStack.func_77960_j()));
                        continue block5;
                    }
                    case 2: {
                        toTake.add(new ItemStack(tempStack.func_77973_b(), 1, tempStack.func_77960_j()));
                    }
                }
            }
        }
        if (toTake.size() == 0 && toStore.size() == 0) {
            return false;
        }
        IInventory inv = (IInventory)tile;
        boolean changed = false;
        if (toStore.size() > 0 && !player.func_70093_af()) {
            for (i = 0; i < toStore.size(); ++i) {
                ItemStack store = (ItemStack)toStore.get(i);
                for (j = 0; j < packInv.func_70302_i_(); ++j) {
                    ItemStack packStack = packInv.func_70301_a(j);
                    if (packStack == null || packStack.field_77993_c != store.field_77993_c || packStack.func_77960_j() != store.func_77960_j()) continue;
                    int prevSize = packStack.field_77994_a;
                    if (DartUtils.addItemStackToInventory(inv, packStack)) {
                        packInv.func_70299_a(j, null);
                    }
                    if (packStack != null && packStack.field_77994_a >= prevSize) continue;
                    changed = true;
                }
            }
        }
        if (toTake.size() > 0 && !changed) {
            for (i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack invStack = inv.func_70301_a(i);
                if (invStack == null) continue;
                for (ItemStack tempStack : toTake) {
                    if (tempStack.field_77993_c != invStack.field_77993_c || tempStack.func_77960_j() != invStack.func_77960_j()) continue;
                    if (packInv.addItemToInventory(invStack)) {
                        changed = true;
                    }
                    if (invStack.field_77994_a > 0) continue;
                    inv.func_70299_a(i, (ItemStack)null);
                }
            }
        }
        if (changed) {
            packInv.save();
        }
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack stack) {
        return stack != null && UpgradeHelper.getUpgradeCompound(stack).func_74764_b("Sturdy") ? EnumRarity.rare : EnumRarity.uncommon;
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return stack != null && UpgradeHelper.getUpgradeCompound(stack).func_74764_b("Sturdy");
    }

    public Entity createEntity(World world, Entity entity, ItemStack stack) {
        EntityInvincibleItem item = new EntityInvincibleItem(world, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, stack);
        item.field_70159_w = entity.field_70159_w;
        item.field_70181_x = entity.field_70181_x;
        item.field_70179_y = entity.field_70179_y;
        return item;
    }

    @Override
    public int[] validUpgrades() {
        int[] nArray = new int[3];
        nArray[0] = ForceUpgradeManager.STORAGE.getID();
        nArray[1] = ForceUpgradeManager.ENDER.getID();
        nArray[2] = ForceUpgradeManager.STURDY.getID();
        return nArray;
    }
}

