/*
 * Decompiled with CFR 0.152.
 */
package bluedart.item.tool;

import bluedart.api.IBreakable;
import bluedart.block.DartBlock;
import bluedart.client.TabDart;
import bluedart.core.network.FXPacket;
import bluedart.item.DartItem;
import bluedart.proxy.Proxies;
import bluedart.proxy.ProxyCommon;
import bluedart.utils.DartUtils;
import bluedart.utils.SocketHelper;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.arboriculture.IToolGrafter;
import ic2.core.Ic2Items;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumToolMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumHelper;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.entity.player.UseHoeEvent;

public class ItemForceMitts
extends ItemTool
implements IBreakable,
IToolGrafter {
    private static int damage = 0;
    private static float efficiency = 16.0f;
    private static int toolLevel = 4;
    public static EnumToolMaterial material = EnumHelper.addToolMaterial((String)"FORCE", (int)toolLevel, (int)256, (float)efficiency, (int)damage, (int)0);
    public ArrayList mineableBlocks = new ArrayList();
    private int range = 2;

    public ItemForceMitts(int id) {
        super(id, 0, material, new Block[0]);
        this.func_77637_a(TabDart.instance);
        this.field_77864_a = efficiency;
        this.loadMinables();
        MinecraftForge.setToolClass((Item)this, (String)"pickaxe", (int)4);
        MinecraftForge.setToolClass((Item)this, (String)"shovel", (int)4);
        MinecraftForge.setToolClass((Item)this, (String)"axe", (int)4);
    }

    private void loadMinables() {
        this.mineableBlocks.add(Block.field_71978_w);
        this.mineableBlocks.add(Block.field_71981_t);
        this.mineableBlocks.add(Block.field_71957_Q);
        this.mineableBlocks.add(Block.field_72087_ao);
        this.mineableBlocks.add(Block.field_71949_H);
        this.mineableBlocks.add(Block.field_71950_I);
        this.mineableBlocks.add(Block.field_72036_aT);
        this.mineableBlocks.add(Block.field_72081_al);
        this.mineableBlocks.add(Block.field_72014_bd);
        this.mineableBlocks.add(Block.field_71980_u);
        this.mineableBlocks.add(Block.field_71979_v);
        this.mineableBlocks.add(Block.field_71994_by);
        this.mineableBlocks.add(Block.field_71939_E);
        this.mineableBlocks.add(Block.field_71940_F);
        this.mineableBlocks.add(Block.field_72037_aS);
        this.mineableBlocks.add(Block.field_72039_aU);
        this.mineableBlocks.add(Block.field_72041_aW);
        this.mineableBlocks.add(Block.field_72050_aA);
        this.mineableBlocks.add(Block.field_72007_bm);
        this.mineableBlocks.add(Block.field_72013_bc);
        this.mineableBlocks.add(Block.field_71952_K);
        this.mineableBlocks.add(DartBlock.forceLeaves);
        this.mineableBlocks.add(DartBlock.forceLog);
    }

    public float func_77638_a(ItemStack stack, Block block) {
        return this.getStrVsBlock(stack, block, 0);
    }

    public float getStrVsBlock(ItemStack stack, Block block, int meta) {
        if (ForgeHooks.isToolEffective((ItemStack)stack, (Block)block, (int)meta) || this.func_77641_a(block)) {
            NBTTagCompound upgrades = SocketHelper.getSocketCompound(stack);
            if (upgrades.func_74764_b("Speed")) {
                return this.field_77864_a * (1.0f + 0.8f * (float)upgrades.func_74762_e("Speed"));
            }
            return this.field_77864_a;
        }
        return 1.0f;
    }

    public boolean func_77641_a(Block block) {
        return this.mineableBlocks.contains(block) || block.field_72018_cp == Material.field_76257_i || block.field_72018_cp == Material.field_76245_d || this.isCrop(block);
    }

    private boolean isCrop(Block block) {
        return Loader.isModLoaded((String)"IC2") && Ic2Items.crop != null && Block.field_71973_m[Ic2Items.crop.field_77993_c] == block;
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int par7, float par8, float par9, float par10) {
        if (!player.func_82247_a(x, y, z, par7, stack)) {
            return false;
        }
        UseHoeEvent event = new UseHoeEvent(player, stack, world, x, y, z);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        if (event.getResult() == Event.Result.ALLOW) {
            stack.func_77972_a(1, (EntityLiving)player);
            return true;
        }
        int i1 = world.func_72798_a(x, y, z);
        int j1 = world.func_72798_a(x, y + 1, z);
        if ((par7 == 0 || j1 != 0 || i1 != Block.field_71980_u.field_71990_ca) && i1 != Block.field_71979_v.field_71990_ca) {
            return false;
        }
        Block block = Block.field_72050_aA;
        world.func_72908_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), block.field_72020_cn.func_72675_d(), (block.field_72020_cn.func_72677_b() + 1.0f) / 2.0f, block.field_72020_cn.func_72678_c() * 0.8f);
        if (world.field_72995_K) {
            return true;
        }
        world.func_94575_c(x, y, z, block.field_71990_ca);
        DartUtils.damageTool(player, stack, 1);
        return true;
    }

    public boolean onBlockStartBreak(ItemStack stack, int x, int y, int z, EntityPlayer player) {
        World world = player.field_70170_p;
        if (!Proxies.common.isSimulating(world)) {
            return false;
        }
        int brokenID = world.func_72798_a(x, y, z);
        Block block = Block.field_71973_m[brokenID];
        Material mat = world.func_72803_f(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        if (block != null && block instanceof BlockFlower || mat != null && mat == Material.field_76257_i) {
            for (int i = 0 - this.range; i < 1 + this.range; ++i) {
                for (int j = 0 - this.range; j < 1 + this.range; ++j) {
                    for (int k = 0 - this.range; k < 1 + this.range; ++k) {
                        int newX = x + i;
                        int newY = y + j;
                        int newZ = z + k;
                        Material mat2 = world.func_72803_f(newX, newY, newZ);
                        Block block2 = Block.field_71973_m[world.func_72798_a(newX, newY, newZ)];
                        if ((block2 == null || !(block2 instanceof BlockFlower)) && (mat2 == null || mat2 != Material.field_76257_i)) continue;
                        if (DartItem.thaumLeaves != null && block2 != null && block2.field_71990_ca == DartItem.thaumLeaves.field_77993_c && world.func_72805_g(newX, newY, newZ) == DartItem.thaumLeaves.func_77960_j() && DartItem.thaumSapling != null) {
                            if (ProxyCommon.rand.nextFloat() >= 0.98f) {
                                DartUtils.dropItem(new ItemStack(DartItem.thaumSapling.func_77973_b(), 1, DartItem.thaumSapling.func_77960_j()), world, x + i, y + j, z + k);
                            }
                        }
                        Block.field_71973_m[world.func_72798_a(x + i, y + j, z + k)].func_71893_a(world, player, x + i, y + j, z + k, world.func_72805_g(x + i, y + j, z + k));
                        world.func_94571_i(x + i, y + j, z + k);
                        if (i != 0 || j != 0 || k != 0) continue;
                        PacketDispatcher.sendPacketToAllAround((double)x, (double)y, (double)z, (double)30.0, (int)player.field_71093_bK, (Packet)new FXPacket(17, x, y, z).getPacket());
                    }
                }
            }
            DartUtils.damageTool(player, stack, 1);
            world.func_72908_a((double)x, (double)y, (double)z, "bluedart.fly", 0.75f, DartUtils.randomPitch());
            return true;
        }
        return false;
    }

    public boolean func_77644_a(ItemStack stack, EntityLiving victim, EntityLiving attacker) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IconRegister reggie) {
        this.field_77791_bV = reggie.func_94245_a("Dartcraft:forceMitts");
    }

    @Override
    public ItemStack itemReturned() {
        return new ItemStack((Item)DartItem.forceShard);
    }

    @Override
    public float getSaplingModifier(ItemStack stack, World world, EntityPlayer player, int x, int y, int z) {
        return 100.0f;
    }
}

