/*
 * Decompiled with CFR 0.152.
 */
package bluedart.item.tool;

import bluedart.api.DartAPI;
import bluedart.api.ForceUpgradeManager;
import bluedart.api.IBreakable;
import bluedart.api.IForceUpgradable;
import bluedart.client.IconDirectory;
import bluedart.client.TabDart;
import bluedart.core.Constants;
import bluedart.entity.EntityDartArrow;
import bluedart.integration.ThaumCraftIntegration;
import bluedart.item.DartItem;
import bluedart.proxy.Proxies;
import bluedart.utils.DartUtils;
import bluedart.utils.UpgradeHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.ArrowNockEvent;
import thaumcraft.api.IVisRepairable;

public class ItemForceBow
extends ItemBow
implements IBreakable,
IForceUpgradable,
IVisRepairable {
    public ItemForceBow(int id) {
        super(id);
        this.func_77656_e(332);
        this.func_77664_n();
        this.func_77637_a(TabDart.instance);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean thing) {
        NBTTagCompound upgrades;
        if (stack.func_77942_o() && (upgrades = stack.func_77978_p().func_74775_l("upgrades")) != null) {
            if (upgrades.func_74764_b("Bane")) {
                list.add("\u00a7cBane");
            }
            if (upgrades.func_74764_b("Speed")) {
                list.add("\u00a7bSwiftness");
            }
            if (upgrades.func_74764_b("Bleed")) {
                list.add("\u00a74Bleeding" + DartUtils.enchantName(upgrades.func_74762_e("Bleed")));
            }
            if (upgrades.func_74764_b("Luck")) {
                list.add("\u00a7bLuck" + DartUtils.enchantName(upgrades.func_74762_e("Luck")));
            }
        }
    }

    public String func_77628_j(ItemStack stack) {
        NBTTagCompound upgrades = UpgradeHelper.getUpgradeCompound(stack);
        if (upgrades.func_74764_b("Ender")) {
            return "Ender Bow";
        }
        if (upgrades.func_74764_b("Heat")) {
            return "Heat Bow";
        }
        return super.func_77628_j(stack);
    }

    public boolean func_77636_d(ItemStack stack) {
        return false;
    }

    public Icon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        Icon[] ref = IconDirectory.forceBow;
        NBTTagCompound upgrades = UpgradeHelper.getUpgradeCompound(stack);
        if (upgrades.func_74764_b("Heat")) {
            ref = IconDirectory.heatBow;
        }
        if (upgrades.func_74764_b("Ender")) {
            ref = IconDirectory.enderBow;
        }
        if (usingItem != null && usingItem.func_77973_b().field_77779_bT == this.field_77779_bT) {
            int useTime = usingItem.func_77988_m() - useRemaining;
            if (useTime >= 18) {
                return ref[3];
            }
            if (useTime >= 13) {
                return ref[2];
            }
            if (useTime >= 0) {
                return ref[1];
            }
        }
        return ref[0];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IconRegister reggie) {
        int i;
        for (i = 0; i < 4; ++i) {
            IconDirectory.forceBow[i] = reggie.func_94245_a("Dartcraft:forceBow" + i);
        }
        for (i = 0; i < 4; ++i) {
            IconDirectory.heatBow[i] = reggie.func_94245_a("Dartcraft:heatBow" + i);
        }
        for (i = 0; i < 4; ++i) {
            IconDirectory.enderBow[i] = reggie.func_94245_a("Dartcraft:enderBow" + i);
        }
        this.field_77791_bV = IconDirectory.forceBow[0];
    }

    public ItemStack func_77659_a(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        ArrowNockEvent event = new ArrowNockEvent(par3EntityPlayer, par1ItemStack);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return event.result;
        }
        if (par3EntityPlayer.field_71075_bZ.field_75098_d || par3EntityPlayer.field_71071_by.func_70450_e(DartItem.forceArrow.field_77779_bT)) {
            par3EntityPlayer.func_71008_a(par1ItemStack, this.func_77626_a(par1ItemStack));
        }
        return par1ItemStack;
    }

    public void func_77615_a(ItemStack stack, World world, EntityPlayer player, int duration) {
        boolean infinite;
        int timeLeft = this.func_77626_a(stack) - duration;
        ArrowLooseEvent event = new ArrowLooseEvent(player, stack, timeLeft);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return;
        }
        timeLeft = event.charge;
        boolean bl = infinite = player.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((int)Enchantment.field_77342_w.field_77352_x, (ItemStack)stack) > 0;
        if (infinite || player.field_71071_by.func_70450_e(DartItem.forceArrow.field_77779_bT)) {
            NBTTagCompound upgrades;
            int level;
            float time = (float)timeLeft / 20.0f;
            if ((double)(time = (time * time + time * 2.0f) / 3.0f) < 0.1) {
                return;
            }
            if (time > 1.0f) {
                time = 1.0f;
            }
            EntityDartArrow arrow = new EntityDartArrow(world, (EntityLiving)player, time * 2.0f);
            if (time == 1.0f) {
                arrow.func_70243_d(true);
            }
            if ((level = EnchantmentHelper.func_77506_a((int)Enchantment.field_77345_t.field_77352_x, (ItemStack)stack)) > 0) {
                arrow.func_70239_b(arrow.func_70242_d() + (double)level * 0.5 + 0.5);
            }
            if ((level = EnchantmentHelper.func_77506_a((int)Enchantment.field_77344_u.field_77352_x, (ItemStack)stack)) > 0) {
                arrow.func_70240_a(level);
            }
            if (EnchantmentHelper.func_77506_a((int)Enchantment.field_77343_v.field_77352_x, (ItemStack)stack) > 0) {
                arrow.func_70015_d(100);
            }
            if (stack.func_77942_o() && (upgrades = stack.func_77978_p().func_74775_l("upgrades")) != null) {
                if (upgrades.func_74764_b("Speed")) {
                    arrow.setSwift();
                }
                if (upgrades.func_74764_b("Luck")) {
                    arrow.setLuck(upgrades.func_74762_e("Luck"));
                }
                if (upgrades.func_74764_b("Ender")) {
                    arrow.setEnder();
                }
                if (upgrades.func_74764_b("Freeze")) {
                    arrow.setFreeze();
                }
                if (upgrades.func_74764_b("Light")) {
                    arrow.setLight();
                }
                if (upgrades.func_74764_b("Bane")) {
                    arrow.setBane();
                }
                if (upgrades.func_74764_b("Bleed")) {
                    arrow.setBleed(upgrades.func_74762_e("Bleed"));
                }
            }
            stack.func_77972_a(1, (EntityLiving)player);
            if (stack.field_77994_a == 0) {
                player.func_71028_bD();
            }
            world.func_72956_a((Entity)player, "random.bow", 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + time * 0.5f);
            if (infinite) {
                arrow.field_70251_a = 2;
            } else {
                player.field_71071_by.func_70435_d(DartItem.forceArrow.field_77779_bT);
            }
            if (Proxies.common.isSimulating(world)) {
                world.func_72838_d((Entity)arrow);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack stack) {
        if (stack.func_77942_o()) {
            NBTTagCompound upgrades = stack.func_77978_p().func_74775_l("upgrades");
            if (upgrades.func_74764_b("Ender")) {
                return EnumRarity.epic;
            }
            if (upgrades.func_74764_b("Heat")) {
                return EnumRarity.uncommon;
            }
        }
        return EnumRarity.common;
    }

    public int func_77619_b() {
        return 50;
    }

    @Override
    public ItemStack itemReturned() {
        return new ItemStack((Item)DartItem.forceShard);
    }

    public String getTextureFile() {
        return Constants.ITEMS_PNG;
    }

    @Override
    public int[] validUpgrades() {
        ForceUpgradeManager fum = DartAPI.fum;
        int[] nArray = new int[8];
        nArray[0] = ForceUpgradeManager.HEAT.getID();
        nArray[1] = ForceUpgradeManager.BLEED.getID();
        nArray[2] = ForceUpgradeManager.LUCK.getID();
        nArray[3] = ForceUpgradeManager.DAMAGE.getID();
        nArray[4] = ForceUpgradeManager.ENDER.getID();
        nArray[5] = ForceUpgradeManager.BANE.getID();
        nArray[6] = ForceUpgradeManager.MINING.getID();
        nArray[7] = ForceUpgradeManager.REPAIR.getID();
        return nArray;
    }

    @Override
    public void doRepair(ItemStack stack, Entity entity) {
        ThaumCraftIntegration.doRepair(stack, entity);
    }
}

