/*
 * Decompiled with CFR 0.152.
 */
package bluedart.item.tool;

import bluedart.api.DartAPI;
import bluedart.api.ForceUpgradeManager;
import bluedart.api.IBreakable;
import bluedart.api.IForceUpgradable;
import bluedart.client.IconDirectory;
import bluedart.client.TabDart;
import bluedart.core.network.TreeFXPacket;
import bluedart.integration.ThaumCraftIntegration;
import bluedart.item.DartItem;
import bluedart.proxy.Proxies;
import bluedart.utils.DartUtils;
import bluedart.utils.UpgradeHelper;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.arboriculture.IToolGrafter;
import ic2.core.Ic2Items;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.EnumToolMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumHelper;
import net.minecraftforge.common.ForgeHooks;
import thaumcraft.api.IVisRepairable;

public class ItemForceAxe
extends ItemAxe
implements IBreakable,
IForceUpgradable,
IToolGrafter,
IVisRepairable {
    private static int damage = 1;
    private static float efficiency = 5.0f;
    private static int toolLevel = 10;
    public static EnumToolMaterial material = EnumHelper.addToolMaterial((String)"FORCE", (int)toolLevel, (int)512, (float)efficiency, (int)damage, (int)50);

    public ItemForceAxe(int id) {
        super(id, material);
        this.func_77637_a(TabDart.instance);
    }

    public boolean onBlockStartBreak(ItemStack stack, int x, int y, int z, EntityPlayer player) {
        World world = player.field_70170_p;
        int brokenID = world.func_72798_a(x, y, z);
        Block tempBlock = Block.field_71973_m[brokenID];
        NBTTagCompound upgrades = UpgradeHelper.getUpgradeCompound(stack);
        if (!(!upgrades.func_74764_b("Grinding") || upgrades.func_74764_b("Lumberjack") && DartUtils.isBlockWood(world, x, y + 1, z) || player.func_70093_af() || !(this.func_77638_a(stack, tempBlock) > 1.0f))) {
            return DartUtils.grindWood(player, x, y, z, stack);
        }
        if (!(!upgrades.func_74764_b("Heat") || upgrades.func_74764_b("Lumberjack") && DartUtils.isBlockWood(world, x, y + 1, z) || player.func_70093_af() || !(this.func_77638_a(stack, tempBlock) > 1.0f))) {
            return DartUtils.smeltBlock(world, stack, player, x, y, z);
        }
        return false;
    }

    public boolean func_77660_a(ItemStack stack, World world, int id, int x, int y, int z, EntityLiving entity) {
        if (!Proxies.common.isSimulating(world)) {
            return false;
        }
        if (!(entity instanceof EntityPlayer)) {
            return false;
        }
        EntityPlayer player = (EntityPlayer)entity;
        NBTTagCompound upgrades = UpgradeHelper.getUpgradeCompound(stack);
        Material mat = world.func_72803_f(x, y, z);
        if (mat == Material.field_76257_i) {
            if (upgrades.func_74764_b("Grafting")) {
                DartUtils.damageTool(player, stack, 5);
                return false;
            }
            return false;
        }
        boolean active = true;
        if (upgrades.func_74764_b("Lumberjack") && DartUtils.isBlockWood(world, x, y + 1, z) && !player.func_70093_af()) {
            int xCoord = x;
            int yCoord = y;
            int zCoord = z;
            int number = 0;
            while (DartUtils.isBlockWood(world, xCoord, yCoord, zCoord)) {
                if (active) {
                    for (int i = -3; i < 4; ++i) {
                        for (int j = -3; j < 4; ++j) {
                            if (!DartUtils.isBlockWood(world, xCoord + i, yCoord, zCoord + j)) continue;
                            if (DartUtils.breakWood(player, xCoord + i, yCoord, zCoord + j, stack)) {
                                ++number;
                            }
                            if (stack != null && stack.field_77994_a != 0) continue;
                            world.func_72956_a((Entity)player, "random.break", 1.0f, DartUtils.randomPitch());
                            return true;
                        }
                    }
                } else if (DartUtils.isBlockWood(world, xCoord, yCoord, zCoord)) {
                    if (DartUtils.breakWood(player, xCoord, yCoord, zCoord, stack)) {
                        ++number;
                    }
                    if (stack == null || stack.field_77994_a == 0) {
                        world.func_72956_a((Entity)player, "random.break", 1.0f, DartUtils.randomPitch());
                        return true;
                    }
                }
                ++yCoord;
            }
            PacketDispatcher.sendPacketToAllAround((double)x, (double)y, (double)z, (double)30.0, (int)world.func_72912_H().func_76076_i(), (Packet)new TreeFXPacket(x, y, z, number).getPacket());
        } else {
            DartUtils.damageTool(player, stack, 1);
        }
        return false;
    }

    public float func_77638_a(ItemStack stack, Block block) {
        return this.getStrVsBlock(stack, block, 0);
    }

    public float getStrVsBlock(ItemStack stack, Block block, int meta) {
        float modifier = 1.0f;
        Material mat = block.field_72018_cp;
        boolean isProperMaterial = mat == Material.field_76266_z || mat == Material.field_76245_d || mat == Material.field_76257_i || mat == Material.field_76268_x || this.isCrop(block);
        NBTTagCompound upgrades = UpgradeHelper.getUpgradeCompound(stack);
        if (upgrades.func_74764_b("Speed")) {
            modifier = 1.0f + 0.75f * (float)upgrades.func_74762_e("Speed");
        }
        if (ForgeHooks.isToolEffective((ItemStack)stack, (Block)block, (int)meta) || isProperMaterial) {
            return efficiency * modifier;
        }
        return 1.0f;
    }

    private boolean isCrop(Block block) {
        return Loader.isModLoaded((String)"IC2") && Ic2Items.crop != null && Block.field_71973_m[Ic2Items.crop.field_77993_c] == block;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean thing) {
        NBTTagCompound upgrades;
        if (stack.func_77942_o() && (upgrades = stack.func_77978_p().func_74775_l("upgrades")) != null) {
            if (upgrades.func_74764_b("Grafting")) {
                list.add("Grafting");
            }
            if (upgrades.func_74764_b("Lumberjack")) {
                list.add("\u00a7aLumberjack");
            }
            if (upgrades.func_74764_b("Grinding")) {
                list.add("\u00a73Grinding");
            }
            if (upgrades.func_74764_b("Speed")) {
                list.add("\u00a7fSpeed" + DartUtils.enchantName(upgrades.func_74762_e("Speed")));
            }
        }
    }

    public String func_77628_j(ItemStack stack) {
        NBTTagCompound upgrades = UpgradeHelper.getUpgradeCompound(stack);
        if (upgrades.func_74764_b("Heat")) {
            return "Heat Axe";
        }
        return super.func_77628_j(stack);
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        NBTTagCompound upgrades;
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("upgrades") && (upgrades = stack.func_77978_p().func_74775_l("upgrades")).func_74764_b("Heat")) {
            return EnumRarity.uncommon;
        }
        return EnumRarity.common;
    }

    public boolean func_77636_d(ItemStack stack) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    public Icon getIcon(ItemStack stack, int pass) {
        NBTTagCompound upgrades;
        if (stack.func_77942_o() && (upgrades = stack.func_77978_p().func_74775_l("upgrades")) != null && upgrades.func_74764_b("Heat")) {
            return IconDirectory.heatAxe;
        }
        return this.field_77791_bV;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IconRegister reggie) {
        IconDirectory.forceAxe = reggie.func_94245_a("Dartcraft:forceAxe");
        IconDirectory.heatAxe = reggie.func_94245_a("Dartcraft:heatAxe");
        this.field_77791_bV = IconDirectory.forceAxe;
    }

    @Override
    public ItemStack itemReturned() {
        return new ItemStack((Item)DartItem.forceShard);
    }

    @Override
    public int[] validUpgrades() {
        ForceUpgradeManager fum = DartAPI.fum;
        int[] nArray = new int[9];
        nArray[0] = ForceUpgradeManager.HEAT.getID();
        nArray[1] = ForceUpgradeManager.LUMBERJACK.getID();
        nArray[2] = ForceUpgradeManager.LUCK.getID();
        nArray[3] = ForceUpgradeManager.TOUCH.getID();
        nArray[4] = ForceUpgradeManager.STURDY.getID();
        nArray[5] = ForceUpgradeManager.MINING.getID();
        nArray[6] = ForceUpgradeManager.GRINDING.getID();
        nArray[7] = ForceUpgradeManager.GRAFTING.getID();
        nArray[8] = ForceUpgradeManager.REPAIR.getID();
        return nArray;
    }

    @Override
    public float getSaplingModifier(ItemStack stack, World world, EntityPlayer player, int x, int y, int z) {
        return UpgradeHelper.getUpgradeCompound(stack).func_74764_b("Grafting") ? 100.0f : 0.0f;
    }

    @Override
    public void doRepair(ItemStack stack, Entity entity) {
        ThaumCraftIntegration.doRepair(stack, entity);
    }
}

