/*
 * Decompiled with CFR 0.152.
 */
package bluedart.item;

import bluedart.api.DartAPI;
import bluedart.api.ForceUpgradeManager;
import bluedart.api.IForceUpgradable;
import bluedart.client.IconDirectory;
import bluedart.item.DartItem;
import bluedart.utils.DartUtils;
import bluedart.utils.UpgradeHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;

public class ItemUpgradeCore
extends DartItem
implements IForceUpgradable {
    public ItemUpgradeCore(int id) {
        super(id);
        this.func_77625_d(16);
        this.func_77656_e(0);
        this.setUnlocalizedName("upgradeCore");
    }

    public String func_77628_j(ItemStack stack) {
        NBTTagCompound upgrades = UpgradeHelper.getUpgradeCompound(stack);
        if (upgrades.func_74764_b("Grinding")) {
            return "Core of Grinding";
        }
        if (upgrades.func_74764_b("Speed")) {
            return "Core of Speed" + DartUtils.enchantName(upgrades.func_74762_e("Speed"));
        }
        if (upgrades.func_74764_b("Bane")) {
            return "Core of Bane";
        }
        if (upgrades.func_74764_b("Touch")) {
            return "Core of Silk Touch";
        }
        if (upgrades.func_74764_b("Luck")) {
            return "Core of Luck" + DartUtils.enchantName(upgrades.func_74762_e("Luck"));
        }
        if (upgrades.func_74764_b("Bleed")) {
            return "Bleeding" + DartUtils.enchantName(upgrades.func_74762_e("Bleed")) + " Core";
        }
        if (upgrades.func_74764_b("Heat")) {
            return "Heat Core";
        }
        if (upgrades.func_74764_b("Wing")) {
            return "Wing Core";
        }
        if (upgrades.func_74764_b("Sturdy")) {
            return "Sturdy Core";
        }
        if (upgrades.func_74764_b("Damage")) {
            return "Core of Damage" + DartUtils.enchantName(upgrades.func_74762_e("Damage"));
        }
        if (upgrades.func_74764_b("Lumberjack")) {
            return "Lumberjack Core";
        }
        if (upgrades.func_74764_b("Force")) {
            return "Damaged Core";
        }
        return super.func_77628_j(stack);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean thing) {
        NBTTagCompound upgrades = UpgradeHelper.getUpgradeCompound(stack);
        if (upgrades.func_74764_b("Force")) {
            list.add("Kill Me!");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    public Icon getIcon(ItemStack stack, int pass) {
        if (stack != null && stack.func_77942_o() && stack.func_77978_p().func_74764_b("upgrades")) {
            NBTTagCompound upgrades = stack.func_77978_p().func_74775_l("upgrades");
            if (upgrades == null) {
                return this.field_77791_bV;
            }
            if (upgrades.func_74764_b("Force") || upgrades.func_74764_b("Speed")) {
                return IconDirectory.cores[2];
            }
            if (upgrades.func_74764_b("Grinding") || upgrades.func_74764_b("Touch")) {
                return IconDirectory.cores[4];
            }
            if (upgrades.func_74764_b("Luck") || upgrades.func_74764_b("Wing")) {
                return IconDirectory.cores[1];
            }
            if (upgrades.func_74764_b("Heat") || upgrades.func_74764_b("Sturdy") || upgrades.func_74764_b("Damage") || upgrades.func_74764_b("Bleed")) {
                return IconDirectory.cores[3];
            }
            if (upgrades.func_74764_b("Lumberjack") || upgrades.func_74764_b("Bane")) {
                return IconDirectory.cores[5];
            }
            if (upgrades.func_74764_b("Holding")) {
                return IconDirectory.cores[6];
            }
        }
        return this.field_77791_bV;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IconRegister reggie) {
        for (int i = 0; i < 7; ++i) {
            IconDirectory.cores[i] = reggie.func_94245_a("Dartcraft:upgrade" + i);
        }
        this.field_77791_bV = IconDirectory.cores[0];
    }

    public boolean func_77636_d(ItemStack stack) {
        return false;
    }

    @Override
    public int[] validUpgrades() {
        ForceUpgradeManager fum = DartAPI.fum;
        int[] nArray = new int[11];
        nArray[0] = ForceUpgradeManager.MINING.getID();
        nArray[1] = ForceUpgradeManager.GRINDING.getID();
        nArray[2] = ForceUpgradeManager.LUCK.getID();
        nArray[3] = ForceUpgradeManager.TOUCH.getID();
        nArray[4] = ForceUpgradeManager.HEAT.getID();
        nArray[5] = ForceUpgradeManager.WING.getID();
        nArray[6] = ForceUpgradeManager.STURDY.getID();
        nArray[7] = ForceUpgradeManager.DAMAGE.getID();
        nArray[8] = ForceUpgradeManager.LUMBERJACK.getID();
        nArray[9] = ForceUpgradeManager.BANE.getID();
        nArray[10] = ForceUpgradeManager.BLEED.getID();
        return nArray;
    }
}

