/*
 * Decompiled with CFR 0.152.
 */
package bluedart.item;

import bluedart.api.DartAPI;
import bluedart.api.ForceUpgradeManager;
import bluedart.api.IBreakable;
import bluedart.api.IForceUpgradable;
import bluedart.client.TabDart;
import bluedart.integration.ThaumCraftIntegration;
import bluedart.item.DartItem;
import bluedart.proxy.Proxies;
import bluedart.proxy.ProxyCommon;
import bluedart.utils.DartUtils;
import bluedart.utils.UpgradeHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.ICustomElectricItem;
import java.util.List;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumArmorMaterial;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumHelper;
import net.minecraftforge.common.IArmorTextureProvider;
import net.minecraftforge.common.ISpecialArmor;
import thaumcraft.api.IVisRepairable;

public class ItemForceArmor
extends ItemArmor
implements ISpecialArmor,
IArmorTextureProvider,
IBreakable,
IForceUpgradable,
ICustomElectricItem,
IVisRepairable {
    public static EnumArmorMaterial forceArmorEnum = EnumHelper.addArmorMaterial((String)"FORCE", (int)25, (int[])new int[]{3, 6, 4, 3}, (int)0);
    public Icon icon2;
    public String iconName;
    public static final int maxCharge = 10000;
    public static final int transferLimit = 250;
    public static final int tier = 1;
    public static final int damageOnHit = 100;
    public static final int priority = 0;
    public static final float ratio = 1.0f;
    public static final ISpecialArmor.ArmorProperties[] props = new ISpecialArmor.ArmorProperties[]{new ISpecialArmor.ArmorProperties(0, 1.0, 0), new ISpecialArmor.ArmorProperties(0, 1.0, 1), new ISpecialArmor.ArmorProperties(0, 1.0, 2), new ISpecialArmor.ArmorProperties(0, 1.0, 3)};
    public static final int[] values = new int[]{3, 4, 6, 3};

    public ItemForceArmor(int id, int type) {
        super(id, forceArmorEnum, 4, type);
        this.func_77637_a(TabDart.instance);
    }

    public String getArmorTextureFile(ItemStack stack) {
        NBTTagCompound upgrades = UpgradeHelper.getUpgradeCompound(stack);
        int num = 0;
        String name = "/bluedart/force_";
        if (!upgrades.func_74764_b("Camo")) {
            if (upgrades.func_74764_b("Charge") || upgrades.func_74764_b("Charge2")) {
                num += 2;
            }
            if (stack.field_77993_c == DartItem.forceCap.field_77779_bT || stack.field_77993_c == DartItem.forceTunic.field_77779_bT || stack.field_77993_c == DartItem.forceBoots.field_77779_bT) {
                ++num;
            }
            if (stack.field_77993_c == DartItem.forcePants.field_77779_bT) {
                num += 2;
            }
        }
        return name + num + ".png";
    }

    public boolean func_77623_v() {
        return true;
    }

    public Icon getIcon(ItemStack stack, int pass) {
        NBTTagCompound upgrades = UpgradeHelper.getUpgradeCompound(stack);
        if (upgrades.func_74764_b("Charge") || upgrades.func_74764_b("Charge2")) {
            return this.icon2;
        }
        return this.field_77791_bV;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean thing) {
        NBTTagCompound upgrades = UpgradeHelper.getUpgradeCompound(stack);
        if (upgrades.func_74764_b("Camo")) {
            list.add("\u00a7fCamo");
        }
        if (upgrades.func_74764_b("Repair")) {
            list.add("\u00a7bRepair");
        }
        if (upgrades.func_74764_b("Bane")) {
            list.add("\u00a7bBane");
        }
        if (upgrades.func_74764_b("Heat")) {
            list.add("\u00a76Heat");
        }
        if (upgrades.func_74764_b("Damage")) {
            list.add("\u00a74Damage");
        }
        if (upgrades.func_74764_b("Bleed")) {
            list.add("\u00a74Bleeding" + DartUtils.enchantName(upgrades.func_74762_e("Bleed")));
        }
        if (upgrades.func_74764_b("Luck")) {
            list.add("\u00a7bLuck");
        }
        if (upgrades.func_74764_b("Grinding")) {
            list.add("Grinding");
        }
        if (upgrades.func_74764_b("Speed")) {
            list.add("Speed");
        }
        if (upgrades.func_74764_b("Wing")) {
            list.add("\u00a7bWing");
        }
        if (upgrades.func_74764_b("Sturdy")) {
            list.add("\u00a74Sturdy");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack stack) {
        NBTTagCompound upgrades = UpgradeHelper.getUpgradeCompound(stack);
        if (upgrades.func_74764_b("Charge") || upgrades.func_74764_b("Charge2")) {
            return EnumRarity.rare;
        }
        return EnumRarity.common;
    }

    public String func_77628_j(ItemStack stack) {
        NBTTagCompound upgrades = UpgradeHelper.getUpgradeCompound(stack);
        if (upgrades.func_74764_b("Charge") || upgrades.func_74764_b("Charge2")) {
            if (stack.func_77973_b() == DartItem.forceCap) {
                return "Light Cap";
            }
            if (stack.func_77973_b() == DartItem.forceTunic) {
                return "Light Tunic";
            }
            if (stack.func_77973_b() == DartItem.forcePants) {
                return "Light Pants";
            }
            if (stack.func_77973_b() == DartItem.forceBoots) {
                return "Light Boots";
            }
        }
        return super.func_77628_j(stack);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int par4, boolean par5) {
        NBTTagCompound comp;
        super.func_77663_a(stack, world, entity, par4, par5);
        if (!Proxies.common.isSimulating(world)) {
            return;
        }
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (!(comp = stack.func_77978_p()).func_74764_b("ID")) {
            comp.func_74768_a("ID", ProxyCommon.rand.nextInt());
        }
    }

    private void setVisualDamage(ItemStack stack) {
        NBTTagCompound upgrades = UpgradeHelper.getUpgradeCompound(stack);
        if ((upgrades.func_74764_b("Charge") || upgrades.func_74764_b("Charge2")) && stack.func_77973_b() instanceof ItemForceArmor) {
            int charge = stack.func_77978_p().func_74762_e("charge");
            int maxCharge = this.getMaxCharge(stack);
            if (maxCharge > 0) {
                int damage = this.func_77612_l() - (int)((float)charge / (float)maxCharge * (float)this.func_77612_l());
                if (damage <= 0) {
                    damage = 1;
                }
                if (stack.func_77960_j() != damage) {
                    stack.func_77964_b(damage);
                }
            }
        }
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        return stack;
    }

    public boolean func_82789_a(ItemStack stack, ItemStack repair) {
        return false;
    }

    public boolean func_77636_d(ItemStack stack) {
        return false;
    }

    @Override
    public ItemStack itemReturned() {
        return new ItemStack((Item)DartItem.forceShard);
    }

    public ItemForceArmor setUnlocalizedName(String name) {
        this.iconName = name;
        return (ItemForceArmor)super.func_77655_b(name);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IconRegister reggie) {
        this.field_77791_bV = reggie.func_94245_a("Dartcraft:" + this.iconName);
        this.icon2 = reggie.func_94245_a("Dartcraft:" + this.iconName + "Charged");
    }

    @Override
    public int[] validUpgrades() {
        ForceUpgradeManager fum = DartAPI.fum;
        int[] nArray = new int[12];
        nArray[0] = ForceUpgradeManager.CHARGE.getID();
        nArray[1] = ForceUpgradeManager.CHARGE2.getID();
        nArray[2] = ForceUpgradeManager.CAMO.getID();
        nArray[3] = ForceUpgradeManager.MINING.getID();
        nArray[4] = ForceUpgradeManager.HEAT.getID();
        nArray[5] = ForceUpgradeManager.WING.getID();
        nArray[6] = ForceUpgradeManager.STURDY.getID();
        nArray[7] = ForceUpgradeManager.DAMAGE.getID();
        nArray[8] = ForceUpgradeManager.LUCK.getID();
        nArray[9] = ForceUpgradeManager.BANE.getID();
        nArray[10] = ForceUpgradeManager.BLEED.getID();
        nArray[11] = ForceUpgradeManager.REPAIR.getID();
        return nArray;
    }

    @Override
    public int charge(ItemStack stack, int amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        NBTTagCompound upgrades = UpgradeHelper.getUpgradeCompound(stack);
        if (upgrades.func_74764_b("Charge") || upgrades.func_74764_b("Charge2")) {
            int charged = 0;
            if (tier >= this.getTier(stack)) {
                int defecit;
                if (!ignoreTransferLimit) {
                    amount = this.getTransferLimit(stack);
                }
                charged = amount > (defecit = this.getMaxCharge(stack) - stack.func_77978_p().func_74762_e("charge")) ? defecit : amount;
                if (!simulate) {
                    stack.func_77978_p().func_74768_a("charge", stack.func_77978_p().func_74762_e("charge") + charged);
                    this.setVisualDamage(stack);
                }
                return charged;
            }
        }
        return 0;
    }

    @Override
    public int discharge(ItemStack stack, int amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        NBTTagCompound upgrades = UpgradeHelper.getUpgradeCompound(stack);
        if (upgrades.func_74764_b("Charge") || upgrades.func_74764_b("Charge2")) {
            int charge = stack.func_77978_p().func_74762_e("charge");
            if (!ignoreTransferLimit && amount > this.getTransferLimit(stack)) {
                amount = this.getTransferLimit(stack);
            }
            if (amount > charge) {
                amount = charge;
            }
            if (!simulate) {
                stack.func_77978_p().func_74768_a("charge", charge - amount);
                this.setVisualDamage(stack);
            }
            return amount;
        }
        return 0;
    }

    @Override
    public boolean canUse(ItemStack stack, int amount) {
        NBTTagCompound upgrades = UpgradeHelper.getUpgradeCompound(stack);
        if (upgrades.func_74764_b("Charge") || upgrades.func_74764_b("Charge2")) {
            return stack.func_77978_p().func_74762_e("charge") >= amount;
        }
        return false;
    }

    @Override
    public boolean canShowChargeToolTip(ItemStack stack) {
        NBTTagCompound upgrades = UpgradeHelper.getUpgradeCompound(stack);
        return upgrades.func_74764_b("Charge") || upgrades.func_74764_b("Charge2");
    }

    @Override
    public boolean canProvideEnergy(ItemStack stack) {
        NBTTagCompound upgrades = UpgradeHelper.getUpgradeCompound(stack);
        if (upgrades.func_74764_b("Charge") || upgrades.func_74764_b("Charge2")) {
            return stack.func_77973_b() == DartItem.forceTunic;
        }
        return false;
    }

    @Override
    public int getChargedItemId(ItemStack stack) {
        return this.field_77779_bT;
    }

    @Override
    public int getEmptyItemId(ItemStack stack) {
        return this.field_77779_bT;
    }

    @Override
    public int getMaxCharge(ItemStack stack) {
        NBTTagCompound upgrades = UpgradeHelper.getUpgradeCompound(stack);
        if (upgrades.func_74764_b("Charge") || upgrades.func_74764_b("Charge2")) {
            return upgrades.func_74762_e("Charge") * 10000 + upgrades.func_74762_e("Charge2") * 100000;
        }
        return 0;
    }

    @Override
    public int getTier(ItemStack stack) {
        NBTTagCompound upgrades = UpgradeHelper.getUpgradeCompound(stack);
        if (upgrades.func_74764_b("Charge") || upgrades.func_74764_b("Charge2")) {
            int charge = this.getMaxCharge(stack);
            if (charge >= 100000) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    @Override
    public int getTransferLimit(ItemStack stack) {
        NBTTagCompound upgrades = UpgradeHelper.getUpgradeCompound(stack);
        if (upgrades.func_74764_b("Charge") || upgrades.func_74764_b("Charge2")) {
            switch (this.getTier(stack)) {
                case 1: {
                    return 100;
                }
                case 2: {
                    return 500;
                }
            }
        }
        return 0;
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLiving player, ItemStack armor, DamageSource source, double damage, int slot) {
        return props[slot];
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        NBTTagCompound upgrades = UpgradeHelper.getUpgradeCompound(armor);
        if ((upgrades.func_74764_b("Charge") || upgrades.func_74764_b("Charge2")) && armor.func_77973_b() instanceof ItemForceArmor && armor.func_77978_p().func_74762_e("charge") <= 0) {
            return 0;
        }
        return values[slot];
    }

    public void damageArmor(EntityLiving entity, ItemStack stack, DamageSource source, int damage, int slot) {
        NBTTagCompound upgrades = UpgradeHelper.getUpgradeCompound(stack);
        if ((upgrades.func_74764_b("Charge") || upgrades.func_74764_b("Charge2")) && stack.func_77973_b() instanceof ItemForceArmor) {
            ItemForceArmor armor = (ItemForceArmor)stack.func_77973_b();
            armor.discharge(stack, 100, 2, true, false);
        } else {
            stack.func_77972_a(1, entity);
        }
    }

    @Override
    public void doRepair(ItemStack stack, Entity entity) {
        NBTTagCompound upgrades = UpgradeHelper.getUpgradeCompound(stack);
        if (!upgrades.func_74764_b("Charge") && !upgrades.func_74764_b("Charge2")) {
            ThaumCraftIntegration.doRepair(stack, entity);
        }
    }
}

