/*
 * Decompiled with CFR 0.152.
 */
package bluedart.item;

import bluedart.utils.SocketHelper;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumToolMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public abstract class ElectricTool
extends ItemTool
implements IElectricItem {
    public int cl;
    public int operationEnergyCost;
    public int maxCharge;
    public int transferLimit;
    public int tier;
    public ArrayList mineableBlocks = new ArrayList();

    public ElectricTool(int id, EnumToolMaterial toolmaterial, int operationEnergyCost) {
        super(id, 0, toolmaterial, new Block[0]);
        this.operationEnergyCost = operationEnergyCost;
        this.func_77656_e(27);
        this.func_77625_d(1);
    }

    public float func_77638_a(ItemStack stack, Block block) {
        return this.getStrVsBlock(stack, block, 0);
    }

    public float getStrVsBlock(ItemStack stack, Block block, int meta) {
        if (!Loader.isModLoaded((String)"IC2")) {
            return 0.01f;
        }
        if (!ElectricItem.canUse(stack, this.getOperationCost(stack))) {
            return 1.0f;
        }
        if (ForgeHooks.isToolEffective((ItemStack)stack, (Block)block, (int)meta) || this.func_77641_a(block)) {
            NBTTagCompound upgrades = SocketHelper.getSocketCompound(stack);
            float speed = this.field_77864_a;
            if (upgrades.func_74764_b("Speed")) {
                speed *= 1.0f + 2.0f * (float)upgrades.func_74762_e("Speed");
            }
            if (stack.func_77942_o() && stack.func_77978_p().func_74767_n("active")) {
                speed /= 8.0f;
            }
            return speed;
        }
        return 1.0f;
    }

    public int getOperationCost(ItemStack stack) {
        float modifier = 1.0f;
        NBTTagCompound upgrades = SocketHelper.getSocketCompound(stack);
        if (upgrades.func_74764_b("Speed")) {
            modifier += 0.1f * (float)Math.pow(upgrades.func_74762_e("Speed"), 2.0);
        }
        return (int)(modifier * (float)this.operationEnergyCost);
    }

    public boolean func_77641_a(Block block) {
        return this.mineableBlocks.contains(block);
    }

    public boolean func_77644_a(ItemStack itemstack, EntityLiving entityliving, EntityLiving entityliving1) {
        return true;
    }

    public int func_77619_b() {
        return 0;
    }

    public boolean isRepairable() {
        return false;
    }

    public int func_77649_a(Entity entity) {
        return this.field_77865_bY;
    }

    @Override
    public boolean canProvideEnergy(ItemStack stack) {
        return false;
    }

    @Override
    public int getChargedItemId(ItemStack stack) {
        return this.field_77779_bT;
    }

    @Override
    public int getEmptyItemId(ItemStack stack) {
        return this.field_77779_bT;
    }

    @Override
    public int getMaxCharge(ItemStack stack) {
        return this.maxCharge;
    }

    @Override
    public int getTier(ItemStack stack) {
        return this.tier;
    }

    @Override
    public int getTransferLimit(ItemStack stack) {
        return this.transferLimit;
    }

    public boolean func_77660_a(ItemStack stack, World world, int blockID, int x, int y, int z, EntityLiving entity) {
        if (!Loader.isModLoaded((String)"IC2")) {
            return true;
        }
        Block block = Block.field_71973_m[blockID];
        int meta = world.func_72805_g(x, y, z);
        if ((double)block.func_71934_m(world, x, y, z) != 0.0) {
            if (entity instanceof EntityPlayer) {
                ElectricItem.use(stack, this.getOperationCost(stack), (EntityPlayer)entity);
            } else {
                ElectricItem.discharge(stack, this.getOperationCost(stack), this.tier, true, false);
            }
        }
        return true;
    }

    public boolean func_82789_a(ItemStack par1ItemStack, ItemStack par2ItemStack) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77633_a(int i, CreativeTabs tabs, List itemList) {
        if (!Loader.isModLoaded((String)"IC2")) {
            return;
        }
        ItemStack charged = new ItemStack((Item)this, 1);
        ElectricItem.charge(charged, this.getMaxCharge(charged), this.getTier(charged), true, false);
        itemList.add(charged);
        itemList.add(new ItemStack((Item)this, 1, this.func_77612_l()));
    }
}

