/*
 * Decompiled with CFR 0.152.
 */
package bluedart.integration;

import bluedart.DartCraft;
import bluedart.api.DartAPI;
import bluedart.api.ForceUpgradeManager;
import bluedart.block.DartBlock;
import bluedart.item.DartItem;
import bluedart.utils.DartUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import thaumcraft.api.EnumTag;
import thaumcraft.api.ItemApi;
import thaumcraft.api.ObjectTags;
import thaumcraft.api.ThaumcraftApi;

public class ThaumCraftIntegration {
    public static ItemStack thaumium;
    public static ItemStack crystal;
    public static Enchantment enchRepair;
    public static Class auraClass;
    public static Method useAura;

    public static void load() {
        DartCraft.dartLog.info("Loading Thaumcraft integration.");
        ThaumCraftIntegration.loadTags();
        ThaumCraftIntegration.loadEnchants();
        ThaumCraftIntegration.loadBlacklist();
        ThaumCraftIntegration.loadTransmutes();
        crystal = ItemApi.getItem("itemShard", 0);
        if (crystal != null) {
            for (int i = 0; i < 6; ++i) {
                DartAPI.fum.materials.add(DartAPI.umh.createMaterial(ThaumCraftIntegration.crystal.field_77993_c, i, ForceUpgradeManager.REPAIR.getID(), 0, 4.0f));
            }
        }
    }

    private static void loadTags() {
        try {
            ObjectTags blankTag = new ObjectTags();
            ThaumcraftApi.registerObjectTag(DartItem.clipboard.field_77779_bT, 0, blankTag);
            ThaumcraftApi.registerObjectTag(DartItem.forcePack.field_77779_bT, 0, blankTag);
            ThaumcraftApi.registerObjectTag(DartItem.forceTome.field_77779_bT, 0, blankTag);
            ThaumcraftApi.registerObjectTag(DartItem.forcePick.field_77779_bT, 0, blankTag);
            ThaumcraftApi.registerObjectTag(DartItem.forceSpade.field_77779_bT, 0, blankTag);
            ThaumcraftApi.registerObjectTag(DartItem.forceAxe.field_77779_bT, 0, blankTag);
            ThaumcraftApi.registerObjectTag(DartItem.forceSword.field_77779_bT, 0, blankTag);
            ThaumcraftApi.registerObjectTag(DartItem.forceBow.field_77779_bT, 0, blankTag);
            ThaumcraftApi.registerObjectTag(DartItem.forceShears.field_77779_bT, 0, blankTag);
            ThaumcraftApi.registerObjectTag(DartItem.memberCard.field_77779_bT, 0, blankTag);
            ThaumcraftApi.registerObjectTag(DartItem.forceGear.field_77779_bT, 0, blankTag);
            ThaumcraftApi.registerObjectTag(DartItem.magnetGlove.field_77779_bT, 0, blankTag);
            if (DartItem.terraWart != null) {
                ThaumcraftApi.registerObjectTag(DartItem.terraWart.field_77993_c, DartItem.terraWart.func_77960_j(), new ObjectTags().add(EnumTag.PURE, 2));
            }
            ThaumcraftApi.registerObjectTag(DartItem.ingotForce.field_77779_bT, 0, new ObjectTags().add(EnumTag.POWER, 4).add(EnumTag.MAGIC, 4).add(EnumTag.METAL, 4));
            ThaumcraftApi.registerObjectTag(DartItem.rawLambchop.field_77779_bT, 0, new ObjectTags().add(EnumTag.FLESH, 4).add(EnumTag.BEAST, 2));
            ThaumcraftApi.registerObjectTag(DartItem.cookedLambchop.field_77779_bT, 0, new ObjectTags().add(EnumTag.FLESH, 4).add(EnumTag.BEAST, 2).add(EnumTag.LIFE, 4));
            ThaumcraftApi.registerObjectTag(DartItem.gemForce.field_77779_bT, 0, new ObjectTags().add(EnumTag.MAGIC, 4).add(EnumTag.POWER, 4).add(EnumTag.CRYSTAL, 4));
            ThaumcraftApi.registerObjectTag(DartItem.fortune.field_77779_bT, 0, new ObjectTags().add(EnumTag.KNOWLEDGE, 8).add(EnumTag.VALUABLE, 4));
            ObjectTags brickTag = new ObjectTags().add(EnumTag.ROCK, 2).add(EnumTag.VALUABLE, 2);
            for (int i = 0; i < 16; ++i) {
                ThaumcraftApi.registerObjectTag(DartBlock.forceBrick.field_71990_ca, i, brickTag);
            }
            ThaumcraftApi.registerObjectTag(DartItem.forceRod.field_77779_bT, 0, new ObjectTags().add(EnumTag.EXCHANGE, 8).add(EnumTag.MAGIC, 2).add(EnumTag.METAL, 2));
            ThaumcraftApi.registerObjectTag(DartItem.tear.field_77779_bT, 0, new ObjectTags().add(EnumTag.SPIRIT, 4).add(EnumTag.WATER, 4).add(EnumTag.EVIL, 4));
            ThaumcraftApi.registerObjectTag(DartItem.claw.field_77779_bT, 0, new ObjectTags().add(EnumTag.BEAST, 4).add(EnumTag.ELDRITCH, 2).add(EnumTag.POISON, 2));
            ThaumcraftApi.registerObjectTag(DartItem.forceNugget.field_77779_bT, 0, new ObjectTags().add(EnumTag.MAGIC, 1));
            ThaumcraftApi.registerObjectTag(DartItem.forceShard.field_77779_bT, 0, new ObjectTags().add(EnumTag.MAGIC, 2).add(EnumTag.POWER, 2));
            ThaumcraftApi.registerObjectTag(DartBlock.forceLeaves.field_71990_ca, 0, new ObjectTags().add(EnumTag.PLANT, 2));
            ThaumcraftApi.registerObjectTag(DartBlock.forceSapling.field_71990_ca, 0, new ObjectTags().add(EnumTag.PLANT, 2).add(EnumTag.MAGIC, 1).add(EnumTag.POWER, 1));
            ThaumcraftApi.registerObjectTag(DartBlock.forceLog.field_71990_ca, 0, new ObjectTags().add(EnumTag.PLANT, 2).add(EnumTag.MAGIC, 1).add(EnumTag.WOOD, 8));
            ThaumcraftApi.registerObjectTag(DartItem.forceStick.field_77779_bT, 0, new ObjectTags().add(EnumTag.MAGIC, 1).add(EnumTag.WOOD, 4));
            ThaumcraftApi.registerObjectTag(DartBlock.forceLog.field_71990_ca, 1, new ObjectTags().add(EnumTag.WOOD, 2));
            ThaumcraftApi.registerObjectTag(DartItem.goldenPower.field_77779_bT, 0, new ObjectTags().add(EnumTag.FIRE, 2).add(EnumTag.POWER, 4).add(EnumTag.MAGIC, 1));
            if (DartItem.milkContainer != null) {
                ObjectTags milkTag = new ObjectTags().add(EnumTag.HEAL, 2);
                ThaumcraftApi.registerObjectTag(DartItem.milkContainer.field_77779_bT, 0, milkTag);
                ThaumcraftApi.registerObjectTag(DartItem.milkContainer.field_77779_bT, 1, milkTag);
                ThaumcraftApi.registerObjectTag(DartItem.milkContainer.field_77779_bT, 2, milkTag);
            }
            ThaumcraftApi.registerObjectTag(DartItem.entityBottle.field_77779_bT, 0, new ObjectTags().add(EnumTag.SPIRIT, 2).add(EnumTag.LIFE, 2));
            ThaumcraftApi.registerObjectTag(DartItem.soulWafer.field_77779_bT, 0, new ObjectTags().add(EnumTag.SPIRIT, 4).add(EnumTag.LIFE, 4));
            ThaumcraftApi.registerObjectTag(DartItem.forceFlask.field_77779_bT, 0, new ObjectTags().add(EnumTag.VOID, 4).add(EnumTag.CRYSTAL, 4));
        }
        catch (Exception e) {
            DartCraft.dartLog.info("Unable to load Thaumcraft ObjectTags.");
        }
    }

    private static void loadBlacklist() {
        String[] blacklist;
        int failures = 0;
        for (String name : blacklist = new String[]{"tiles.TileArcanePressurePlate", "tiles.TileCrystalCapacitor", "tiles.TileMirror", "tiles.TileNitor", "tiles.TileOwned", "blocks.jars.TileJarFillable"}) {
            try {
                DartUtils.blacklistTile("thaumcraft.common." + name);
            }
            catch (Exception e) {
                ++failures;
            }
        }
        if (failures > 0) {
            DartCraft.dartLog.info("Unable to blacklist " + failures + " Thaumcraft TileEntities for Force Wrenching.");
        }
        failures = 0;
        for (String name : blacklist = new String[]{"Clay", "ClayAdvanced", "IronGuardian", "Stone", "StoneAdvanced", "Straw", "Tallow", "TallowAdvanced", "Warrior", "Warrior", "Wood", "Worker"}) {
            try {
                DartAPI.blacklistEntity(Class.forName("thaumcraft.common.entities.golems.EntityGolem" + name));
            }
            catch (Exception e) {
                ++failures;
            }
        }
        if (failures > 0) {
            DartCraft.dartLog.info("Unable to blacklist " + failures + " Thaumcraft Golems for bottling.");
        }
    }

    private static void loadEnchants() {
        try {
            Field repair = Class.forName("thaumcraft.common.Config").getField("enchRepair");
            enchRepair = (Enchantment)repair.get(new Object());
            auraClass = Class.forName("thaumcraft.common.aura.AuraManager");
            useAura = auraClass.getMethod("decreaseClosestAura", World.class, Double.TYPE, Double.TYPE, Double.TYPE, Integer.TYPE);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void loadTransmutes() {
        try {
            DartItem.thaumLeaves = ItemApi.getItem("blockMagicalLeaves", 9);
            DartItem.thaumSapling = ItemApi.getItem("blockCustomPlant", 1);
            thaumium = ItemApi.getItem("itemResource", 2);
            ItemStack hoe = ItemApi.getItem("itemHoeThaumium", 0);
            ItemStack axe = ItemApi.getItem("itemAxeThaumium", 0);
            ItemStack shovel = ItemApi.getItem("itemShovelThaumium", 0);
            ItemStack pick = ItemApi.getItem("itemPickThaumium", 0);
            ItemStack sword = ItemApi.getItem("itemSwordThaumium", 0);
            ItemStack helm = ItemApi.getItem("itemHelmetThaumium", 0);
            ItemStack chest = ItemApi.getItem("itemChestThaumium", 0);
            ItemStack boots = ItemApi.getItem("itemBootsThaumium", 0);
            ItemStack legs = ItemApi.getItem("itemLegsThaumium", 0);
            if (thaumium != null) {
                if (hoe != null) {
                    DartAPI.addForceTransmutation(hoe, ThaumCraftIntegration.getThaumium(2), 1, true);
                }
                if (axe != null) {
                    DartAPI.addForceTransmutation(axe, ThaumCraftIntegration.getThaumium(3), 1, true);
                }
                if (shovel != null) {
                    DartAPI.addForceTransmutation(shovel, ThaumCraftIntegration.getThaumium(1), 1, true);
                }
                if (pick != null) {
                    DartAPI.addForceTransmutation(pick, ThaumCraftIntegration.getThaumium(3), 1, true);
                }
                if (sword != null) {
                    DartAPI.addForceTransmutation(sword, ThaumCraftIntegration.getThaumium(2), 1, true);
                }
                if (helm != null) {
                    DartAPI.addForceTransmutation(helm, ThaumCraftIntegration.getThaumium(5), 1, true);
                }
                if (chest != null) {
                    DartAPI.addForceTransmutation(chest, ThaumCraftIntegration.getThaumium(8), 1, true);
                }
                if (boots != null) {
                    DartAPI.addForceTransmutation(boots, ThaumCraftIntegration.getThaumium(4), 1, true);
                }
                if (legs != null) {
                    DartAPI.addForceTransmutation(legs, ThaumCraftIntegration.getThaumium(7), 1, true);
                }
            }
        }
        catch (Exception e) {
            DartCraft.dartLog.info("There was an error loading Thaumium Force Transmutations.");
        }
    }

    private static ItemStack getThaumium(int amt) {
        if (thaumium != null) {
            return new ItemStack(thaumium.func_77973_b(), amt, thaumium.func_77960_j());
        }
        return null;
    }

    public static void doRepair(ItemStack stack, Entity entity) {
        if (stack.func_77960_j() > 0 && useAura != null && auraClass != null) {
            try {
                useAura.invoke((Object)auraClass, entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 1);
                stack.func_77964_b(stack.func_77960_j() - 1);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static {
        enchRepair = null;
        auraClass = null;
        useAura = null;
    }
}

