/*
 * Decompiled with CFR 0.152.
 */
package bluedart.integration;

import bluedart.DartCraft;
import bluedart.api.DartAPI;
import bluedart.api.ForceUpgradeManager;
import bluedart.block.DartBlock;
import bluedart.core.Config;
import bluedart.integration.ForceFarmable;
import bluedart.item.DartItem;
import bluedart.item.ItemForceContainer;
import bluedart.item.ItemMilkContainer;
import bluedart.proxy.Proxies;
import bluedart.utils.DartUtils;
import forestry.api.core.BlockInterface;
import forestry.api.core.ItemInterface;
import forestry.api.farming.Farmables;
import forestry.api.recipes.RecipeManagers;
import forestry.api.storage.BackpackManager;
import forestry.core.config.ForestryItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.liquids.LiquidContainerData;
import net.minecraftforge.liquids.LiquidContainerRegistry;
import net.minecraftforge.liquids.LiquidDictionary;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.oredict.OreDictionary;

public class ForestryIntegration {
    public static void load() {
        String[] blacklist;
        try {
            ItemStack glass;
            ItemStack hives;
            DartCraft.dartLog.info("Loading Forestry integration.");
            DartItem.forestryCrate = ItemInterface.getItem("crate");
            DartItem.forestryCan = ItemInterface.getItem("canEmpty");
            DartItem.forestryCapsule0 = ItemInterface.getItem("waxCapsule");
            DartItem.forestryCapsule1 = ItemInterface.getItem("refractoryEmpty");
            DartItem.forestryBronze = ItemInterface.getItem("ingotBronze");
            DartItem.grafter = ItemInterface.getItem("grafter");
            if (DartItem.grafter != null) {
                DartAPI.fum.materials.add(DartAPI.umh.createMaterial(DartItem.grafter.field_77993_c, DartItem.grafter.func_77960_j(), ForceUpgradeManager.GRAFTING.getID(), 0, 10.0f));
            }
            if ((hives = BlockInterface.getBlock("beehives")) != null) {
                DartAPI.addDismantleable(Block.field_71973_m[hives.field_77993_c]);
            }
            if ((glass = BlockInterface.getBlock("glass")) != null) {
                DartAPI.addDismantleable(Block.field_71973_m[glass.field_77993_c]);
            }
            ArrayList sapphires = OreDictionary.getOres((String)"gemSapphire");
            if (Config.blacklistForestryPacks) {
                for (String name : new String[]{"apiaristBackpack", "minerBackpack", "minerBackpackT2", "diggerBackpack", "diggerBackpackT2", "foresterBackpack", "foresterBackpackT2", "hunterBackpack", "hunterBackpackT2", "builderBackpack", "builderBackpackT2", "adventurerBackpack", "adventurerBackpackT2", "tinkererBackpack", "tinkererBackpackT2", "railroaderBackpack", "railroaderBackpackT2", "dyerBackpack", "dyerBackpackT2"}) {
                    if (ItemInterface.getItem(name) == null) continue;
                    DartItem.packBlacklist.add(ItemInterface.getItem(name));
                }
            }
            if (DartItem.forestryCrate != null && RecipeManagers.carpenterManager != null) {
                ItemStack recipeStack;
                if (Config.netherStarRecipe) {
                    ArrayList tears = OreDictionary.getOres((String)"itemTear");
                    ArrayList claws = OreDictionary.getOres((String)"itemClaw");
                    if (tears.size() > 0 && claws.size() > 0) {
                        for (ItemStack tearStack : tears) {
                            for (ItemStack clawStack : claws) {
                                RecipeManagers.carpenterManager.addRecipe(20, DartItem.liquidStack, null, new ItemStack((Item)DartItem.inertCore), new Object[]{"STS", "CDC", "STS", Character.valueOf('S'), Block.field_72013_bc, Character.valueOf('T'), tearStack.func_77973_b(), Character.valueOf('C'), clawStack.func_77973_b(), Character.valueOf('D'), Item.field_77702_n});
                                if (sapphires == null || sapphires.size() <= 0) continue;
                                for (ItemStack sapphireStack : sapphires) {
                                    if (sapphireStack == null) continue;
                                    RecipeManagers.carpenterManager.addRecipe(20, DartItem.liquidStack, null, new ItemStack((Item)DartItem.inertCore), new Object[]{"STS", "CDC", "STS", Character.valueOf('S'), Block.field_72013_bc, Character.valueOf('T'), tearStack.func_77973_b(), Character.valueOf('C'), clawStack.func_77973_b(), Character.valueOf('D'), sapphireStack});
                                }
                            }
                        }
                    }
                }
                RecipeManagers.carpenterManager.addCrating("gemForce", new ItemStack((Item)DartItem.gemForce, 9), new ItemStack((Item)DartItem.cratedForceGems));
                RecipeManagers.carpenterManager.addRecipe(10, new LiquidStack(DartItem.liquidForce.field_77779_bT, 750), null, new ItemStack((Item)DartItem.ingotForce, 2), new Object[]{"II", Character.valueOf('I'), Item.field_77703_o});
                RecipeManagers.carpenterManager.addRecipe(10, new LiquidStack(DartItem.liquidForce.field_77779_bT, 750), null, new ItemStack((Item)DartItem.ingotForce, 2), new Object[]{"I", "I", Character.valueOf('I'), Item.field_77703_o});
                ArrayList forgeOres = OreDictionary.getOres((String)"ingotBronze");
                if (forgeOres != null && forgeOres.size() > 0) {
                    for (ItemStack stack : forgeOres) {
                        recipeStack = new ItemStack(stack.func_77973_b(), 1, stack.func_77960_j());
                        RecipeManagers.carpenterManager.addRecipe(10, new LiquidStack(DartItem.liquidForce.field_77779_bT, 750), null, new ItemStack((Item)DartItem.ingotForce, 2), new Object[]{"II", Character.valueOf('I'), recipeStack});
                        RecipeManagers.carpenterManager.addRecipe(10, new LiquidStack(DartItem.liquidForce.field_77779_bT, 750), null, new ItemStack((Item)DartItem.ingotForce, 2), new Object[]{"I", "I", Character.valueOf('I'), recipeStack});
                    }
                }
                if ((forgeOres = OreDictionary.getOres((String)"ingotRefinedIron")) != null && forgeOres.size() > 0) {
                    for (ItemStack stack : forgeOres) {
                        recipeStack = new ItemStack(stack.func_77973_b(), 1, stack.func_77960_j());
                        RecipeManagers.carpenterManager.addRecipe(10, new LiquidStack(DartItem.liquidForce.field_77779_bT, 750), null, new ItemStack((Item)DartItem.ingotForce, 3), new Object[]{"II", Character.valueOf('I'), recipeStack});
                        RecipeManagers.carpenterManager.addRecipe(10, new LiquidStack(DartItem.liquidForce.field_77779_bT, 750), null, new ItemStack((Item)DartItem.ingotForce, 3), new Object[]{"I", "I", Character.valueOf('I'), recipeStack});
                    }
                }
                if ((forgeOres = OreDictionary.getOres((String)"ingotSilver")) != null && forgeOres.size() > 0) {
                    for (ItemStack stack : forgeOres) {
                        recipeStack = new ItemStack(stack.func_77973_b(), 1, stack.func_77960_j());
                        RecipeManagers.carpenterManager.addRecipe(10, new LiquidStack(DartItem.liquidForce.field_77779_bT, 750), null, new ItemStack((Item)DartItem.ingotForce, 3), new Object[]{"II", Character.valueOf('I'), recipeStack});
                        RecipeManagers.carpenterManager.addRecipe(10, new LiquidStack(DartItem.liquidForce.field_77779_bT, 750), null, new ItemStack((Item)DartItem.ingotForce, 3), new Object[]{"I", "I", Character.valueOf('I'), recipeStack});
                    }
                }
                if ((forgeOres = OreDictionary.getOres((String)"ingotGold")) != null && forgeOres.size() > 0) {
                    for (ItemStack stack : forgeOres) {
                        recipeStack = new ItemStack(stack.func_77973_b(), 1, stack.func_77960_j());
                        RecipeManagers.carpenterManager.addRecipe(10, new LiquidStack(DartItem.liquidForce.field_77779_bT, 750), null, new ItemStack((Item)DartItem.ingotForce, 3), new Object[]{"II", Character.valueOf('I'), recipeStack});
                        RecipeManagers.carpenterManager.addRecipe(10, new LiquidStack(DartItem.liquidForce.field_77779_bT, 750), null, new ItemStack((Item)DartItem.ingotForce, 3), new Object[]{"I", "I", Character.valueOf('I'), recipeStack});
                    }
                }
                if (DartItem.xychoridite != null && DartItem.xychoridite.size() > 0) {
                    for (ItemStack stack : DartItem.xychoridite) {
                        recipeStack = new ItemStack(stack.func_77973_b(), 1, stack.func_77960_j());
                        RecipeManagers.carpenterManager.addRecipe(10, new LiquidStack(DartItem.liquidForce.field_77779_bT, 750), null, new ItemStack((Item)DartItem.ingotForce, 3), new Object[]{"II", Character.valueOf('I'), recipeStack});
                        RecipeManagers.carpenterManager.addRecipe(10, new LiquidStack(DartItem.liquidForce.field_77779_bT, 750), null, new ItemStack((Item)DartItem.ingotForce, 3), new Object[]{"I", "I", Character.valueOf('I'), recipeStack});
                    }
                }
                ItemStack provenFrame = ItemInterface.getItem("frameProven");
                ItemStack impregnatedFrame = ItemInterface.getItem("frameImpregnated");
                if (provenFrame != null && impregnatedFrame != null) {
                    Proxies.common.addRecipe(provenFrame, new Object[]{"SSS", "SFS", "SSS", Character.valueOf('S'), DartItem.forceStick, Character.valueOf('F'), impregnatedFrame});
                }
            }
            LiquidStack milk = LiquidDictionary.getLiquid((String)"milk", (int)1000);
            if (DartItem.forestryCan != null) {
                DartItem.forceContainer = new ItemForceContainer(Config.forceContainerID);
                LiquidContainerRegistry.registerLiquid((LiquidContainerData)new LiquidContainerData(DartItem.liquidStack, new ItemStack(DartItem.forceContainer, 1, 0), DartItem.forestryCan));
                if (milk != null) {
                    DartItem.milkContainer = new ItemMilkContainer(Config.milkContainerID);
                    LiquidContainerRegistry.registerLiquid((LiquidContainerData)new LiquidContainerData(milk, new ItemStack(DartItem.milkContainer, 1, 0), DartItem.forestryCan));
                }
            }
            if (DartItem.forestryCapsule0 != null) {
                LiquidContainerRegistry.registerLiquid((LiquidContainerData)new LiquidContainerData(DartItem.liquidStack, new ItemStack(DartItem.forceContainer, 1, 1), DartItem.forestryCapsule0));
                if (milk != null) {
                    LiquidContainerRegistry.registerLiquid((LiquidContainerData)new LiquidContainerData(milk, new ItemStack(DartItem.milkContainer, 1, 1), DartItem.forestryCapsule0));
                }
            }
            if (DartItem.forestryCapsule1 != null) {
                LiquidContainerRegistry.registerLiquid((LiquidContainerData)new LiquidContainerData(DartItem.liquidStack, new ItemStack(DartItem.forceContainer, 1, 2), DartItem.forestryCapsule1));
                if (milk != null) {
                    LiquidContainerRegistry.registerLiquid((LiquidContainerData)new LiquidContainerData(milk, new ItemStack(DartItem.milkContainer, 1, 2), DartItem.forestryCapsule1));
                }
            }
            if (RecipeManagers.squeezerManager != null) {
                RecipeManagers.squeezerManager.addRecipe(8, new ItemStack[]{new ItemStack((Item)DartItem.gemForce)}, new LiquidStack(DartItem.liquidForce.field_77779_bT, 1500), new ItemStack((Item)DartItem.forceShard), 10);
                if (DartItem.forceContainer != null) {
                    RecipeManagers.squeezerManager.addRecipe(5, new ItemStack[]{new ItemStack(DartItem.forceContainer, 1, 0)}, DartItem.liquidStack);
                    RecipeManagers.squeezerManager.addRecipe(5, new ItemStack[]{new ItemStack(DartItem.forceContainer, 1, 1)}, DartItem.liquidStack);
                    RecipeManagers.squeezerManager.addRecipe(5, new ItemStack[]{new ItemStack(DartItem.forceContainer, 1, 2)}, DartItem.liquidStack);
                }
                RecipeManagers.squeezerManager.addRecipe(8, new ItemStack[]{new ItemStack(DartBlock.forceLog, 1, 0)}, new LiquidStack(DartItem.liquidForce.field_77779_bT, 100));
            }
            DartItem.forestryHumus = BlockInterface.getBlock("soil");
            LiquidStack biomass = new LiquidStack(ItemInterface.getItem((String)"liquidBiomass").field_77993_c, 1000);
            if (RecipeManagers.fermenterManager != null) {
                RecipeManagers.fermenterManager.addRecipe(new ItemStack(DartBlock.forceSapling), 500, 1.0f, biomass);
            }
            if (BackpackManager.backpackItems != null && BackpackManager.backpackItems.length > 3 && BackpackManager.backpackItems[4] != null) {
                ArrayList hunter = BackpackManager.backpackItems[4];
                hunter.add(new ItemStack((Item)DartItem.tear));
                hunter.add(new ItemStack((Item)DartItem.claw));
                hunter.add(new ItemStack(DartItem.cookedLambchop));
                hunter.add(new ItemStack(DartItem.rawLambchop));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (Config.populateCrates) {
                ArrayList nikoliteDusts = OreDictionary.getOres((String)"dustNikolite");
                ArrayList brassIngots = OreDictionary.getOres((String)"ingotBrass");
                if (ForestryItem.cratedNikolite != null && nikoliteDusts.size() > 0) {
                    RecipeManagers.carpenterManager.addRecipe(5, new LiquidStack(Block.field_71943_B, 100), DartItem.forestryCrate, new ItemStack((Item)ForestryItem.cratedNikolite), new Object[]{"NNN", "NNN", "NNN", Character.valueOf('N'), nikoliteDusts.get(0)});
                    RecipeManagers.carpenterManager.addRecipe(5, null, new ItemStack(((ItemStack)nikoliteDusts.get(0)).func_77973_b(), 9, ((ItemStack)nikoliteDusts.get(0)).func_77960_j()), new Object[]{"C", Character.valueOf('C'), ForestryItem.cratedNikolite});
                    ForestryItem.cratedNikolite.setContained(null, new ItemStack(((ItemStack)nikoliteDusts.get(0)).func_77973_b(), 9, ((ItemStack)nikoliteDusts.get(0)).func_77960_j()));
                    DartCraft.dartLog.info("Enabled Crated Nikolite.");
                }
                if (ForestryItem.cratedBrass != null && brassIngots.size() > 0) {
                    RecipeManagers.carpenterManager.addRecipe(5, new LiquidStack(Block.field_71943_B, 100), DartItem.forestryCrate, new ItemStack((Item)ForestryItem.cratedBrass), new Object[]{"BBB", "BBB", "BBB", Character.valueOf('B'), brassIngots.get(0)});
                    RecipeManagers.carpenterManager.addRecipe(5, null, new ItemStack(((ItemStack)brassIngots.get(0)).func_77973_b(), 9, ((ItemStack)brassIngots.get(0)).func_77960_j()), new Object[]{"C", Character.valueOf('C'), ForestryItem.cratedBrass});
                    ForestryItem.cratedBrass.setContained(null, new ItemStack(((ItemStack)brassIngots.get(0)).func_77973_b(), 9, ((ItemStack)brassIngots.get(0)).func_77960_j()));
                    DartCraft.dartLog.info("Enabled Crated Brass.");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            List trees = (List)Farmables.farmables.get("farmArboreal");
            trees.add(new ForceFarmable());
        }
        catch (Exception e) {
            DartCraft.dartLog.info("Could not add Force Trees as a valid Forestry Tree.");
            e.printStackTrace();
        }
        boolean success = true;
        for (String name : blacklist = new String[]{"forestry.farming.gadgets.TileControl", "forestry.farming.gadgets.TileFarm", "forestry.farming.gadgets.TileFarmPlain", "forestry.farming.gadgets.TileGearbox", "forestry.farming.gadgets.TileHatch", "forestry.farming.gadgets.TileValve"}) {
            if (DartUtils.blacklistTile(name)) continue;
            success = false;
        }
        if (!success) {
            DartCraft.dartLog.info("Calm down, Forestry changed a non Force Wrenchable's class name, it's not the end of the world.");
        }
    }
}

