/*
 * Decompiled with CFR 0.152.
 */
package bluedart.integration;

import bluedart.DartCraft;
import bluedart.api.DartAPI;
import bluedart.block.DartBlock;
import bluedart.core.Config;
import bluedart.item.DartItem;
import bluedart.proxy.Proxies;
import bluedart.transport.ItemForcePipe;
import bluedart.transport.PipeItemsForce;
import bluedart.utils.DartUtils;
import buildcraft.BuildCraftBuilders;
import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftFactory;
import buildcraft.BuildCraftTransport;
import buildcraft.api.transport.FacadeManager;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.ItemPipe;
import buildcraft.transport.Pipe;
import buildcraft.transport.TransportProxy;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.GameRegistry;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class BuildCraftIntegration {
    public Class transport;

    public void initialize() {
        DartCraft.dartLog.info("Loading Buildcraft integration.");
        this.loadPipe();
        this.loadTriggers();
        this.loadRecipes();
        this.loadTiles();
    }

    private void loadPipe() {
        try {
            Class<?> genPipe = Class.forName("buildcraft.transport.BlockGenericPipe");
            Method registerPipe = genPipe.getDeclaredMethod("registerPipe", Integer.TYPE, Class.class);
            DartItem.itemForcePipe = new ItemForcePipe(Config.pipeItemID);
            GameRegistry.registerItem((Item)DartItem.itemForcePipe, (String)"forcePipe");
            BlockGenericPipe.pipes.put(DartItem.itemForcePipe.field_77779_bT, PipeItemsForce.class);
            Pipe dummy = BlockGenericPipe.createPipe((int)DartItem.itemForcePipe.field_77779_bT);
            ((ItemPipe)DartItem.itemForcePipe).setPipeIconIndex(dummy.getIconIndexForItem());
            TransportProxy.proxy.setIconProviderFromPipe((ItemPipe)DartItem.itemForcePipe, dummy);
            List recipes = CraftingManager.func_77594_a().func_77592_b();
            recipes.add(new ShapedOreRecipe(new ItemStack(DartItem.itemForcePipe, 8), new Object[]{"IGI", Character.valueOf('I'), "ingotForce", Character.valueOf('G'), Block.field_71946_M}));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadTriggers() {
    }

    private void loadRecipes() {
        List recipes = CraftingManager.func_77594_a().func_77592_b();
        try {
            ArrayList greenStacks;
            for (int i = 0; i < 16; ++i) {
                FacadeManager.addFacade(new ItemStack(DartBlock.forceBrick, 1, i));
            }
            FacadeManager.addFacade(new ItemStack(DartBlock.forceLog, 1, 0));
            FacadeManager.addFacade(new ItemStack(DartBlock.forceLog, 1, 1));
            recipes.add(new ShapedOreRecipe(new ItemStack((Item)DartItem.forceGear, 1), new Object[]{" I ", "IGI", " I ", Character.valueOf('I'), "ingotForce", Character.valueOf('G'), BuildCraftCore.stoneGearItem}));
            ItemStack ironGear = new ItemStack(BuildCraftCore.ironGearItem);
            ItemStack diamondGear = new ItemStack(BuildCraftCore.diamondGearItem);
            Proxies.common.addRecipe(diamondGear, new Object[]{" D ", "DGD", " D ", Character.valueOf('D'), Item.field_77702_n, Character.valueOf('G'), DartItem.forceGear});
            if (Loader.isModLoaded((String)"BuildCraft|Builders")) {
                Proxies.common.addRecipe(new ItemStack((Block)BuildCraftBuilders.fillerBlock), new Object[]{"ILI", "DTD", "GCG", Character.valueOf('I'), new ItemStack(Item.field_77756_aW, 1, 0), Character.valueOf('L'), BuildCraftBuilders.markerBlock, Character.valueOf('D'), new ItemStack(Item.field_77756_aW, 1, 11), Character.valueOf('T'), Block.field_72060_ay, Character.valueOf('G'), DartItem.forceGear, Character.valueOf('C'), Block.field_72077_au});
            }
            if (Loader.isModLoaded((String)"BuildCraft|Factory") && Config.forceQuarry) {
                Proxies.common.addRecipe(new ItemStack((Block)BuildCraftFactory.quarryBlock), new Object[]{"IRI", "FIF", "DPD", Character.valueOf('I'), ironGear, Character.valueOf('R'), Item.field_77767_aC, Character.valueOf('F'), DartItem.forceGear, Character.valueOf('D'), diamondGear, Character.valueOf('P'), Item.field_77674_B});
            }
            if ((greenStacks = OreDictionary.getOres((String)"gemGreenSapphire")) != null && greenStacks.size() > 0 && Loader.isModLoaded((String)"BuildCraft|Transport")) {
                for (ItemStack greenStack : greenStacks) {
                    if (greenStack == null || BuildCraftTransport.pipeItemsEmerald == null) continue;
                    Proxies.common.addRecipe(new ItemStack(BuildCraftTransport.pipeItemsEmerald, 8), new Object[]{"SGS", Character.valueOf('S'), greenStack, Character.valueOf('G'), Block.field_71946_M});
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            Class<?> energyClass = Class.forName("buildcraft.BuildCraftEnergy");
            Field oilStill = energyClass.getField("oilStill");
            Field oilMoving = energyClass.getField("oilMoving");
            DartAPI.addSkateable((Block)oilStill.get(new Object()));
            DartAPI.addSkateable((Block)oilMoving.get(new Object()));
        }
        catch (Exception e) {
            DartCraft.dartLog.info("Unable to load BuildCraft oil as a skatable liquid.");
        }
    }

    private void loadTiles() {
        String[] blacklist;
        boolean success = true;
        for (String name : blacklist = new String[]{"buildcraft.factory.TileRefinery", "buildcraft.factory.TileQuarry", "buildcraft.transport.TileGenericPipe"}) {
            if (DartUtils.blacklistTile(name)) continue;
            success = false;
        }
        if (!success) {
            DartCraft.dartLog.info("Calm down, BuildCraft changed a non Force Wrenchable's class name, it's not the end of the world.");
        }
    }
}

