/*
 * Decompiled with CFR 0.152.
 */
package bluedart.handlers;

import bluedart.api.ISocketableTool;
import bluedart.core.Config;
import bluedart.core.network.FXPacket;
import bluedart.entity.EntityColdChicken;
import bluedart.entity.EntityColdCow;
import bluedart.integration.TwilightForestIntegration;
import bluedart.item.tool.ItemForceShears;
import bluedart.item.tool.ItemPowerSaw;
import bluedart.proxy.Proxies;
import bluedart.utils.DartUtils;
import bluedart.utils.SocketHelper;
import bluedart.utils.UpgradeHelper;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.network.PacketDispatcher;
import ic2.api.recipe.Recipes;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.player.EntityInteractEvent;

public class ShearHandler {
    @ForgeSubscribe
    public void onEntityInteract(EntityInteractEvent event) {
        if (!(event.target instanceof EntityLiving)) {
            return;
        }
        Object entity = (EntityLiving)event.target;
        if (!Proxies.common.isSimulating(entity.field_70170_p)) {
            return;
        }
        ItemStack stack = null;
        if (event.entityPlayer != null) {
            stack = event.entityPlayer.func_71045_bC();
        }
        if (stack == null || !(stack.func_77973_b() instanceof ItemForceShears) && !(stack.func_77973_b() instanceof ItemPowerSaw)) {
            return;
        }
        NBTTagCompound upgrades = null;
        upgrades = stack.func_77973_b() instanceof ISocketableTool ? SocketHelper.getSocketCompound(stack) : UpgradeHelper.getUpgradeCompound(stack);
        if (entity instanceof IShearable) {
            IShearable target = (IShearable)entity;
            if (target.isShearable(stack, entity.field_70170_p, (int)entity.field_70165_t, (int)entity.field_70163_u, (int)entity.field_70161_v)) {
                boolean rainbow;
                int bonus = 0;
                boolean bl = rainbow = upgrades != null && upgrades.func_74764_b("Rainbow");
                if (upgrades != null && upgrades.func_74764_b("Luck")) {
                    bonus = upgrades.func_74762_e("Luck");
                }
                ArrayList drops = entity instanceof EntitySheep ? (rainbow ? this.rainbowShear((EntitySheep)entity, bonus) : this.sheepShear((EntitySheep)entity, bonus)) : target.onSheared(stack, entity.field_70170_p, (int)entity.field_70165_t, (int)entity.field_70163_u, (int)entity.field_70161_v, bonus);
                boolean hasGrind = false;
                ArrayList<ItemStack> grindDrops = new ArrayList<ItemStack>();
                if (upgrades != null && upgrades.func_74764_b("Grinding") && Config.IC2Integration && Loader.isModLoaded((String)"IC2") && drops != null && drops.size() > 0) {
                    for (ItemStack dropCheck : drops) {
                        ItemStack tempStack = (ItemStack)Recipes.macerator.getOutputFor(dropCheck, true);
                        if (tempStack != null) {
                            grindDrops.add(tempStack);
                            hasGrind = true;
                            continue;
                        }
                        grindDrops.add(dropCheck);
                    }
                }
                if (hasGrind) {
                    PacketDispatcher.sendPacketToAllAround((double)entity.field_70165_t, (double)entity.field_70163_u, (double)entity.field_70161_v, (double)30.0, (int)entity.field_71093_bK, (Packet)new FXPacket(6, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v).getPacket());
                    entity.field_70170_p.func_72956_a((Entity)entity, "random.pop", 1.0f, DartUtils.randomPitch());
                    this.dropItems(grindDrops, (EntityLiving)entity);
                } else {
                    entity.field_70170_p.func_72956_a((Entity)entity, "mob.sheep.shear", 1.0f, DartUtils.randomPitch());
                    this.dropItems(drops, (EntityLiving)entity);
                }
                DartUtils.damageTool(event.entityPlayer, stack, 1);
                if (upgrades != null && upgrades.func_74764_b("Heat")) {
                    entity.func_70015_d(10);
                }
                return;
            }
        } else if (entity instanceof EntityCow || entity instanceof EntityChicken) {
            if (TwilightForestIntegration.isDeer(entity)) {
                return;
            }
            if (((EntityAnimal)entity).func_70874_b() < 0) {
                return;
            }
            int bonus = 0;
            if (upgrades.func_74764_b("Luck")) {
                bonus = upgrades.func_74762_e("Luck");
            }
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            ItemStack droppedItem = null;
            droppedItem = entity instanceof EntityCow ? new ItemStack(Item.field_77770_aF, 1) : new ItemStack(Item.field_77676_L, 1);
            drops.add(droppedItem);
            if (bonus > 0) {
                for (int i = 0; i < bonus; ++i) {
                    if (!entity.func_70681_au().nextBoolean()) continue;
                    drops.add(droppedItem);
                }
            }
            this.dropItems(drops, (EntityLiving)entity);
            DartUtils.damageTool(event.entityPlayer, stack, 1);
            double posX = entity.field_70165_t;
            double posY = entity.field_70163_u;
            double posZ = entity.field_70161_v;
            float yaw = entity.field_70177_z;
            float pitch = entity.field_70125_A;
            float yaw2 = entity.field_70726_aT;
            NBTTagCompound data = (NBTTagCompound)entity.getEntityData().func_74737_b();
            int health = entity.func_70630_aN();
            float fall = entity.field_70143_R;
            boolean isOnFire = entity.func_70027_ad();
            int air = entity.func_70086_ai();
            float speed = entity.func_70689_ay();
            PathEntity dest = entity.func_70661_as().func_75505_d();
            World world = entity.field_70170_p;
            world.func_72956_a((Entity)entity, "random.pop", 1.0f, 1.0f);
            PacketDispatcher.sendPacketToAllInDimension((Packet)new FXPacket(6, entity.field_70165_t, entity.field_70163_u + (double)(entity.field_70131_O / 2.0f), entity.field_70161_v).getPacket(), (int)entity.field_71093_bK);
            boolean isCow = entity instanceof EntityCow;
            entity.func_70106_y();
            entity = null;
            entity = isCow ? new EntityColdCow(world) : new EntityColdChicken(world);
            entity.func_70080_a(posX, posY, posZ, yaw, pitch);
            entity.field_70726_aT = yaw2;
            entity.func_70606_j(health);
            entity.field_70143_R = fall;
            if (isOnFire) {
                entity.func_70015_d(1);
            }
            entity.func_70050_g(air);
            entity.func_70661_as().func_75484_a(dest, 1.0f);
            entity.func_70661_as().func_75489_a(speed);
            NBTTagCompound comp = entity.getEntityData();
            comp = data;
            world.func_72838_d((Entity)entity);
            if (upgrades != null && upgrades.func_74764_b("Heat")) {
                entity.func_70015_d(10);
            } else if (isCow) {
                world.func_72956_a((Entity)entity, "mob.cow.hurt", 1.0f, 1.0f);
            } else {
                world.func_72956_a((Entity)entity, "mob.chicken.hurt", 1.0f, 1.0f);
            }
            if (isCow) {
                EntityColdCow cow = (EntityColdCow)((Object)entity);
                cow.func_70018_K();
                cow.func_70604_c((EntityLiving)cow);
            } else {
                EntityColdChicken chicken = (EntityColdChicken)((Object)entity);
                chicken.func_70018_K();
                chicken.func_70604_c((EntityLiving)chicken);
            }
        }
    }

    private ArrayList rainbowShear(EntitySheep sheep, int bonus) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        sheep.func_70893_e(true);
        int i = 1 + sheep.func_70681_au().nextInt(3 + bonus);
        for (int j = 0; j < i; ++j) {
            drops.add(new ItemStack(Block.field_72101_ab.field_71990_ca, 1, sheep.func_70681_au().nextInt(16)));
        }
        return drops;
    }

    private ArrayList sheepShear(EntitySheep sheep, int bonus) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        sheep.func_70893_e(true);
        int i = 1 + sheep.func_70681_au().nextInt(3 + bonus);
        for (int j = 0; j < i; ++j) {
            drops.add(new ItemStack(Block.field_72101_ab.field_71990_ca, 1, sheep.func_70896_n()));
        }
        return drops;
    }

    private void dropItems(ArrayList drops, EntityLiving entity) {
        if (!Proxies.common.isSimulating(entity.field_70170_p)) {
            return;
        }
        for (ItemStack temp : drops) {
            EntityItem ent = entity.func_70099_a(temp, 1.0f);
            ent.field_70181_x += (double)(entity.func_70681_au().nextFloat() * 0.05f);
            ent.field_70159_w += (double)((entity.func_70681_au().nextFloat() - entity.func_70681_au().nextFloat()) * 0.1f);
            ent.field_70179_y += (double)((entity.func_70681_au().nextFloat() - entity.func_70681_au().nextFloat()) * 0.1f);
        }
    }
}

