/*
 * Decompiled with CFR 0.152.
 */
package bluedart.handlers;

import bluedart.core.damage.PunishDamage;
import bluedart.item.DartItem;
import bluedart.proxy.Proxies;
import bluedart.proxy.ProxyCommon;
import bluedart.utils.UpgradeHelper;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class PunishHandler {
    public static ArrayList immutables = new ArrayList();

    public static void loadImmutables() {
        immutables.add(new ItemStack((Item)DartItem.forcePack));
        immutables.add(new ItemStack((Item)DartItem.clipboard));
        immutables.add(new ItemStack((Item)DartItem.forceCap));
        immutables.add(new ItemStack((Item)DartItem.forceTunic));
        immutables.add(new ItemStack((Item)DartItem.forcePants));
        immutables.add(new ItemStack((Item)DartItem.forceBoots));
        immutables.add(new ItemStack(DartItem.forceSword));
        immutables.add(new ItemStack((Item)DartItem.forceBelt));
        if (DartItem.powerDrill != null) {
            immutables.add(new ItemStack(DartItem.powerDrill));
        }
        if (DartItem.powerSaw != null) {
            immutables.add(new ItemStack(DartItem.powerSaw));
        }
    }

    private static boolean isImmutable(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (immutables != null && immutables.size() > 0) {
            for (ItemStack check : immutables) {
                if (check == null || check.field_77993_c != stack.field_77993_c) continue;
                return true;
            }
        }
        return false;
    }

    @ForgeSubscribe
    public void handlePunish(LivingHurtEvent e) {
        if (e.entityLiving == null || e.source == null || !(e.source instanceof PunishDamage) || !Proxies.common.isSimulating(e.entityLiving.field_70170_p)) {
            return;
        }
        if (e.entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)e.entityLiving;
            ArrayList<Integer> occupiedSlots = new ArrayList<Integer>();
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack tempStack = player.field_71071_by.func_70301_a(i);
                if (tempStack == null || PunishHandler.isImmutable(tempStack)) continue;
                occupiedSlots.add(new Integer(i));
            }
            int remove = e.ammount / 2;
            if (remove <= 0) {
                remove = 1;
            }
            if (occupiedSlots.size() > 0) {
                for (int i = 0; i < remove; ++i) {
                    int slot = (Integer)occupiedSlots.get(ProxyCommon.rand.nextInt(occupiedSlots.size()));
                    player.func_71019_a(player.field_71071_by.func_70301_a(slot), true);
                    player.field_71071_by.func_70299_a(slot, (ItemStack)null);
                }
            }
        } else {
            EntityLiving victim = e.entityLiving;
            NBTTagCompound dartTag = UpgradeHelper.getDartData((Entity)victim);
            ArrayList<Integer> occupiedSlots = new ArrayList<Integer>();
            for (int i = 0; i < 5; ++i) {
                if (victim.func_71124_b(i) == null) continue;
                occupiedSlots.add(new Integer(i));
            }
            if (occupiedSlots.size() > 0) {
                int slot = (Integer)occupiedSlots.get(ProxyCommon.rand.nextInt(occupiedSlots.size()));
                victim.func_70099_a(victim.func_71124_b(slot), victim.field_70131_O);
                victim.func_70062_b(slot, (ItemStack)null);
            }
        }
    }
}

