/*
 * Decompiled with CFR 0.152.
 */
package bluedart.handlers;

import bluedart.client.ticker.WingMeter;
import bluedart.core.Config;
import bluedart.core.damage.BleedDamage;
import bluedart.core.damage.DartFallDamage;
import bluedart.core.damage.ForceDamage;
import bluedart.core.damage.PunishDamage;
import bluedart.core.network.DartPacket;
import bluedart.core.network.FXPacket;
import bluedart.core.network.PacketInt;
import bluedart.core.reflect.CreeperReflector;
import bluedart.entity.EntityEnderTot;
import bluedart.item.ItemForceArmor;
import bluedart.proxy.Proxies;
import bluedart.proxy.ProxyCommon;
import bluedart.utils.DartUtils;
import bluedart.utils.SocketHelper;
import bluedart.utils.UpgradeHelper;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class PlayerEventHandler {
    private int particleTime;
    private int armorTime;
    public int penalty;
    public static final int MAX_PENALTY = 150;
    public static final int FLIGHT_LOSS = 10;
    public static final int ARMOR_TIMEOUT = 40;
    public static final int BLEED_TIMEOUT = 10;

    @ForgeSubscribe
    public void livingUpdate(LivingEvent.LivingUpdateEvent e) {
        EntityLiving entity = e.entityLiving;
        NBTTagCompound dartTag = UpgradeHelper.getDartData((Entity)entity);
        if (Proxies.common.isSimulating(entity.field_70170_p)) {
            if (dartTag.func_74762_e("lastBleed") > 0) {
                dartTag.func_74768_a("lastBleed", dartTag.func_74762_e("lastBleed") - 1);
            }
            if (dartTag.func_74762_e("bleed") > 0 && dartTag.func_74762_e("lastBleed") <= 0) {
                dartTag.func_74768_a("lastBleed", 10);
                int damage = 1;
                if (entity.func_70027_ad() && !entity.func_70045_F() && dartTag.func_74762_e("bleed") % 2 == 1) {
                    ++damage;
                }
                entity.func_70097_a((DamageSource)BleedDamage.instance, damage);
                dartTag.func_74768_a("bleed", dartTag.func_74762_e("bleed") - 1);
            }
            if (entity instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)entity;
                for (int i = 0; i < 4; ++i) {
                    ItemStack armorStack = player.func_82169_q(i);
                    if (armorStack == null || !(armorStack.func_77973_b() instanceof ItemForceArmor)) continue;
                    NBTTagCompound comp = armorStack.func_77978_p();
                    NBTTagCompound upgrades = UpgradeHelper.getUpgradeCompound(armorStack);
                    ItemForceArmor armor = (ItemForceArmor)armorStack.func_77973_b();
                    if (!upgrades.func_74764_b("Repair")) continue;
                    comp.func_74768_a("timeout", comp.func_74762_e("timeout") + 1);
                    if (comp.func_74762_e("timeout") < 200 / upgrades.func_74762_e("Repair")) continue;
                    armor.doRepair(armorStack, (Entity)entity);
                    comp.func_74768_a("timeout", 0);
                }
            }
        }
        if (entity instanceof EntityCreeper && dartTag.func_74767_n("baned")) {
            EntityCreeper creeper = (EntityCreeper)entity;
            CreeperReflector.neutralizeCreeper(creeper);
        }
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (dartTag.func_74762_e("lastTransmute") > 0) {
                dartTag.func_74768_a("lastTransmute", dartTag.func_74762_e("lastTransmute") - 1);
            }
            if (!Proxies.common.isSimulating(player.field_70170_p)) {
                int speed = SocketHelper.getUpgradeAmount(player, "Speed")[0];
                ItemStack stack = player.func_71045_bC();
                int flight = dartTag.func_74762_e("flight");
                boolean canFly = SocketHelper.canPlayerFly(player);
                if (speed > 0 && flight > 0) {
                    player.field_70747_aH = 0.025f + (float)speed * 0.02f;
                    player.field_70746_aG = 0.15f + (float)speed * 0.02f;
                }
                if (canFly && !dartTag.func_74767_n("isFlying") && flight >= 100 && (player.func_70093_af() || Proxies.common.isShiftDown()) && Proxies.common.isSpaceDown() && Proxies.common.isButtonDown(1) && Config.wingEnabled) {
                    DartUtils.performFlight(stack, player.field_70170_p, player);
                    dartTag.func_74757_a("isFlying", true);
                    dartTag.func_74757_a("wasFlying", player.field_71075_bZ.field_75101_c);
                    player.field_71075_bZ.field_75100_b = true;
                    player.field_71075_bZ.field_75101_c = true;
                    PacketDispatcher.sendPacketToServer((Packet)new DartPacket(22).getPacket());
                }
                if (!(!canFly || player.field_71075_bZ.field_75098_d || player.field_71075_bZ.field_75100_b || Proxies.common.isSimulating(player.field_70170_p) || player.field_70122_E || player.func_70090_H() || !Proxies.common.isSpaceDown() || flight <= 0)) {
                    if (player.field_70143_R > 0.0f) {
                        player.field_70143_R = 0.0f;
                        PacketDispatcher.sendPacketToServer((Packet)new DartPacket(10).getPacket());
                    }
                    if (player.field_70181_x < -0.25) {
                        player.field_70181_x += 0.125;
                    }
                    if (player.field_70181_x < 0.0 && player.field_70181_x > -0.25) {
                        player.field_70181_x = -0.25;
                    }
                    if ((flight -= 10) <= 0) {
                        flight = 0;
                        this.penalty = 150;
                        PacketDispatcher.sendPacketToServer((Packet)new FXPacket(24, player.field_70165_t, player.field_70163_u, player.field_70161_v).getPacket());
                    }
                }
                if (flight < WingMeter.maxFlight) {
                    if (this.penalty > 0) {
                        --this.penalty;
                    } else if (player.field_70122_E || player.func_70090_H()) {
                        flight += 40;
                    }
                    if (flight > WingMeter.maxFlight) {
                        flight = WingMeter.maxFlight;
                    }
                    if (!player.field_71075_bZ.field_75100_b) {
                        player.getEntityData().func_74775_l("DartCraft").func_74768_a("flight", flight);
                    }
                }
                if (dartTag.func_74767_n("isFlying") && !player.field_71075_bZ.field_75098_d) {
                    dartTag.func_74768_a("flight", dartTag.func_74762_e("flight") - 10);
                    ItemStack equipped = player.func_71045_bC();
                    NBTTagCompound upgrades = UpgradeHelper.getUpgradeCompound(equipped);
                    if (dartTag.func_74762_e("flight") <= 0 || !canFly) {
                        if (dartTag.func_74762_e("flight") <= 0) {
                            this.penalty = 150;
                        }
                        DartUtils.disableFlight(player, dartTag);
                    }
                    if (dartTag.func_74762_e("flight") <= 0) {
                        PacketDispatcher.sendPacketToServer((Packet)new FXPacket(24, player.field_70165_t, player.field_70163_u, player.field_70161_v).getPacket());
                    }
                    if (dartTag.func_74767_n("isFlying") && !player.field_71075_bZ.field_75098_d && !player.field_71075_bZ.field_75100_b) {
                        DartUtils.disableFlight(player, dartTag);
                    }
                }
                ++this.particleTime;
                if (player.field_71075_bZ.field_75100_b && this.particleTime >= 6) {
                    PacketDispatcher.sendPacketToServer((Packet)new FXPacket(25, player.field_70165_t, player.field_70163_u, player.field_70161_v).getPacket());
                    this.particleTime = 0;
                }
            }
        }
    }

    @ForgeSubscribe
    public void breakBlock(PlayerEvent.HarvestCheck check) {
        if (check.entityPlayer == null) {
            return;
        }
        int count = SocketHelper.getUpgradeAmount(check.entityPlayer, "Force")[2];
        int sturdy = SocketHelper.getUpgradeAmount(check.entityPlayer, "Sturdy")[1];
        ItemStack item = check.entityPlayer.func_71045_bC();
        if (item == null && count >= 3 && !check.success) {
            check.success = true;
            if (ProxyCommon.rand.nextFloat() > 0.975f) {
                DartUtils.damageForceArmor(check.entityPlayer, 1);
            }
        }
    }

    @ForgeSubscribe
    public void breakSpeed(PlayerEvent.BreakSpeed speed) {
        if (speed.entityPlayer == null) {
            return;
        }
        int[] force = SocketHelper.getUpgradeAmount(speed.entityPlayer, "Force");
        float modifier = 2.0f * (float)force[2];
        if (!speed.entityPlayer.field_70122_E || speed.entityPlayer.func_70090_H()) {
            modifier *= 4.0f;
        }
        if (speed.entityPlayer.func_71045_bC() == null && modifier > 0.0f) {
            speed.newSpeed *= modifier;
        }
        if (speed.entityPlayer.func_71045_bC() != null && modifier > 0.0f && speed.entityPlayer.func_71062_b(speed.block)) {
            speed.newSpeed *= 0.16666667f * modifier;
        }
    }

    @ForgeSubscribe
    public void attackEvent(LivingAttackEvent event) {
        if (event.source.func_76346_g() instanceof EntityPlayer && !(event.source instanceof ForceDamage) && !(event.source instanceof PunishDamage)) {
            EntityPlayer player = (EntityPlayer)event.source.func_76346_g();
            EntityLiving victim = event.entityLiving;
            NBTTagCompound dartTag = UpgradeHelper.getDartData((Entity)event.entityLiving);
            if (Proxies.common.isSimulating(player.field_70170_p) && event.entityLiving instanceof EntityEnderTot) {
                dartTag.func_74778_a("player", player.field_71092_bJ);
            }
            NBTTagCompound attackComp = UpgradeHelper.getPlayerEquippedComp(player);
            if (victim != null) {
                if (attackComp.func_74764_b("Bane")) {
                    dartTag.func_74757_a("baned", true);
                    if (victim instanceof EntityEnderTot) {
                        EntityEnderTot tot = (EntityEnderTot)victim;
                        tot.setBaned();
                    }
                    if (victim instanceof EntityPlayer) {
                        victim.func_70097_a((DamageSource)PunishDamage.instance, 0);
                    }
                }
                if (attackComp.func_74764_b("Bleed")) {
                    dartTag.func_74768_a("bleed", dartTag.func_74762_e("bleed") + attackComp.func_74762_e("Bleed") * 2);
                }
            }
            int[] force = SocketHelper.getUpgradeAmount(player, "Force");
            int heat = SocketHelper.getUpgradeAmount(player, "Heat")[0];
            int damage = SocketHelper.getUpgradeAmount(player, "Damage")[0];
            int luck = SocketHelper.getUpgradeAmount(player, "Luck")[0];
            float modifier = 1.5f * (float)force[2] + 0.5f * (float)damage;
            if (player.func_71045_bC() != null || event.ammount == 0) {
                return;
            }
            if (player.field_71075_bZ.field_75098_d && Proxies.common.isSimulating(player.field_70170_p) && victim.field_70737_aN <= 0 && victim.func_70089_S() && Config.debugPunch && !(victim instanceof EntityPlayer)) {
                victim.field_70170_p.func_72956_a((Entity)victim, "bluedart.punch", 1.0f, DartUtils.randomPitch());
                event.entityLiving.func_70097_a((DamageSource)new PunishDamage(), Config.punchDamage);
                float mod = 2.0f;
                victim.field_70159_w = -MathHelper.func_76126_a((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(player.field_70125_A / 180.0f * (float)Math.PI)) * mod;
                victim.field_70179_y = MathHelper.func_76134_b((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(player.field_70125_A / 180.0f * (float)Math.PI)) * mod;
                double temp = (double)(-MathHelper.func_76126_a((float)(player.field_70125_A / 180.0f * (float)Math.PI)) * 2.0f * mod + 0.33f) + 0.25;
                victim.field_70181_x = temp > 0.0 && temp < 1.0 || temp < 0.0 && temp > -2.0 ? 1.5 : temp;
            } else if (Proxies.common.isSimulating(player.field_70170_p) && (victim.field_70172_ad <= 0 || victim.field_70737_aN <= 0) && victim.func_70089_S() && modifier > 0.0f) {
                if (player.func_71045_bC() == null) {
                    victim.field_70170_p.func_72956_a((Entity)victim, "bluedart.punch", 1.0f, DartUtils.randomPitch());
                }
                if (!(victim instanceof EntityPlayer)) {
                    if (luck > 0) {
                        dartTag.func_74768_a("luck", dartTag.func_74762_e("luck") + luck);
                    }
                    if (heat > 0) {
                        event.entityLiving.func_70097_a(DamageSource.field_76372_a, heat);
                        event.entityLiving.func_70015_d(heat);
                    }
                    event.entityLiving.func_70097_a((DamageSource)new ForceDamage(player), (int)(2.0f * modifier));
                }
                float mod = 0.25f * (float)force[2] + 0.125f * (float)damage;
                victim.field_70159_w = -MathHelper.func_76126_a((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(player.field_70125_A / 180.0f * (float)Math.PI)) * mod;
                victim.field_70179_y = MathHelper.func_76134_b((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(player.field_70125_A / 180.0f * (float)Math.PI)) * mod;
                victim.field_70181_x = (double)(-MathHelper.func_76126_a((float)(player.field_70125_A / 180.0f * (float)Math.PI)) * 2.0f * mod + 0.33f) + 0.25;
                DartUtils.damageForceArmor(player, 1);
            }
        }
    }

    @ForgeSubscribe
    public void hurtEvent(LivingHurtEvent event) {
        if (event.source.equals((Object)DartFallDamage.instance)) {
            return;
        }
        if (event.entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entityLiving;
            int[] resist = SocketHelper.getUpgradeAmount(player, "Sturdy");
            int wing = SocketHelper.getUpgradeAmount(player, "Wing")[0];
            if (event.source.equals(DamageSource.field_76379_h) && wing > 0) {
                event.ammount = 0;
                PacketDispatcher.sendPacketToPlayer((Packet)new PacketInt(45, (int)player.field_70143_R).getPacket(), (Player)((Player)player));
                return;
            }
            if (resist[2] == 0) {
                return;
            }
            float resistance = (float)resist[2] * 0.085f;
            float f = Config.sturdyNerf && !player.field_71092_bJ.equalsIgnoreCase("bluedartpro") ? 0.0625f : 0.125f;
            int prevAmt = event.ammount;
            event.ammount = (int)((float)event.ammount * (1.0f - (resistance += (float)resist[0] * f)));
            if (event.ammount >= player.func_70630_aN() && player.func_70630_aN() >= 2) {
                event.ammount = player.func_70630_aN() - 1;
                player.field_70170_p.func_72956_a((Entity)player, "bluedart.meterEmpty", 1.0f, DartUtils.randomPitch());
            }
            if (prevAmt != 0 && event.ammount == 0) {
                DartUtils.damageForceArmor(player, 1);
            }
        }
    }

    @ForgeSubscribe
    public void handleTeleport(EnderTeleportEvent event) {
        NBTTagCompound dartTag;
        if (event.entityLiving != null && event.entityLiving instanceof EntityEnderman && (dartTag = UpgradeHelper.getDartData((Entity)event.entityLiving)).func_74767_n("baned")) {
            event.setCanceled(true);
        }
    }
}

