/*
 * Decompiled with CFR 0.152.
 */
package bluedart.handlers;

import bluedart.api.ISocketableTool;
import bluedart.gui.ContainerBelt;
import bluedart.gui.ContainerClipboard;
import bluedart.gui.ContainerEnderPack;
import bluedart.gui.ContainerForceEngine;
import bluedart.gui.ContainerForceInfuser;
import bluedart.gui.ContainerForcePack;
import bluedart.gui.ContainerFrame;
import bluedart.gui.ContainerLootBag;
import bluedart.gui.ContainerMemberCard;
import bluedart.gui.ContainerSocket;
import bluedart.gui.GuiBelt;
import bluedart.gui.GuiClipboard;
import bluedart.gui.GuiEnderPack;
import bluedart.gui.GuiEngine;
import bluedart.gui.GuiForceInfuser;
import bluedart.gui.GuiForcePack;
import bluedart.gui.GuiFortune;
import bluedart.gui.GuiFrame;
import bluedart.gui.GuiLootBag;
import bluedart.gui.GuiMemberCard;
import bluedart.gui.GuiRenameBelt;
import bluedart.gui.GuiRenameCard;
import bluedart.gui.GuiRenamePack;
import bluedart.gui.GuiRenameRod;
import bluedart.gui.GuiSocket;
import bluedart.item.ItemFortune;
import bluedart.item.tool.ItemClipboard;
import bluedart.item.tool.ItemForceBelt;
import bluedart.item.tool.ItemForcePack;
import bluedart.item.tool.ItemForceRod;
import bluedart.item.tool.ItemLootBag;
import bluedart.item.tool.ItemMemberCard;
import bluedart.tile.TileEntityForceEngine;
import bluedart.tile.TileEntityForceInfuser;
import bluedart.tile.TileForceFrame;
import bluedart.transport.gui.ContainerForcePipe;
import bluedart.transport.gui.GuiForcePipe;
import bluedart.utils.ItemCraftingInventory;
import bluedart.utils.ItemInventory;
import buildcraft.transport.TileGenericPipe;
import cpw.mods.fml.common.network.IGuiHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class GuiHandler
implements IGuiHandler {
    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        ItemStack stack = player.func_71045_bC();
        switch (ID) {
            case 0: {
                ItemStack clipStack = this.getClipboard(player);
                if (clipStack == null) break;
                return new ContainerClipboard(player, new ItemCraftingInventory(9, clipStack));
            }
            case 1: {
                ItemStack packStack = this.getForcePack(player);
                if (packStack == null) break;
                return new ContainerForcePack(player, new ItemInventory(packStack.func_77978_p().func_74762_e("size"), packStack));
            }
            case 14: {
                ItemStack lootStack = this.getLootBag(player);
                if (lootStack == null) break;
                return new ContainerLootBag(player, new ItemInventory(lootStack.func_77978_p().func_74762_e("size"), lootStack));
            }
            case 9: {
                return this.findBelt(player);
            }
            case 4: {
                return new ContainerEnderPack(player);
            }
            case 5: {
                TileEntity te = world.func_72796_p(x, y, z);
                if (te == null || !(te instanceof TileEntityForceInfuser)) break;
                TileEntityForceInfuser infuser = (TileEntityForceInfuser)te;
                return new ContainerForceInfuser(player.field_71071_by, infuser);
            }
            case 6: {
                ItemStack socketable = this.getSocketable(player);
                if (socketable == null) break;
                return new ContainerSocket(player, new ItemInventory(socketable.func_77978_p().func_74762_e("size"), socketable));
            }
            case 7: {
                TileEntity te2 = world.func_72796_p(x, y, z);
                if (te2 == null || !(te2 instanceof TileEntityForceEngine)) break;
                TileEntityForceEngine engine = (TileEntityForceEngine)te2;
                return new ContainerForceEngine(player, engine);
            }
            case 11: {
                TileEntity te3 = world.func_72796_p(x, y, z);
                if (te3 == null || !(te3 instanceof TileForceFrame)) break;
                TileForceFrame frame = (TileForceFrame)te3;
                return new ContainerFrame(player, frame);
            }
            case 12: {
                ItemStack cardStack = this.getCard(player);
                if (cardStack == null) break;
                return new ContainerMemberCard(player, new ItemInventory(16, cardStack));
            }
            case 15: {
                TileEntity tile = world.func_72796_p(x, y, z);
                if (tile == null || !(tile instanceof TileGenericPipe)) break;
                return new ContainerForcePipe(player, (TileGenericPipe)tile);
            }
        }
        return null;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        ItemStack stack = player.func_71045_bC();
        switch (ID) {
            case 0: {
                ItemStack clipStack = this.getClipboard(player);
                if (clipStack == null) break;
                return new GuiClipboard(new ContainerClipboard(player, new ItemCraftingInventory(9, clipStack)));
            }
            case 1: {
                ItemStack packStack = this.getForcePack(player);
                if (packStack == null) break;
                return new GuiForcePack(new ContainerForcePack(player, new ItemInventory(packStack.func_77978_p().func_74762_e("size"), packStack)));
            }
            case 14: {
                ItemStack lootStack = this.getLootBag(player);
                if (lootStack != null) {
                    return new GuiLootBag(new ContainerLootBag(player, new ItemInventory(lootStack.func_77978_p().func_74762_e("size"), lootStack)));
                }
            }
            case 9: {
                ContainerBelt belt = this.findBelt(player);
                if (belt == null) break;
                return new GuiBelt(belt);
            }
            case 3: {
                if (stack == null || !(stack.func_77973_b() instanceof ItemFortune)) break;
                return new GuiFortune(player, stack);
            }
            case 2: {
                if (stack == null || !(stack.func_77973_b() instanceof ItemForcePack)) break;
                return new GuiRenamePack(player, stack);
            }
            case 10: {
                if (stack == null || !(stack.func_77973_b() instanceof ItemForceBelt)) break;
                return new GuiRenameBelt(player, stack);
            }
            case 8: {
                if (stack == null || !(stack.func_77973_b() instanceof ItemForceRod)) break;
                return new GuiRenameRod(player, stack);
            }
            case 13: {
                if (stack == null || !(stack.func_77973_b() instanceof ItemMemberCard)) break;
                return new GuiRenameCard(player, stack);
            }
            case 4: {
                return new GuiEnderPack(new ContainerEnderPack(player));
            }
            case 5: {
                TileEntity te = world.func_72796_p(x, y, z);
                if (te == null || !(te instanceof TileEntityForceInfuser)) break;
                TileEntityForceInfuser infuser = (TileEntityForceInfuser)te;
                return new GuiForceInfuser(new ContainerForceInfuser(player.field_71071_by, infuser));
            }
            case 6: {
                if (stack == null || !(stack.func_77973_b() instanceof ISocketableTool) || !stack.func_77942_o()) break;
                return new GuiSocket(new ContainerSocket(player, new ItemInventory(stack.func_77978_p().func_74762_e("size"), stack)));
            }
            case 7: {
                TileEntity te2 = world.func_72796_p(x, y, z);
                if (te2 == null || !(te2 instanceof TileEntityForceEngine)) break;
                TileEntityForceEngine engine = (TileEntityForceEngine)te2;
                return new GuiEngine(new ContainerForceEngine(player, engine));
            }
            case 11: {
                TileEntity te3 = world.func_72796_p(x, y, z);
                if (te3 == null || !(te3 instanceof TileForceFrame)) break;
                TileForceFrame frame = (TileForceFrame)te3;
                return new GuiFrame(new ContainerFrame(player, frame));
            }
            case 12: {
                ItemStack cardStack = this.getCard(player);
                if (cardStack == null) break;
                return new GuiMemberCard(new ContainerMemberCard(player, new ItemInventory(16, cardStack)));
            }
            case 15: {
                TileEntity tile = world.func_72796_p(x, y, z);
                if (tile == null || !(tile instanceof TileGenericPipe)) break;
                return new GuiForcePipe(new ContainerForcePipe(player, (TileGenericPipe)tile));
            }
        }
        return null;
    }

    private ContainerBelt findBelt(EntityPlayer player) {
        int count = 0;
        ItemStack belt = null;
        for (int i = 0; i < 9; ++i) {
            ItemStack tempStack = player.field_71071_by.field_70462_a[i];
            if (tempStack == null || !(tempStack.func_77973_b() instanceof ItemForceBelt) || !tempStack.func_77942_o()) continue;
            if (++count > 1) {
                player.func_70006_a("Too many Force Belts on hotbar.");
                return null;
            }
            belt = player.field_71071_by.field_70462_a[i];
        }
        if (belt != null) {
            return new ContainerBelt(player, new ItemInventory(8, belt));
        }
        return null;
    }

    private ItemStack getClipboard(EntityPlayer player) {
        if (player.getEntityData() == null || !player.getEntityData().func_74764_b("DartCraft")) {
            return null;
        }
        int location = -1;
        NBTTagCompound dartTag = player.getEntityData().func_74775_l("DartCraft");
        if (dartTag != null) {
            for (int i = 0; i < 9; ++i) {
                ItemStack tempStack = player.field_71071_by.field_70462_a[i];
                if (tempStack == null || !(tempStack.func_77973_b() instanceof ItemClipboard) || tempStack.func_77978_p().func_74762_e("ID") != dartTag.func_74762_e("toOpen")) continue;
                if (location == -1) {
                    location = i;
                    continue;
                }
                player.field_71071_by.field_70462_a[i].func_77978_p().func_82580_o("ID");
                dartTag.func_82580_o("toOpen");
                return null;
            }
        }
        dartTag.func_82580_o("toOpen");
        if (location > -1) {
            return player.field_71071_by.field_70462_a[location];
        }
        return null;
    }

    private ItemStack getForcePack(EntityPlayer player) {
        if (player.getEntityData() == null || !player.getEntityData().func_74764_b("DartCraft")) {
            return null;
        }
        int location = -1;
        NBTTagCompound dartTag = player.getEntityData().func_74775_l("DartCraft");
        if (dartTag != null) {
            for (int i = 0; i < 9; ++i) {
                ItemStack tempStack = player.field_71071_by.field_70462_a[i];
                if (tempStack == null || !(tempStack.func_77973_b() instanceof ItemForcePack) || tempStack.func_77978_p().func_74762_e("ID") != dartTag.func_74762_e("toOpen")) continue;
                if (location == -1) {
                    location = i;
                    continue;
                }
                player.field_71071_by.field_70462_a[i].func_77978_p().func_82580_o("ID");
                dartTag.func_82580_o("toOpen");
                return null;
            }
        }
        dartTag.func_82580_o("toOpen");
        if (location > -1) {
            return player.field_71071_by.field_70462_a[location];
        }
        return null;
    }

    private ItemStack getCard(EntityPlayer player) {
        if (player.getEntityData() == null || !player.getEntityData().func_74764_b("DartCraft")) {
            return null;
        }
        int location = -1;
        NBTTagCompound dartTag = player.getEntityData().func_74775_l("DartCraft");
        if (dartTag != null) {
            for (int i = 0; i < 9; ++i) {
                ItemStack tempStack = player.field_71071_by.field_70462_a[i];
                if (tempStack == null || !(tempStack.func_77973_b() instanceof ItemMemberCard) || tempStack.func_77978_p().func_74762_e("ID") != dartTag.func_74762_e("toOpen")) continue;
                if (location == -1) {
                    location = i;
                    continue;
                }
                player.field_71071_by.field_70462_a[i].func_77978_p().func_82580_o("ID");
                dartTag.func_82580_o("toOpen");
                return null;
            }
        }
        dartTag.func_82580_o("toOpen");
        if (location > -1) {
            return player.field_71071_by.field_70462_a[location];
        }
        return null;
    }

    private ItemStack getLootBag(EntityPlayer player) {
        if (player.getEntityData() == null || !player.getEntityData().func_74764_b("DartCraft")) {
            return null;
        }
        int location = -1;
        NBTTagCompound dartTag = player.getEntityData().func_74775_l("DartCraft");
        if (dartTag != null) {
            for (int i = 0; i < 9; ++i) {
                ItemStack tempStack = player.field_71071_by.field_70462_a[i];
                if (tempStack == null || !(tempStack.func_77973_b() instanceof ItemLootBag) || tempStack.func_77978_p().func_74762_e("ID") != dartTag.func_74762_e("toOpen")) continue;
                if (location == -1) {
                    location = i;
                    continue;
                }
                player.field_71071_by.field_70462_a[i].func_77978_p().func_82580_o("ID");
                dartTag.func_82580_o("toOpen");
                return null;
            }
        }
        dartTag.func_82580_o("toOpen");
        if (location > -1) {
            return player.field_71071_by.field_70462_a[location];
        }
        return null;
    }

    private ItemStack getSocketable(EntityPlayer player) {
        if (player.getEntityData() == null || !player.getEntityData().func_74764_b("DartCraft")) {
            return null;
        }
        int location = -1;
        NBTTagCompound dartTag = player.getEntityData().func_74775_l("DartCraft");
        if (dartTag != null) {
            for (int i = 0; i < 9; ++i) {
                ItemStack tempStack = player.field_71071_by.field_70462_a[i];
                if (tempStack == null || !(tempStack.func_77973_b() instanceof ISocketableTool) || tempStack.func_77978_p().func_74762_e("ID") != dartTag.func_74762_e("toOpen")) continue;
                if (location == -1) {
                    location = i;
                    continue;
                }
                player.field_71071_by.field_70462_a[i].func_77978_p().func_82580_o("ID");
                dartTag.func_82580_o("toOpen");
                return null;
            }
        }
        dartTag.func_82580_o("toOpen");
        if (location > -1) {
            return player.field_71071_by.field_70462_a[location];
        }
        return null;
    }
}

