/*
 * Decompiled with CFR 0.152.
 */
package bluedart.handlers;

import bluedart.core.network.FXPacket;
import bluedart.gui.ContainerForcePack;
import bluedart.item.tool.ItemForcePack;
import bluedart.proxy.Proxies;
import bluedart.utils.DartUtils;
import bluedart.utils.InventoryUtils;
import bluedart.utils.ItemInventory;
import bluedart.utils.UpgradeHelper;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.network.PacketDispatcher;
import java.util.ArrayList;
import java.util.EnumSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ContainerPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;

public class CardHandler
implements ITickHandler {
    private int timeout;

    @ForgeSubscribe
    public void handleItemPickup(EntityItemPickupEvent event) {
        if (!Proxies.common.isSimulating(event.entity.field_70170_p)) {
            return;
        }
        if (event.entityPlayer != null && event.item != null && event.item.func_92059_d() != null) {
            ItemStack stack = event.item.func_92059_d();
            EntityPlayer player = event.entityPlayer;
            ItemStack openStack = null;
            if (player.field_71070_bA != null && player.field_71070_bA instanceof ContainerForcePack) {
                openStack = ((ContainerForcePack)player.field_71070_bA).originStack;
            }
            for (ItemStack invStack : player.field_71071_by.field_70462_a) {
                if (invStack == null || !(invStack.func_77973_b() instanceof ItemForcePack) || !invStack.func_77942_o()) continue;
                boolean takeItem = false;
                if (openStack != null && openStack.func_77942_o() && openStack.func_77978_p().func_74762_e("ID") == invStack.func_77978_p().func_74762_e("ID")) continue;
                ItemInventory packInv = new ItemInventory(invStack.func_77978_p().func_74762_e("size"), invStack);
                ArrayList cards = DartUtils.retrieveCards(packInv);
                if (cards.size() > 0) {
                    block1: for (ItemStack cardStack : cards) {
                        ItemInventory cardInv = new ItemInventory(16, cardStack);
                        for (int j = 0; j < cardInv.func_70302_i_(); ++j) {
                            ItemStack tempStack = cardInv.func_70301_a(j);
                            if (tempStack == null || !tempStack.func_77942_o() || tempStack.func_77978_p().func_74771_c("mode") != 1 || tempStack.field_77993_c != stack.field_77993_c || tempStack.func_77960_j() != stack.func_77960_j() && tempStack.func_77960_j() != 0) continue;
                            takeItem = true;
                            break block1;
                        }
                    }
                }
                if (!takeItem) continue;
                packInv.addItemToInventory(stack);
                packInv.save();
                invStack.field_77992_b = 5;
                boolean hasCrafted = false;
                if (cards.size() > 0) {
                    for (ItemStack cardStack : cards) {
                        NBTTagCompound upgrades = UpgradeHelper.getUpgradeCompound(cardStack);
                        if (upgrades.func_74764_b("Craft") && DartUtils.performCraft(player, packInv, new ItemInventory(9, cardStack))) {
                            hasCrafted = true;
                        }
                        if (upgrades.func_74764_b("Force") && DartUtils.performTrans(player, packInv, new ItemInventory(9, cardStack))) {
                            hasCrafted = true;
                        }
                        if (!upgrades.func_74764_b("Forge") || !InventoryUtils.forgify(player, packInv, new ItemInventory(16, cardStack))) continue;
                        hasCrafted = true;
                    }
                }
                if (!hasCrafted) continue;
                player.field_70170_p.func_72956_a((Entity)player, "bluedart.magic", 1.0f, DartUtils.randomPitch());
                PacketDispatcher.sendPacketToAllAround((double)event.item.field_70165_t, (double)event.item.field_70163_u, (double)event.item.field_70161_v, (double)30.0, (int)player.field_71093_bK, (Packet)new FXPacket(21, event.item.field_70165_t, event.item.field_70163_u, event.item.field_70161_v).getPacket());
            }
        }
    }

    @ForgeSubscribe
    public void toolDestroyed(PlayerDestroyItemEvent event) {
        if (!Proxies.common.isSimulating(event.entity.field_70170_p) || event.entityPlayer == null || event.original == null) {
            return;
        }
        ItemStack toPut = null;
        ItemStack openStack = null;
        if (event.entityPlayer.field_71070_bA != null && event.entityPlayer.field_71070_bA instanceof ContainerForcePack) {
            openStack = ((ContainerForcePack)event.entityPlayer.field_71070_bA).originStack;
        }
        block0: for (ItemStack invStack : event.entityPlayer.field_71071_by.field_70462_a) {
            ArrayList cards;
            if (invStack == null || !(invStack.func_77973_b() instanceof ItemForcePack) || !invStack.func_77942_o()) continue;
            ItemInventory inv = new ItemInventory(invStack.func_77978_p().func_74762_e("size"), invStack);
            if (openStack != null && openStack.func_77942_o() && openStack.func_77978_p().func_74762_e("ID") == invStack.func_77978_p().func_74762_e("ID") || (cards = DartUtils.retrieveCards(inv)).size() <= 0) continue;
            for (ItemStack cardStack : cards) {
                if (cardStack == null || !cardStack.func_77942_o()) continue;
                ItemInventory card = new ItemInventory(16, cardStack);
                for (int i = 0; i < card.func_70302_i_(); ++i) {
                    ItemStack tempStack = card.func_70301_a(i);
                    if (tempStack == null || !tempStack.func_77942_o() || tempStack.func_77978_p().func_74771_c("mode") != 2 || tempStack.field_77993_c != event.original.field_77993_c) continue;
                    for (int j = 0; j < inv.func_70302_i_(); ++j) {
                        ItemStack checkStack = inv.func_70301_a(j);
                        if (checkStack == null || checkStack.field_77993_c != event.original.field_77993_c) continue;
                        toPut = checkStack.func_77946_l();
                        inv.func_70299_a(j, null);
                        inv.save();
                        break block0;
                    }
                }
            }
        }
        if (toPut != null && event.entityPlayer.func_71045_bC() == null) {
            event.entityPlayer.func_70062_b(0, toPut);
            event.entityPlayer.field_70170_p.func_72956_a((Entity)event.entityPlayer, "bluedart.magic", 1.0f, DartUtils.randomPitch());
            PacketDispatcher.sendPacketToAllAround((double)event.entityPlayer.field_70165_t, (double)event.entityPlayer.field_70163_u, (double)event.entityPlayer.field_70161_v, (double)20.0, (int)event.entityPlayer.field_71093_bK, (Packet)new FXPacket(21, event.entityPlayer.field_70165_t, event.entityPlayer.field_70163_u + 1.0, event.entityPlayer.field_70161_v).getPacket());
        }
    }

    public void tickStart(EnumSet type, Object ... tickData) {
    }

    public void tickEnd(EnumSet type, Object ... tickData) {
        ++this.timeout;
        if (this.timeout < 100) {
            return;
        }
        this.timeout = 0;
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        try {
            WorldServer[] servers;
            for (WorldServer serv : servers = server.field_71305_c) {
                if (serv == null || serv.field_73010_i == null) continue;
                for (EntityPlayerMP player : serv.field_73010_i) {
                    if (player == null) continue;
                    this.checkPlayerRestock((EntityPlayer)player);
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private void checkPlayerRestock(EntityPlayer player) {
        if (!(player.field_71070_bA instanceof ContainerPlayer)) {
            return;
        }
        for (ItemStack invStack : player.field_71071_by.field_70462_a) {
            if (invStack == null || !(invStack.func_77973_b() instanceof ItemForcePack) || !invStack.func_77942_o()) continue;
            ItemInventory inv = new ItemInventory(invStack.func_77978_p().func_74762_e("size"), invStack);
            ArrayList cards = DartUtils.retrieveCards(inv);
            boolean hasCrafted = false;
            if (cards.size() > 0) {
                for (ItemStack cardStack : cards) {
                    if (cardStack == null || !cardStack.func_77942_o()) continue;
                    ItemInventory card = new ItemInventory(16, cardStack);
                    ArrayList toCheck = new ArrayList();
                    NBTTagCompound upgrades = UpgradeHelper.getUpgradeCompound(cardStack);
                    if (upgrades.func_74764_b("Craft") && DartUtils.performCraft(player, inv, new ItemInventory(9, cardStack))) {
                        hasCrafted = true;
                        invStack.field_77992_b = 5;
                    }
                    if (upgrades.func_74764_b("Force") && DartUtils.performTrans(player, inv, new ItemInventory(9, cardStack))) {
                        hasCrafted = true;
                    }
                    if (upgrades.func_74764_b("Forge") && InventoryUtils.forgify(player, inv, new ItemInventory(16, cardStack))) {
                        hasCrafted = true;
                    }
                    for (int i = 0; i < card.func_70302_i_(); ++i) {
                        ItemStack tempStack = card.func_70301_a(i);
                        if (tempStack == null || !tempStack.func_77942_o() || tempStack.func_77978_p().func_74771_c("mode") != 2 || tempStack.func_77958_k() != 0 && !tempStack.func_77981_g()) continue;
                        for (ItemStack checkStack : player.field_71071_by.field_70462_a) {
                            if (checkStack == null || checkStack.field_77993_c != tempStack.field_77993_c || checkStack.func_77960_j() != tempStack.func_77960_j()) continue;
                            for (int k = 0; k < inv.func_70302_i_(); ++k) {
                                ItemStack bagStack = inv.func_70301_a(k);
                                if (bagStack == null || bagStack.field_77993_c != checkStack.field_77993_c || bagStack.func_77960_j() != checkStack.func_77960_j()) continue;
                                int count = 0;
                                int bagSize = bagStack.field_77994_a;
                                while (checkStack.field_77994_a < checkStack.func_77976_d() && bagSize > 0) {
                                    ++checkStack.field_77994_a;
                                    inv.func_70298_a(k, 1);
                                    checkStack.field_77992_b = 5;
                                    --bagSize;
                                    ++count;
                                }
                                inv.save();
                            }
                        }
                    }
                }
            }
            if (!hasCrafted) continue;
            player.field_70170_p.func_72956_a((Entity)player, "bluedart.magic", 1.0f, DartUtils.randomPitch());
            PacketDispatcher.sendPacketToAllAround((double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v, (double)20.0, (int)player.field_71093_bK, (Packet)new FXPacket(21, player.field_70165_t, player.field_70163_u + 1.0, player.field_70161_v).getPacket());
        }
    }

    public EnumSet ticks() {
        return EnumSet.of(TickType.SERVER);
    }

    public String getLabel() {
        return "cardTicker";
    }
}

