/*
 * Decompiled with CFR 0.152.
 */
package bluedart.gui;

import bluedart.core.Constants;
import bluedart.gui.ContainerMemberCard;
import bluedart.utils.UpgradeHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.opengl.GL11;

public class GuiMemberCard
extends GuiContainer {
    private int posX;
    private int posY;
    private int size;
    private String textureIndex;
    private ContainerMemberCard container;
    private int type;

    public GuiMemberCard(ContainerMemberCard pack) {
        super((Container)pack);
        this.container = pack;
        this.type = 0;
        NBTTagCompound upgrades = UpgradeHelper.getUpgradeCompound(this.container.originStack);
        if (upgrades.func_74764_b("Craft")) {
            this.type = 1;
        }
        if (upgrades.func_74764_b("Force")) {
            this.type = 2;
        }
        if (upgrades.func_74764_b("Forge")) {
            this.type = 3;
        }
        this.size = 16;
        this.field_74194_b = 176;
        this.field_74195_c = (this.type > 0 && this.type != 3 ? 171 : 116) + 18 * (this.size / 8);
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (!this.container.canStayOpen(this.container.user)) {
            this.container.user.func_71053_j();
        }
    }

    public List handleItemTooltip(ItemStack stack, int x, int y, List tooltip) {
        if (this.type == 3 && stack != null) {
            ArrayList ores;
            int id;
            if (tooltip.size() > 1) {
                for (int i = tooltip.size() - 1; i > 0; --i) {
                    tooltip.remove(i);
                }
            }
            if ((id = OreDictionary.getOreID((ItemStack)stack)) >= 0 && (ores = OreDictionary.getOres((Integer)id)) != null && ores.size() > 1 && OreDictionary.getOreName((int)id) != null) {
                tooltip.add("\u00a7e" + OreDictionary.getOreName((int)id));
            }
        }
        return tooltip;
    }

    protected void func_74185_a(float var1, int var2, int var3) {
        this.posX = (this.field_73880_f - this.field_74194_b) / 2;
        this.posY = (this.field_73881_g - this.field_74195_c) / 2;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        String texture = Constants.PACK1_PNG;
        switch (this.type) {
            case 1: {
                texture = Constants.CARD_CRAFT_GUI_PNG;
                break;
            }
            case 2: {
                texture = Constants.CARD_TRANS_GUI_PNG;
            }
        }
        this.field_73882_e.field_71446_o.func_98187_b(texture);
        this.func_73729_b(this.posX, this.posY, 0, 0, this.field_74194_b, this.field_74195_c);
        float temp = this.field_73735_i;
        this.field_73735_i = 1000.0f;
        this.posX = (this.field_73880_f - this.field_74194_b) / 2;
        this.posY = (this.field_73881_g - this.field_74195_c) / 2;
        int x = 17;
        int y = 20;
        if (this.type == 1) {
            x = 42;
        }
        if (this.type == 2) {
            x = 13;
        }
        if (this.container.contents != null && this.container.contents.func_70302_i_() > 0) {
            for (int i = 0; i < (this.type > 0 && this.type != 3 ? 3 : this.container.contents.func_70302_i_() / 8); ++i) {
                block9: for (int j = 0; j < (this.type > 0 && this.type != 3 ? 3 : 8); ++j) {
                    int index = i * (this.type > 0 && this.type != 3 ? 3 : 8) + j;
                    ItemStack tempStack = this.container.contents.func_70301_a(index);
                    int x2 = 176;
                    if (tempStack == null || !tempStack.func_77942_o()) continue;
                    switch (tempStack.func_77978_p().func_74771_c("mode")) {
                        case 0: {
                            continue block9;
                        }
                        case 2: {
                            x2 = 183;
                        }
                        default: {
                            this.func_73729_b(this.posX + x + 18 * j + 8, this.posY + y + 18 * i + 6, x2, 0, 7, 9);
                        }
                    }
                }
            }
        }
        this.field_73735_i = temp;
        this.field_73886_k.func_78276_b(this.container.originStack.func_82833_r(), this.posX + 17, this.posY + 7, 0x404040);
        this.field_73886_k.func_78276_b("Inventory", this.posX + 8, this.posY + 23 + 18 * (this.size / 8) + (this.type > 0 && this.type != 3 ? 18 : 0), 0x404040);
    }
}

