/*
 * Decompiled with CFR 0.152.
 */
package bluedart.gui;

import bluedart.api.DartAPI;
import bluedart.api.IForceUpgradeMaterial;
import bluedart.core.Constants;
import bluedart.core.network.PacketDimCoords;
import bluedart.gui.ContainerForceInfuser;
import bluedart.tile.TileEntityForceInfuser;
import codechicken.nei.VisiblityData;
import codechicken.nei.api.INEIGuiHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.network.PacketDispatcher;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.network.packet.Packet;
import net.minecraftforge.liquids.LiquidStack;
import org.lwjgl.opengl.GL11;
import thermalexpansion.core.gui.GuiTE;
import thermalexpansion.core.gui.Tab;

public class GuiForceInfuser
extends GuiTE
implements INEIGuiHandler {
    private TileEntityForceInfuser infuser;
    private ContainerForceInfuser container;
    private Rectangle goBounds;
    private Rectangle tankBounds;
    private Rectangle energyBounds;
    private ErrorTab errorTab;

    public GuiForceInfuser(ContainerForceInfuser container) {
        super(container);
        this.infuser = container.infuser;
        this.container = container;
        this.field_74194_b = 176;
        this.field_74195_c = 209;
        this.addTab(new InfoTab((Gui)this));
        this.errorTab = new ErrorTab((Gui)this);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.goBounds = new Rectangle(this.field_74198_m + 39, this.field_74197_n + 100, 13, 13);
        this.tankBounds = new Rectangle(this.field_74198_m + 10, this.field_74197_n + 60, 16, 58);
        this.energyBounds = new Rectangle(this.field_74198_m + 152, this.field_74197_n + 11, 12, 107);
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (!this.infuser.hasTome() && !this.tabListRight.contains(this.errorTab)) {
            this.tabListRight.add(0, this.errorTab);
        }
        if (this.infuser.hasTome() && this.tabListRight.contains(this.errorTab)) {
            this.tabListRight.remove(this.errorTab);
            if (this.errorTab.isOpen()) {
                this.errorTab.toggleOpen();
                this.errorTab.close();
            }
        }
    }

    @Override
    protected void func_73864_a(int x, int y, int button) {
        Point pointerLoc;
        super.func_73864_a(x, y, button);
        if (button == 0 && this.goBounds.contains(pointerLoc = new Point(x, y)) && this.infuser.canUpgrade == 1 && this.infuser.totalProgress == 0) {
            this.field_73882_e.field_71416_A.func_77366_a("random.click", 1.0f, 1.0f);
            PacketDispatcher.sendPacketToServer((Packet)new PacketDimCoords(5, this.container.usingPlayer.field_71093_bK, this.infuser.field_70329_l, this.infuser.field_70330_m, this.infuser.field_70327_n).getPacket());
        }
    }

    public List handleItemTooltip(ItemStack stack, int x, int y, List tooltip) {
        IForceUpgradeMaterial mat;
        Point pointerLoc = new Point(x, y);
        if (this.goBounds.contains(pointerLoc)) {
            tooltip.add("Go");
        }
        if (this.tankBounds.contains(pointerLoc) && this.infuser != null && this.infuser.getLiquid() != null) {
            tooltip.add("\u00a7eLiquid Force\u00a7f (" + this.infuser.getLiquid().amount + ")");
        }
        if (this.energyBounds.contains(pointerLoc) && this.infuser.provider != null) {
            tooltip.add("" + (int)this.infuser.provider.getEnergyStored() + " MJ");
        }
        if (stack != null && (mat = DartAPI.fum.getMaterialFromItemStack(stack)) != null) {
            if (tooltip.size() > 1) {
                for (int i = tooltip.size() - 1; i > 0; --i) {
                    tooltip.remove(i);
                }
            }
            tooltip.add("\u00a7e" + DartAPI.fum.getFromID(mat.getUpgradeID()).getName());
            int tier = DartAPI.fum.getFromID(mat.getUpgradeID()).getTier();
            if (tier > this.infuser.getActiveTier()) {
                tooltip.add("\u00a7bTier " + tier);
            }
        }
        return tooltip;
    }

    protected void func_74185_a(float par1, int par2, int par3) {
        int height;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_73882_e.field_71446_o.func_98187_b(Constants.INFUSER_PNG);
        int posX = (this.field_73880_f - this.field_74194_b) / 2;
        int posY = (this.field_73881_g - this.field_74195_c) / 2;
        this.func_73729_b(posX, posY, 0, 0, this.field_74194_b, this.field_74195_c);
        if (this.infuser.getLiquid() != null && this.infuser.getLiquid().amount > 0) {
            this.displayGauge(this.tankBounds.x, this.tankBounds.y, this.infuser.getLiquid());
        }
        if (this.infuser != null && this.infuser.provider != null) {
            height = (int)(107.0f * this.infuser.provider.getEnergyStored() / 25000.0f);
            this.func_73729_b(this.field_74198_m + 152, this.field_74197_n + 11 + (107 - height), 176, 20 + (107 - height), 12, height);
        }
        if (this.infuser != null && this.infuser.canUpgrade > 0 || this.infuser.canUpgrade()) {
            if (this.infuser.progress > 0) {
                this.func_73729_b(this.field_74198_m + 39, this.field_74197_n + 101, 188, 13, 13, 13);
                height = this.infuser.totalProgress != 0 ? 20 * this.infuser.progress / this.infuser.totalProgress : 20;
                this.func_73729_b(this.field_74198_m + 134, this.field_74197_n + 93 + (20 - ++height), 176, 0 + (20 - height), 2, height);
            } else {
                this.func_73729_b(this.field_74198_m + 39, this.field_74197_n + 101, 188, 0, 13, 13);
            }
        }
    }

    private void displayGauge(int x, int y, LiquidStack liquid) {
        int tempx;
        if (liquid == null) {
            return;
        }
        int start = 0;
        int squaled = (int)(58.0f * (float)liquid.amount / 10000.0f);
        this.field_73882_e.field_71446_o.func_98187_b(liquid.canonical().getTextureSheet());
        do {
            tempx = 0;
            if (squaled > 16) {
                tempx = 16;
                squaled -= 16;
            } else {
                tempx = squaled;
                squaled = 0;
            }
            this.func_94065_a(x, y + 58 - tempx - start, liquid.canonical().getRenderingIcon(), 16, 16 - (16 - tempx));
            start += 16;
        } while (tempx != 0 && squaled != 0);
        this.field_73882_e.field_71446_o.func_98187_b(Constants.INFUSER_PNG);
        this.func_73729_b(this.field_74198_m + 10, this.field_74197_n + 60, 188, 26, 16, 58);
    }

    @Override
    protected void drawTooltips() {
    }

    @Override
    public VisiblityData modifyVisiblity(GuiContainer gui, VisiblityData currentVisibility) {
        currentVisibility.showNEI = false;
        return currentVisibility;
    }

    @Override
    public int getItemSpawnSlot(GuiContainer gui, ItemStack item) {
        return -1;
    }

    @Override
    public List getInventoryAreas(GuiContainer gui) {
        return null;
    }

    @Override
    public boolean handleDragNDrop(GuiContainer gui, int mousex, int mousey, ItemStack draggedStack, int button) {
        return false;
    }

    private class ErrorTab
    extends Tab {
        public static final int ERROR_TOME = 1;
        private int type;

        public ErrorTab(Gui gui) {
            super(gui);
            this.leftSide = false;
            this.overlayColor = 0xFF0000;
            this.maxHeight = 90;
            this.maxWidth = 100;
        }

        public void close() {
            this.currentHeight = this.minHeight;
            this.currentWidth = this.minWidth;
        }

        @Override
        public void draw(int x, int y) {
            this.drawBackground(x, y);
            this.drawIcon(Constants.ITEMS_PNG, 18, x + 2, y + 2);
            if (!this.isFullyOpened()) {
                return;
            }
            tabFontRenderer.func_78261_a("Error", x + 22, y + 6, 0xFFFFFF);
            tabFontRenderer.func_78279_b(this.getInfo(), x + 8, y + 20, this.maxWidth - 14, 0);
        }

        private String getInfo() {
            return "You'll need an Upgrade Tome in the top-leftmost slot to get anything useful done.";
        }

        @Override
        public String getTooltip() {
            return null;
        }
    }

    private class InfoTab
    extends Tab {
        public ArrayList infoStrings;
        private String currentInfo;

        public InfoTab(Gui gui) {
            super(gui);
            this.infoStrings = new ArrayList();
            this.leftSide = false;
            this.overlayColor = 1217260;
            this.maxHeight = 110;
            this.maxWidth = 120;
            this.initializeItems();
            this.currentInfo = this.getRandomItem();
        }

        private void initializeItems() {
            this.infoStrings.add("The Force Infuser can be used to imbue your Force Tools with special upgrades that range from vanilla Fortune to auto-maceration and smelting.");
            this.infoStrings.add("Upgrade materials show their upgrade in this Gui as a secondary tooltip in yellow.  If a third tooltip is active that is the Tier at which the upgrade is unlocked.");
            this.infoStrings.add("Upgrade Tomes are created by Right-clicking a Book with a Force Rod.");
            this.infoStrings.add("The Force Infuser requires both Liquid Force and Minecraft Joules to run.");
            this.infoStrings.add("Experience Tomes can hold any amount of experience for the player, and are tradable to boot.");
            this.infoStrings.add("Try using your Force Rod on an Experience Tome, but don't expect to get it back...");
            this.infoStrings.add("Force Rods do WHAT to leather armor!?");
            this.infoStrings.add("Additional upgrade slots are unlocked by advancing your Upgrade Tome in tier.");
            this.infoStrings.add("Ender Bows will not work on players.  You have been warned.");
            this.infoStrings.add("You're going to need Force Sticks, why not try your Force Rod on a sapling?");
            this.infoStrings.add("Use your Force Shears on other animals.");
            if (Loader.isModLoaded((String)"Forestry")) {
                this.infoStrings.add("You can place Force Gems directly into the Force Infuser to get some Liquid Force, but you're better off squeezing them.");
            } else {
                this.infoStrings.add("You can place Force Gems directly into the Force Infuser and Force Engine to get some Liquid Force");
            }
            this.infoStrings.add("Force Shard?  What's all this junk?  Force Shards provide 1 bucket of Liquid Force only inside an Infuser, but they also give the Upgrade Tome a bonus 10 points.");
            this.infoStrings.add("Using differing upgrades will help level your Upgrade Tome faster.");
            this.infoStrings.add("Force Rods are upgraded directly in the Force Infuser.");
            if (Loader.isModLoaded((String)"BuildCraft|Transport")) {
                this.infoStrings.add("Did you know?  You can pump Liquid Force back out of the Force Infuser!");
            }
        }

        @Override
        public void toggleOpen() {
            super.toggleOpen();
            if (this.isOpen()) {
                this.currentInfo = this.getRandomItem();
            }
        }

        @Override
        public void draw(int x, int y) {
            this.drawBackground(x, y);
            this.drawIcon(Constants.ITEMS_PNG, 0, x + 2, y + 2);
            if (!this.isFullyOpened()) {
                return;
            }
            tabFontRenderer.func_78261_a("Information", x + 22, y + 6, 0xFFFFFF);
            tabFontRenderer.func_78279_b(this.currentInfo, x + 8, y + 20, this.maxWidth - 14, 0);
        }

        private String getRandomItem() {
            if (((GuiForceInfuser)GuiForceInfuser.this).infuser.field_70331_k.field_73012_v.nextFloat() >= 0.85f) {
                return DartAPI.leeYang.getFortune();
            }
            if (this.infoStrings != null && this.infoStrings.size() > 0) {
                return (String)this.infoStrings.get(((GuiForceInfuser)GuiForceInfuser.this).infuser.field_70331_k.field_73012_v.nextInt(this.infoStrings.size()));
            }
            return "";
        }

        @Override
        public String getTooltip() {
            return null;
        }
    }
}

