/*
 * Decompiled with CFR 0.152.
 */
package bluedart.gui;

import bluedart.api.DartAPI;
import bluedart.api.EngineLiquid;
import bluedart.api.ForceEngineLiquids;
import bluedart.core.Constants;
import bluedart.gui.ContainerForceEngine;
import bluedart.tile.TileEntityForceEngine;
import codechicken.nei.VisiblityData;
import codechicken.nei.api.INEIGuiHandler;
import cpw.mods.fml.common.Loader;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.liquids.LiquidStack;
import org.lwjgl.opengl.GL11;
import thermalexpansion.core.gui.GuiTE;
import thermalexpansion.core.gui.Tab;

public class GuiEngine
extends GuiTE
implements INEIGuiHandler {
    private TileEntityForceEngine engine;
    private ContainerForceEngine container;
    private Rectangle fuelBounds;
    private Rectangle throttleBounds;
    private Rectangle energyBounds;
    private Rectangle throttleMeterBounds;

    public GuiEngine(ContainerForceEngine container) {
        super(container);
        this.engine = container.engine;
        this.container = container;
        this.field_74194_b = 176;
        this.field_74195_c = 161;
        this.addTab(new EnergyTab((Gui)this));
        this.addTab(new InfoTab((Gui)this));
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.fuelBounds = new Rectangle(this.field_74198_m + 66, this.field_74197_n + 11, 16, 58);
        this.throttleBounds = new Rectangle(this.field_74198_m + 94, this.field_74197_n + 11, 16, 58);
    }

    public void func_73876_c() {
        super.func_73876_c();
    }

    public List handleItemTooltip(ItemStack stack, int x, int y, List tooltip) {
        Point pointerLoc = new Point(x, y);
        if (this.fuelBounds.contains(pointerLoc)) {
            try {
                tooltip.add("" + this.engine.fuelTank.getLiquid().asItemStack().func_82833_r() + " (" + this.engine.fuelTank.getLiquid().amount + ")");
            }
            catch (Exception e) {
                tooltip.add("Empty");
            }
        }
        if (this.throttleBounds.contains(pointerLoc)) {
            try {
                tooltip.add("" + this.engine.throttleTank.getLiquid().asItemStack().func_82833_r() + " (" + this.engine.throttleTank.getLiquid().amount + ")");
            }
            catch (Exception e) {
                tooltip.add("Empty");
            }
        }
        return tooltip;
    }

    protected void func_74185_a(float par1, int par2, int par3) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_73882_e.field_71446_o.func_98187_b(Constants.ENGINE_GUI_PNG);
        int posX = (this.field_73880_f - this.field_74194_b) / 2;
        int posY = (this.field_73881_g - this.field_74195_c) / 2;
        this.func_73729_b(posX, posY, 0, 0, this.field_74194_b, this.field_74195_c);
        if (this.engine.fuelTank.getLiquid() != null && this.engine.fuelTank.getLiquid().amount > 0) {
            this.displayGauge(this.fuelBounds.x, this.fuelBounds.y, this.engine.fuelTank.getLiquid());
        }
        if (this.engine.throttleTank.getLiquid() != null && this.engine.throttleTank.getLiquid().amount > 0) {
            this.displayGauge(this.throttleBounds.x, this.throttleBounds.y, this.engine.throttleTank.getLiquid());
        }
    }

    private void displayGauge(int x, int y, LiquidStack liquid) {
        int tempx;
        if (liquid == null) {
            return;
        }
        int start = 0;
        int squaled = (int)(58.0f * (float)liquid.amount / 10000.0f);
        this.field_73882_e.field_71446_o.func_98187_b(liquid.canonical().getTextureSheet());
        do {
            tempx = 0;
            if (squaled > 16) {
                tempx = 16;
                squaled -= 16;
            } else {
                tempx = squaled;
                squaled = 0;
            }
            this.func_94065_a(x, y + 58 - tempx - start, liquid.canonical().getRenderingIcon(), 16, 16 - (16 - tempx));
            start += 16;
        } while (tempx != 0 && squaled != 0);
        this.field_73882_e.field_71446_o.func_98187_b(Constants.ENGINE_GUI_PNG);
        this.func_73729_b(x, y, 176, 0, 16, 58);
    }

    @Override
    protected void drawTooltips() {
    }

    @Override
    public VisiblityData modifyVisiblity(GuiContainer gui, VisiblityData currentVisibility) {
        currentVisibility.showNEI = false;
        return currentVisibility;
    }

    @Override
    public int getItemSpawnSlot(GuiContainer gui, ItemStack item) {
        return -1;
    }

    @Override
    public List getInventoryAreas(GuiContainer gui) {
        return null;
    }

    @Override
    public boolean handleDragNDrop(GuiContainer gui, int mousex, int mousey, ItemStack draggedStack, int button) {
        return false;
    }

    private class InfoTab
    extends Tab {
        public ArrayList infoStrings;
        private String currentInfo;

        public InfoTab(Gui gui) {
            super(gui);
            this.infoStrings = new ArrayList();
            this.leftSide = false;
            this.overlayColor = 1217260;
            this.maxHeight = 100;
            this.maxWidth = 120;
            this.initializeItems();
            this.currentInfo = this.getRandomItem();
        }

        private void initializeItems() {
            this.infoStrings.add("The Force Engine can be throttled with a few liquids, most notably water.");
            this.infoStrings.add("The Force Engine's output is determined by the base output of the Fuel multiplied by the Throttle's value.");
            this.infoStrings.add("The Force Engine will never explode or die of loneliness.");
            this.infoStrings.add("The Force Engine requires a redstone signal to run.");
            this.infoStrings.add("You can right-click the Force Engine with a valid liquid container to add liquid quickly.");
            if (Loader.isModLoaded((String)"BuildCraft|Energy")) {
                this.infoStrings.add("A wide variety of fuels are usable inside the Force Engine.  While Liquid Force is the most effective, BuildCraft Fuel or even lava is also usable.");
                this.infoStrings.add("Using Fuel or Lava in the Force Engine will yield the same output as the Combustion Engine if water is used as a throttle.");
            } else {
                this.infoStrings.add("Lava is also a valid Force Engine Fuel, although not as effective as Liquid Force.");
            }
            if (Loader.isModLoaded((String)"Forestry")) {
                this.infoStrings.add("Liquid Force may also be obtained by squeezing Force Logs.");
                this.infoStrings.add("Milk is also an effective throttle.");
                this.infoStrings.add("Did someone say Glacial bees?");
            }
        }

        @Override
        public void toggleOpen() {
            super.toggleOpen();
            if (this.isOpen()) {
                this.currentInfo = this.getRandomItem();
            }
        }

        @Override
        public void draw(int x, int y) {
            this.drawBackground(x, y);
            this.drawIcon(Constants.ITEMS_PNG, 0, x + 2, y + 2);
            if (!this.isFullyOpened()) {
                return;
            }
            tabFontRenderer.func_78261_a("Information", x + 22, y + 6, 0xFFFFFF);
            tabFontRenderer.func_78279_b(this.currentInfo, x + 8, y + 20, this.maxWidth - 14, 0);
        }

        private String getRandomItem() {
            if (((GuiEngine)GuiEngine.this).engine.field_70331_k.field_73012_v.nextFloat() >= 0.85f) {
                return DartAPI.leeYang.getFortune();
            }
            if (this.infoStrings != null && this.infoStrings.size() > 0) {
                return (String)this.infoStrings.get(((GuiEngine)GuiEngine.this).engine.field_70331_k.field_73012_v.nextInt(this.infoStrings.size()));
            }
            return "";
        }

        @Override
        public String getTooltip() {
            return null;
        }
    }

    private class EnergyTab
    extends Tab {
        public EnergyTab(Gui gui) {
            super(gui);
            this.leftSide = false;
            this.overlayColor = 13914449;
            this.maxHeight = 48;
            this.maxWidth = 90;
        }

        @Override
        public void draw(int x, int y) {
            EngineLiquid throttleLiquid;
            this.drawBackground(x, y);
            this.drawIcon(Constants.ITEMS_PNG, 49, x + 2, y + 2);
            if (!this.isFullyOpened()) {
                return;
            }
            float output = GuiEngine.this.engine.getEnergyPerProcess();
            float throttle = 0.0f;
            if (((GuiEngine)GuiEngine.this).engine.throttleTank.getLiquid() != null && (throttleLiquid = ForceEngineLiquids.getEngineLiquid(((GuiEngine)GuiEngine.this).engine.throttleTank.getLiquid())) != null) {
                throttle = throttleLiquid.getModifier();
            }
            if (!((GuiEngine)GuiEngine.this).engine.isActive) {
                throttle = 0.0f;
                output = 0.0f;
            }
            int subColor = 0xE4E4E4;
            tabFontRenderer.func_78261_a("Output", x + 22, y + 6, 0xFFFFFF);
            tabFontRenderer.func_78261_a("MJ/t:", x + 8, y + 20, 0xFFFFFF);
            if (output > 0.0f) {
                tabFontRenderer.func_78261_a("" + GuiEngine.this.engine.getEnergyPerProcess(), x + 36, y + 20, subColor);
            } else {
                tabFontRenderer.func_78261_a("None", x + 36, y + 20, subColor);
            }
            tabFontRenderer.func_78261_a("Throttle:", x + 8, y + 30, 0xFFFFFF);
            if (throttle > 0.0f) {
                tabFontRenderer.func_78261_a("" + throttle, x + 55, y + 30, subColor);
            } else {
                tabFontRenderer.func_78261_a("None", x + 55, y + 30, subColor);
            }
        }

        @Override
        public String getTooltip() {
            return null;
        }
    }
}

