/*
 * Decompiled with CFR 0.152.
 */
package bluedart.gui;

import bluedart.api.ForceUpgradeManager;
import bluedart.api.ISocketableTool;
import bluedart.item.ItemForceArmor;
import bluedart.item.ItemUpgradeCore;
import bluedart.item.tool.ItemPowerDrill;
import bluedart.proxy.Proxies;
import bluedart.utils.DartUtils;
import bluedart.utils.ItemInventory;
import bluedart.utils.SocketHelper;
import bluedart.utils.UpgradeHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class ContainerSocket
extends Container {
    public ItemInventory contents;
    public IInventory playerInv;
    public EntityPlayer user;
    public ItemStack originStack;

    public ContainerSocket(EntityPlayer player, ItemInventory inv) {
        int i;
        this.user = player;
        this.playerInv = player.field_71071_by;
        this.contents = inv;
        if (inv.func_70302_i_() > 0) {
            this.func_75146_a(new SocketSlot(this.contents, 0, 80, 19));
        }
        if (inv.func_70302_i_() > 1) {
            this.func_75146_a(new SocketSlot(this.contents, 1, 62, 55));
        }
        if (inv.func_70302_i_() > 2) {
            this.func_75146_a(new SocketSlot(this.contents, 2, 98, 55));
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot(this.playerInv, 9 + i * 9 + j, 8 + 18 * j, 88 + 18 * i));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot(this.playerInv, i, 8 + 18 * i, 146));
        }
        this.originStack = this.user.func_71045_bC();
    }

    public ItemStack func_75144_a(int slot, int button, int par3, EntityPlayer player) {
        ItemStack parent = this.contents.findParent(player);
        if (parent != null) {
            this.contents.onGuiSaved(player);
        } else {
            player.func_71053_j();
        }
        if (slot < this.func_75138_a().size()) {
            return super.func_75144_a(slot, button, par3, player);
        }
        return null;
    }

    public boolean canStayOpen(EntityPlayer player) {
        return this.contents.findParent(player) != null;
    }

    public void func_75134_a(EntityPlayer player) {
        if (!Proxies.common.isSimulating(player.field_70170_p)) {
            return;
        }
        this.contents.onGuiSaved(player);
        ItemStack parent = this.contents.findParent(player);
        if (parent != null) {
            NBTTagCompound comp = parent.func_77978_p();
            NBTTagCompound upgrades = SocketHelper.getSocketCompound(parent);
            if (comp != null && upgrades != null) {
                NBTTagList ench = new NBTTagList();
                if (upgrades.func_74764_b("Luck")) {
                    if (this.originStack.func_77973_b() instanceof ItemPowerDrill) {
                        ench.func_74742_a((NBTBase)DartUtils.simulateEnchant(35, upgrades.func_74762_e("Luck")));
                    } else {
                        ench.func_74742_a((NBTBase)DartUtils.simulateEnchant(21, upgrades.func_74762_e("Luck")));
                    }
                }
                if (upgrades.func_74764_b("Touch")) {
                    ench.func_74742_a((NBTBase)DartUtils.simulateEnchant(33, 1));
                }
                if (!(parent.func_77973_b() instanceof ItemForceArmor)) {
                    comp.func_74782_a("ench", (NBTBase)ench);
                }
            }
        }
    }

    public ItemStack func_82846_b(EntityPlayer player, int index) {
        ItemStack returnStack = null;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack stack = slot.func_75211_c();
            returnStack = stack.func_77946_l();
            if (stack.field_77994_a == 0) {
                slot.func_75215_d((ItemStack)null);
            } else {
                slot.func_75218_e();
            }
            if (stack.field_77994_a == returnStack.field_77994_a) {
                return null;
            }
            slot.func_82870_a(player, stack);
        }
        return returnStack;
    }

    public void removeSlot(int slot) {
        this.contents.func_70299_a(slot, null);
    }

    protected void func_75133_b(int par1, int par2, boolean par3, EntityPlayer par4EntityPlayer) {
    }

    public boolean func_75145_c(EntityPlayer var1) {
        return true;
    }

    private class SocketSlot
    extends Slot {
        public SocketSlot(IInventory inv, int index, int x, int y) {
            super(inv, index, x, y);
        }

        public boolean func_75214_a(ItemStack stack) {
            if (stack == null || !(stack.func_77973_b() instanceof ItemUpgradeCore)) {
                return false;
            }
            int upgradeID = -1;
            NBTTagCompound upgrades = UpgradeHelper.getUpgradeCompound(stack);
            if (upgrades.func_74764_b("Force")) {
                upgradeID = ForceUpgradeManager.FORCE.getID();
            }
            if (upgrades.func_74764_b("Luck")) {
                upgradeID = ForceUpgradeManager.LUCK.getID();
            }
            if (upgrades.func_74764_b("Speed")) {
                upgradeID = ForceUpgradeManager.MINING.getID();
            }
            if (upgrades.func_74764_b("Grinding")) {
                upgradeID = ForceUpgradeManager.GRINDING.getID();
            }
            if (upgrades.func_74764_b("Bane")) {
                upgradeID = ForceUpgradeManager.BANE.getID();
            }
            if (upgrades.func_74764_b("Bleed")) {
                upgradeID = ForceUpgradeManager.BLEED.getID();
            }
            if (upgrades.func_74764_b("Heat")) {
                upgradeID = ForceUpgradeManager.HEAT.getID();
            }
            if (upgrades.func_74764_b("Wing")) {
                upgradeID = ForceUpgradeManager.WING.getID();
            }
            if (upgrades.func_74764_b("Rainbow")) {
                upgradeID = ForceUpgradeManager.RAINBOW.getID();
            }
            if (upgrades.func_74764_b("Touch")) {
                upgradeID = ForceUpgradeManager.TOUCH.getID();
            }
            if (upgrades.func_74764_b("Sturdy")) {
                upgradeID = ForceUpgradeManager.STURDY.getID();
            }
            if (upgrades.func_74764_b("Holding")) {
                upgradeID = ForceUpgradeManager.STORAGE.getID();
            }
            if (upgrades.func_74764_b("Damage")) {
                upgradeID = ForceUpgradeManager.DAMAGE.getID();
            }
            if (upgrades.func_74764_b("Lumberjack")) {
                upgradeID = ForceUpgradeManager.LUMBERJACK.getID();
            }
            for (int check : ((ISocketableTool)ContainerSocket.this.originStack.func_77973_b()).validSockets()) {
                if (check != upgradeID) continue;
                return true;
            }
            return false;
        }

        public boolean func_82869_a(EntityPlayer player) {
            return false;
        }
    }
}

