/*
 * Decompiled with CFR 0.152.
 */
package bluedart.gui;

import bluedart.api.ForceTransmutation;
import bluedart.gui.CraftingContainer;
import bluedart.item.tool.ItemMemberCard;
import bluedart.proxy.Proxies;
import bluedart.utils.DartUtils;
import bluedart.utils.InventoryUtils;
import bluedart.utils.ItemInventory;
import bluedart.utils.UpgradeHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.nbt.NBTTagCompound;

public class ContainerMemberCard
extends Container {
    public ItemInventory contents;
    public IInventory playerInv;
    private InventoryBasic buffer;
    public EntityPlayer user;
    public ItemStack originStack;
    private int type;
    private ItemStack result;

    public ContainerMemberCard(EntityPlayer player, ItemInventory inv) {
        int j;
        int i;
        this.contents = inv;
        this.user = player;
        this.playerInv = player.field_71071_by;
        this.originStack = inv.parent;
        if (this.originStack == null || !(this.originStack.func_77973_b() instanceof ItemMemberCard)) {
            this.user.func_71053_j();
        }
        this.buffer = new InventoryBasic("", false, 9);
        NBTTagCompound upgrades = UpgradeHelper.getUpgradeCompound(this.originStack);
        int posY = 20;
        int posX = 17;
        this.type = 0;
        if (upgrades.func_74764_b("Craft")) {
            this.type = 1;
        }
        if (upgrades.func_74764_b("Force")) {
            this.type = 2;
        }
        if (upgrades.func_74764_b("Forge")) {
            this.type = 3;
        }
        if (this.type == 1) {
            posX = 42;
            for (i = 0; i < 3; ++i) {
                for (j = 0; j < 3; ++j) {
                    this.func_75146_a(new CardSlot(this.contents, i * 3 + j, posX + j * 18, posY + i * 18));
                }
            }
            this.func_75146_a(new ResultSlot(this.contents, 9, 133, 38));
            this.contents.func_70299_a(9, null);
            posY = 90;
        } else if (this.type == 2) {
            posX = 13;
            for (i = 0; i < 3; ++i) {
                for (j = 0; j < 3; ++j) {
                    this.func_75146_a(new CardSlot(this.contents, i * 3 + j, posX + j * 18, posY + i * 18));
                }
            }
            posX = 111;
            for (i = 0; i < 3; ++i) {
                for (j = 0; j < 3; ++j) {
                    this.func_75146_a(new TransSlot((IInventory)this.buffer, i * 3 + j, posX + j * 18, posY + i * 18));
                }
            }
            posY = 90;
        } else {
            for (i = 0; i < inv.func_70302_i_() / 8; ++i) {
                for (j = 0; j < 8; ++j) {
                    this.func_75146_a(new CardSlot(this.contents, i * 8 + j, posX + j * 18, posY + i * 18));
                }
            }
            posY += 18 * (inv.func_70302_i_() / 8) + 16;
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                ItemStack tempStack = this.playerInv.func_70301_a(9 + i * 9 + j);
                this.func_75146_a(new Slot(this.playerInv, 9 + i * 9 + j, 8 + 18 * j, posY + 18 * i));
            }
        }
        posY += 58;
        for (i = 0; i < 9; ++i) {
            ItemStack tempStack = this.playerInv.func_70301_a(i);
            this.func_75146_a(new Slot(this.playerInv, i, 8 + 18 * i, posY));
        }
        this.findResult();
    }

    public ItemStack func_75144_a(int slot, int button, int par3, EntityPlayer player) {
        ItemStack parent;
        if (slot < (this.type > 0 && this.type != 3 ? 9 : 16) && slot >= 0) {
            if (button == 0) {
                ItemStack stack = player.field_71071_by.func_70445_o();
                if (stack != null && DartUtils.isAllowedInPack(stack)) {
                    boolean allowed = true;
                    if (this.type == 3 && !InventoryUtils.isForgeItem(stack)) {
                        allowed = false;
                    }
                    if (allowed) {
                        ItemStack saveStack = new ItemStack(stack.func_77973_b(), 1, stack.func_77960_j());
                        if (!stack.func_77973_b().func_77614_k() || stack.func_77973_b() instanceof ItemTool) {
                            saveStack.func_77964_b(-1);
                        }
                        this.contents.func_70299_a(slot, saveStack);
                    }
                } else if (stack == null) {
                    this.contents.func_70299_a(slot, null);
                }
            } else if (button == 1) {
                if (this.contents.func_70301_a(slot) != null) {
                    NBTTagCompound comp = null;
                    if (this.contents.func_70301_a(slot).func_77942_o()) {
                        comp = this.contents.func_70301_a(slot).func_77978_p();
                    } else {
                        comp = new NBTTagCompound();
                        this.contents.func_70301_a(slot).func_77982_d(comp);
                    }
                    if (comp != null) {
                        switch (comp.func_74771_c("mode")) {
                            case 0: 
                            case 1: {
                                comp.func_74774_a("mode", (byte)(comp.func_74771_c("mode") + 1));
                                break;
                            }
                            case 2: {
                                comp.func_74774_a("mode", (byte)0);
                            }
                        }
                    }
                }
            } else {
                this.contents.func_70299_a(slot, null);
            }
        }
        if ((parent = this.contents.findParent(player)) != null) {
            this.contents.onGuiSaved(player);
        } else {
            player.func_71053_j();
        }
        this.findResult();
        if (slot < this.func_75138_a().size()) {
            return super.func_75144_a(slot, button, par3, player);
        }
        return null;
    }

    public boolean canStayOpen(EntityPlayer player) {
        return this.contents.findParent(player) != null;
    }

    private void findResult() {
        InventoryCrafting inv = new InventoryCrafting((Container)new CraftingContainer(), 3, 3);
        for (int i = 0; i < 9; ++i) {
            inv.func_70299_a(i, this.contents.func_70301_a(i));
        }
        this.result = CraftingManager.func_77594_a().func_82787_a(inv, this.user.field_70170_p);
    }

    public ItemStack func_82846_b(EntityPlayer player, int index) {
        ItemStack returnStack = null;
        Slot slot = (Slot)this.field_75151_b.get(index);
        return returnStack;
    }

    public void func_75134_a(EntityPlayer player) {
        if (!Proxies.common.isSimulating(player.field_70170_p)) {
            return;
        }
        this.contents.onGuiSaved(player);
    }

    protected void func_75133_b(int par1, int par2, boolean par3, EntityPlayer par4EntityPlayer) {
    }

    public boolean func_75145_c(EntityPlayer var1) {
        return true;
    }

    private class CardSlot
    extends Slot {
        public CardSlot(IInventory inv, int index, int x, int y) {
            super(inv, index, x, y);
        }

        public boolean func_75214_a(ItemStack stack) {
            return false;
        }

        public boolean func_82869_a(EntityPlayer player) {
            return false;
        }
    }

    private class TransSlot
    extends CardSlot {
        public TransSlot(IInventory inv, int index, int x, int y) {
            super(inv, index, x, y);
        }

        public ItemStack func_75211_c() {
            ForceTransmutation trans;
            ItemStack stack = ContainerMemberCard.this.contents.func_70301_a(this.field_75222_d - 9);
            if (stack != null && (trans = ForceTransmutation.getTransmutable(stack)) != null && trans.getOutput() != null) {
                return trans.getOutput().func_77946_l();
            }
            return null;
        }
    }

    private class ResultSlot
    extends CardSlot {
        public ResultSlot(IInventory inv, int index, int x, int y) {
            super(inv, index, x, y);
        }

        public ItemStack func_75211_c() {
            return ContainerMemberCard.this.result;
        }
    }
}

