/*
 * Decompiled with CFR 0.152.
 */
package bluedart.gui;

import bluedart.api.DartAPI;
import bluedart.api.IForceUpgradeMaterial;
import bluedart.client.IconDirectory;
import bluedart.core.Constants;
import bluedart.item.ItemForceTome;
import bluedart.tile.TileEntityForceInfuser;
import bluedart.utils.DartUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;

public class ContainerForceInfuser
extends Container {
    public TileEntityForceInfuser infuser;
    public IInventory infuserInv;
    public EntityPlayer usingPlayer;
    public int lastEnergyLevel;
    public int lastProgress;
    public int lastAmount;
    public int canUpgrade;
    public int totalProgress;

    public ContainerForceInfuser(InventoryPlayer inv, TileEntityForceInfuser tileinfuser) {
        int i;
        this.infuser = tileinfuser;
        this.infuserInv = this.infuser;
        this.usingPlayer = inv.field_70458_d;
        this.totalProgress = 0;
        this.canUpgrade = 0;
        this.func_75146_a(new TomeSlot(this.infuserInv, 0, 10, 10, this.infuser));
        this.func_75146_a(new GemSlot(this.infuserInv, 1, 10, 35));
        this.func_75146_a(new ItemSlot(this.infuserInv, 2, 80, 57, this.infuser));
        this.func_75146_a(new UpgradeSlot(this.infuserInv, 3, 80, 20, this.infuser, 0));
        this.func_75146_a(new UpgradeSlot(this.infuserInv, 4, 104, 32, this.infuser, 1));
        this.func_75146_a(new UpgradeSlot(this.infuserInv, 5, 116, 57, this.infuser, 2));
        this.func_75146_a(new UpgradeSlot(this.infuserInv, 6, 104, 81, this.infuser, 3));
        this.func_75146_a(new UpgradeSlot(this.infuserInv, 7, 80, 93, this.infuser, 4));
        this.func_75146_a(new UpgradeSlot(this.infuserInv, 8, 56, 81, this.infuser, 5));
        this.func_75146_a(new UpgradeSlot(this.infuserInv, 9, 44, 57, this.infuser, 6));
        this.func_75146_a(new UpgradeSlot(this.infuserInv, 10, 56, 32, this.infuser, 7));
        for (i = 0; i < 3; ++i) {
            for (int var4 = 0; var4 < 9; ++var4) {
                this.func_75146_a(new Slot((IInventory)inv, var4 + i * 9 + 9, 8 + var4 * 18, 127 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)inv, i, 8 + i * 18, 185));
        }
    }

    public boolean func_75145_c(EntityPlayer par1EntityPlayer) {
        return this.infuser != null;
    }

    public ItemStack func_82846_b(EntityPlayer player, int index) {
        ItemStack returnStack = null;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack stack = slot.func_75211_c();
            returnStack = stack.func_77946_l();
            if (index >= 0 && index < 11 && !this.func_75135_a(stack, 11, 47, false)) {
                return null;
            }
            if (index > 10 && index < 47) {
                IForceUpgradeMaterial upgrade;
                NBTTagCompound tomeComp;
                if (stack.func_77973_b() instanceof ItemForceTome && stack.func_77942_o() && ((tomeComp = stack.func_77978_p()).func_74764_b("type") ? tomeComp.func_74762_e("type") == 0 && !this.func_75135_a(stack, 0, 1, false) : !this.func_75135_a(stack, 2, 3, false))) {
                    return null;
                }
                if (DartUtils.isForceContainer(stack) && !this.func_75135_a(stack, 1, 2, false)) {
                    return null;
                }
                if (DartUtils.canUpgrade(stack)) {
                    if (stack.field_77994_a > 1) {
                        if (this.func_75139_a(2).func_75211_c() != null || !this.func_75135_a(new ItemStack(stack.func_77973_b(), 1, stack.func_77960_j()), 2, 3, false)) {
                            return null;
                        }
                        --stack.field_77994_a;
                    } else if (!this.func_75135_a(stack, 2, 3, false)) {
                        return null;
                    }
                }
                if (this.infuser != null && this.infuser.totalProgress == 0 && (upgrade = DartAPI.fum.getMaterialFromItemStack(stack)) != null) {
                    int tier;
                    int n = tier = this.infuser != null ? this.infuser.getActiveTier() : 0;
                    if (tier < DartAPI.fum.getFromID(upgrade.getUpgradeID()).getTier()) {
                        return null;
                    }
                    boolean transferred = false;
                    for (int i = 3; i < 4 + tier; ++i) {
                        ItemStack tempStack = stack.func_77946_l();
                        tempStack.field_77994_a = 1;
                        if (this.func_75139_a(i).func_75211_c() != null || !this.func_75135_a(tempStack, i, i + 1, false)) continue;
                        --stack.field_77994_a;
                        transferred = true;
                        break;
                    }
                    if (!transferred) {
                        return null;
                    }
                }
            }
            if (stack.field_77994_a == 0) {
                slot.func_75215_d((ItemStack)null);
            } else {
                slot.func_75218_e();
            }
            if (stack.field_77994_a == returnStack.field_77994_a) {
                return null;
            }
            slot.func_82870_a(player, stack);
        }
        return returnStack;
    }

    protected void func_75133_b(int par1, int par2, boolean par3, EntityPlayer par4EntityPlayer) {
    }

    private boolean tryStack(ItemStack stack, int slot, int index) {
        if (!this.func_75139_a(slot).func_75216_d()) {
            ItemStack temp = stack.func_77946_l();
            temp.field_77994_a = 1;
            this.func_75141_a(slot, temp);
            temp = this.func_75139_a(index).func_75211_c();
            --temp.field_77994_a;
            if (temp.field_77994_a < 1) {
                this.func_75141_a(index, null);
            }
            return true;
        }
        return false;
    }

    public void func_75132_a(ICrafting crafting) {
        super.func_75132_a(crafting);
        if (this.infuser == null) {
            return;
        }
        try {
            crafting.func_71112_a((Container)this, 0, (int)this.infuser.provider.getEnergyStored());
            crafting.func_71112_a((Container)this, 1, this.infuser.progress);
            crafting.func_71112_a((Container)this, 2, this.infuser.liquid.amount);
            crafting.func_71112_a((Container)this, 3, this.infuser.canUpgrade);
            crafting.func_71112_a((Container)this, 4, this.infuser.totalProgress);
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (this.infuser == null || this.infuser.provider == null) {
            return;
        }
        try {
            for (int var1 = 0; var1 < this.field_75149_d.size(); ++var1) {
                ICrafting var2 = (ICrafting)this.field_75149_d.get(var1);
                if (this.lastEnergyLevel != (int)this.infuser.provider.getEnergyStored()) {
                    var2.func_71112_a((Container)this, 0, (int)this.infuser.provider.getEnergyStored());
                }
                if (this.lastProgress != this.infuser.progress) {
                    var2.func_71112_a((Container)this, 1, this.infuser.progress);
                }
                if (this.lastAmount != this.infuser.liquid.amount) {
                    var2.func_71112_a((Container)this, 2, this.infuser.liquid.amount);
                }
                if (this.canUpgrade != this.infuser.canUpgrade) {
                    var2.func_71112_a((Container)this, 3, this.infuser.canUpgrade);
                }
                if (this.totalProgress == this.infuser.totalProgress) continue;
                var2.func_71112_a((Container)this, 4, this.infuser.totalProgress);
            }
            this.lastEnergyLevel = (int)this.infuser.provider.getEnergyStored();
            this.lastProgress = this.infuser.progress;
            this.lastAmount = this.infuser.liquid.amount;
            this.canUpgrade = this.infuser.canUpgrade;
            this.totalProgress = this.infuser.totalProgress;
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int i, int j) {
        if (this.infuser == null) {
            return;
        }
        switch (i) {
            case 0: {
                this.infuser.provider.setEnergyStored(j);
                break;
            }
            case 1: {
                this.infuser.progress = j;
                break;
            }
            case 2: {
                this.infuser.liquid.amount = j;
                break;
            }
            case 3: {
                this.infuser.canUpgrade = j;
                break;
            }
            case 4: {
                this.infuser.totalProgress = j;
            }
        }
    }

    private class TomeSlot
    extends Slot {
        TileEntityForceInfuser infuser;

        public TomeSlot(IInventory par1iInventory, int par2, int par3, int par4, TileEntityForceInfuser infuser) {
            super(par1iInventory, par2, par3, par4);
            this.infuser = infuser;
        }

        public boolean func_75214_a(ItemStack stack) {
            if (stack == null) {
                return false;
            }
            return stack.func_77973_b() instanceof ItemForceTome && stack.func_77942_o() && stack.func_77978_p().func_74764_b("type") && stack.func_77978_p().func_74762_e("type") == 0;
        }

        public boolean func_82869_a(EntityPlayer player) {
            return this.infuser != null ? this.infuser.totalProgress == 0 : false;
        }

        public int func_75219_a() {
            return 1;
        }
    }

    private class GemSlot
    extends Slot {
        public GemSlot(IInventory par1iInventory, int par2, int par3, int par4) {
            super(par1iInventory, par2, par3, par4);
        }

        public boolean func_75214_a(ItemStack stack) {
            return DartUtils.isForceContainer(stack);
        }
    }

    private class ItemSlot
    extends Slot {
        TileEntityForceInfuser infuser;

        public ItemSlot(IInventory par1iInventory, int par2, int par3, int par4, TileEntityForceInfuser infuser) {
            super(par1iInventory, par2, par3, par4);
            this.infuser = infuser;
        }

        public boolean func_75214_a(ItemStack stack) {
            return DartUtils.canUpgrade(stack);
        }

        public boolean func_82869_a(EntityPlayer player) {
            return this.infuser != null ? this.infuser.totalProgress == 0 : false;
        }

        public int func_75219_a() {
            return 1;
        }
    }

    private class UpgradeSlot
    extends Slot {
        private TileEntityForceInfuser infuser;
        private int tier;

        public UpgradeSlot(IInventory par1iInventory, int par2, int par3, int par4, TileEntityForceInfuser infuser, int tier) {
            super(par1iInventory, par2, par3, par4);
            this.infuser = infuser;
            this.tier = tier;
        }

        public String getBackgroundIconTexture() {
            if (this.infuser != null && this.infuser.getActiveTier() < this.tier) {
                return Constants.ITEMS_PNG;
            }
            return super.getBackgroundIconTexture();
        }

        public Icon func_75212_b() {
            if (this.infuser != null && this.infuser.getActiveTier() < this.tier) {
                return IconDirectory.noSlot;
            }
            return super.func_75212_b();
        }

        public boolean func_75214_a(ItemStack stack) {
            if (this.infuser == null) {
                return false;
            }
            if (this.infuser.getActiveTier() < this.tier || this.infuser.totalProgress > 0) {
                return false;
            }
            IForceUpgradeMaterial upgrade = DartAPI.fum.getMaterialFromItemStack(stack);
            if (upgrade == null) {
                return false;
            }
            for (IForceUpgradeMaterial check : DartAPI.fum.materials) {
                if (check == null || !check.equals(upgrade) || (this.infuser != null ? this.infuser.getActiveTier() : 0) < DartAPI.fum.getFromID(check.getUpgradeID()).getTier()) continue;
                return true;
            }
            return false;
        }

        public boolean func_82869_a(EntityPlayer player) {
            return this.infuser != null ? this.infuser.totalProgress == 0 : false;
        }

        public int func_75219_a() {
            return 1;
        }
    }
}

