/*
 * Decompiled with CFR 0.152.
 */
package bluedart.gui;

import bluedart.item.tool.ItemClipboard;
import bluedart.item.tool.ItemForceBelt;
import bluedart.item.tool.ItemForcePack;
import bluedart.proxy.Proxies;
import bluedart.utils.DartUtils;
import bluedart.utils.InventoryUtils;
import bluedart.utils.ItemCraftingInventory;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;

public class ContainerClipboard
extends Container {
    public ItemCraftingInventory contents;
    public InventoryCraftResult craftResult = new InventoryCraftResult();
    public ItemStack originStack;
    public IInventory playerInv;
    public EntityPlayer user;
    private boolean hasInitialized;
    private boolean useInventory;
    private ItemStack[] neiBuffer;

    public ContainerClipboard(EntityPlayer player, ItemCraftingInventory inv) {
        int j;
        int i;
        if (player == null) {
            return;
        }
        if (inv == null || inv.parent == null) {
            player.func_71053_j();
            return;
        }
        this.hasInitialized = false;
        this.contents = inv;
        this.user = player;
        this.playerInv = player.field_71071_by;
        this.contents.setCraftingListener(this);
        this.neiBuffer = new ItemStack[9];
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                this.func_75146_a(new ClipSlot(this.contents, i * 3 + j, 25 + j * 18, 12 + i * 18));
            }
        }
        this.func_75146_a((Slot)new SlotCrafting(this.user, (IInventory)this.contents, (IInventory)this.craftResult, 0, 113, 30));
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                ItemStack tempStack = this.playerInv.func_70301_a(9 + i * 9 + j);
                if (tempStack != null && tempStack.func_77973_b() instanceof ItemClipboard) {
                    this.func_75146_a(new Slot(this.playerInv, 9 + i * 9 + j, 8 + 18 * j, 75 + 18 * i));
                    continue;
                }
                this.func_75146_a(new Slot(this.playerInv, 9 + i * 9 + j, 8 + 18 * j, 75 + 18 * i));
            }
        }
        for (i = 0; i < 9; ++i) {
            ItemStack tempStack = this.playerInv.func_70301_a(i);
            if (tempStack != null && tempStack.func_77973_b() instanceof ItemClipboard) {
                this.func_75146_a(new Slot(this.playerInv, i, 8 + 18 * i, 133));
                continue;
            }
            this.func_75146_a(new Slot(this.playerInv, i, 8 + 18 * i, 133));
        }
        this.hasInitialized = true;
        this.func_75130_a(this.contents);
        this.originStack = inv.parent;
        if (this.originStack == null || !(this.originStack.func_77973_b() instanceof ItemClipboard)) {
            player.func_71053_j();
        }
        this.useInventory = this.originStack.func_77978_p().func_74767_n("useInventory");
        this.canStayOpen(player);
    }

    public void func_75130_a(IInventory inv) {
        if (!this.hasInitialized) {
            return;
        }
        this.craftResult.func_70299_a(0, CraftingManager.func_77594_a().func_82787_a((InventoryCrafting)this.contents, this.user.field_70170_p));
    }

    public ItemStack func_75144_a(int slot, int button, int par3, EntityPlayer player) {
        ItemStack parent = this.contents.findParent(player);
        if (parent != null) {
            this.contents.onGuiSaved(player);
        } else {
            player.func_71053_j();
        }
        if (slot < this.func_75138_a().size()) {
            return super.func_75144_a(slot, button, par3, player);
        }
        return null;
    }

    public boolean canStayOpen(EntityPlayer player) {
        return this.contents.findParent(player) != null;
    }

    public ItemStack func_82846_b(EntityPlayer player, int index) {
        ItemStack returnStack = null;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack stack = slot.func_75211_c();
            returnStack = stack.func_77946_l();
            if (index >= 0 && index < 9 && !this.func_75135_a(stack, 10, 46, true)) {
                return null;
            }
            if (index == 9) {
                int i;
                int maxCraftable = this.craftResult.func_70301_a(0).func_77976_d() / this.craftResult.func_70301_a((int)0).field_77994_a;
                for (i = 0; i < 9; ++i) {
                    ItemStack tempStack = this.contents.func_70301_a(i);
                    if (tempStack == null || tempStack.func_77973_b().func_77634_r() || tempStack.field_77994_a >= maxCraftable) continue;
                    maxCraftable = tempStack.field_77994_a;
                }
                for (i = 0; i < maxCraftable; ++i) {
                    if (!this.func_75135_a(stack.func_77946_l(), 10, 46, true)) {
                        return null;
                    }
                    slot.func_75218_e();
                    slot.func_82870_a(player, stack);
                }
            }
            if (index > 9 && index < 46) {
                if (!this.isItemValidForSlot(stack)) {
                    return null;
                }
                if (!this.func_75135_a(stack, 0, 9, false)) {
                    return null;
                }
            }
            if (stack.field_77994_a == 0) {
                slot.func_75215_d((ItemStack)null);
            } else {
                slot.func_75218_e();
            }
            if (stack.field_77994_a == returnStack.field_77994_a) {
                return null;
            }
            slot.func_82870_a(player, stack);
        }
        return returnStack;
    }

    private boolean isItemValidForSlot(ItemStack stack) {
        boolean isValid = !(stack.func_77973_b() instanceof ItemClipboard) && !(stack.func_77973_b() instanceof ItemForcePack) && !(stack.func_77973_b() instanceof ItemForceBelt);
        return isValid;
    }

    public void func_75134_a(EntityPlayer player) {
        if (!Proxies.common.isSimulating(player.field_70170_p)) {
            return;
        }
        this.contents.onGuiSaved(player);
    }

    protected void func_75133_b(int par1, int par2, boolean par3, EntityPlayer par4EntityPlayer) {
    }

    public void grabItems(ItemStack[] items) {
        int i;
        if (items == null || items.length != 9 || this.contents == null) {
            return;
        }
        this.clearMatrix();
        for (i = 0; i < this.contents.func_70302_i_(); ++i) {
            ItemStack tempStack = this.contents.func_70301_a(i);
            if (tempStack == null) continue;
            this.user.func_85030_a("random.explode", 1.0f, DartUtils.randomPitch());
            return;
        }
        block1: for (i = 0; i < 9; ++i) {
            int j;
            if (items[i] == null) continue;
            boolean found = false;
            for (j = 0; j < this.user.field_71071_by.field_70462_a.length; ++j) {
                if (!InventoryUtils.isItemEquivalent(items[i], this.user.field_71071_by.field_70462_a[j])) continue;
                this.contents.func_70299_a(i, this.user.field_71071_by.field_70462_a[j].func_77946_l());
                this.user.field_71071_by.field_70462_a[j] = null;
                found = true;
                break;
            }
            if (found) continue;
            for (j = 0; j < this.contents.func_70302_i_() && j < i; ++j) {
                if (!InventoryUtils.isItemEquivalent(items[i], this.contents.func_70301_a(j)) || this.contents.func_70301_a((int)j).field_77994_a <= 1) continue;
                this.contents.func_70299_a(i, this.contents.func_70301_a(j).func_77946_l());
                this.contents.func_70301_a((int)i).field_77994_a = 1;
                --this.contents.func_70301_a((int)j).field_77994_a;
                continue block1;
            }
        }
        this.balanceItems();
    }

    public void balanceItems() {
        ArrayList<ItemStack> checked = new ArrayList<ItemStack>();
        for (int i = 0; i < 9; ++i) {
            ItemStack contentAt = this.contents.func_70301_a(i);
            if (contentAt == null || contentAt.func_77976_d() <= 1 || contentAt.func_77942_o() || this.containsItem(checked, contentAt)) continue;
            checked.add(contentAt.func_77946_l());
            int total = 0;
            int stacks = 0;
            for (int j = 0; j < 9; ++j) {
                ItemStack tempStack = this.contents.func_70301_a(j);
                if (tempStack == null || !this.areStacksSameItem(tempStack, contentAt)) continue;
                total += this.contents.func_70301_a((int)j).field_77994_a;
                ++stacks;
            }
            int newAmt = total / stacks;
            int remainder = total % stacks;
            for (int j = 0; j < 9; ++j) {
                ItemStack tempStack = this.contents.func_70301_a(j);
                if (tempStack == null || !this.areStacksSameItem(tempStack, contentAt)) continue;
                tempStack.field_77994_a = newAmt;
                if (remainder <= 0) continue;
                ++tempStack.field_77994_a;
                --remainder;
            }
        }
    }

    public void doDistribute() {
        ItemStack firstStack = null;
        ItemStack secondStack = null;
        int[] iterator = new int[]{0, 1, 2, 5, 8, 7, 6, 3};
        int freeSlots = 0;
        for (int i : iterator) {
            if (this.contents.func_70301_a(i) != null && this.contents.func_70301_a((int)i).field_77994_a > 1 && !this.contents.func_70301_a(i).func_77942_o() && this.contents.func_70301_a(i).func_77976_d() > 1) {
                if (firstStack == null) {
                    firstStack = this.contents.func_70301_a(i);
                } else if (secondStack == null) {
                    secondStack = this.contents.func_70301_a(i);
                }
            }
            if (this.contents.func_70301_a(i) != null) continue;
            ++freeSlots;
        }
        if (freeSlots == 9) {
            return;
        }
        boolean turn = true;
        boolean hasChanged = false;
        if (freeSlots > 0 && firstStack != null) {
            for (int i : iterator) {
                if (this.contents.func_70301_a(i) != null) continue;
                if (turn) {
                    if (firstStack.field_77994_a > 1) {
                        this.contents.func_70299_a(i, new ItemStack(firstStack.func_77973_b(), 1, firstStack.func_77960_j()));
                        --firstStack.field_77994_a;
                        hasChanged = true;
                    } else if (secondStack != null && secondStack.field_77994_a > 1) {
                        this.contents.func_70299_a(i, new ItemStack(secondStack.func_77973_b(), 1, secondStack.func_77960_j()));
                        --secondStack.field_77994_a;
                        hasChanged = true;
                    }
                    turn = secondStack == null;
                    continue;
                }
                if (secondStack.field_77994_a > 1) {
                    this.contents.func_70299_a(i, new ItemStack(secondStack.func_77973_b(), 1, secondStack.func_77960_j()));
                    --secondStack.field_77994_a;
                    hasChanged = true;
                } else if (firstStack != null && firstStack.field_77994_a > 1) {
                    this.contents.func_70299_a(i, new ItemStack(firstStack.func_77973_b(), 1, firstStack.func_77960_j()));
                    --firstStack.field_77994_a;
                    hasChanged = true;
                }
                turn = true;
            }
        }
        if (freeSlots == 0 || !hasChanged) {
            ArrayList<ItemStack> buffer = new ArrayList<ItemStack>();
            for (int i : iterator) {
                buffer.add(this.contents.func_70301_a(i));
            }
            int index = 0;
            for (int i : new int[]{1, 2, 5, 8, 7, 6, 3, 0}) {
                this.contents.func_70299_a(i, (ItemStack)buffer.get(index));
                ++index;
            }
        }
        this.balanceItems();
    }

    private boolean containsItem(ArrayList list, ItemStack stack) {
        for (ItemStack check : list) {
            if (!this.areStacksSameItem(check, stack)) continue;
            return true;
        }
        return false;
    }

    private boolean areStacksSameItem(ItemStack stack1, ItemStack stack2) {
        if (stack1 == null || stack2 == null) {
            return stack1 == null && stack2 == null;
        }
        return stack1.field_77993_c == stack2.field_77993_c && stack1.func_77960_j() == stack2.func_77960_j();
    }

    public void clearMatrix() {
        if (!this.canStayOpen(this.user)) {
            this.user.func_71053_j();
            return;
        }
        for (int i = 0; i < 9; ++i) {
            this.func_82846_b(this.user, i);
        }
    }

    public boolean getUseInventory() {
        return this.useInventory;
    }

    public boolean func_75145_c(EntityPlayer var1) {
        return true;
    }

    private class ClipSlot
    extends Slot {
        public ClipSlot(IInventory inv, int index, int x, int y) {
            super(inv, index, x, y);
        }

        public boolean func_75214_a(ItemStack stack) {
            if (stack != null) {
                return ContainerClipboard.this.isItemValidForSlot(stack);
            }
            return false;
        }

        public boolean func_82869_a(EntityPlayer player) {
            if (!this.func_75216_d()) {
                return true;
            }
            if (!ContainerClipboard.this.canStayOpen(player)) {
                return false;
            }
            return !(this.func_75211_c().func_77973_b() instanceof ItemClipboard);
        }
    }
}

