/*
 * Decompiled with CFR 0.152.
 */
package bluedart.core.network;

import bluedart.DartCraft;
import bluedart.core.Config;
import bluedart.core.DartCraftCore;
import bluedart.core.damage.DartFallDamage;
import bluedart.core.network.FXEnderPacket;
import bluedart.core.network.FXPacket;
import bluedart.core.network.FramePacket;
import bluedart.core.network.PacketBelt;
import bluedart.core.network.PacketCoords;
import bluedart.core.network.PacketDimCoords;
import bluedart.core.network.PacketDualInt;
import bluedart.core.network.PacketInt;
import bluedart.core.network.PacketLocation;
import bluedart.core.network.PacketNBT;
import bluedart.core.network.PacketRename;
import bluedart.core.network.PacketRenameRod;
import bluedart.core.network.TreeFXPacket;
import bluedart.gui.ContainerClipboard;
import bluedart.gui.ContainerSocket;
import bluedart.item.DartItem;
import bluedart.item.ItemForceFlask;
import bluedart.item.tool.ItemClipboard;
import bluedart.item.tool.ItemForceBelt;
import bluedart.item.tool.ItemForcePack;
import bluedart.item.tool.ItemForceRod;
import bluedart.item.tool.ItemMemberCard;
import bluedart.proxy.Proxies;
import bluedart.proxy.ProxyCommon;
import bluedart.tile.TileEntityForceInfuser;
import bluedart.tile.TileForceFrame;
import bluedart.utils.DartUtils;
import bluedart.utils.FXUtils;
import bluedart.utils.InventoryUtils;
import bluedart.utils.ItemInventory;
import bluedart.utils.SocketHelper;
import bluedart.utils.UpgradeHelper;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import net.minecraft.block.Block;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.world.WorldServer;

public class PacketHandler
implements IPacketHandler {
    public void onPacketData(INetworkManager manager, Packet250CustomPayload packet, Player user) {
        DataInputStream is = new DataInputStream(new ByteArrayInputStream(packet.field_73629_c));
        byte type = 0;
        try {
            type = is.readByte();
            EntityPlayer player = null;
            NBTTagCompound dartTag = null;
            if (user instanceof EntityPlayer) {
                player = (EntityPlayer)user;
            }
            if (player != null && player.getEntityData().func_74764_b("DartCraft")) {
                dartTag = player.getEntityData().func_74775_l("DartCraft");
            }
            switch (type) {
                case 2: {
                    if (player == null || player.field_71070_bA == null || !(player.field_71070_bA instanceof ContainerClipboard)) break;
                    ((ContainerClipboard)player.field_71070_bA).clearMatrix();
                    break;
                }
                case 4: {
                    if (player == null || player.field_71070_bA == null || !(player.field_71070_bA instanceof ContainerClipboard)) break;
                    ((ContainerClipboard)player.field_71070_bA).balanceItems();
                    break;
                }
                case 3: {
                    if (player == null || !(player.field_71070_bA instanceof ContainerClipboard)) break;
                    ((ContainerClipboard)player.field_71070_bA).doDistribute();
                    break;
                }
                case 10: {
                    if (player == null || !Config.wingEnabled) break;
                    player.field_70143_R = 0.0f;
                    break;
                }
                case 8: {
                    FXPacket wing1 = new FXPacket();
                    wing1.readData(is);
                    this.wingFX(player, wing1);
                    break;
                }
                case 15: {
                    FXPacket wing2 = new FXPacket();
                    wing2.readData(is);
                    FXUtils.makeWingEffects(player.field_70170_p, wing2.x, wing2.y, wing2.z, 16);
                    break;
                }
                case 1: {
                    PacketRename rename = new PacketRename();
                    rename.readData(is);
                    this.handleRename(rename, player);
                    break;
                }
                case 6: {
                    FXPacket change = new FXPacket();
                    change.readData(is);
                    FXUtils.makeChangeEffects(player.field_70170_p, change.x, change.y, change.z, 1, 32);
                    break;
                }
                case 27: {
                    FXPacket change2 = new FXPacket();
                    change2.readData(is);
                    FXUtils.makeChangeEffects(player.field_70170_p, change2.x, change2.y, change2.z, 2, 16);
                    break;
                }
                case 5: {
                    PacketDimCoords coords = new PacketDimCoords();
                    coords.readData(is);
                    if (player == null) break;
                    this.openTileGui(coords, player);
                    break;
                }
                case 18: {
                    PacketInt intPacket = new PacketInt();
                    intPacket.readData(is);
                    if (player == null || !(player.field_71070_bA instanceof ContainerSocket)) break;
                    ((ContainerSocket)player.field_71070_bA).removeSlot(intPacket.intVal);
                    break;
                }
                case 14: {
                    TreeFXPacket fell = new TreeFXPacket();
                    fell.readData(is);
                    for (int i = 0; i < fell.height; ++i) {
                        FXUtils.makeChangeEffects(player.field_70170_p, (float)fell.x, (float)(fell.y + (double)i), (float)fell.z, 1, 16);
                    }
                    break;
                }
                case 7: {
                    FXEnderPacket ender = new FXEnderPacket();
                    ender.readData(is);
                    FXUtils.makeEnderEffects((Entity)player, ender.x, ender.y, ender.z, ender.prevX, ender.prevY, ender.prevZ, 128, false);
                    break;
                }
                case 16: {
                    FXPacket firePack = new FXPacket();
                    firePack.readData(is);
                    FXUtils.spawnFlameFX(player.field_70170_p, (int)firePack.x, (int)firePack.y, (int)firePack.z);
                    break;
                }
                case 17: {
                    FXPacket breakPack = new FXPacket();
                    breakPack.readData(is);
                    FXUtils.makeChangeEffects(player.field_70170_p, (float)breakPack.x, (float)breakPack.y, (float)breakPack.z, 1, 8);
                    break;
                }
                case 19: {
                    FXPacket flyPack = new FXPacket();
                    flyPack.readData(is);
                    FXUtils.makeShiny(player.field_70170_p, flyPack.x, flyPack.y, flyPack.z, 0, 0xFFFF00, 3, false);
                    break;
                }
                case 20: {
                    FXPacket disPack = new FXPacket();
                    disPack.readData(is);
                    FXUtils.makeShiny(player.field_70170_p, disPack.x, disPack.y, disPack.z, 2, 0xFFFF00, 32, true);
                    break;
                }
                case 21: {
                    FXPacket disPack2 = new FXPacket();
                    disPack2.readData(is);
                    FXUtils.makeShiny(player.field_70170_p, disPack2.x, disPack2.y, disPack2.z, 2, 0xFFFF00, 32, false);
                    break;
                }
                case 42: {
                    FXPacket disPack3 = new FXPacket();
                    disPack3.readData(is);
                    FXUtils.makeShiny(player.field_70170_p, disPack3.x, disPack3.y, disPack3.z, 2, FXUtils.randomParticleColor(), 2, false);
                    break;
                }
                case 22: {
                    dartTag.func_74757_a("wasFlying", player.field_71075_bZ.field_75101_c);
                    dartTag.func_74757_a("isFlying", true);
                    player.field_71075_bZ.field_75101_c = true;
                    player.field_71075_bZ.field_75100_b = true;
                    player.field_70143_R = 0.0f;
                    break;
                }
                case 23: {
                    player.field_71075_bZ.field_75101_c = false;
                    player.field_71075_bZ.field_75100_b = false;
                    dartTag.func_74757_a("isFlying", false);
                    player.field_70143_R = 0.0f;
                    break;
                }
                case 24: {
                    player.field_70170_p.func_72956_a((Entity)player, "bluedart.meterEmpty", 1.0f, DartUtils.randomPitch());
                    break;
                }
                case 25: {
                    FXPacket flyPack1 = new FXPacket();
                    flyPack1.readData(is);
                    this.flyFX(player, flyPack1);
                    break;
                }
                case 26: {
                    FXPacket flyPack2 = new FXPacket();
                    flyPack2.readData(is);
                    this.showFlightParticles(player, flyPack2);
                    break;
                }
                case 32: {
                    PacketRenameRod rodPack = new PacketRenameRod();
                    rodPack.readData(is);
                    this.handleRenameRod(player, rodPack);
                    break;
                }
                case 33: {
                    PacketBelt beltPack = new PacketBelt();
                    beltPack.readData(is);
                    this.handleUseRod(player, beltPack);
                    break;
                }
                case 34: {
                    PacketRename renameBelt = new PacketRename();
                    renameBelt.readData(is);
                    this.handleRenameBelt(player, renameBelt);
                    break;
                }
                case 41: {
                    PacketRename renameCard = new PacketRename();
                    renameCard.readData(is);
                    this.handleRenameCard(player, renameCard);
                    break;
                }
                case 36: {
                    PacketCoords frameTrigger = new PacketCoords();
                    frameTrigger.readData(is);
                    this.handleFrameTrigger(player, frameTrigger);
                    break;
                }
                case 35: {
                    FramePacket framePack = new FramePacket();
                    framePack.readData(is);
                    this.handleFrameUpdate(player, framePack);
                    break;
                }
                case 37: {
                    player.openGui((Object)DartCraft.instance, 9, player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
                    break;
                }
                case 38: {
                    player.openGui((Object)DartCraft.instance, 4, player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
                    break;
                }
                case 39: {
                    PacketInt clipID = new PacketInt();
                    clipID.readData(is);
                    this.openClipboard(player, clipID.intVal);
                    break;
                }
                case 40: {
                    PacketDualInt massBreak = new PacketDualInt();
                    massBreak.readData(is);
                    this.renderBreak(player, massBreak);
                    break;
                }
                case 43: {
                    PacketLocation skatePack = new PacketLocation();
                    skatePack.readData(is);
                    if (player.field_71093_bK == skatePack.intVal) {
                        player.field_70170_p.func_72908_a(skatePack.posX, skatePack.posY, skatePack.posZ, "bluedart.skate", 0.5f, DartUtils.randomPitch());
                    }
                    PacketDispatcher.sendPacketToAllAround((double)skatePack.posX, (double)skatePack.posY, (double)skatePack.posZ, (double)20.0, (int)skatePack.intVal, (Packet)new FXPacket(44, skatePack.posX, skatePack.posY, skatePack.posZ).getPacket());
                    break;
                }
                case 44: {
                    FXPacket skatePack2 = new FXPacket();
                    skatePack2.readData(is);
                    this.handleSkatePacket(player, skatePack2);
                    break;
                }
                case 45: {
                    PacketInt lossPack = new PacketInt();
                    lossPack.readData(is);
                    this.handleFlightLoss(lossPack.intVal);
                    break;
                }
                case 46: {
                    PacketRename damagePack = new PacketRename();
                    damagePack.readData(is);
                    this.handleFallDamage(damagePack.name, damagePack.packID);
                    break;
                }
                case 47: {
                    PacketNBT grabPack = new PacketNBT();
                    grabPack.readData(is);
                    this.handleClipGrab(player, grabPack);
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void handleRename(PacketRename rename, EntityPlayer player) {
        Object backpack = null;
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            int check;
            ItemStack tempStack = player.field_71071_by.func_70301_a(i);
            if (tempStack == null || !(tempStack.func_77973_b() instanceof ItemForcePack) || !tempStack.func_77942_o() || !tempStack.func_77978_p().func_74764_b("ID") || (check = tempStack.func_77978_p().func_74762_e("ID")) != rename.packID) continue;
            tempStack.func_77964_b(rename.color);
            NBTTagCompound comp = tempStack.func_77978_p();
            comp.func_74778_a("name", rename.name);
            break;
        }
    }

    private void handleRenameBelt(EntityPlayer player, PacketRename pack) {
        Object belt = null;
        for (int i = 0; i < 9; ++i) {
            ItemStack tempStack = player.field_71071_by.field_70462_a[i];
            if (tempStack == null || !(tempStack.func_77973_b() instanceof ItemForceBelt) || tempStack.func_77978_p().func_74762_e("ID") != pack.packID) continue;
            tempStack.func_77964_b(pack.color);
            NBTTagCompound comp = tempStack.func_77978_p();
            comp.func_74778_a("name", pack.name);
            break;
        }
    }

    private void makeEffects(FXPacket packet, EntityPlayer player) {
        if (packet.id == 6) {
            float modifier = 1.0f;
            float velModifier = 0.25f;
            int particles = 32;
            for (int i = 0; i < particles; ++i) {
                float x = (float)(packet.x + (double)(ProxyCommon.rand.nextFloat() * modifier));
                float y = (float)(packet.y + (double)(ProxyCommon.rand.nextFloat() * modifier));
                float z = (float)(packet.z + (double)(ProxyCommon.rand.nextFloat() * modifier));
                float velX = (ProxyCommon.rand.nextFloat() * 2.0f - 1.0f) * velModifier;
                float velY = (ProxyCommon.rand.nextFloat() * 2.0f - 1.0f) * velModifier;
                float velZ = (ProxyCommon.rand.nextFloat() * 2.0f - 1.0f) * velModifier;
                player.field_70170_p.func_72869_a("cloud", (double)x, (double)y, (double)z, (double)velX, (double)velY, (double)velZ);
            }
        }
    }

    private void openTileGui(PacketDimCoords packet, EntityPlayer player) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        WorldServer world = server.func_71218_a(packet.dimID);
        if (world == null) {
            return;
        }
        TileEntity tile = world.func_72796_p(packet.posX, packet.posY, packet.posZ);
        if (tile == null) {
            return;
        }
        if (tile instanceof TileEntityForceInfuser) {
            TileEntityForceInfuser infuser = (TileEntityForceInfuser)tile;
            infuser.go();
        }
    }

    private void wingFX(EntityPlayer player, FXPacket loc) {
        player.field_70170_p.func_72908_a(loc.x, loc.y, loc.z, "bluedart.fly", 1.0f, DartUtils.randomPitch());
        PacketDispatcher.sendPacketToAllAround((double)loc.x, (double)loc.y, (double)loc.z, (double)30.0, (int)player.field_71093_bK, (Packet)new FXPacket(15, loc.x, loc.y, loc.z).getPacket());
    }

    private void flyFX(EntityPlayer player, FXPacket loc) {
        PacketDispatcher.sendPacketToAllAround((double)loc.x, (double)loc.y, (double)loc.z, (double)30.0, (int)player.field_71093_bK, (Packet)new FXPacket(26, loc.x, loc.y, loc.z).getPacket());
    }

    private void showFlightParticles(EntityPlayer player, FXPacket loc) {
        if (player == null) {
            return;
        }
        switch (Config.flightParticles) {
            case 0: {
                return;
            }
            case 1: {
                if (Proxies.common.getClientInstance() == null || Proxies.common.getClientInstance().field_71439_g == null) {
                    return;
                }
                if (player != Proxies.common.getClientInstance().field_71439_g) break;
                return;
            }
            case 2: {
                if (!player.field_71075_bZ.field_75098_d) break;
                return;
            }
        }
        FXUtils.makeShiny(player.field_70170_p, loc.x, loc.y - (double)player.field_70131_O, loc.z, 0, 0xFFFF00, 3, false);
    }

    private void handleRenameRod(EntityPlayer player, PacketRenameRod pack) {
        if (player == null || pack == null) {
            return;
        }
        ItemStack rod = player.func_71045_bC();
        if (rod == null || !(rod.func_77973_b() instanceof ItemForceRod)) {
            return;
        }
        NBTTagCompound upgrades = UpgradeHelper.getUpgradeCompound(rod);
        if (upgrades.func_74764_b("Ender")) {
            NBTTagCompound enderComp = rod.func_77978_p();
            if (!pack.justName) {
                enderComp.func_74768_a("dim", pack.dimID);
                enderComp.func_74780_a("x", pack.posX);
                enderComp.func_74780_a("y", pack.posY);
                enderComp.func_74780_a("z", pack.posZ);
                enderComp.func_74757_a("init", true);
            }
            enderComp.func_74778_a("name", pack.name);
        }
    }

    private void handleUseRod(EntityPlayer player, PacketBelt beltPack) {
        if (player == null) {
            return;
        }
        ItemStack belt = null;
        for (int i = 0; i < 8; ++i) {
            ItemStack tempStack = player.field_71071_by.field_70462_a[i];
            if (tempStack == null || !(tempStack.func_77973_b() instanceof ItemForceBelt) || tempStack.func_77978_p().func_74762_e("ID") != beltPack.beltID) continue;
            belt = tempStack;
            break;
        }
        if (belt == null) {
            return;
        }
        ItemInventory inv = new ItemInventory(8, belt);
        ItemStack rod = inv.func_70301_a(beltPack.index);
        if (rod == null || !(rod.func_77973_b() instanceof ItemForceRod)) {
            return;
        }
        boolean shouldBreak = rod.func_77960_j() == rod.func_77958_k();
        int prevDamage = rod.func_77960_j();
        rod.func_77973_b().func_77659_a(rod, player.field_70170_p, player);
        NBTTagCompound upgrades = UpgradeHelper.getUpgradeCompound(rod);
        if (rod != null && upgrades.func_74764_b("Holding") && rod.func_77960_j() != prevDamage) {
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack tempStack = inv.func_70301_a(i);
                if (tempStack == null || !(tempStack.func_77973_b() instanceof ItemForceFlask)) continue;
                inv.func_70298_a(i, 1);
                break;
            }
        }
        if (shouldBreak) {
            inv.func_70299_a(beltPack.index, null);
            DartUtils.dropItem(new ItemStack((Item)DartItem.forceShard), player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v);
            player.field_70170_p.func_72956_a((Entity)player, "random.break", 1.0f, DartUtils.randomPitch());
        }
        inv.onGuiSaved(player);
    }

    private void handleFrameTrigger(EntityPlayer player, PacketCoords pack) {
        TileEntity te = player.field_70170_p.func_72796_p(pack.posX, pack.posY, pack.posZ);
        if (te == null || !(te instanceof TileForceFrame)) {
            return;
        }
        TileForceFrame frame = (TileForceFrame)te;
        PacketDispatcher.sendPacketToPlayer((Packet)new FramePacket(pack.posX, pack.posY, pack.posZ, frame.facing, frame.color).getPacket(), (Player)((Player)player));
    }

    private void handleFrameUpdate(EntityPlayer player, FramePacket pack) {
        TileEntity te = player.field_70170_p.func_72796_p(pack.posX, pack.posY, pack.posZ);
        if (te == null || !(te instanceof TileForceFrame)) {
            return;
        }
        TileForceFrame frame = (TileForceFrame)te;
        frame.setFacing(pack.facing);
        frame.setColor(pack.color);
        System.out.println("Set facing: " + pack.facing + " Set Color: " + pack.color);
    }

    private void openClipboard(EntityPlayer player, int id) {
        for (int i = 0; i < 9; ++i) {
            ItemStack tempStack = player.field_71071_by.field_70462_a[i];
            if (tempStack == null || !(tempStack.func_77973_b() instanceof ItemClipboard) || !tempStack.func_77942_o() || tempStack.func_77978_p().func_74762_e("ID") != id) continue;
            player.getEntityData().func_74775_l("DartCraft").func_74768_a("toOpen", id);
            player.openGui((Object)DartCraft.instance, 0, player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
            break;
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void renderBreak(EntityPlayer player, PacketDualInt pack) {
        if (pack.val1 < Block.field_71973_m.length) {
            Block block = Block.field_71973_m[pack.val1];
            block.addBlockDestroyEffects(player.field_70170_p, pack.posX, pack.posY, pack.posZ, pack.val2, Proxies.common.getClientInstance().field_71452_i);
        }
    }

    private void handleRenameCard(EntityPlayer player, PacketRename pack) {
        Object card = null;
        for (int i = 0; i < 9; ++i) {
            ItemStack tempStack = player.field_71071_by.field_70462_a[i];
            if (tempStack == null || !(tempStack.func_77973_b() instanceof ItemMemberCard) || tempStack.func_77978_p().func_74762_e("ID") != pack.packID) continue;
            NBTTagCompound comp = tempStack.func_77978_p();
            comp.func_74778_a("name", pack.name);
            break;
        }
    }

    private void handleSkatePacket(EntityPlayer player, FXPacket pack) {
        FXUtils.makeSkateEffects(player.field_70170_p, pack.x, pack.y, pack.z, 8);
    }

    @SideOnly(value=Side.CLIENT)
    private void handleFlightLoss(int amount) {
        NBTTagCompound dartTag = null;
        EntityClientPlayerMP player = Proxies.common.getClientInstance().field_71439_g;
        if (player != null) {
            dartTag = player.getEntityData().func_74775_l("DartCraft");
        }
        if (dartTag == null) {
            return;
        }
        int flight = dartTag.func_74762_e("flight");
        int wing = SocketHelper.getUpgradeAmount((EntityPlayer)player, "Wing")[0];
        if (flight > amount * 100) {
            dartTag.func_74768_a("flight", flight - amount * 100);
            DartCraftCore.armorHandler.penalty = 37;
        } else {
            System.out.println("Client: Flight depleted.");
            dartTag.func_74768_a("flight", 0);
            int damage = (int)((float)amount * 0.5f - 1.5f);
            if (flight > 0) {
                damage -= (int)((float)flight / 200.0f);
            }
            if (DartCraftCore.armorHandler.penalty <= 0) {
                PacketDispatcher.sendPacketToServer((Packet)new FXPacket(24, player.field_70165_t, player.field_70163_u, player.field_70161_v).getPacket());
            }
            DartCraftCore.armorHandler.penalty = 150;
            if (damage > 0) {
                PacketDispatcher.sendPacketToServer((Packet)new PacketRename(46, damage, 0, player.field_71092_bJ).getPacket());
            }
        }
    }

    private void handleFallDamage(String name, int amount) {
        WorldServer[] servers;
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        for (WorldServer serv : servers = server.field_71305_c) {
            if (serv == null || serv.field_73010_i == null) continue;
            for (EntityPlayerMP player : serv.field_73010_i) {
                if (player == null || !player.field_71092_bJ.equals(name)) continue;
                player.field_70172_ad = 0;
                player.func_70097_a((DamageSource)DartFallDamage.instance, amount);
                return;
            }
        }
    }

    private void handleClipGrab(EntityPlayer player, PacketNBT packet) {
        if (player == null || packet == null || packet.comp == null) {
            return;
        }
        int id = packet.comp.func_74762_e("ID");
        if (player.field_71070_bA != null && player.field_71070_bA instanceof ContainerClipboard) {
            ContainerClipboard clip = (ContainerClipboard)player.field_71070_bA;
            ItemStack[] items = InventoryUtils.readItemsFromNBT(packet.comp);
            if (items != null) {
                clip.grabItems(items);
            }
        }
    }
}

