/*
 * Decompiled with CFR 0.152.
 */
package bluedart.core.network;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;

public class DartPacket {
    public static final int RENAME_SAVE = 1;
    public static final int CLIP_CLEAR = 2;
    public static final int CLIP_DIST = 3;
    public static final int CLIP_BALANCE = 4;
    public static final int INFUSER_GO = 5;
    public static final int DESOCKET = 18;
    public static final int RENAME_ROD = 32;
    public static final int RENAME_BELT = 34;
    public static final int OPEN_BELT = 37;
    public static final int OPEN_ENDER = 38;
    public static final int OPEN_CLIPBOARD = 39;
    public static final int RENAME_CARD = 41;
    public static final int CLIP_GRAB = 47;
    public static final int FX_CHANGE = 6;
    public static final int FX_ENDER = 7;
    public static final int FX_WING = 8;
    public static final int FX_WING2 = 15;
    public static final int FX_FELL = 14;
    public static final int FX_FIRE = 16;
    public static final int FX_BREAK = 17;
    public static final int FX_DISNEY = 19;
    public static final int FX_DISNEY2 = 20;
    public static final int FX_DISNEY3 = 21;
    public static final int METER_DEPLETE = 24;
    public static final int FX_FLY = 25;
    public static final int FX_FLY2 = 26;
    public static final int FX_CHANGE2 = 27;
    public static final int FX_BREAK2 = 40;
    public static final int FX_DISNEY4 = 42;
    public static final int FX_SKATE = 43;
    public static final int FX_SKATE2 = 44;
    public static final int ITEM_DESTROY = 9;
    public static final int BELT_USE = 33;
    public static final int FRAME_UPDATE = 35;
    public static final int TRIGGER_FRAME_UPDATE = 36;
    public static final int RESET_FALL = 10;
    public static final int FLIGHT_ENABLE = 22;
    public static final int FLIGHT_DISABLE = 23;
    public static final int FLIGHT_LOSS = 45;
    public static final int FLIGHT_DAMAGE = 46;
    protected int id;
    protected String channel = "DartCraft";
    protected boolean isChunkDataPacket = false;

    public DartPacket() {
    }

    public DartPacket(int id) {
        this.id = id;
    }

    public Packet getPacket() {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(bytes);
        try {
            data.writeByte(this.getID());
            this.writeData(data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Packet250CustomPayload packet = new Packet250CustomPayload();
        packet.field_73630_a = this.channel;
        packet.field_73629_c = bytes.toByteArray();
        packet.field_73628_b = packet.field_73629_c.length;
        packet.field_73287_r = this.isChunkDataPacket;
        return packet;
    }

    public int getID() {
        return this.id;
    }

    protected ItemStack readItemStack(DataInputStream data) throws IOException {
        ItemStack itemstack = null;
        short itemID = data.readShort();
        if (itemID >= 0) {
            byte stackSize = data.readByte();
            short meta = data.readShort();
            itemstack = new ItemStack((int)itemID, (int)stackSize, (int)meta);
            if (Item.field_77698_e[itemID].func_77645_m() || Item.field_77698_e[itemID].func_77651_p()) {
                itemstack.field_77990_d = this.readNBTTagCompound(data);
            }
        }
        return itemstack;
    }

    protected void writeItemStack(ItemStack itemstack, DataOutputStream data) throws IOException {
        if (itemstack == null) {
            data.writeShort(-1);
        } else {
            data.writeShort(itemstack.field_77993_c);
            data.writeByte(itemstack.field_77994_a);
            data.writeShort(itemstack.func_77960_j());
            if (itemstack.func_77973_b().func_77645_m() || itemstack.func_77973_b().func_77651_p()) {
                this.writeNBTTagCompound(itemstack.field_77990_d, data);
            }
        }
    }

    protected NBTTagCompound readNBTTagCompound(DataInputStream data) throws IOException {
        short length = data.readShort();
        if (length < 0) {
            return null;
        }
        byte[] compressed = new byte[length];
        data.readFully(compressed);
        return CompressedStreamTools.func_74792_a((byte[])compressed);
    }

    protected void writeNBTTagCompound(NBTTagCompound nbttagcompound, DataOutputStream data) throws IOException {
        if (nbttagcompound == null) {
            data.writeShort(-1);
        } else {
            byte[] compressed = CompressedStreamTools.func_74798_a((NBTTagCompound)nbttagcompound);
            data.writeShort((short)compressed.length);
            data.write(compressed);
        }
    }

    public void writeData(DataOutputStream data) throws IOException {
    }

    public void readData(DataInputStream data) throws IOException {
    }
}

