/*
 * Decompiled with CFR 0.152.
 */
package bluedart.core;

import bluedart.block.DartBlock;
import bluedart.core.Config;
import bluedart.core.DartGenMinable;
import cpw.mods.fml.common.IWorldGenerator;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;

public class DartWorldGen
implements IWorldGenerator {
    WorldGenMinable powerMinable;
    DartGenMinable netherMinable;

    public DartWorldGen() {
        this.powerMinable = new WorldGenMinable(DartBlock.powerOre.field_71990_ca, Config.powerOreFreq);
        this.netherMinable = new DartGenMinable(DartBlock.powerOre.field_71990_ca, 1, Config.powerOreFreq);
    }

    public void generate(Random rand, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (!Config.regenOre) {
            this.doGeneration(rand, chunkX, chunkZ, world);
        }
    }

    public void doGeneration(Random rand, int chunkX, int chunkZ, World world) {
        if (world.field_73011_w.field_76574_g == -1 && Config.generateNetherOre) {
            this.generateNether(rand, chunkX, chunkZ, world);
            return;
        }
        if (world.field_73011_w.field_76574_g == 1) {
            return;
        }
        if (Config.generateOre) {
            this.normalGen(rand, chunkX, chunkZ, world);
        }
    }

    public void generateNether(Random rand, int chunkX, int chunkZ, World world) {
        for (int i = 0; i < (int)((double)Config.powerOreRarity * Config.netherFreq); ++i) {
            int posx = chunkX * 16 + rand.nextInt(16);
            int posy = rand.nextInt(128);
            int posz = chunkZ * 16 + rand.nextInt(16);
            this.netherMinable.func_76484_a(world, rand, posx, posy, posz);
        }
    }

    public void normalGen(Random rand, int chunkX, int chunkZ, World world) {
        for (int i = 0; i < Config.powerOreRarity; ++i) {
            int posx = chunkX * 16 + rand.nextInt(16);
            int posy = rand.nextInt(Config.powerOreSpawnHeight);
            int posz = chunkZ * 16 + rand.nextInt(16);
            this.powerMinable.func_76484_a(world, rand, posx, posy, posz);
        }
    }
}

