/*
 * Decompiled with CFR 0.152.
 */
package bluedart.core;

import bluedart.DartCraft;
import bluedart.api.DartAPI;
import bluedart.api.EngineLiquid;
import bluedart.api.ForceEngineLiquids;
import bluedart.api.ForceUpgradeManager;
import bluedart.api.IMagneticBlock;
import bluedart.api.UpgradeMaterialHelper;
import bluedart.block.BlockDartPlant;
import bluedart.block.BlockForceBrick;
import bluedart.block.BlockForceEngine;
import bluedart.block.BlockForceInfuser;
import bluedart.block.BlockForceLeaves;
import bluedart.block.BlockForceLog;
import bluedart.block.BlockForceSlab;
import bluedart.block.BlockForceStairs;
import bluedart.block.BlockPowerOre;
import bluedart.block.DartBlock;
import bluedart.block.MultiBlockBrick;
import bluedart.block.MultiBlockOre;
import bluedart.block.MultiBlockSlab;
import bluedart.block.MultiBlockStairs;
import bluedart.block.MultiBlockWood;
import bluedart.core.Config;
import bluedart.core.DartWorldGen;
import bluedart.core.RegenTicker;
import bluedart.core.cheats.CommandCheatBottles;
import bluedart.core.cheats.CommandCheatDartChest;
import bluedart.core.cheats.CommandCheatExpTome;
import bluedart.core.cheats.CommandCheatTots;
import bluedart.core.cheats.CommandCheatUpgradeTome;
import bluedart.core.cheats.CommandPunish;
import bluedart.core.cheats.CommandSpawnLoot;
import bluedart.entity.EntityAngryEnderman;
import bluedart.entity.EntityColdChicken;
import bluedart.entity.EntityColdCow;
import bluedart.entity.EntityEnderTot;
import bluedart.entity.EntityEntityBottle;
import bluedart.entity.EntityInvincibleItem;
import bluedart.handlers.BoneMealHandler;
import bluedart.handlers.CardHandler;
import bluedart.handlers.DestroyToolHandler;
import bluedart.handlers.EntityEventHandler;
import bluedart.handlers.FuelHandler;
import bluedart.handlers.GuiHandler;
import bluedart.handlers.MilkWatcher;
import bluedart.handlers.PlayerEventHandler;
import bluedart.handlers.PunishHandler;
import bluedart.handlers.RegenHandler;
import bluedart.handlers.ShearHandler;
import bluedart.handlers.SoundLoadHandler;
import bluedart.integration.ArsMagicaIntegration;
import bluedart.integration.BuildCraftIntegration;
import bluedart.integration.ExtraBeesIntegration;
import bluedart.integration.FactorizationIntegration;
import bluedart.integration.ForestryIntegration;
import bluedart.integration.IC2Integration;
import bluedart.integration.IronChestIntegration;
import bluedart.integration.RailCraftIntegration;
import bluedart.integration.SoulShardsIntegration;
import bluedart.integration.ThaumCraftIntegration;
import bluedart.integration.ThermalExpansionIntegration;
import bluedart.integration.TinkerIntegration;
import bluedart.integration.TwilightForestIntegration;
import bluedart.item.DartItem;
import bluedart.item.ItemCrate;
import bluedart.item.ItemDartFood;
import bluedart.item.ItemEntityBottle;
import bluedart.item.ItemForceArmor;
import bluedart.item.ItemForceFlask;
import bluedart.item.ItemForceTome;
import bluedart.item.ItemFortune;
import bluedart.item.ItemFortuneCookie;
import bluedart.item.ItemInertCore;
import bluedart.item.ItemLiquidForce;
import bluedart.item.ItemSoulWafer;
import bluedart.item.ItemTear;
import bluedart.item.ItemTileBox;
import bluedart.item.ItemUpgradeCore;
import bluedart.item.tool.ItemClipboard;
import bluedart.item.tool.ItemEnderPack;
import bluedart.item.tool.ItemForceAxe;
import bluedart.item.tool.ItemForceBelt;
import bluedart.item.tool.ItemForceBow;
import bluedart.item.tool.ItemForceMitts;
import bluedart.item.tool.ItemForcePack;
import bluedart.item.tool.ItemForcePickaxe;
import bluedart.item.tool.ItemForceRod;
import bluedart.item.tool.ItemForceShears;
import bluedart.item.tool.ItemForceSpade;
import bluedart.item.tool.ItemForceSword;
import bluedart.item.tool.ItemForceWrench;
import bluedart.item.tool.ItemLootBag;
import bluedart.item.tool.ItemMagnet;
import bluedart.item.tool.ItemMemberCard;
import bluedart.item.tool.ItemPowerDrill;
import bluedart.item.tool.ItemPowerSaw;
import bluedart.proxy.Proxies;
import bluedart.tile.TileEntityForceEngine;
import bluedart.tile.TileEntityForceInfuser;
import bluedart.tile.TileEntityStairs;
import bluedart.utils.FortuneMaker;
import bluedart.utils.TomeUtils;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.IFuelHandler;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.command.ICommand;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityDragonPart;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityCommandBlock;
import net.minecraft.tileentity.TileEntityComparator;
import net.minecraft.tileentity.TileEntityDaylightDetector;
import net.minecraft.tileentity.TileEntityEnchantmentTable;
import net.minecraft.tileentity.TileEntityEndPortal;
import net.minecraft.tileentity.TileEntityEnderChest;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.liquids.LiquidContainerData;
import net.minecraftforge.liquids.LiquidContainerRegistry;
import net.minecraftforge.liquids.LiquidDictionary;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class DartCraftCore {
    public static PlayerEventHandler armorHandler = new PlayerEventHandler();
    public static File configDir;

    public boolean isSimulating(World world) {
        return true;
    }

    public Minecraft getClientInstance() {
        return FMLClientHandler.instance().getClient();
    }

    public void preInit(File sourceFile, Object mod) {
        configDir = sourceFile;
        DartCraft.dartLog.info("DartCraft Beta 0.1.20 Initializing.");
        DartCraft.dartLog.info("by: bluedart");
        DartAPI.instance = mod;
        DartAPI.fum = new ForceUpgradeManager();
        DartAPI.umh = new UpgradeMaterialHelper();
        DartAPI.leeYang = new FortuneMaker();
        DartAPI.leeYang.init();
        MinecraftForge.EVENT_BUS.register((Object)new SoundLoadHandler());
        MinecraftForge.EVENT_BUS.register((Object)new EntityEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new PunishHandler());
        MinecraftForge.EVENT_BUS.register((Object)new DestroyToolHandler());
        MinecraftForge.EVENT_BUS.register((Object)new RegenHandler());
        MinecraftForge.EVENT_BUS.register((Object)new BoneMealHandler());
        MinecraftForge.EVENT_BUS.register((Object)new MilkWatcher());
        MinecraftForge.EVENT_BUS.register((Object)new ShearHandler());
        MinecraftForge.EVENT_BUS.register((Object)new CardHandler());
    }

    public void init(Object mod) {
        Config.load(configDir);
        this.loadBlocks();
        this.loadItems();
        this.loadRecipes();
        this.loadEntities();
        OreDictionary.registerOre((String)"gemForce", (ItemStack)new ItemStack((Item)DartItem.gemForce));
        OreDictionary.registerOre((String)"ingotForce", (ItemStack)new ItemStack((Item)DartItem.ingotForce));
        OreDictionary.registerOre((String)"logWood", (ItemStack)new ItemStack(DartBlock.forceLog, 1, 0));
        OreDictionary.registerOre((String)"plankWood", (ItemStack)new ItemStack(DartBlock.forceLog, 1, 1));
        OreDictionary.registerOre((String)"treeSapling", (ItemStack)new ItemStack(DartBlock.forceSapling));
        OreDictionary.registerOre((String)"treeLeaves", (ItemStack)new ItemStack(DartBlock.forceLeaves));
        OreDictionary.registerOre((String)"stickWood", (ItemStack)new ItemStack((Item)DartItem.forceStick));
        OreDictionary.registerOre((String)"itemTear", (ItemStack)new ItemStack((Item)DartItem.tear));
        OreDictionary.registerOre((String)"itemTear", (ItemStack)new ItemStack(Item.field_77732_bp));
        OreDictionary.registerOre((String)"itemClaw", (ItemStack)new ItemStack((Item)DartItem.claw));
        this.loadForgeRecipes();
        DartItem.liquidStack = LiquidDictionary.getOrCreateLiquid((String)"liquidForce", (LiquidStack)new LiquidStack(DartItem.liquidForce.field_77779_bT, 1000));
        LiquidContainerRegistry.registerLiquid((LiquidContainerData)new LiquidContainerData(DartItem.liquidStack, new ItemStack((Item)DartItem.forceBucket, 1), LiquidContainerRegistry.EMPTY_BUCKET));
        this.loadDungeonItems();
        NBTTagCompound comp = new NBTTagCompound();
        comp.func_74768_a("stored", 1337);
        comp.func_74768_a("type", 2);
        ItemStack lootStack = new ItemStack((Item)DartItem.forceTome, 1);
        lootStack.func_77982_d(comp);
        DartCraft.dartGen = new DartWorldGen();
        GameRegistry.registerWorldGenerator((IWorldGenerator)DartCraft.dartGen);
        GameRegistry.registerFuelHandler((IFuelHandler)new FuelHandler());
        NetworkRegistry.instance().registerGuiHandler((Object)DartCraft.instance, (IGuiHandler)new GuiHandler());
        MinecraftForge.setToolClass((Item)DartItem.forcePick, (String)"pickaxe", (int)10);
        MinecraftForge.setToolClass((Item)DartItem.powerDrill, (String)"shovel", (int)10);
        MinecraftForge.setToolClass((Item)DartItem.powerDrill, (String)"pickaxe", (int)10);
        MinecraftForge.setToolClass((Item)DartItem.forceAxe, (String)"axe", (int)10);
        MinecraftForge.setToolClass((Item)DartItem.powerSaw, (String)"axe", (int)10);
        DartAPI.fum.initialize();
    }

    public void postInit() {
        ItemStack smeltResult;
        this.loadXyStuff();
        if (Loader.isModLoaded((String)"BuildCraft|Core")) {
            this.loadBCIntegration();
        }
        if (Config.forestryIntegration && Loader.isModLoaded((String)"Forestry")) {
            this.loadForestryIntegration();
        }
        if (Loader.isModLoaded((String)"ExtraBees")) {
            ExtraBeesIntegration.load();
        }
        if (Config.IC2Integration && Loader.isModLoaded((String)"IC2")) {
            this.loadIC2Integration();
        }
        if (Config.railcraftIntegration && Loader.isModLoaded((String)"Railcraft")) {
            this.loadRailcraftIntegration();
        }
        if (Config.TEIntegration && Loader.isModLoaded((String)"ThermalExpansion")) {
            this.loadTEIntegration();
        }
        if (Config.thaumcraftIntegration && Loader.isModLoaded((String)"Thaumcraft")) {
            this.loadThaumcraftIntegration();
        }
        if (Loader.isModLoaded((String)"factorization")) {
            this.loadFactorizationIntegration();
        }
        if (Loader.isModLoaded((String)"IronChest")) {
            IronChestIntegration.load();
        }
        if (Loader.isModLoaded((String)"TwilightForest")) {
            TwilightForestIntegration.load();
        }
        if (Loader.isModLoaded((String)"ArsMagica")) {
            ArsMagicaIntegration.load();
        }
        if (Loader.isModLoaded((String)"SoulShards")) {
            SoulShardsIntegration.load();
        }
        if (Loader.isModLoaded((String)"TConstruct")) {
            TinkerIntegration.load();
        }
        MinecraftForge.EVENT_BUS.register((Object)armorHandler);
        DartAPI.blacklistEntity(EntityDragon.class);
        DartAPI.blacklistEntity(EntityDragonPart.class);
        if (DartItem.dustSilver != null && (smeltResult = FurnaceRecipes.func_77602_a().getSmeltingResult(new ItemStack(DartItem.dustSilver.field_77993_c, 1, DartItem.dustSilver.func_77960_j()))) != null) {
            smeltResult.field_77994_a = 1;
        }
        if (DartItem.milkContainer != null) {
            for (int i = 0; i < 3; ++i) {
                Proxies.common.addRecipe(new ItemStack(Item.field_77746_aZ), new Object[]{"MMM", "SES", "WWW", Character.valueOf('M'), new ItemStack(DartItem.milkContainer, 1, i), Character.valueOf('S'), Item.field_77747_aY, Character.valueOf('E'), Item.field_77764_aP, Character.valueOf('W'), Item.field_77685_T});
            }
        }
        this.loadEngineLiquids();
        this.loadTransmutes();
        this.loadSkateables();
        this.loadAttractors();
        this.loadMonsterSpawns();
        this.loadWrenchables();
        this.loadPackBlacklist();
        PunishHandler.loadImmutables();
    }

    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandCheatExpTome());
        event.registerServerCommand((ICommand)new CommandCheatUpgradeTome());
        event.registerServerCommand((ICommand)new CommandPunish());
        event.registerServerCommand((ICommand)new CommandSpawnLoot());
        event.registerServerCommand((ICommand)new CommandCheatBottles());
        event.registerServerCommand((ICommand)new CommandCheatDartChest());
        event.registerServerCommand((ICommand)new CommandCheatTots());
    }

    public void registerTickers() {
        TickRegistry.registerTickHandler((ITickHandler)new RegenTicker(), (Side)Side.SERVER);
        TickRegistry.registerTickHandler((ITickHandler)new CardHandler(), (Side)Side.SERVER);
    }

    private void loadBlocks() {
        DartBlock.powerOre = new BlockPowerOre(Config.oreBlockID);
        GameRegistry.registerBlock((Block)DartBlock.powerOre, MultiBlockOre.class, (String)"powerOre");
        MinecraftForge.setBlockHarvestLevel((Block)DartBlock.powerOre, (String)"pickaxe", (int)1);
        DartBlock.blockInfuser = new BlockForceInfuser(Config.infuserBlockID).func_71864_b("blockInfuser");
        GameRegistry.registerBlock((Block)DartBlock.blockInfuser, (String)"blockInfuser");
        MinecraftForge.setBlockHarvestLevel((Block)DartBlock.blockInfuser, (String)"pickaxe", (int)1);
        GameRegistry.registerTileEntity(TileEntityForceInfuser.class, (String)"forceInfuser");
        DartBlock.forceBrick = new BlockForceBrick(Config.forceBrickID);
        GameRegistry.registerBlock((Block)DartBlock.forceBrick, MultiBlockBrick.class, (String)"forceBrick");
        MinecraftForge.setBlockHarvestLevel((Block)DartBlock.forceBrick, (String)"pickaxe", (int)1);
        DartBlock.forceSlab = new BlockForceSlab(Config.forceSlabID, 0);
        GameRegistry.registerBlock((Block)DartBlock.forceSlab, MultiBlockSlab.class, (String)"forceSlab");
        MinecraftForge.setBlockHarvestLevel((Block)DartBlock.forceSlab, (String)"pickaxe", (int)0);
        MinecraftForge.setBlockHarvestLevel((Block)DartBlock.forceSlab, (String)"axe", (int)0);
        DartBlock.forceStairs = new BlockForceStairs(Config.forceStairsID);
        GameRegistry.registerBlock((Block)DartBlock.forceStairs, MultiBlockStairs.class, (String)"forceStairs");
        GameRegistry.registerTileEntity(TileEntityStairs.class, (String)"dartStairEntity");
        MinecraftForge.setBlockHarvestLevel((Block)DartBlock.forceStairs, (String)"pickaxe", (int)0);
        MinecraftForge.setBlockHarvestLevel((Block)DartBlock.forceStairs, (String)"axe", (int)0);
        DartBlock.forceLog = new BlockForceLog(Config.forceLogID);
        GameRegistry.registerBlock((Block)DartBlock.forceLog, MultiBlockWood.class, (String)"forceLog");
        DartBlock.forceLeaves = new BlockForceLeaves(Config.forceLeavesID);
        GameRegistry.registerBlock((Block)DartBlock.forceLeaves, (String)"forceLeaves");
        DartBlock.forceSapling = new BlockDartPlant(Config.forceSaplingID).func_71864_b("forceSapling");
        GameRegistry.registerBlock((Block)DartBlock.forceSapling, (String)"forceSapling");
        DartBlock.forceEngine = new BlockForceEngine(Config.forceEngineID).func_71864_b("forceEngine");
        GameRegistry.registerBlock((Block)DartBlock.forceEngine, (String)"forceEngine");
        MinecraftForge.setBlockHarvestLevel((Block)DartBlock.forceEngine, (String)"pickaxe", (int)1);
        GameRegistry.registerTileEntity(TileEntityForceEngine.class, (String)"forceEngine");
    }

    private void loadItems() {
        DartItem.gemForce = new DartItem(Config.gemID).setUnlocalizedName("gemForce");
        DartItem.forceShard = new DartItem(Config.shardID).setUnlocalizedName("forceShard");
        DartItem.ingotForce = new DartItem(Config.ingotID).setUnlocalizedName("ingotForce");
        DartItem.forceNugget = new DartItem(Config.forceNuggetID).setUnlocalizedName("nuggetForce");
        DartItem.goldenPower = new DartItem(Config.goldenPowerID).setUnlocalizedName("goldenPower");
        DartItem.clipboard = new ItemClipboard(Config.clipboardID);
        DartItem.clipboard.setUnlocalizedName("clipboard");
        DartItem.forceSword = new ItemForceSword(Config.forceSwordID).func_77655_b("forceSword");
        DartItem.enderPack = new ItemEnderPack(Config.enderPackID).setUnlocalizedName("enderPack");
        DartItem.forcePack = new ItemForcePack(Config.forcePackID).setUnlocalizedName("forcePack");
        DartItem.forceBelt = new ItemForceBelt(Config.forceBeltID);
        DartItem.forcePick = new ItemForcePickaxe(Config.forcePickID).func_77655_b("forcePickaxe");
        DartItem.forceSpade = new ItemForceSpade(Config.forceSpadeID).func_77655_b("forceSpade");
        DartItem.forceAxe = new ItemForceAxe(Config.forceAxeID).func_77655_b("forceAxe");
        DartItem.forceShears = new ItemForceShears(Config.forceShearsID).func_77655_b("forceShears");
        DartItem.forceBow = new ItemForceBow(Config.forceBowID).func_77655_b("forceBow");
        DartItem.forceArrow = new DartItem(Config.forceArrowID).setUnlocalizedName("forceArrow");
        DartItem.fortuneCookie = new ItemFortuneCookie(Config.fortuneCookieID);
        DartItem.fortuneCookie.func_77655_b("fortuneCookie");
        DartItem.fortune = new ItemFortune(Config.fortuneID);
        DartItem.memberCard = new ItemMemberCard(Config.memberCardID);
        DartItem.forceTome = new ItemForceTome(Config.forceTomeID);
        DartItem.liquidForce = new ItemLiquidForce(Config.liquidForceID);
        DartItem.forceBucket = (DartItem)new DartItem(Config.forceBucketID).setUnlocalizedName("forceBucket").func_77625_d(1).func_77642_a(LiquidContainerRegistry.EMPTY_BUCKET.func_77973_b());
        DartItem.rawLambchop = new ItemDartFood(Config.rawLambchopID, 3, 0.3f, true);
        DartItem.rawLambchop.func_77655_b("rawLambchop");
        DartItem.cookedLambchop = new ItemDartFood(Config.cookedLambchopID, 7, 0.8f, true);
        DartItem.cookedLambchop.func_77655_b("cookedLambchop");
        DartItem.cratedForceGems = (ItemCrate)new ItemCrate(Config.cratedForceGemsID).setUnlocalizedName("cratedForceGems");
        DartItem.cratedForceGems.setContained(null, new ItemStack((Item)DartItem.gemForce, 9));
        DartItem.claw = new DartItem(Config.clawID).setUnlocalizedName("itemClaw");
        DartItem.tear = new ItemTear(Config.tearID).setUnlocalizedName("itemTear");
        DartItem.inertCore = new ItemInertCore(Config.coreID);
        DartItem.forceRod = new ItemForceRod(Config.forceRodID);
        DartItem.upgradeCore = new ItemUpgradeCore(Config.upgradeCoreID);
        DartItem.forceStick = new DartItem(Config.stickID).setUnlocalizedName("forceStick");
        DartItem.forceGear = new DartItem(Config.forceGearID).setUnlocalizedName("forceGear");
        DartItem.forceWrench = new ItemForceWrench(Config.forceWrenchID);
        DartItem.forceCap = new ItemForceArmor(Config.forceCapID, 0).setUnlocalizedName("forceCap");
        DartItem.forceTunic = new ItemForceArmor(Config.forceTunicID, 1).setUnlocalizedName("forceTunic");
        DartItem.forcePants = new ItemForceArmor(Config.forcePantsID, 2).setUnlocalizedName("forcePants");
        DartItem.forceBoots = new ItemForceArmor(Config.forceBootsID, 3).setUnlocalizedName("forceBoots");
        DartItem.entityBottle = new ItemEntityBottle(Config.entityBottleID);
        DartItem.forceFlask = new ItemForceFlask(Config.forceFlaskID);
        DartItem.forceMitts = new ItemForceMitts(Config.forceMittsID).func_77655_b("forceMitts");
        DartItem.lootBag = new ItemLootBag(Config.lootBagID);
        DartItem.magnetGlove = new ItemMagnet(Config.magnetID);
        DartItem.soulWafer = new ItemSoulWafer(Config.waferID);
        DartItem.tileBox = new ItemTileBox(Config.tileBoxID);
        if (Loader.isModLoaded((String)"IC2")) {
            DartItem.powerDrill = new ItemPowerDrill(Config.powerDrillID);
            DartItem.powerSaw = new ItemPowerSaw(Config.powerSawID);
        }
    }

    private void loadEngineLiquids() {
        ForceEngineLiquids.addLiquid(new EngineLiquid(new LiquidStack(DartItem.liquidForce.field_77779_bT, 1000, 0), 0, Config.burnTimeForce, 4.0f));
        ForceEngineLiquids.addLiquid(new EngineLiquid(new LiquidStack(Block.field_71943_B, 1000), 1, 600, 2.0f));
        LiquidStack crushedIce = LiquidDictionary.getLiquid((String)"ice", (int)1000);
        if (Config.burnLava) {
            ForceEngineLiquids.addLiquid(new EngineLiquid(new LiquidStack(Block.field_71938_D, 1000), 0, 20000, 0.5f));
        }
        if (crushedIce != null) {
            ForceEngineLiquids.addLiquid(new EngineLiquid(crushedIce, 1, 20000, 4.0f));
        }
        LiquidStack milk = LiquidDictionary.getLiquid((String)"milk", (int)1000);
        if (Config.burnMilk && milk != null) {
            ForceEngineLiquids.addLiquid(new EngineLiquid(milk, 1, 3000, 2.5f));
        }
        LiquidStack oil = LiquidDictionary.getLiquid((String)"Oil", (int)1000);
        if (Config.burnOil && oil != null) {
            ForceEngineLiquids.addLiquid(new EngineLiquid(oil, 0, 20000, 1.5f));
        }
        LiquidStack fuel = LiquidDictionary.getLiquid((String)"Fuel", (int)1000);
        if (Config.burnFuel && fuel != null) {
            ForceEngineLiquids.addLiquid(new EngineLiquid(fuel, 0, 100000, 3.0f));
        }
        LiquidStack bioFuel = LiquidDictionary.getLiquid((String)"biofuel", (int)1000);
        if (Config.burnBiofuel && bioFuel != null) {
            ForceEngineLiquids.addLiquid(new EngineLiquid(bioFuel, 0, 60000, 2.0f));
        }
        LiquidStack ethanol = LiquidDictionary.getLiquid((String)"ethanol", (int)1000);
        if (Config.burnBiofuel && ethanol != null) {
            ForceEngineLiquids.addLiquid(new EngineLiquid(ethanol, 0, 60000, 2.0f));
        }
    }

    private void loadTransmutes() {
        ItemStack tomeStack = new ItemStack((Item)DartItem.forceTome);
        tomeStack.func_77982_d(TomeUtils.initUpgradeComp(false));
        DartAPI.addForceTransmutation(new ItemStack(Item.field_77760_aL), tomeStack, 1, false);
        DartAPI.addForceTransmutation(new ItemStack((Item)Item.field_77707_k), new ItemStack(Item.field_77683_K), 1, true);
        DartAPI.addForceTransmutation(new ItemStack(Block.field_72007_bm), new ItemStack(DartBlock.forceBrick, 1, 11), 64, true);
        DartAPI.addForceTransmutation(new ItemStack(Item.field_77719_y), new ItemStack(Item.field_77669_D), 1, true);
        DartAPI.addForceTransmutation(new ItemStack(Item.field_77720_x), new ItemStack(Item.field_77669_D), 1, true);
        DartAPI.addForceTransmutation(new ItemStack(Item.field_77710_w), new ItemStack(Item.field_77669_D), 1, true);
        DartAPI.addForceTransmutation(new ItemStack(Item.field_77679_O), new ItemStack(Item.field_77669_D), 1, true);
        DartAPI.addForceTransmutation(new ItemStack(Item.field_77711_v), new ItemStack(Item.field_77669_D), 1, true);
        DartAPI.addForceTransmutation(new ItemStack(Item.field_77712_u), new ItemStack(Item.field_77669_D), 1, true);
        DartAPI.addForceTransmutation(new ItemStack(Item.field_77713_t), new ItemStack(Item.field_77669_D), 1, true);
        DartAPI.addForceTransmutation(new ItemStack(Item.field_77714_s), new ItemStack(Item.field_77669_D), 1, true);
        DartAPI.addForceTransmutation(new ItemStack(Item.field_77678_N), new ItemStack(Item.field_77669_D), 1, true);
        DartAPI.addForceTransmutation(new ItemStack(Item.field_77715_r), new ItemStack(Item.field_77669_D), 1, true);
        DartAPI.addForceTransmutation(new ItemStack((Block)Block.field_72097_ad), new ItemStack((Block)Block.field_72107_ae), 64, false);
        DartAPI.addForceTransmutation(new ItemStack((Block)Block.field_72107_ae), new ItemStack((Block)Block.field_72097_ad), 64, false);
        DartAPI.addForceTransmutation(new ItemStack((Block)Block.field_72109_af), new ItemStack((Block)Block.field_72103_ag), 64, false);
        DartAPI.addForceTransmutation(new ItemStack((Block)Block.field_72103_ag), new ItemStack((Block)Block.field_72109_af), 64, false);
        DartAPI.addForceTransmutation(new ItemStack(Item.field_77752_aS), new ItemStack(Item.field_77717_p, 4), 64, false);
        DartAPI.addForceTransmutation(new ItemStack((Item)Item.field_77687_V), new ItemStack((Item)DartItem.forceCap), 1, true);
        DartAPI.addForceTransmutation(new ItemStack((Item)Item.field_77686_W), new ItemStack((Item)DartItem.forceTunic), 1, true);
        DartAPI.addForceTransmutation(new ItemStack((Item)Item.field_77693_X), new ItemStack((Item)DartItem.forcePants), 1, true);
        DartAPI.addForceTransmutation(new ItemStack((Item)Item.field_77692_Y), new ItemStack((Item)DartItem.forceBoots), 1, true);
        DartAPI.addForceTransmutation(new ItemStack(DartItem.fortuneCookie), new ItemStack((Item)DartItem.fortune), 16, false);
        DartAPI.addForceTransmutation(new ItemStack(DartItem.forceSword), new ItemStack((Item)DartItem.forceShard), 1, true);
        DartAPI.addForceTransmutation(new ItemStack(DartItem.forcePick), new ItemStack((Item)DartItem.forceShard), 1, true);
        DartAPI.addForceTransmutation(new ItemStack(DartItem.forceSpade), new ItemStack((Item)DartItem.forceShard), 1, true);
        DartAPI.addForceTransmutation(new ItemStack(DartItem.forceAxe), new ItemStack((Item)DartItem.forceShard), 1, true);
        DartAPI.addForceTransmutation(new ItemStack(DartItem.forceShears), new ItemStack((Item)DartItem.forceShard), 1, true);
        DartAPI.addForceTransmutation(new ItemStack(DartItem.forceBow), new ItemStack((Item)DartItem.forceShard), 1, true);
        DartAPI.addForceTransmutation(new ItemStack(Item.field_77696_g), new ItemStack(Item.field_77703_o, 2), 1, true);
        DartAPI.addForceTransmutation(new ItemStack(Item.field_77716_q), new ItemStack(Item.field_77703_o, 1), 1, true);
        DartAPI.addForceTransmutation(new ItemStack(Item.field_77695_f), new ItemStack(Item.field_77703_o, 1), 1, true);
        DartAPI.addForceTransmutation(new ItemStack(Item.field_77689_P), new ItemStack(Item.field_77703_o, 1), 1, true);
        DartAPI.addForceTransmutation(new ItemStack(Item.field_77766_aB), new ItemStack(Item.field_77703_o, 6), 1, false);
        DartAPI.addForceTransmutation(new ItemStack(Item.field_77721_bz), new ItemStack(Item.field_77703_o, 7), 64, false);
        DartAPI.addForceTransmutation(new ItemStack(Item.field_77773_az), new ItemStack(Item.field_77703_o, 5), 3, false);
        DartAPI.addForceTransmutation(new ItemStack(Item.field_77788_aw), new ItemStack(Item.field_77703_o, 3), 16, false);
        DartAPI.addForceTransmutation(new ItemStack((Item)Item.field_77812_ad), new ItemStack(Item.field_77703_o, 4), 1, true);
        DartAPI.addForceTransmutation(new ItemStack((Item)Item.field_77822_ae), new ItemStack(Item.field_77703_o, 7), 1, true);
        DartAPI.addForceTransmutation(new ItemStack((Item)Item.field_77824_af), new ItemStack(Item.field_77703_o, 6), 1, true);
        DartAPI.addForceTransmutation(new ItemStack((Item)Item.field_77818_ag), new ItemStack(Item.field_77703_o, 3), 1, true);
        DartAPI.addForceTransmutation(new ItemStack((Item)Item.field_77796_al), new ItemStack(Item.field_77717_p, 5), 1, true);
        DartAPI.addForceTransmutation(new ItemStack((Item)Item.field_77806_am), new ItemStack(Item.field_77717_p, 8), 1, true);
        DartAPI.addForceTransmutation(new ItemStack((Item)Item.field_77808_an), new ItemStack(Item.field_77717_p, 7), 1, true);
        DartAPI.addForceTransmutation(new ItemStack((Item)Item.field_77802_ao), new ItemStack(Item.field_77717_p, 4), 1, true);
        DartAPI.addForceTransmutation(new ItemStack(Item.field_77672_G), new ItemStack(Item.field_77717_p, 2), 1, true);
        DartAPI.addForceTransmutation(new ItemStack(Item.field_77681_I), new ItemStack(Item.field_77717_p, 3), 1, true);
        DartAPI.addForceTransmutation(new ItemStack(Item.field_77682_J), new ItemStack(Item.field_77717_p, 3), 1, true);
        DartAPI.addForceTransmutation(new ItemStack(Item.field_77680_H), new ItemStack(Item.field_77717_p, 1), 1, true);
        DartAPI.addForceTransmutation(new ItemStack(Item.field_77691_R), new ItemStack(Item.field_77717_p, 2), 1, true);
        DartAPI.addForceTransmutation(new ItemStack((Item)Item.field_77694_Z), new ItemStack(Item.field_77703_o, 3), 1, true);
        DartAPI.addForceTransmutation(new ItemStack((Item)Item.field_77814_aa), new ItemStack(Item.field_77703_o, 6), 1, true);
        DartAPI.addForceTransmutation(new ItemStack((Item)Item.field_77816_ab), new ItemStack(Item.field_77703_o, 4), 1, true);
        DartAPI.addForceTransmutation(new ItemStack((Item)Item.field_77810_ac), new ItemStack(Item.field_77703_o, 2), 1, true);
        DartAPI.addForceTransmutation(new ItemStack(Block.field_82510_ck), new ItemStack(Item.field_77703_o, 31), 1, true);
        if (DartItem.forestryBronze != null) {
            if (DartItem.bronzeSword != null) {
                DartAPI.addForceTransmutation(DartItem.bronzeSword, new ItemStack(DartItem.forestryBronze.func_77973_b(), 1), 1, true);
            }
            if (DartItem.bronzePick != null) {
                DartAPI.addForceTransmutation(DartItem.bronzePick, new ItemStack(DartItem.forestryBronze.func_77973_b(), 2), 1, true);
            }
            if (DartItem.bronzeShovel != null) {
                DartAPI.addForceTransmutation(DartItem.bronzeShovel, new ItemStack(DartItem.forestryBronze.func_77973_b(), 1), 1, true);
            }
            if (DartItem.bronzeAxe != null) {
                DartAPI.addForceTransmutation(DartItem.bronzeAxe, new ItemStack(DartItem.forestryBronze.func_77973_b(), 3), 1, true);
            }
            if (DartItem.bronzeHoe != null) {
                DartAPI.addForceTransmutation(DartItem.bronzeHoe, new ItemStack(DartItem.forestryBronze.func_77973_b(), 2), 1, true);
            }
            if (DartItem.bronzeHelm != null) {
                DartAPI.addForceTransmutation(DartItem.bronzeHelm, new ItemStack(DartItem.forestryBronze.func_77973_b(), 4), 1, true);
            }
            if (DartItem.bronzeChest != null) {
                DartAPI.addForceTransmutation(DartItem.bronzeChest, new ItemStack(DartItem.forestryBronze.func_77973_b(), 7), 1, true);
            }
            if (DartItem.bronzeLegs != null) {
                DartAPI.addForceTransmutation(DartItem.bronzeLegs, new ItemStack(DartItem.forestryBronze.func_77973_b(), 6), 1, true);
            }
            if (DartItem.bronzeBoots != null) {
                DartAPI.addForceTransmutation(DartItem.bronzeBoots, new ItemStack(DartItem.forestryBronze.func_77973_b(), 3), 1, true);
            }
        }
        if (DartItem.railcraftSteel != null) {
            if (DartItem.steelSword != null) {
                DartAPI.addForceTransmutation(DartItem.steelSword, new ItemStack(DartItem.railcraftSteel.func_77973_b(), 2), 1, true);
            }
            if (DartItem.steelPick != null) {
                DartAPI.addForceTransmutation(DartItem.steelPick, new ItemStack(DartItem.railcraftSteel.func_77973_b(), 3), 1, true);
            }
            if (DartItem.steelShovel != null) {
                DartAPI.addForceTransmutation(DartItem.steelShovel, new ItemStack(DartItem.railcraftSteel.func_77973_b(), 1), 1, true);
            }
            if (DartItem.steelAxe != null) {
                DartAPI.addForceTransmutation(DartItem.steelAxe, new ItemStack(DartItem.railcraftSteel.func_77973_b(), 3), 1, true);
            }
            if (DartItem.steelHoe != null) {
                DartAPI.addForceTransmutation(DartItem.steelHoe, new ItemStack(DartItem.railcraftSteel.func_77973_b(), 2), 1, true);
            }
            if (DartItem.steelHelm != null) {
                DartAPI.addForceTransmutation(DartItem.steelHelm, new ItemStack(DartItem.railcraftSteel.func_77973_b(), 5), 1, true);
            }
            if (DartItem.steelChest != null) {
                DartAPI.addForceTransmutation(DartItem.steelChest, new ItemStack(DartItem.railcraftSteel.func_77973_b(), 8), 1, true);
            }
            if (DartItem.steelLegs != null) {
                DartAPI.addForceTransmutation(DartItem.steelLegs, new ItemStack(DartItem.railcraftSteel.func_77973_b(), 7), 1, true);
            }
            if (DartItem.steelBoots != null) {
                DartAPI.addForceTransmutation(DartItem.steelBoots, new ItemStack(DartItem.railcraftSteel.func_77973_b(), 4), 1, true);
            }
        }
    }

    private void loadSkateables() {
        DartAPI.addSkateable(Block.field_71943_B);
        DartAPI.addSkateable((Block)Block.field_71942_A);
        DartAPI.addSkateable(Block.field_71938_D);
        DartAPI.addSkateable((Block)Block.field_71944_C);
    }

    private void loadAttractors() {
        DartAPI.addAttractor(new IMagneticBlock(Block.field_72083_ai.field_71990_ca, 0, 1.0f));
        DartAPI.addAttractor(new IMagneticBlock(Block.field_72105_ah.field_71990_ca, 0, 1.0f));
        DartAPI.addAttractor(new IMagneticBlock(Block.field_72071_ax.field_71990_ca, 0, 1.0f));
        DartAPI.addAttractor(new IMagneticBlock(Block.field_72076_bV.field_71990_ca, 0, 1.0f));
        DartAPI.addAttractor(new IMagneticBlock(Block.field_94341_cq.field_71990_ca, 0, 2.0f));
        DartAPI.addAttractor(new IMagneticBlock(Block.field_71948_O.field_71990_ca, 0, 2.5f));
        DartAPI.addAttractor(new IMagneticBlock(DartBlock.powerOre.field_71990_ca, 0, 3.0f));
    }

    private void loadWrenchables() {
        DartAPI.addDismantleable(Block.field_71946_M);
        DartAPI.addDismantleable(Block.field_72003_bq);
        DartAPI.addDismantleable(Block.field_72093_an);
        DartAPI.addDismantleable(Block.field_72096_bE);
        DartAPI.addDismantleable(Block.field_72066_bS);
        DartAPI.addDismantleable(Block.field_72036_aT);
        DartAPI.addDismantleable(Block.field_72084_bK);
        DartAPI.addDismantleable(Block.field_71955_W);
        DartAPI.blacklistTile(TileEntityStairs.class);
        DartAPI.blacklistTile(TileEntityEnchantmentTable.class);
        DartAPI.blacklistTile(TileEntityEnderChest.class);
        DartAPI.blacklistTile(TileEntityEndPortal.class);
        DartAPI.blacklistTile(TileEntityComparator.class);
        DartAPI.blacklistTile(TileEntityDaylightDetector.class);
        DartAPI.blacklistTile(TileEntityCommandBlock.class);
        DartAPI.blacklistTile(TileEntitySkull.class);
    }

    private void loadPackBlacklist() {
        DartItem.packBlacklist.add(new ItemStack((Item)DartItem.forceBelt));
        DartItem.packBlacklist.add(new ItemStack((Item)DartItem.clipboard));
        DartItem.packBlacklist.add(new ItemStack((Item)DartItem.forcePack));
    }

    private void loadMonsterSpawns() {
        BiomeGenBase[] allowed;
        if (Config.enderTotChance == 0 || Config.maxEnderTots == 0) {
            Config.shouldPunish = true;
            return;
        }
        for (BiomeGenBase biome : allowed = new BiomeGenBase[]{BiomeGenBase.field_76787_r, BiomeGenBase.field_76769_d, BiomeGenBase.field_76786_s, BiomeGenBase.field_76770_e, BiomeGenBase.field_76783_v, BiomeGenBase.field_76767_f, BiomeGenBase.field_76785_t, BiomeGenBase.field_76776_l, BiomeGenBase.field_76777_m, BiomeGenBase.field_76775_o, BiomeGenBase.field_76774_n, BiomeGenBase.field_76782_w, BiomeGenBase.field_76792_x, BiomeGenBase.field_76771_b, BiomeGenBase.field_76772_c, BiomeGenBase.field_76781_i, BiomeGenBase.field_76779_k, BiomeGenBase.field_76780_h, BiomeGenBase.field_76768_g, BiomeGenBase.field_76784_u}) {
            if (biome == null) continue;
            if (!Loader.isModLoaded((String)"TC")) {
                EntityRegistry.addSpawn((String)"enderTot", (int)Config.enderTotChance, (int)1, (int)Config.maxEnderTots, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])new BiomeGenBase[]{biome});
                continue;
            }
            EntityRegistry.addSpawn(EntityEnderTot.class, (int)Config.enderTotChance, (int)1, (int)Config.maxEnderTots, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])new BiomeGenBase[]{biome});
        }
    }

    private void loadDungeonItems() {
        ChestGenHooks dungeon;
        String[] types;
        for (String type : types = new String[]{"dungeonChest", "mineshaftCorridor", "pyramidDesertyChest", "strongholdCorridor", "pyramidJungleChest", "strongholdCrossing", "strongholdLibrary", "villageBlacksmith"}) {
            dungeon = ChestGenHooks.getInfo((String)type);
            dungeon.addItem(new WeightedRandomChestContent(new ItemStack((Item)DartItem.gemForce), 1, 8, 20));
            dungeon.addItem(new WeightedRandomChestContent(new ItemStack((Item)DartItem.forceShard), 1, 2, 20));
            dungeon.addItem(new WeightedRandomChestContent(new ItemStack((Item)DartItem.forceBucket), 1, 1, 20));
            dungeon.addItem(new WeightedRandomChestContent(new ItemStack((Item)DartItem.claw), 1, 4, 20));
            dungeon.addItem(new WeightedRandomChestContent(new ItemStack((Item)DartItem.tear), 1, 2, 10));
            dungeon.addItem(new WeightedRandomChestContent(new ItemStack(DartItem.forceMitts), 1, 1, 10));
            dungeon.addItem(new WeightedRandomChestContent(new ItemStack((Item)DartItem.lootBag), 1, 1, 10));
        }
        dungeon = ChestGenHooks.getInfo((String)"bonusChest");
        dungeon.addItem(new WeightedRandomChestContent(new ItemStack(DartItem.forceMitts), 1, 1, 20));
    }

    private void loadRecipes() {
        Proxies.common.addRecipe(new ItemStack(Block.field_71955_W), new Object[]{"S S", " B ", "S S", Character.valueOf('S'), Item.field_77683_K, Character.valueOf('B'), Item.field_77761_aM});
        Proxies.common.addRecipe(new ItemStack((Item)DartItem.forceWrench), new Object[]{"I I", " G ", " I ", Character.valueOf('I'), DartItem.ingotForce, Character.valueOf('G'), DartItem.forceGear});
        Proxies.common.addRecipe(new ItemStack((Item)DartItem.magnetGlove), new Object[]{" I ", "ISI", " I ", Character.valueOf('I'), Item.field_77703_o, Character.valueOf('S'), Item.field_82792_bS});
        Proxies.common.addRecipe(new ItemStack(DartBlock.forceBrick, 8, 11), new Object[]{"BBB", "BNB", "BBB", Character.valueOf('B'), Block.field_72007_bm, Character.valueOf('N'), DartItem.forceNugget});
        Proxies.common.addRecipe(new ItemStack(Block.field_72069_aq, 6), new Object[]{"G", "S", Character.valueOf('G'), DartItem.goldenPower, Character.valueOf('S'), Item.field_77669_D});
        Proxies.common.addShapelessRecipe(new ItemStack((Item)DartItem.ingotForce, 2), new Object[]{DartItem.gemForce, Item.field_77703_o, Item.field_77703_o});
        Proxies.common.addShapelessRecipe(new ItemStack((Item)DartItem.ingotForce, 3), new Object[]{DartItem.gemForce, Item.field_77717_p, Item.field_77717_p});
        Proxies.common.addShapelessRecipe(new ItemStack(DartItem.forceNugget, 9), new Object[]{DartItem.ingotForce});
        Proxies.common.addRecipe(new ItemStack((Item)DartItem.ingotForce, 1), new Object[]{"FFF", "FFF", "FFF", Character.valueOf('F'), DartItem.forceNugget});
        Proxies.common.addRecipe(new ItemStack(DartItem.forceSword, 1), new Object[]{"I", "I", "S", Character.valueOf('I'), DartItem.ingotForce, Character.valueOf('S'), DartItem.forceStick});
        Proxies.common.addRecipe(new ItemStack(DartItem.forceMitts), new Object[]{"CL ", "CFI", "CLL", Character.valueOf('C'), Block.field_71978_w, Character.valueOf('L'), Item.field_77770_aF, Character.valueOf('F'), DartItem.ingotForce, Character.valueOf('I'), Item.field_77703_o});
        Proxies.common.addRecipe(new ItemStack(DartItem.forcePick, 1), new Object[]{"III", " S ", " S ", Character.valueOf('I'), DartItem.ingotForce, Character.valueOf('S'), DartItem.forceStick});
        Proxies.common.addRecipe(new ItemStack(DartItem.forceSpade, 1), new Object[]{"I", "S", "S", Character.valueOf('I'), DartItem.ingotForce, Character.valueOf('S'), DartItem.forceStick});
        Proxies.common.addRecipe(new ItemStack(DartItem.forceAxe, 1), new Object[]{"II", "IS", " S", Character.valueOf('I'), DartItem.ingotForce, Character.valueOf('S'), DartItem.forceStick});
        Proxies.common.addRecipe(new ItemStack(DartItem.forceShears, 1), new Object[]{"F ", " F", Character.valueOf('F'), DartItem.ingotForce});
        Proxies.common.addRecipe(new ItemStack(DartItem.forceArrow, 6), new Object[]{"N", "S", "F", Character.valueOf('N'), DartItem.forceNugget, Character.valueOf('S'), DartItem.forceStick, Character.valueOf('F'), Item.field_77676_L});
        Proxies.common.addShapelessRecipe(new ItemStack(DartItem.fortuneCookie, 1), new Object[]{Item.field_77743_bc, Item.field_77759_aK});
        Proxies.common.addShapelessRecipe(new ItemStack(Item.field_77759_aK, 1), new Object[]{DartItem.fortune});
        Proxies.common.addRecipe(new ItemStack((Item)DartItem.forcePack, 1, 11), new Object[]{"ILI", "LCL", "ILI", Character.valueOf('L'), Item.field_77770_aF, Character.valueOf('I'), DartItem.ingotForce, Character.valueOf('C'), Block.field_72077_au});
        Proxies.common.addRecipe(new ItemStack((Item)DartItem.forceBelt, 1), new Object[]{"LWL", "FIF", "LWL", Character.valueOf('L'), Item.field_77770_aF, Character.valueOf('F'), DartItem.ingotForce, Character.valueOf('I'), Item.field_77703_o, Character.valueOf('W'), Block.field_72101_ab});
        Proxies.common.addRecipe(new ItemStack((Item)DartItem.forceFlask, 8), new Object[]{" G ", "GNG", " G ", Character.valueOf('G'), Block.field_71946_M, Character.valueOf('N'), DartItem.forceNugget});
        Proxies.common.addRecipe(new ItemStack((Item)DartItem.forceRod, 1, 48), new Object[]{"  I", " S ", "N  ", Character.valueOf('I'), DartItem.ingotForce, Character.valueOf('S'), Item.field_77669_D, Character.valueOf('N'), DartItem.forceNugget});
        Proxies.common.addRecipe(new ItemStack((Item)DartItem.forceRod), new Object[]{"  I", " S ", "N  ", Character.valueOf('I'), DartItem.ingotForce, Character.valueOf('S'), DartItem.forceStick, Character.valueOf('N'), DartItem.forceNugget});
        Proxies.common.addShapelessRecipe(new ItemStack(DartBlock.forceLog, 4, 1), new Object[]{DartBlock.forceLog});
        GameRegistry.addSmelting((int)DartItem.rawLambchop.field_77779_bT, (ItemStack)new ItemStack(DartItem.cookedLambchop, 1), (float)2.0f);
        FurnaceRecipes.func_77602_a().addSmelting(DartBlock.forceLog.field_71990_ca, 0, new ItemStack((Item)DartItem.goldenPower), 2.0f);
        GameRegistry.addSmelting((int)DartItem.entityBottle.field_77779_bT, (ItemStack)new ItemStack(DartItem.soulWafer), (float)20.0f);
        for (int i = 0; i < 16; ++i) {
            Proxies.common.addRecipe(new ItemStack(DartBlock.forceSlab, 6, i), new Object[]{"BBB", Character.valueOf('B'), new ItemStack(DartBlock.forceBrick, 1, i)});
            Proxies.common.addRecipe(new ItemStack(DartBlock.forceBrick, 1, i), new Object[]{"S", "S", Character.valueOf('S'), new ItemStack(DartBlock.forceSlab, 1, i)});
            Proxies.common.addRecipe(new ItemStack(DartBlock.forceStairs, 4, i), new Object[]{"B  ", "BB ", "BBB", Character.valueOf('B'), new ItemStack(DartBlock.forceBrick, 1, i)});
            Proxies.common.addRecipe(new ItemStack(DartBlock.forceBrick, 6, i), new Object[]{"SS", "SS", Character.valueOf('S'), new ItemStack(DartBlock.forceStairs, 1, i)});
            Proxies.common.addShapelessRecipe(new ItemStack(Block.field_72007_bm), new Object[]{new ItemStack(DartBlock.forceBrick, 1, i)});
            Proxies.common.addRecipe(new ItemStack(DartBlock.forceBrick, 8, i), new Object[]{"BBB", "BDB", "BBB", Character.valueOf('B'), DartBlock.forceBrick, Character.valueOf('D'), new ItemStack(Item.field_77756_aW, 1, i)});
        }
        Proxies.common.addRecipe(new ItemStack(DartBlock.forceStairs, 4, 16), new Object[]{"B  ", "BB ", "BBB", Character.valueOf('B'), new ItemStack(DartBlock.forceLog, 1, 1)});
        Proxies.common.addRecipe(new ItemStack(DartBlock.forceLog, 6, 1), new Object[]{"SS", "SS", Character.valueOf('S'), new ItemStack(DartBlock.forceStairs, 1, 16)});
        Proxies.common.addRecipe(new ItemStack(DartBlock.forceSlab, 6, 16), new Object[]{"BBB", Character.valueOf('B'), new ItemStack(DartBlock.forceLog, 1, 1)});
        Proxies.common.addRecipe(new ItemStack(DartBlock.forceLog, 1, 1), new Object[]{"S", "S", Character.valueOf('S'), new ItemStack(DartBlock.forceSlab, 1, 16)});
    }

    private void loadForgeRecipes() {
        List recipes = CraftingManager.func_77594_a().func_77592_b();
        recipes.add(0, new ShapedOreRecipe(new ItemStack((Item)DartItem.forceStick, 4), new Object[]{"W", "W", Character.valueOf('W'), new ItemStack(DartBlock.forceLog, 1, 1)}));
        recipes.add(0, new ShapedOreRecipe(new ItemStack(DartItem.forceBow, 1), new Object[]{" FS", "F S", " FS", Character.valueOf('F'), DartItem.forceStick, Character.valueOf('S'), Item.field_77683_K}));
        recipes.add(0, new ShapedOreRecipe(new ItemStack(DartItem.forceBow, 1), new Object[]{"SF ", "S F", "SF ", Character.valueOf('F'), DartItem.forceStick, Character.valueOf('S'), Item.field_77683_K}));
        Proxies.common.addRecipe(new ItemStack((Item)DartItem.clipboard, 1), new Object[]{"PIP", "PpP", "PpP", Character.valueOf('P'), "plankWood", Character.valueOf('I'), Item.field_77703_o, Character.valueOf('p'), Item.field_77759_aK});
        recipes.add(new ShapelessOreRecipe(new ItemStack((Item)DartItem.ingotForce, 2), new Object[]{DartItem.gemForce, "ingotBronze", "ingotBronze"}));
        recipes.add(new ShapelessOreRecipe(new ItemStack((Item)DartItem.ingotForce, 3), new Object[]{DartItem.gemForce, "ingotRefinedIron", "ingotRefinedIron"}));
        recipes.add(new ShapelessOreRecipe(new ItemStack((Item)DartItem.ingotForce, 3), new Object[]{DartItem.gemForce, "ingotSilver", "ingotSilver"}));
        recipes.add(new ShapedOreRecipe(new ItemStack((Item)DartItem.memberCard), new Object[]{"PRP", "PFP", "PBP", Character.valueOf('P'), Item.field_77759_aK, Character.valueOf('R'), "dyeRed", Character.valueOf('F'), "ingotForce", Character.valueOf('B'), "dyeBlue"}));
        recipes.add(new ShapedOreRecipe(new ItemStack((Item)DartItem.memberCard), new Object[]{"PPP", "RFB", "PPP", Character.valueOf('P'), Item.field_77759_aK, Character.valueOf('R'), "dyeRed", Character.valueOf('F'), "ingotForce", Character.valueOf('B'), "dyeBlue"}));
        recipes.add(new ShapedOreRecipe(new ItemStack((Item)DartItem.memberCard), new Object[]{"C", Character.valueOf('C'), DartItem.memberCard}));
        if (!Config.forestryIntegration || !Loader.isModLoaded((String)"Forestry") && Config.netherStarRecipe) {
            Proxies.common.addRecipe(new ItemStack((Item)DartItem.inertCore, 1), new Object[]{"STS", "CDC", "STS", Character.valueOf('S'), Block.field_72013_bc, Character.valueOf('T'), "itemTear", Character.valueOf('C'), "itemClaw", Character.valueOf('D'), Item.field_77702_n});
            Proxies.common.addRecipe(new ItemStack((Item)DartItem.inertCore, 1), new Object[]{"STS", "CDC", "STS", Character.valueOf('S'), Block.field_72013_bc, Character.valueOf('T'), "itemTear", Character.valueOf('C'), "itemClaw", Character.valueOf('D'), "gemSapphire"});
        }
        if (!Loader.isModLoaded((String)"BuildCraft|Core")) {
            recipes.add(new ShapedOreRecipe(new ItemStack((Item)DartItem.forceGear, 1), new Object[]{" F ", "FIF", " F ", Character.valueOf('F'), "ingotForce", Character.valueOf('I'), Item.field_77703_o}));
        }
        recipes.add(new ShapedOreRecipe(new ItemStack(DartBlock.forceEngine), new Object[]{"III", " G ", "FPF", Character.valueOf('I'), "ingotForce", Character.valueOf('G'), Block.field_71946_M, Character.valueOf('F'), DartItem.forceGear, Character.valueOf('P'), Block.field_71963_Z}));
        recipes.add(new ShapedOreRecipe(new ItemStack((Block)Block.field_71963_Z), new Object[]{"PPP", "CIC", "CRC", Character.valueOf('C'), Block.field_71978_w, Character.valueOf('P'), "plankWood", Character.valueOf('I'), "ingotForce", Character.valueOf('R'), Item.field_77767_aC}));
    }

    private void loadXyStuff() {
        ArrayList temp = OreDictionary.getOres((String)"xychoriditeMetal");
        if (temp != null && temp.size() > 0) {
            for (ItemStack toAdd : temp) {
                if (toAdd == null || DartItem.xychoridite.contains(toAdd)) continue;
                DartItem.xychoridite.add(toAdd);
            }
        }
        if (DartItem.xychoridite.size() > 0) {
            for (ItemStack xy : DartItem.xychoridite) {
                Proxies.common.addShapelessRecipe(new ItemStack((Item)DartItem.ingotForce, 3), new Object[]{DartItem.gemForce, xy, xy});
            }
        }
    }

    private void loadEntities() {
        EntityRegistry.registerModEntity(EntityEntityBottle.class, (String)"entityEntityBottle", (int)0, (Object)DartCraft.instance, (int)40, (int)1, (boolean)true);
        EntityRegistry.registerModEntity(EntityAngryEnderman.class, (String)"entityAngryEnderman", (int)1, (Object)DartCraft.instance, (int)40, (int)1, (boolean)true);
        if (Loader.isModLoaded((String)"TC")) {
            DartCraft.dartLog.info("Traincraft found, removing DartCraft entity eggs to avoid crash.");
            EntityRegistry.registerModEntity(EntityEnderTot.class, (String)"enderTot", (int)2, (Object)DartCraft.instance, (int)40, (int)1, (boolean)true);
            EntityRegistry.registerModEntity(EntityColdCow.class, (String)"coldCow", (int)3, (Object)DartCraft.instance, (int)40, (int)1, (boolean)true);
            EntityRegistry.registerModEntity(EntityColdChicken.class, (String)"coldChicken", (int)4, (Object)DartCraft.instance, (int)40, (int)1, (boolean)true);
        } else {
            EntityRegistry.registerGlobalEntityID(EntityColdCow.class, (String)"coldCow", (int)EntityRegistry.findGlobalUniqueEntityId(), (int)8599562, (int)7025930);
            EntityRegistry.registerGlobalEntityID(EntityColdChicken.class, (String)"coldChicken", (int)EntityRegistry.findGlobalUniqueEntityId(), (int)15299437, (int)11095622);
            EntityRegistry.registerGlobalEntityID(EntityEnderTot.class, (String)"enderTot", (int)EntityRegistry.findGlobalUniqueEntityId(), (int)0, (int)0xFFFFFF);
        }
        EntityRegistry.registerModEntity(EntityInvincibleItem.class, (String)"entityInvincibleItem", (int)5, (Object)DartCraft.instance, (int)40, (int)1, (boolean)true);
    }

    private void loadBCIntegration() {
        try {
            Class.forName("buildcraft.BuildCraftBuilders");
            Class.forName("buildcraft.BuildCraftCore");
            Class.forName("buildcraft.BuildCraftFactory");
            Class.forName("buildcraft.BuildCraftTransport");
            Class.forName("buildcraft.api.transport.FacadeManager");
            Class.forName("buildcraft.transport.BlockGenericPipe");
            Class.forName("buildcraft.transport.ItemPipe");
            Class.forName("buildcraft.transport.Pipe");
            Class.forName("buildcraft.transport.TileGenericPipe");
            Class.forName("buildcraft.transport.TransportProxy");
            BuildCraftIntegration bcIntegration = new BuildCraftIntegration();
            bcIntegration.initialize();
        }
        catch (Exception e) {
            DartCraft.dartLog.info("Could not load BuildCraft integration as the API has changed or not all modules are installed.");
        }
    }

    private void loadForestryIntegration() {
        try {
            Class.forName("forestry.api.core.BlockInterface");
            Class.forName("forestry.api.core.ItemInterface");
            Class.forName("forestry.api.recipes.RecipeManagers");
            Class.forName("forestry.api.storage.BackpackManager");
            Class.forName("forestry.core.config.ForestryItem");
            ForestryIntegration.load();
        }
        catch (Exception e) {
            DartCraft.dartLog.info("Could not load Forestry integration as the API has been changed.");
        }
    }

    private void loadIC2Integration() {
        try {
            Class.forName("ic2.api.item.Items");
            Class.forName("ic2.api.recipe.Recipes");
            IC2Integration.load();
        }
        catch (Exception e) {
            DartCraft.dartLog.info("Could not load IC2 integration as the API has been changed.");
        }
    }

    private void loadRailcraftIntegration() {
        try {
            RailCraftIntegration.load();
        }
        catch (Exception e) {
            DartCraft.dartLog.info("There was a problem loading Railcraft integration.");
        }
    }

    private void loadTEIntegration() {
        try {
            Class.forName("thermalexpansion.api.item.ItemRegistry");
            Class.forName("thermalexpansion.api.crafting.CraftingManagers");
            Class.forName("cofh.api.block.IDismantleable");
            ThermalExpansionIntegration.load();
        }
        catch (Exception e) {
            DartCraft.dartLog.info("Could not load Thermal Expansion integration as the API has been changed.");
        }
    }

    private void loadEnderStorageIntegration() {
    }

    private void loadThaumcraftIntegration() {
        try {
            Class.forName("thaumcraft.api.ThaumcraftApi");
            ThaumCraftIntegration.load();
        }
        catch (Exception e) {
            DartCraft.dartLog.info("Unable to load Thaumcraft integration as the API has changed.");
        }
    }

    private void loadFactorizationIntegration() {
        try {
            Class.forName("factorization.common.TileEntityBarrel");
            FactorizationIntegration.load();
        }
        catch (Exception e) {
            DartCraft.dartLog.info("Unable to load Factorization integration.");
        }
    }
}

