/*
 * Decompiled with CFR 0.152.
 */
package bluedart.core;

import bluedart.DartCraft;
import bluedart.block.BlockForceBrick;
import bluedart.block.BlockForceSlab;
import bluedart.block.BlockForceStairs;
import bluedart.block.DartBlock;
import bluedart.client.TabDart;
import bluedart.client.model.ModelColdChicken;
import bluedart.client.model.ModelColdCow;
import bluedart.client.model.ModelEnderTot;
import bluedart.client.renderer.RenderAngryEnderman;
import bluedart.client.renderer.RenderBlockPowerOre;
import bluedart.client.renderer.RenderColdChicken;
import bluedart.client.renderer.RenderColdCow;
import bluedart.client.renderer.RenderEnderTot;
import bluedart.client.renderer.RenderEntityEntityBottle;
import bluedart.client.renderer.RenderEntityForceProjectile;
import bluedart.client.renderer.item.RenderItemEngine;
import bluedart.client.renderer.item.RenderItemForceBow;
import bluedart.client.renderer.item.RenderItemForceFlask;
import bluedart.client.renderer.item.RenderItemForceInfuser;
import bluedart.client.renderer.item.RenderItemForceStairs;
import bluedart.client.renderer.item.RenderItemTileBox;
import bluedart.client.renderer.tile.RenderTileForceEngine;
import bluedart.client.renderer.tile.RenderTileForceFrame;
import bluedart.client.renderer.tile.RenderTileForceInfuser;
import bluedart.client.ticker.DartMacroHandler;
import bluedart.client.ticker.NEIOverlayTicker;
import bluedart.client.ticker.WingMeter;
import bluedart.core.Config;
import bluedart.core.DartCraftCore;
import bluedart.entity.EntityAngryEnderman;
import bluedart.entity.EntityColdChicken;
import bluedart.entity.EntityColdCow;
import bluedart.entity.EntityEnderTot;
import bluedart.entity.EntityEntityBottle;
import bluedart.entity.EntityForceProjectile;
import bluedart.handlers.SpeedHandler;
import bluedart.handlers.TextureAnimationHandler;
import bluedart.integration.nei.NEIIntegration;
import bluedart.item.DartItem;
import bluedart.tile.TileEntityForceEngine;
import bluedart.tile.TileEntityForceInfuser;
import bluedart.transport.PipeItemRenderer;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.KeyBindingRegistry;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.RenderEngine;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.MinecraftForge;

public class DartCraftClient
extends DartCraftCore {
    public static WingMeter meter = new WingMeter();
    public static RenderTileForceEngine engineRenderer;
    public static RenderTileForceInfuser infuserRenderer;
    public static RenderItemForceStairs renderStairs;
    public static RenderTileForceFrame renderFrame;

    @Override
    public boolean isSimulating(World world) {
        return !world.field_72995_K;
    }

    @Override
    public void init(Object mod) {
        super.init(mod);
        this.renderBlocks();
        this.renderItems();
        this.renderEntities();
        MinecraftForge.EVENT_BUS.register((Object)meter);
        MinecraftForge.EVENT_BUS.register((Object)new TextureAnimationHandler());
        MinecraftForge.EVENT_BUS.register((Object)new SpeedHandler());
    }

    @Override
    public void postInit() {
        super.postInit();
        this.loadClientForestryIntegration();
        this.loadClientBuildCraftIntegration();
        if (Loader.isModLoaded((String)"NotEnoughItems")) {
            NEIIntegration.load();
        }
    }

    @Override
    public void registerTickers() {
        super.registerTickers();
        TickRegistry.registerTickHandler((ITickHandler)meter, (Side)Side.CLIENT);
        if (Loader.isModLoaded((String)"NotEnoughItems")) {
            TickRegistry.registerTickHandler((ITickHandler)new NEIOverlayTicker(), (Side)Side.CLIENT);
        }
        this.registerKeys();
    }

    private void registerKeys() {
        KeyBinding[] key = new KeyBinding[]{new KeyBinding("Clipboard", 46), new KeyBinding("Ender Pack", 45), new KeyBinding("Force Belt", 44), new KeyBinding("Force Belt Slot 1", 79), new KeyBinding("Force Belt Slot 2", 80), new KeyBinding("Force Belt Slot 3", 81), new KeyBinding("Force Belt Slot 4", 75), new KeyBinding("Force Belt Slot 5", 76), new KeyBinding("Force Belt Slot 6", 77), new KeyBinding("Force Belt Slot 7", 71), new KeyBinding("Force Belt Slot 8", 72)};
        boolean[] repeat = new boolean[]{false, false, false, false, false, false, false, false, false, false, false};
        KeyBindingRegistry.registerKeyBinding((KeyBindingRegistry.KeyHandler)new DartMacroHandler(key, repeat));
    }

    private void loadClientForestryIntegration() {
        if (DartItem.forceContainer != null) {
            LanguageRegistry.addName((Object)DartItem.forceContainer, (String)"Can of Force");
        }
        if (DartItem.milkContainer != null) {
            LanguageRegistry.addName((Object)DartItem.milkContainer, (String)"Milk Can");
        }
    }

    private void loadClientBuildCraftIntegration() {
        if (Loader.isModLoaded((String)"BuildCraft|Transport")) {
            try {
                Class.forName("buildcraft.BuildCraftTransport");
                Class.forName("buildcraft.transport.ItemPipe");
                MinecraftForgeClient.registerItemRenderer((int)DartItem.itemForcePipe.field_77779_bT, (IItemRenderer)new PipeItemRenderer());
            }
            catch (Exception e) {
                DartCraft.dartLog.info("Unable to load Force Pipe Renderer.");
            }
        }
        if (DartItem.itemForcePipe != null) {
            LanguageRegistry.addName((Object)DartItem.itemForcePipe, (String)"Force Transport Pipe");
        }
        LanguageRegistry.instance().addStringLocalization("item.forcePipe", "en_US", "Force Transport Pipe");
    }

    private void renderBlocks() {
        int i;
        LanguageRegistry.addName((Object)new ItemStack(DartBlock.powerOre, 1, 0), (String)"Power Ore");
        LanguageRegistry.addName((Object)new ItemStack(DartBlock.powerOre, 1, 1), (String)"Nether Ore");
        LanguageRegistry.addName((Object)DartBlock.blockInfuser, (String)"Force Infuser");
        for (i = 0; i < BlockForceBrick.names.length; ++i) {
            LanguageRegistry.addName((Object)new ItemStack(DartBlock.forceBrick, 1, i), (String)BlockForceBrick.names[i]);
        }
        for (i = 0; i < BlockForceSlab.names.length; ++i) {
            LanguageRegistry.addName((Object)new ItemStack(DartBlock.forceSlab, 1, i), (String)BlockForceSlab.names[i]);
        }
        for (i = 0; i < BlockForceStairs.names.length; ++i) {
            LanguageRegistry.addName((Object)new ItemStack(DartBlock.forceStairs, 1, i), (String)BlockForceStairs.names[i]);
        }
        LanguageRegistry.addName((Object)new ItemStack(DartBlock.forceLog, 1, 0), (String)"Force Log");
        LanguageRegistry.addName((Object)new ItemStack(DartBlock.forceLog, 1, 1), (String)"Force Planks");
        LanguageRegistry.addName((Object)DartBlock.forceLeaves, (String)"Force Leaves");
        LanguageRegistry.addName((Object)DartBlock.forceSapling, (String)"Force Sapling");
        LanguageRegistry.addName((Object)DartBlock.forceEngine, (String)"Force Engine");
        Config.powerOreRenderID = RenderingRegistry.getNextAvailableRenderId();
        Config.engineRenderID = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new RenderBlockPowerOre());
        engineRenderer = new RenderTileForceEngine();
        infuserRenderer = new RenderTileForceInfuser();
        renderStairs = new RenderItemForceStairs();
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityForceEngine.class, (TileEntitySpecialRenderer)engineRenderer);
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityForceInfuser.class, (TileEntitySpecialRenderer)infuserRenderer);
        MinecraftForgeClient.registerItemRenderer((int)DartBlock.forceEngine.field_71990_ca, (IItemRenderer)new RenderItemEngine());
        MinecraftForgeClient.registerItemRenderer((int)DartBlock.blockInfuser.field_71990_ca, (IItemRenderer)new RenderItemForceInfuser());
        MinecraftForgeClient.registerItemRenderer((int)DartBlock.forceStairs.field_71990_ca, (IItemRenderer)renderStairs);
        MinecraftForgeClient.registerItemRenderer((int)DartBlock.forceSlab.field_71990_ca, (IItemRenderer)renderStairs);
    }

    private void renderItems() {
        DartItem.gemForce.func_77637_a(TabDart.instance);
        DartItem.gemForce.setRarity(EnumRarity.uncommon);
        LanguageRegistry.addName((Object)((Object)DartItem.gemForce), (String)"Force Gem");
        DartItem.forceShard.func_77637_a(TabDart.instance);
        DartItem.forceShard.setRarity(EnumRarity.uncommon);
        LanguageRegistry.addName((Object)((Object)DartItem.forceShard), (String)"Force Shard");
        DartItem.ingotForce.func_77637_a(TabDart.instance);
        LanguageRegistry.addName((Object)((Object)DartItem.ingotForce), (String)"Force Ingot");
        DartItem.goldenPower.func_77637_a(TabDart.instance);
        DartItem.goldenPower.setRarity(EnumRarity.uncommon);
        LanguageRegistry.addName((Object)((Object)DartItem.goldenPower), (String)"Golden Power Source");
        LanguageRegistry.addName((Object)((Object)DartItem.clipboard), (String)"Clipboard");
        DartItem.enderPack.setRarity(EnumRarity.rare);
        LanguageRegistry.addName((Object)((Object)DartItem.enderPack), (String)"Ender Pack");
        DartItem.forcePack.setRarity(EnumRarity.uncommon);
        LanguageRegistry.addName((Object)((Object)DartItem.forcePack), (String)"Force Pack");
        LanguageRegistry.addName((Object)((Object)DartItem.forceBelt), (String)"Force Belt");
        LanguageRegistry.addName((Object)DartItem.forceSword, (String)"Force Sword");
        LanguageRegistry.addName((Object)DartItem.forcePick, (String)"Force Pickaxe");
        LanguageRegistry.addName((Object)DartItem.forceSpade, (String)"Force Shovel");
        LanguageRegistry.addName((Object)DartItem.forceAxe, (String)"Force Axe");
        LanguageRegistry.addName((Object)DartItem.forceShears, (String)"Force Shears");
        LanguageRegistry.addName((Object)DartItem.forceBow, (String)"Force Bow");
        LanguageRegistry.addName((Object)((Object)DartItem.forceWrench), (String)"Force Wrench");
        LanguageRegistry.addName((Object)((Object)DartItem.tileBox), (String)"Tile Box");
        LanguageRegistry.addName((Object)DartItem.forceArrow, (String)"Force Arrow");
        LanguageRegistry.addName((Object)DartItem.forceNugget, (String)"Force Nugget");
        LanguageRegistry.addName((Object)DartItem.fortuneCookie, (String)"Fortune Cookie");
        LanguageRegistry.addName((Object)((Object)DartItem.fortune), (String)"Fortune");
        LanguageRegistry.addName((Object)((Object)DartItem.memberCard), (String)"Item Card");
        LanguageRegistry.addName((Object)((Object)DartItem.forceTome), (String)"Force Tome");
        LanguageRegistry.addName((Object)DartItem.rawLambchop, (String)"Raw Lambchop");
        LanguageRegistry.addName((Object)DartItem.cookedLambchop, (String)"Cooked Lambchop");
        LanguageRegistry.addName((Object)((Object)DartItem.liquidForce), (String)"Liquid Force");
        LanguageRegistry.addName((Object)((Object)DartItem.forceBucket), (String)"Bucket of Force");
        LanguageRegistry.addName((Object)DartItem.cratedForceGems, (String)"Crated Force Gems");
        LanguageRegistry.addName((Object)((Object)DartItem.claw), (String)"Claw");
        LanguageRegistry.addName((Object)((Object)DartItem.tear), (String)"Tear");
        LanguageRegistry.addName((Object)((Object)DartItem.inertCore), (String)"Inert Core");
        LanguageRegistry.addName((Object)((Object)DartItem.forceRod), (String)"Force Rod");
        LanguageRegistry.addName((Object)DartItem.upgradeCore, (String)"Upgrade Core");
        LanguageRegistry.addName((Object)((Object)DartItem.forceStick), (String)"Force Stick");
        LanguageRegistry.addName((Object)((Object)DartItem.forceGear), (String)"Force Gear");
        LanguageRegistry.addName((Object)DartItem.forceMitts, (String)"Force Mitts");
        LanguageRegistry.addName((Object)((Object)DartItem.entityBottle), (String)"Bottle o' Entity");
        LanguageRegistry.addName((Object)((Object)DartItem.forceFlask), (String)"Force Flask");
        LanguageRegistry.addName((Object)((Object)DartItem.lootBag), (String)"Spoils Bag");
        LanguageRegistry.addName((Object)((Object)DartItem.magnetGlove), (String)"Magnet Glove");
        LanguageRegistry.addName((Object)DartItem.soulWafer, (String)"Soul Wafer");
        LanguageRegistry.addName((Object)DartItem.forceCap, (String)"Force Cap");
        LanguageRegistry.addName((Object)DartItem.forceTunic, (String)"Force Tunic");
        LanguageRegistry.addName((Object)DartItem.forcePants, (String)"Force Kilt");
        LanguageRegistry.addName((Object)DartItem.forceBoots, (String)"Force Boots");
        if (DartItem.powerDrill != null) {
            LanguageRegistry.addName((Object)DartItem.powerDrill, (String)"Power Drill");
        }
        if (DartItem.powerSaw != null) {
            LanguageRegistry.addName((Object)DartItem.powerSaw, (String)"Power Saw");
        }
        RenderEngine renderEngine = FMLClientHandler.instance().getClient().field_71446_o;
        RenderItemForceFlask flaskRenderer = new RenderItemForceFlask();
        MinecraftForgeClient.registerItemRenderer((int)DartItem.forceBow.field_77779_bT, (IItemRenderer)new RenderItemForceBow());
        MinecraftForgeClient.registerItemRenderer((int)DartItem.entityBottle.field_77779_bT, (IItemRenderer)flaskRenderer);
        MinecraftForgeClient.registerItemRenderer((int)DartItem.forceFlask.field_77779_bT, (IItemRenderer)flaskRenderer);
        MinecraftForgeClient.registerItemRenderer((int)DartItem.tileBox.field_77779_bT, (IItemRenderer)new RenderItemTileBox());
        LanguageRegistry.instance().addStringLocalization("itemGroup.dartTab", "en_US", "DartCraft");
    }

    public void renderEntities() {
        RenderingRegistry.registerEntityRenderingHandler(EntityColdCow.class, (Render)new RenderColdCow((ModelBase)new ModelColdCow(), 0.6f));
        RenderingRegistry.registerEntityRenderingHandler(EntityColdChicken.class, (Render)new RenderColdChicken(new ModelColdChicken(), 0.25f));
        RenderingRegistry.registerEntityRenderingHandler(EntityEnderTot.class, (Render)new RenderEnderTot(new ModelEnderTot()));
        RenderingRegistry.registerEntityRenderingHandler(EntityAngryEnderman.class, (Render)new RenderAngryEnderman());
        RenderingRegistry.registerEntityRenderingHandler(EntityEntityBottle.class, (Render)new RenderEntityEntityBottle());
        RenderingRegistry.registerEntityRenderingHandler(EntityForceProjectile.class, (Render)new RenderEntityForceProjectile());
        LanguageRegistry.instance().addStringLocalization("entity.coldCow.name", "Cold Cow");
        LanguageRegistry.instance().addStringLocalization("entity.coldChicken.name", "Cold Chicken");
        LanguageRegistry.instance().addStringLocalization("entity.enderTot.name", "Ender Tot");
        LanguageRegistry.instance().addStringLocalization("entity.DartCraft.entityAngryEnderman.name", "Angry Enderman");
    }
}

