/*
 * Decompiled with CFR 0.152.
 */
package bluedart.core;

import bluedart.DartCraft;
import java.io.File;
import net.minecraftforge.common.Configuration;

public class Config {
    public static boolean generateOre;
    public static boolean generateNetherOre;
    public static boolean regenOre;
    public static boolean netherStarRecipe;
    public static boolean debugPunch;
    public static boolean shouldPunish;
    public static int powerOreFreq;
    public static int powerOreRarity;
    public static int powerOreSpawnHeight;
    public static double netherFreq;
    public static int maxFlight;
    public static float flightModifier;
    public static int punchDamage;
    public static boolean wingEnabled;
    public static boolean enderEnabled;
    public static boolean enderArrowsEnabled;
    public static boolean holdingEnabled;
    public static boolean sturdyEnabled;
    public static boolean forestryIntegration;
    public static boolean blacklistForestryPacks;
    public static boolean blacklistEnderPouch;
    public static boolean populateCrates;
    public static boolean forceQuarry;
    public static boolean IC2Integration;
    public static boolean TEIntegration;
    public static boolean thaumcraftIntegration;
    public static boolean railcraftIntegration;
    public static int flightParticles;
    public static boolean bottledCreepers;
    public static boolean bottledGhasts;
    public static boolean bottlePassiveOnly;
    public static boolean sturdyNerf;
    public static String[] entityBlacklist;
    public static boolean burnLava;
    public static boolean burnOil;
    public static boolean burnFuel;
    public static boolean burnBiofuel;
    public static boolean burnMilk;
    public static int burnTimeForce;
    public static int oreBlockID;
    public static int infuserBlockID;
    public static int pipeBlockID;
    public static int forceBrickID;
    public static int forceSlabID;
    public static int forceStairsID;
    public static int forceLogID;
    public static int forceLeavesID;
    public static int forceSaplingID;
    public static int forceEngineID;
    public static int forceFrameID;
    public static int enderTotChance;
    public static int maxEnderTots;
    public static int packSize;
    public static int gemID;
    public static int ingotID;
    public static int goldenPowerID;
    public static int shardID;
    public static int stickID;
    public static int clipboardID;
    public static int fortuneCookieID;
    public static int fortuneID;
    public static int memberCardID;
    public static int forceTomeID;
    public static int forcePackID;
    public static int enderPackID;
    public static int forceBeltID;
    public static int forceSwordID;
    public static int forcePickID;
    public static int forceSpadeID;
    public static int forceAxeID;
    public static int forceBowID;
    public static int heatBowID;
    public static int enderBowID;
    public static int forceShearsID;
    public static int forceNuggetID;
    public static int forceArrowID;
    public static int rawLambchopID;
    public static int cookedLambchopID;
    public static int waferID;
    public static int liquidForceID;
    public static int forceBucketID;
    public static int tearID;
    public static int clawID;
    public static int coreID;
    public static int forceRodID;
    public static int cratedForceGemsID;
    public static int forceContainerID;
    public static int milkContainerID;
    public static int powerSawID;
    public static int powerDrillID;
    public static int upgradeCoreID;
    public static int forceGearID;
    public static int forceWrenchID;
    public static int forceMittsID;
    public static int forceCapID;
    public static int forceTunicID;
    public static int forcePantsID;
    public static int forceBootsID;
    public static int forceArmorID;
    public static int entityBottleID;
    public static int forceFlaskID;
    public static int lootBagID;
    public static int magnetID;
    public static int tileBoxID;
    public static int mudoraID;
    public static int pipeItemID;
    public static int powerOreRenderID;
    public static int infuserRenderID;
    public static int leavesRenderID;
    public static int engineRenderID;
    public static Configuration config;

    public static void load(File dir) {
        if (dir != null) {
            config = new Configuration(new File(dir.getAbsolutePath(), "/dartcraft.cfg"));
        } else {
            DartCraft.dartLog.info("DartCraft config file was unable to generate properly, a fail-safe directory has been located.");
            config = new Configuration(new File("./", "config/dartcraft.cfg"));
        }
        config.load();
        config.addCustomCategoryComment("worldGen", "Change how Power Ore generates into the world.");
        generateOre = true;
        generateNetherOre = true;
        powerOreFreq = config.get("worldGen", "Ore Per Vein (2-6)", 4).getInt();
        powerOreSpawnHeight = 48;
        powerOreRarity = config.get("worldGen", "Veins Per Chunk (2-16)", 8).getInt();
        regenOre = Config.getOrCreateBooleanProperty("worldGen", "Auto regen ore.", false);
        netherFreq = config.get("worldGen", "Nether Ore Frequency", 1.5, "1.0 being as common as the overworld, 1.5 being default. (0.5 - 2.5)").getDouble(1.5);
        if (powerOreFreq < 2) {
            powerOreFreq = 2;
        }
        if (powerOreFreq > 6) {
            powerOreFreq = 6;
        }
        if (powerOreRarity < 2) {
            powerOreRarity = 2;
        }
        if (powerOreRarity > 16) {
            powerOreRarity = 16;
        }
        if (netherFreq < 0.5) {
            netherFreq = 0.5;
        }
        if (netherFreq > 2.5) {
            netherFreq = 2.5;
        }
        wingEnabled = true;
        enderEnabled = true;
        enderArrowsEnabled = true;
        netherStarRecipe = true;
        holdingEnabled = true;
        config.addCustomCategoryComment("plugins", "Enable or disable external mod integration.");
        forceQuarry = Config.getOrCreateBooleanProperty("plugins", "Force Gear BC Quarry Recipe", true);
        forestryIntegration = true;
        IC2Integration = true;
        TEIntegration = true;
        populateCrates = true;
        thaumcraftIntegration = true;
        railcraftIntegration = true;
        config.addCustomCategoryComment("packs", "Force Pack config.");
        blacklistForestryPacks = Config.getOrCreateBooleanProperty("packs", "Blacklist Forestry Packs", true);
        packSize = config.get("packs", "Initial pack size (8-40)", 8).getInt();
        config.addCustomCategoryComment("holding", "Prevent certain entities from being bottled. (Set to false to disable");
        bottlePassiveOnly = Config.getOrCreateBooleanProperty("holding", "Only passive entities", false);
        config.addCustomCategoryComment("fuels", "Change values of certain Force Engine properties.");
        burnTimeForce = config.get("fuels", "Liquid Force Burn Time (7500 - 60000)", 20000).getInt();
        if (burnTimeForce < 7500) {
            burnTimeForce = 7500;
        }
        if (burnTimeForce > 60000) {
            burnTimeForce = 60000;
        }
        burnLava = true;
        burnOil = true;
        burnFuel = true;
        burnBiofuel = true;
        burnMilk = true;
        config.addCustomCategoryComment("entities", "Entity settings");
        enderTotChance = config.get("entities", "Ender Tot Spawn Chance (0-3)", 2).getInt();
        maxEnderTots = config.get("entities", "Max Ender Tots Per Spawn (1-2)", 1).getInt();
        if (enderTotChance < 0) {
            enderTotChance = 0;
        }
        if (enderTotChance > 3) {
            enderTotChance = 3;
        }
        if (enderTotChance == 0) {
            shouldPunish = true;
        }
        if (maxEnderTots < 1) {
            maxEnderTots = 1;
        }
        if (maxEnderTots > 2) {
            maxEnderTots = 2;
        }
        config.addCustomCategoryComment("misc", "Utilities and miscellaneous options.");
        debugPunch = Config.getOrCreateBooleanProperty("misc", "Debug Punch", true);
        punchDamage = config.get("misc", "DP damage (0-20)", 8).getInt();
        flightParticles = config.get("misc", "Flight Particles", 2, "0 = none, 1 = others, 2 = others and self, 3 = others, self and creative flight").getInt();
        sturdyNerf = Config.getOrCreateBooleanProperty("misc", "Nerf Sturdy", false);
        if (punchDamage < 0 || punchDamage > 20) {
            punchDamage = 8;
        }
        if (packSize % 8 != 0) {
            packSize -= packSize % 8;
        }
        if (packSize > 40) {
            packSize = 40;
        }
        if (packSize < 8) {
            packSize = 8;
        }
        gemID = Config.getOrCreateItemIdProperty("Force Gem", 6000);
        ingotID = Config.getOrCreateItemIdProperty("Force Ingot", 6001);
        goldenPowerID = Config.getOrCreateItemIdProperty("Golden Power Source", 6002);
        shardID = Config.getOrCreateItemIdProperty("Force Shard", 6003);
        clipboardID = Config.getOrCreateItemIdProperty("Clipboard", 6004);
        forceCapID = Config.getOrCreateItemIdProperty("Force Cap", 6005);
        forceTunicID = Config.getOrCreateItemIdProperty("Force Tunic", 6006);
        forcePantsID = Config.getOrCreateItemIdProperty("Force Pants", 6007);
        forceBootsID = Config.getOrCreateItemIdProperty("Force Boots", 6008);
        forceArrowID = Config.getOrCreateItemIdProperty("Force Arrow", 6009);
        fortuneCookieID = Config.getOrCreateItemIdProperty("Fortune Cookie", 6010);
        fortuneID = Config.getOrCreateItemIdProperty("Fortune", 6011);
        forcePackID = Config.getOrCreateItemIdProperty("Force Pack", 6012);
        forceTomeID = Config.getOrCreateItemIdProperty("Force Tome", 6013);
        forceSwordID = Config.getOrCreateItemIdProperty("Force Sword", 6014);
        forceRodID = Config.getOrCreateItemIdProperty("Force Rod", 6015);
        powerSawID = Config.getOrCreateItemIdProperty("Power Saw", 6016);
        powerDrillID = Config.getOrCreateItemIdProperty("Power Drill", 6017);
        forcePickID = Config.getOrCreateItemIdProperty("Force Pickaxe", 6018);
        upgradeCoreID = Config.getOrCreateItemIdProperty("Upgrade Core", 6019);
        forceNuggetID = Config.getOrCreateItemIdProperty("Force Nugget", 6020);
        forceSpadeID = Config.getOrCreateItemIdProperty("Force Shovel", 6021);
        stickID = Config.getOrCreateItemIdProperty("Force Stick", 6022);
        forceAxeID = Config.getOrCreateItemIdProperty("Force Axe", 6023);
        forceGearID = Config.getOrCreateItemIdProperty("Force Gear", 6024);
        forceBowID = Config.getOrCreateItemIdProperty("Force Bow", 6025);
        forceShearsID = Config.getOrCreateItemIdProperty("Force Shears", 6026);
        cratedForceGemsID = Config.getOrCreateItemIdProperty("Crated Force Gems", 6027);
        enderPackID = Config.getOrCreateItemIdProperty("Ender Pack", 6028);
        rawLambchopID = Config.getOrCreateItemIdProperty("Raw Lambchop", 6029);
        cookedLambchopID = Config.getOrCreateItemIdProperty("Cooked Lambchop", 6030);
        liquidForceID = Config.getOrCreateItemIdProperty("Liquid Force", 6031);
        forceBucketID = Config.getOrCreateItemIdProperty("Force Bucket", 6032);
        forceContainerID = Config.getOrCreateItemIdProperty("Force Container", 6033);
        milkContainerID = Config.getOrCreateItemIdProperty("Milk Container", 6034);
        forceBeltID = Config.getOrCreateItemIdProperty("Force Belt", 6035);
        entityBottleID = Config.getOrCreateItemIdProperty("Entity Bottle", 6036);
        forceFlaskID = Config.getOrCreateItemIdProperty("Force Flask", 6037);
        forceWrenchID = Config.getOrCreateItemIdProperty("Force Wrench", 6038);
        forceMittsID = Config.getOrCreateItemIdProperty("Force Mitts", 6039);
        memberCardID = Config.getOrCreateItemIdProperty("Member Card", 6040);
        lootBagID = Config.getOrCreateItemIdProperty("Loot Bag", 6041);
        magnetID = Config.getOrCreateItemIdProperty("Magnet Glove", 6042);
        tearID = Config.getOrCreateItemIdProperty("Tear", 6043);
        clawID = Config.getOrCreateItemIdProperty("Claw", 6044);
        coreID = Config.getOrCreateItemIdProperty("Inert Core", 6045);
        waferID = Config.getOrCreateItemIdProperty("Soul Wafer", 6047);
        tileBoxID = Config.getOrCreateItemIdProperty("Tile Box", 6048);
        mudoraID = Config.getOrCreateItemIdProperty("Dartpendium", 6049);
        pipeItemID = Config.getOrCreateItemIdProperty("Force Pipe", 6050);
        oreBlockID = Config.getOrCreateBlockIdProperty("Power Ore", 1900);
        forceStairsID = Config.getOrCreateBlockIdProperty("Force Stairs", 1901);
        infuserBlockID = Config.getOrCreateBlockIdProperty("Force Infuser", 1902);
        forceBrickID = Config.getOrCreateBlockIdProperty("Force Brick", 1903);
        forceLogID = Config.getOrCreateBlockIdProperty("Force Wood", 1904);
        forceLeavesID = Config.getOrCreateBlockIdProperty("Force Leaves", 1905);
        forceSaplingID = Config.getOrCreateBlockIdProperty("Plants", 1906);
        forceEngineID = Config.getOrCreateBlockIdProperty("Force Engine", 1907);
        forceSlabID = Config.getOrCreateBlockIdProperty("Force Slab", 1908);
        forceFrameID = Config.getOrCreateBlockIdProperty("Force Frame", 1909);
        pipeBlockID = Config.getOrCreateBlockIdProperty("Force Pipe", 1910);
    }

    public static int getOrCreateBlockIdProperty(String key, int defaultId) {
        int blockid = Integer.parseInt(config.getBlock(key, defaultId).getString());
        config.save();
        return blockid;
    }

    public static int getOrCreateItemIdProperty(String key, int defaultId) {
        int itemid = Integer.parseInt(config.getItem(key, defaultId).getString());
        config.save();
        return itemid;
    }

    public static boolean getOrCreateBooleanProperty(String key, String kind, boolean defaults) {
        return Boolean.parseBoolean(config.get(key, kind, defaults).getString());
    }

    static {
        maxFlight = 1500;
        flightModifier = 1.1f;
    }
}

