/*
 * Decompiled with CFR 0.152.
 */
package bluedart.client.ticker;

import bluedart.core.Constants;
import bluedart.integration.ArsMagicaIntegration;
import bluedart.proxy.Proxies;
import bluedart.utils.FXUtils;
import bluedart.utils.SocketHelper;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.EnumSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.ForgeSubscribe;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class WingMeter
implements ITickHandler {
    public static int maxFlight;
    public static boolean shouldDraw;
    public int fadeTime = 0;
    private int prevTime = 0;
    private int prevFlight = 0;
    private boolean shouldFade = false;
    private int flightCheck;
    private boolean canFly;
    private int playerFlight;
    private long prevTickTime;
    private final int MAX_FADE = 15;

    public WingMeter() {
        shouldDraw = false;
        maxFlight = -1;
    }

    @ForgeSubscribe
    public void renderWing(RenderWorldLastEvent event) {
        Minecraft mc = Proxies.common.getClientInstance();
        EntityPlayer player = (EntityPlayer)Minecraft.func_71410_x().field_71451_h;
        ItemStack stack = player.func_71045_bC();
        this.canFly = SocketHelper.canPlayerFly(player);
        if (!shouldDraw) {
            boolean bl = shouldDraw = this.playerFlight < maxFlight - 150 && this.canFly;
        }
        if (!shouldDraw) {
            return;
        }
        if (this.shouldFade && this.playerFlight < maxFlight) {
            this.shouldFade = false;
        }
        float alpha = 1.0f;
        if (this.shouldFade) {
            if (this.fadeTime > 0) {
                alpha = (float)this.fadeTime / 100.0f;
            } else {
                shouldDraw = false;
                this.shouldFade = false;
                return;
            }
        }
        if (player != null && mc.field_71415_G && Minecraft.func_71382_s()) {
            this.drawThing(mc, player, stack, this.playerFlight, alpha);
        }
    }

    private void drawThing(Minecraft mc, EntityPlayer player, ItemStack stack, int playerFlight, float alpha) {
        ScaledResolution ressy = new ScaledResolution(mc.field_71474_y, mc.field_71443_c, mc.field_71440_d);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)ressy.func_78327_c(), (double)ressy.func_78324_d(), (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        int width = ressy.func_78326_a();
        int height = ressy.func_78328_b();
        boolean h = false;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        GL11.glBindTexture((int)3553, (int)mc.field_71446_o.func_78341_b(Constants.WING_PNG));
        int locX = 5;
        int locY = 5;
        if (ArsMagicaIntegration.spellbook != null) {
            locY += 10;
        }
        if (ArsMagicaIntegration.isHoldingBook(player)) {
            locY += 5;
        }
        int flight = (int)(170.0f * (float)playerFlight / (float)maxFlight);
        FXUtils.drawTexturedQuad(locX + 6, locY + 7, 0, 28, flight, 14, -83.0);
        FXUtils.drawTexturedQuad(locX, locY, 0, 0, 184, 28, -82.0);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
    }

    public void tickStart(EnumSet type, Object ... tickData) {
    }

    public void tickEnd(EnumSet type, Object ... tickData) {
        EntityPlayer player = (EntityPlayer)Minecraft.func_71410_x().field_71451_h;
        if (player == null) {
            return;
        }
        this.playerFlight = player.getEntityData().func_74775_l("DartCraft").func_74762_e("flight");
        ++this.flightCheck;
        if (maxFlight == -1 || this.flightCheck >= 20) {
            maxFlight = SocketHelper.getMaxFlight(player);
            if (this.playerFlight > maxFlight) {
                this.playerFlight = maxFlight;
                player.getEntityData().func_74775_l("DartCraft").func_74768_a("flight", this.playerFlight);
            }
            this.flightCheck = 0;
        }
        this.prevTime = !this.shouldFade && this.prevFlight == this.playerFlight && this.playerFlight == maxFlight ? ++this.prevTime : 0;
        if (!this.shouldFade && this.prevTime >= 15) {
            this.fadeTime = 15;
            this.prevTime = 0;
            this.shouldFade = true;
        }
        if (this.shouldFade) {
            if (this.fadeTime > 0) {
                --this.fadeTime;
            } else {
                shouldDraw = false;
                this.shouldFade = false;
            }
        }
        this.prevFlight = this.playerFlight;
    }

    public EnumSet ticks() {
        return EnumSet.of(TickType.CLIENT);
    }

    public String getLabel() {
        return "wingMeter";
    }
}

