/*
 * Decompiled with CFR 0.152.
 */
package bluedart.block;

import bluedart.block.DartBlock;
import bluedart.client.IconDirectory;
import bluedart.client.TabDart;
import bluedart.proxy.Proxies;
import bluedart.tile.TileEntityStairs;
import bluedart.utils.DartUtils;
import bluedart.utils.FXUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStairs;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockForceStairs
extends BlockStairs {
    public static final String[] names = new String[]{"Black Force Stairs", "Red Force Stairs", "Green Force Stairs", "Brown Force Stairs", "Blue Force Stairs", "Purple Force Stairs", "Cyan Force Stairs", "Light Gray Force Stairs", "Gray Force Stairs", "Pink Force Stairs", "Lime Force Stairs", "Yellow Force Stairs", "Light Blue Force Stairs", "Magenta Force Stairs", "Orange Force Stairs", "White Force Stairs", "Wooden Force Stairs"};

    public BlockForceStairs(int id) {
        super(id, DartBlock.forceBrick, 32);
        this.func_71864_b("forceStairs");
        this.func_71848_c(2.0f);
        this.func_71894_b(2000.0f);
        this.func_71884_a(field_71976_h);
        this.func_71849_a(TabDart.instance);
    }

    public boolean canCreatureSpawn(EnumCreatureType type, World world, int x, int y, int z) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_71922_a(World par1World, int par2, int par3, int par4) {
        return this.field_71990_ca;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_71879_a(int id, CreativeTabs tab, List list) {
        for (int i = 0; i < 17; ++i) {
            list.add(new ItemStack((Block)this, 1, i));
        }
    }

    public boolean hasTileEntity(int meta) {
        return true;
    }

    public TileEntity createTileEntity(World world, int meta) {
        return new TileEntityStairs();
    }

    public static TileEntityStairs getStairTile(IBlockAccess world, int x, int y, int z) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile != null && tile instanceof TileEntityStairs) {
            return (TileEntityStairs)tile;
        }
        return null;
    }

    public boolean removeBlockByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        TileEntity tile;
        int meta = world.func_72805_g(x, y, z);
        if (Proxies.common.isSimulating(world) && this.canHarvestBlock(player, meta) && !player.field_71075_bZ.field_75098_d && (tile = world.func_72796_p(x, y, z)) instanceof TileEntityStairs) {
            TileEntityStairs stairs = (TileEntityStairs)tile;
            ItemStack stack = new ItemStack(this.field_71990_ca, 1, stairs.getColor());
            DartUtils.dropItem(stack, world, x, y, z);
        }
        return world.func_94571_i(x, y, z);
    }

    public ArrayList getBlockDropped(World world, int x, int y, int z, int metadata, int fortune) {
        return new ArrayList();
    }

    public Icon func_71895_b(IBlockAccess world, int x, int y, int z, int side) {
        TileEntityStairs stairs = BlockForceStairs.getStairTile(world, x, y, z);
        if (stairs != null && stairs.getColor() >= 0) {
            if (stairs.getColor() < 16) {
                return IconDirectory.bricks[stairs.getColor()];
            }
            if (stairs.getColor() == 16) {
                return IconDirectory.planks;
            }
        }
        return this.field_94336_cN;
    }

    public int func_85104_a(World world, int x, int y, int z, int par5, float par6, float par7, float par8, int par9) {
        TileEntityStairs stairs = BlockForceStairs.getStairTile((IBlockAccess)world, x, y, z);
        if (stairs != null) {
            stairs.setColor(world.func_72805_g(x, y, z));
        }
        if (par5 != 0 && (par5 == 1 || (double)par7 <= 0.5)) {
            return 0;
        }
        return 4;
    }

    public void func_71860_a(World par1World, int par2, int par3, int par4, EntityLiving entity, ItemStack stack) {
        TileEntityStairs stairs = BlockForceStairs.getStairTile((IBlockAccess)par1World, par2, par3, par4);
        if (stack != null && stack.field_77993_c == this.field_71990_ca && stairs != null) {
            stairs.setColor(stack.func_77960_j());
        }
        super.func_71860_a(par1World, par2, par3, par4, entity, stack);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addBlockDestroyEffects(World world, int x, int y, int z, int meta, EffectRenderer renderer) {
        TileEntityStairs stairs = BlockForceStairs.getStairTile((IBlockAccess)world, x, y, z);
        if (stairs != null) {
            FXUtils.makeShiny(world, x, y, z, 2, DartUtils.getMcColor(stairs.getColor()), 32, true);
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addBlockHitEffects(World world, MovingObjectPosition target, EffectRenderer renderer) {
        TileEntityStairs stairs = BlockForceStairs.getStairTile((IBlockAccess)world, target.field_72311_b, target.field_72312_c, target.field_72309_d);
        if (stairs != null) {
            FXUtils.makeShiny(world, target.field_72311_b, target.field_72312_c, target.field_72309_d, 2, DartUtils.getMcColor(stairs.getColor()), 4, true);
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister reggie) {
    }
}

