/*
 * Decompiled with CFR 0.152.
 */
package bluedart.block;

import bluedart.DartCraft;
import bluedart.client.TabDart;
import bluedart.proxy.Proxies;
import bluedart.tile.TileEntityForceEngine;
import bluedart.utils.DartUtils;
import bluedart.utils.FXUtils;
import bluedart.utils.UtilsBlock;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidContainerRegistry;

public class BlockForceEngine
extends BlockContainer {
    public BlockForceEngine(int id) {
        super(id, Material.field_76243_f);
        this.func_71848_c(3.0f);
        this.func_71894_b(50.0f);
        this.func_71849_a(TabDart.instance);
    }

    public TileEntity func_72274_a(World var1) {
        return new TileEntityForceEngine();
    }

    public boolean func_71903_a(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        if (!Proxies.common.isSimulating(world)) {
            return true;
        }
        TileEntity tile = world.func_72796_p(x, y, z);
        TileEntityForceEngine engine = null;
        if (tile instanceof TileEntityForceEngine) {
            engine = (TileEntityForceEngine)tile;
        }
        if (engine != null) {
            if (DartUtils.isHoldingWrench(player)) {
                engine.rotateBlock();
                return true;
            }
            if (engine instanceof ITankContainer && player.func_71045_bC() != null && LiquidContainerRegistry.getLiquidForFilledItem((ItemStack)player.func_71045_bC()) != null) {
                return UtilsBlock.fillTankWithContainer(engine, player);
            }
            if (!player.func_70093_af() && !DartUtils.isHoldingWrench(player)) {
                player.openGui((Object)DartCraft.instance, 7, world, x, y, z);
            }
        }
        return true;
    }

    public void func_71860_a(World world, int x, int y, int z, EntityLiving living, ItemStack stack) {
        TileEntityForceEngine tile = (TileEntityForceEngine)world.func_72796_p(x, y, z);
        if (tile != null) {
            tile.setFacing(1);
            tile.rotateBlock();
        }
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        TileEntity te = world.func_72796_p(x, y, z);
        if (te instanceof TileEntityForceEngine) {
            return ((TileEntityForceEngine)te).getLightValue();
        }
        return 0;
    }

    public int func_71857_b() {
        return -1;
    }

    public boolean func_71926_d() {
        return false;
    }

    public boolean func_71886_c() {
        return false;
    }

    public void func_71852_a(World world, int x, int y, int z, int par5, int par6) {
        if (!Proxies.common.isSimulating(world)) {
            return;
        }
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof TileEntityForceEngine) {
            TileEntityForceEngine engine = (TileEntityForceEngine)tile;
            for (int i = 0; i < engine.liquidInventory.func_70302_i_(); ++i) {
                ItemStack tempStack = engine.liquidInventory.func_70301_a(i);
                if (tempStack == null) continue;
                DartUtils.dropItem(tempStack, world, x, y, z);
            }
        }
        super.func_71852_a(world, x, y, z, par5, par6);
    }

    public boolean isBlockSolidOnSide(World world, int x, int y, int z, ForgeDirection side) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof TileEntityForceEngine) {
            return ForgeDirection.getOrientation((int)((TileEntityForceEngine)tile).facing).getOpposite() == side;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addBlockDestroyEffects(World world, int x, int y, int z, int meta, EffectRenderer renderer) {
        FXUtils.makeShiny(world, x, y, z, 2, 0xFFFF00, 16, true);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addBlockHitEffects(World world, MovingObjectPosition target, EffectRenderer renderer) {
        if (world != null && target != null) {
            FXUtils.makeShiny(world, target.field_72311_b, target.field_72312_c, target.field_72309_d, 2, 0xFFFF00, 3, true);
        }
        return true;
    }
}

