/*
 * Decompiled with CFR 0.152.
 */
package bluedart.api;

import bluedart.api.DartAPI;
import bluedart.api.IForceUpgradeMaterial;

public class UpgradeMaterialHelper {
    public IForceUpgradeMaterial createMaterial(int index, int upgradeID, int bonus, float efficiency) {
        if (index <= 0 || DartAPI.fum.getFromID(upgradeID) == null) {
            return null;
        }
        return new UpgradeAdapter(index, 0, upgradeID, bonus, efficiency);
    }

    public IForceUpgradeMaterial createMaterial(int index, int meta, int upgradeID, int bonus, float efficiency) {
        if (index <= 0 || DartAPI.fum.getFromID(upgradeID) == null) {
            return null;
        }
        return new UpgradeAdapter(index, meta, upgradeID, bonus, efficiency);
    }

    private class UpgradeAdapter
    implements IForceUpgradeMaterial {
        private int index;
        private int meta;
        private int upgradeID;
        private int bonus;
        private float efficiency;

        public UpgradeAdapter(int index, int meta, int upgradeID, int bonus, float efficiency) {
            this.index = index;
            this.meta = meta;
            this.upgradeID = upgradeID;
            this.bonus = bonus;
            this.efficiency = efficiency;
        }

        @Override
        public int getUpgradeID() {
            return this.upgradeID;
        }

        @Override
        public int getBonus() {
            return this.bonus;
        }

        @Override
        public float getEfficiency() {
            return this.efficiency;
        }

        @Override
        public int getItemID() {
            return this.index;
        }

        @Override
        public int getItemMeta() {
            return this.meta;
        }
    }
}

