/*
 * Decompiled with CFR 0.152.
 */
package bluedart.api;

import bluedart.api.DartAPI;
import bluedart.api.IForceUpgradeMaterial;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ISocket {
    public int damage;
    public int maxDamage;
    public IForceUpgradeMaterial mat;

    public ISocket() {
        this.maxDamage = 0;
        this.damage = 0;
        this.mat = null;
    }

    public ISocket(ItemStack stack, int maxDamage) {
        this.maxDamage = maxDamage;
        this.mat = DartAPI.fum.getMaterialFromItemStack(stack);
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound comp = new NBTTagCompound();
        comp.func_74768_a("damage", this.damage);
        comp.func_74768_a("maxDamage", this.maxDamage);
        if (this.mat != null) {
            comp.func_74768_a("itemID", this.mat.getItemID());
        } else {
            comp.func_74768_a("itemID", 0);
        }
        if (this.mat != null) {
            comp.func_74768_a("itemMeta", this.mat.getItemMeta());
        } else {
            comp.func_74768_a("itemMeta", 0);
        }
        return comp;
    }

    public void readFromNBT(NBTTagCompound comp) {
        this.damage = comp.func_74762_e("damage");
        this.maxDamage = comp.func_74762_e("maxDamage");
        int itemID = comp.func_74762_e("itemID");
        int itemMeta = comp.func_74762_e("itemMeta");
        this.mat = DartAPI.fum.getMaterialFromItemStack(new ItemStack(itemID, 1, itemMeta));
    }
}

