/*
 * Decompiled with CFR 0.152.
 */
package bluedart.api;

import bluedart.api.DartAPI;
import bluedart.api.IForceUpgradable;
import bluedart.api.IForceUpgrade;
import bluedart.api.IForceUpgradeMaterial;
import bluedart.api.IForceWildCard;
import bluedart.block.DartBlock;
import bluedart.core.Config;
import bluedart.item.DartItem;
import bluedart.utils.TomeUtils;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ForceUpgradeManager {
    public static final IForceUpgrade FORCE = new IForceUpgrade(0, 0, "Force", 2);
    public static final IForceUpgrade DAMAGE = new IForceUpgrade(5, 0, "Damage", 5);
    public static final IForceUpgrade HEAT = new IForceUpgrade(1, 1, "Heat", 4, true);
    public static final IForceUpgrade MINING = new IForceUpgrade(2, 1, "Speed", 5);
    public static final IForceUpgrade LUMBERJACK = new IForceUpgrade(3, 1, "Lumberjack", 1);
    public static final IForceUpgrade LUCK = new IForceUpgrade(10, 2, "Luck", 4);
    public static final IForceUpgrade GRINDING = new IForceUpgrade(11, 2, "Grinding", 1);
    public static final IForceUpgrade RAINBOW = new IForceUpgrade(12, 2, "Rainbow", 1);
    public static final IForceUpgrade STORAGE = new IForceUpgrade(13, 2, "Holding", 1);
    public static final IForceUpgrade EXP = new IForceUpgrade(14, 2, "Experience", 3);
    public static final IForceUpgrade TOUCH = new IForceUpgrade(20, 3, "Touch", 1);
    public static final IForceUpgrade BLEED = new IForceUpgrade(22, 3, "Bleed", 3);
    public static final IForceUpgrade HEALING = new IForceUpgrade(23, 3, "Healing", 2);
    public static final IForceUpgrade CAMO = new IForceUpgrade(24, 3, "Camo", 1);
    public static final IForceUpgrade CRAFT = new IForceUpgrade(25, 3, "Craft", 1);
    public static final IForceUpgrade BANE = new IForceUpgrade(26, 3, "Bane", 1);
    public static final IForceUpgrade WING = new IForceUpgrade(30, 4, "Wing", 1, true);
    public static final IForceUpgrade CHARGE = new IForceUpgrade(31, 4, "Charge", 5);
    public static final IForceUpgrade SOUL = new IForceUpgrade(32, 4, "Soul", 5);
    public static final IForceUpgrade SIGHT = new IForceUpgrade(33, 4, "Sight", 1);
    public static final IForceUpgrade FORGE = new IForceUpgrade(34, 4, "Forge", 1);
    public static final IForceUpgrade ENDER = new IForceUpgrade(40, 5, "Ender", 1, true);
    public static final IForceUpgrade CHARGE2 = new IForceUpgrade(41, 5, "Charge2", 5);
    public static final IForceUpgrade LIGHT = new IForceUpgrade(50, 6, "Light", 5, true);
    public static final IForceUpgrade STURDY = new IForceUpgrade(51, 6, "Sturdy", 3);
    public static final IForceUpgrade EXPLOSION = new IForceUpgrade(60, 7, "Explosion", 1, true);
    public static final IForceUpgrade GRAFTING = new IForceUpgrade(61, 7, "Grafting", 1, false);
    public static final IForceUpgrade REPAIR = new IForceUpgrade(62, 7, "Repair", 1);
    public ArrayList upgrades = new ArrayList();
    public ArrayList materials = new ArrayList();

    public void initialize() {
        this.addUpgrade(FORCE);
        this.addUpgrade(DAMAGE);
        this.addUpgrade(HEAT);
        this.addUpgrade(MINING);
        this.addUpgrade(LUMBERJACK);
        this.addUpgrade(LUCK);
        this.addUpgrade(TOUCH);
        this.addUpgrade(BLEED);
        this.addUpgrade(HEALING);
        this.addUpgrade(CAMO);
        this.addUpgrade(CRAFT);
        this.addUpgrade(RAINBOW);
        this.addUpgrade(BANE);
        this.addUpgrade(STORAGE);
        this.addUpgrade(STURDY);
        this.addUpgrade(SOUL);
        this.addUpgrade(SIGHT);
        this.addUpgrade(FORGE);
        this.addUpgrade(GRINDING);
        this.addUpgrade(CHARGE);
        this.addUpgrade(CHARGE2);
        this.addUpgrade(WING);
        this.addUpgrade(ENDER);
        this.addUpgrade(EXP);
        this.addUpgrade(LIGHT);
        this.addUpgrade(EXPLOSION);
        this.addUpgrade(GRAFTING);
        this.addUpgrade(REPAIR);
        this.loadUpgradeMaterials();
        this.loadWildCards();
    }

    private void loadUpgradeMaterials() {
        this.materials.add(DartAPI.umh.createMaterial(DartItem.forceNugget.field_77779_bT, FORCE.getID(), 0, 0.75f));
        this.materials.add(DartAPI.umh.createMaterial(DartItem.claw.field_77779_bT, DAMAGE.getID(), 0, 0.75f));
        this.materials.add(DartAPI.umh.createMaterial(Item.field_77747_aY.field_77779_bT, MINING.getID(), 0, 1.0f));
        this.materials.add(DartAPI.umh.createMaterial(DartBlock.forceLog.field_71990_ca, LUMBERJACK.getID(), 5, 1.5f));
        this.materials.add(DartAPI.umh.createMaterial(Item.field_77705_m.field_77779_bT, HEAT.getID(), 0, 1.0f));
        this.materials.add(DartAPI.umh.createMaterial(Item.field_77705_m.field_77779_bT, 1, HEAT.getID(), 0, 1.0f));
        this.materials.add(DartAPI.umh.createMaterial(DartItem.goldenPower.field_77779_bT, HEAT.getID(), 5, 1.5f));
        this.materials.add(DartAPI.umh.createMaterial(Item.field_77722_bw.field_77779_bT, HEAT.getID(), 10, 2.0f));
        this.materials.add(DartAPI.umh.createMaterial(Item.field_77756_aW.field_77779_bT, 4, RAINBOW.getID(), 0, 0.25f));
        this.materials.add(DartAPI.umh.createMaterial(Block.field_72081_al.field_71990_ca, STURDY.getID(), 0, 1.25f));
        this.materials.add(DartAPI.umh.createMaterial(Block.field_72089_ap.field_71990_ca, STURDY.getID(), 10, 1.75f));
        this.materials.add(DartAPI.umh.createMaterial(DartItem.fortune.field_77779_bT, LUCK.getID(), 0, 2.0f));
        this.materials.add(DartAPI.umh.createMaterial(Block.field_71955_W.field_71990_ca, TOUCH.getID(), 5, 2.0f));
        this.materials.add(DartAPI.umh.createMaterial(Item.field_77704_l.field_77779_bT, BLEED.getID(), 0, 1.0f));
        this.materials.add(DartAPI.umh.createMaterial(Item.field_77728_bu.field_77779_bT, BANE.getID(), 10, 1.5f));
        this.materials.add(DartAPI.umh.createMaterial(DartItem.forceFlask.field_77779_bT, STORAGE.getID(), 0, 0.25f));
        if (Config.wingEnabled) {
            this.materials.add(DartAPI.umh.createMaterial(Item.field_77676_L.field_77779_bT, WING.getID(), 0, 3.0f));
        }
        this.materials.add(DartAPI.umh.createMaterial(Item.field_77804_ap.field_77779_bT, GRINDING.getID(), 0, 1.5f));
        this.materials.add(DartAPI.umh.createMaterial(Item.field_77732_bp.field_77779_bT, HEALING.getID(), 10, 2.0f));
        this.materials.add(DartAPI.umh.createMaterial(DartItem.tear.field_77779_bT, HEALING.getID(), 0, 1.5f));
        this.materials.add(DartAPI.umh.createMaterial(Item.field_77726_bs.field_77779_bT, 8206, CAMO.getID(), 5, 2.0f));
        this.materials.add(DartAPI.umh.createMaterial(Item.field_77726_bs.field_77779_bT, 8270, CAMO.getID(), 5, 2.0f));
        this.materials.add(DartAPI.umh.createMaterial(Item.field_77726_bs.field_77779_bT, 16398, CAMO.getID(), 5, 2.0f));
        this.materials.add(DartAPI.umh.createMaterial(Item.field_77726_bs.field_77779_bT, 16462, CAMO.getID(), 5, 2.0f));
        this.materials.add(DartAPI.umh.createMaterial(Item.field_77726_bs.field_77779_bT, 8198, SIGHT.getID(), 5, 2.0f));
        this.materials.add(DartAPI.umh.createMaterial(Item.field_77726_bs.field_77779_bT, 8262, SIGHT.getID(), 5, 2.0f));
        this.materials.add(DartAPI.umh.createMaterial(Item.field_77726_bs.field_77779_bT, 16390, SIGHT.getID(), 5, 2.0f));
        this.materials.add(DartAPI.umh.createMaterial(Item.field_77726_bs.field_77779_bT, 16454, SIGHT.getID(), 5, 2.0f));
        this.materials.add(DartAPI.umh.createMaterial(Block.field_72060_ay.field_71990_ca, CRAFT.getID(), 0, 1.0f));
        this.materials.add(DartAPI.umh.createMaterial(Block.field_72051_aB.field_71990_ca, FORGE.getID(), 0, 2.0f));
        if (Config.enderEnabled || Config.enderArrowsEnabled) {
            this.materials.add(DartAPI.umh.createMaterial(Item.field_77730_bn.field_77779_bT, ENDER.getID(), 0, 5.0f));
        }
        this.materials.add(DartAPI.umh.createMaterial(Item.field_77809_bD.field_77779_bT, EXP.getID(), 15, 2.25f));
        this.materials.add(DartAPI.umh.createMaterial(DartItem.soulWafer.field_77779_bT, SOUL.getID(), 0, 2.0f));
        this.materials.add(DartAPI.umh.createMaterial(Item.field_77751_aT.field_77779_bT, LIGHT.getID(), 0, 3.0f));
    }

    private void loadWildCards() {
        DartAPI.addWildCard(new IForceWildCard(new ItemStack(Block.field_72007_bm, 1, 0), new ItemStack(DartBlock.forceBrick, 1, 11), FORCE));
        ItemStack tomeStack = new ItemStack((Item)DartItem.forceTome);
        tomeStack.func_77982_d(TomeUtils.initExpComp());
        DartAPI.addWildCard(new IForceWildCard(new ItemStack(Item.field_77760_aL), tomeStack, EXP));
    }

    public boolean addUpgrade(IForceUpgrade upgrade) {
        if (this.upgrades.size() > 0) {
            for (IForceUpgrade temp : this.upgrades) {
                if (temp.getID() != upgrade.getID()) continue;
                return false;
            }
        }
        this.upgrades.add(upgrade);
        return true;
    }

    public IForceUpgrade getFromID(int id) {
        if (this.upgrades.size() > 0) {
            for (IForceUpgrade temp : this.upgrades) {
                if (temp.getID() != id) continue;
                return temp;
            }
        }
        return null;
    }

    public IForceUpgradeMaterial getMaterialFromItemStack(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        for (IForceUpgradeMaterial mat : this.materials) {
            if (mat == null || mat.getItemID() != stack.func_77973_b().field_77779_bT || mat.getItemMeta() != stack.func_77960_j()) continue;
            return mat;
        }
        return null;
    }

    public boolean isUpgradeValid(IForceUpgrade upgrade, IForceUpgradable item) {
        if (item.validUpgrades() != null) {
            for (int id : item.validUpgrades()) {
                if (upgrade.getID() != id) continue;
                return true;
            }
        }
        return false;
    }
}

