/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.vec;

import codechicken.core.vec.Matrix4;
import codechicken.core.vec.Quat;
import codechicken.core.vec.RedundantTransformation;
import codechicken.core.vec.Transformation;
import codechicken.core.vec.VariableTransformation;
import codechicken.core.vec.Vector3;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import org.lwjgl.opengl.GL11;

public class Rotation
extends Transformation {
    public static Transformation[] quarterRotations = new Transformation[]{new RedundantTransformation(), new VariableTransformation(new Matrix4(0.0, 0.0, -1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0)){

        @Override
        public void apply(Vector3 vec) {
            double d1 = vec.x;
            double d2 = vec.z;
            vec.x = -d2;
            vec.z = d1;
        }

        @Override
        public Transformation inverse() {
            return quarterRotations[3];
        }
    }, new VariableTransformation(new Matrix4(-1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, 1.0)){

        @Override
        public void apply(Vector3 vec) {
            vec.x = -vec.x;
            vec.z = -vec.z;
        }

        @Override
        public Transformation inverse() {
            return this;
        }
    }, new VariableTransformation(new Matrix4(0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0)){

        @Override
        public void apply(Vector3 vec) {
            double d2;
            double d1 = vec.x;
            vec.x = d2 = vec.z;
            vec.z = -d1;
        }

        @Override
        public Transformation inverse() {
            return quarterRotations[1];
        }
    }};
    public static Transformation[] sideRotations = new Transformation[]{new RedundantTransformation(), new VariableTransformation(new Matrix4(1.0, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, 1.0)){

        @Override
        public void apply(Vector3 vec) {
            vec.y = -vec.y;
            vec.z = -vec.z;
        }

        @Override
        public Transformation inverse() {
            return this;
        }
    }, new VariableTransformation(new Matrix4(1.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0)){

        @Override
        public void apply(Vector3 vec) {
            double d1 = vec.y;
            double d2 = vec.z;
            vec.y = -d2;
            vec.z = d1;
        }

        @Override
        public Transformation inverse() {
            return sideRotations[3];
        }
    }, new VariableTransformation(new Matrix4(1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0)){

        @Override
        public void apply(Vector3 vec) {
            double d2;
            double d1 = vec.y;
            vec.y = d2 = vec.z;
            vec.z = -d1;
        }

        @Override
        public Transformation inverse() {
            return sideRotations[2];
        }
    }, new VariableTransformation(new Matrix4(0.0, 1.0, 0.0, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0)){

        @Override
        public void apply(Vector3 vec) {
            double d1;
            double d0 = vec.x;
            vec.x = d1 = vec.y;
            vec.y = -d0;
        }

        @Override
        public Transformation inverse() {
            return sideRotations[5];
        }
    }, new VariableTransformation(new Matrix4(0.0, -1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0)){

        @Override
        public void apply(Vector3 vec) {
            double d0 = vec.x;
            double d1 = vec.y;
            vec.x = -d1;
            vec.y = d0;
        }

        @Override
        public Transformation inverse() {
            return sideRotations[4];
        }
    }};
    public static Vector3[] axes = new Vector3[]{new Vector3(0.0, -1.0, 0.0), new Vector3(0.0, 1.0, 0.0), new Vector3(0.0, 0.0, -1.0), new Vector3(0.0, 0.0, 1.0), new Vector3(-1.0, 0.0, 0.0), new Vector3(1.0, 0.0, 0.0)};
    public static int[] sideRotMap;
    public static int[] rotSideMap;
    public static int[] sideRotOffsets;
    public double angle;
    public Vector3 axis;
    private Quat quat;

    static {
        int[] nArray = new int[24];
        nArray[0] = 3;
        nArray[1] = 4;
        nArray[2] = 2;
        nArray[3] = 5;
        nArray[4] = 3;
        nArray[5] = 5;
        nArray[6] = 2;
        nArray[7] = 4;
        nArray[8] = 1;
        nArray[9] = 5;
        nArray[11] = 4;
        nArray[12] = 1;
        nArray[13] = 4;
        nArray[15] = 5;
        nArray[16] = 1;
        nArray[17] = 2;
        nArray[19] = 3;
        nArray[20] = 1;
        nArray[21] = 3;
        nArray[23] = 2;
        sideRotMap = nArray;
        int[] nArray2 = new int[36];
        nArray2[0] = -1;
        nArray2[1] = -1;
        nArray2[2] = 2;
        nArray2[4] = 3;
        nArray2[5] = 1;
        nArray2[6] = -1;
        nArray2[7] = -1;
        nArray2[8] = 2;
        nArray2[10] = 1;
        nArray2[11] = 3;
        nArray2[12] = 2;
        nArray2[14] = -1;
        nArray2[15] = -1;
        nArray2[16] = 3;
        nArray2[17] = 1;
        nArray2[18] = 2;
        nArray2[20] = -1;
        nArray2[21] = -1;
        nArray2[22] = 1;
        nArray2[23] = 3;
        nArray2[24] = 2;
        nArray2[26] = 1;
        nArray2[27] = 3;
        nArray2[28] = -1;
        nArray2[29] = -1;
        nArray2[30] = 2;
        nArray2[32] = 3;
        nArray2[33] = 1;
        nArray2[34] = -1;
        nArray2[35] = -1;
        rotSideMap = nArray2;
        int[] nArray3 = new int[6];
        nArray3[1] = 2;
        nArray3[2] = 2;
        nArray3[4] = 1;
        nArray3[5] = 3;
        sideRotOffsets = nArray3;
    }

    public static int rotateSide(int s, int r) {
        return sideRotMap[s << 2 | r];
    }

    public static int rotationTo(int s1, int s2) {
        if ((s1 & 6) == (s2 & 6)) {
            throw new IllegalArgumentException("Faces " + s1 + " and " + s2 + " are opposites");
        }
        return rotSideMap[s1 * 6 + s2];
    }

    public static int getSidedRotation(sq player, int side) {
        Vector3 look = new Vector3(player.i(1.0f));
        double max = 0.0;
        int maxr = 0;
        int r = 0;
        while (r < 4) {
            Vector3 axis = axes[Rotation.rotateSide(side ^ 1, r)];
            double d = look.scalarProject(axis);
            if (max > d) {
                max = d;
                maxr = r;
            }
            ++r;
        }
        return maxr;
    }

    public static Transformation sideOrientation(int s, int r) {
        return quarterRotations[(r + sideRotOffsets[s]) % 4].with(sideRotations[s]);
    }

    public Rotation(double angle, Vector3 axis) {
        this.angle = angle;
        this.axis = axis;
    }

    public Rotation(double angle, double x, double y2, double z2) {
        this(angle, new Vector3(x, y2, z2));
    }

    public Rotation(Quat quat) {
        this.quat = quat;
        this.angle = Math.acos(quat.s) * 2.0;
        if (this.angle == 0.0) {
            this.axis = new Vector3(0.0, 1.0, 0.0);
        } else {
            double sa = Math.sin(this.angle * 0.5);
            this.axis = new Vector3(quat.x / sa, quat.y / sa, quat.z / sa);
        }
    }

    @Override
    public void apply(Vector3 vec) {
        if (this.quat == null) {
            this.quat = Quat.aroundAxis(this.axis, this.angle);
        }
        vec.rotate(this.quat);
    }

    @Override
    public void applyN(Vector3 normal) {
        this.apply(normal);
    }

    @Override
    public void apply(Matrix4 mat) {
        mat.rotate(this.angle, this.axis);
    }

    public Quat toQuat() {
        if (this.quat == null) {
            this.quat = Quat.aroundAxis(this.axis, this.angle);
        }
        return this.quat;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void glApply() {
        GL11.glRotatef((float)((float)(this.angle * 57.29577951308232)), (float)((float)this.axis.x), (float)((float)this.axis.y), (float)((float)this.axis.z));
    }

    @Override
    public Transformation inverse() {
        return new Rotation(-this.angle, this.axis);
    }

    public String toString() {
        MathContext cont = new MathContext(4, RoundingMode.HALF_UP);
        return "Rotation(" + new BigDecimal(this.angle, cont) + ", " + new BigDecimal(this.axis.x, cont) + ", " + new BigDecimal(this.axis.y, cont) + ", " + new BigDecimal(this.axis.z, cont) + ")";
    }
}

