/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.render;

import codechicken.core.render.CCRenderState;
import codechicken.core.render.IFaceRenderer;
import codechicken.core.render.IUVTransformation;
import codechicken.core.render.IVertexModifier;
import codechicken.core.render.TextureUtils;
import codechicken.core.render.UV;
import codechicken.core.render.Vertex5;
import codechicken.core.vec.Cuboid6;
import codechicken.core.vec.Rotation;
import codechicken.core.vec.Transformation;
import codechicken.core.vec.Vector3;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.liquids.LiquidStack;
import org.lwjgl.opengl.GL11;

public class RenderUtils {
    static Vector3[] vectors = new Vector3[8];
    static bhi uniformRenderItem = new bhi(){

        public boolean shouldBob() {
            return false;
        }
    };
    static rh entityItem;
    private static Vertex5[] face;

    static {
        int i = 0;
        while (i < vectors.length) {
            RenderUtils.vectors[i] = new Vector3();
            ++i;
        }
        uniformRenderItem.a(bgy.a);
        entityItem = new rh(null);
        RenderUtils.entityItem.c = 0.0f;
        face = new Vertex5[]{new Vertex5(), new Vertex5(), new Vertex5(), new Vertex5()};
    }

    public static lx bindLiquidTexture(int liquidID, int liquidMeta) {
        if (liquidID < apa.r.length && apa.r[liquidID] != null) {
            apa liquidBlock = apa.r[liquidID];
            return liquidBlock.a(0, liquidMeta);
        }
        wk liquidItem = wk.f[liquidID];
        if (liquidItem == null) {
            return null;
        }
        return liquidItem.a_(liquidMeta);
    }

    public static void renderLiquidQuad(Vector3 point1, Vector3 point2, Vector3 point3, Vector3 point4, lx icon, double res) {
        double u1 = icon.e();
        double du = icon.f() - icon.e();
        double v2 = icon.h();
        double dv = icon.h() - icon.g();
        Vector3 wide = vectors[0].set(point4).subtract(point1);
        Vector3 high = vectors[1].set(point1).subtract(point2);
        bgd t = bgd.a;
        double wlen = wide.mag();
        double hlen = high.mag();
        double x = 0.0;
        while (x < wlen) {
            double rx = wlen - x;
            if (rx > res) {
                rx = res;
            }
            double y = 0.0;
            while (y < hlen) {
                double ry = hlen - y;
                if (ry > res) {
                    ry = res;
                }
                Vector3 dx1 = vectors[2].set(wide).multiply(x / wlen);
                Vector3 dx2 = vectors[3].set(wide).multiply((x + rx) / wlen);
                Vector3 dy1 = vectors[4].set(high).multiply(y / hlen);
                Vector3 dy2 = vectors[5].set(high).multiply((y + ry) / hlen);
                t.a(point2.x + dx1.x + dy2.x, point2.y + dx1.y + dy2.y, point2.z + dx1.z + dy2.z, u1, v2 - ry / res * dv);
                t.a(point2.x + dx1.x + dy1.x, point2.y + dx1.y + dy1.y, point2.z + dx1.z + dy1.z, u1, v2);
                t.a(point2.x + dx2.x + dy1.x, point2.y + dx2.y + dy1.y, point2.z + dx2.z + dy1.z, u1 + rx / res * du, v2);
                t.a(point2.x + dx2.x + dy2.x, point2.y + dx2.y + dy2.y, point2.z + dx2.z + dy2.z, u1 + rx / res * du, v2 - ry / res * dv);
                y += ry;
            }
            x += rx;
        }
    }

    public static void translateToWorldCoords(mp entity, float frame) {
        double interpPosX = entity.U + (entity.u - entity.U) * (double)frame;
        double interpPosY = entity.V + (entity.v - entity.V) * (double)frame;
        double interpPosZ = entity.W + (entity.w - entity.W) * (double)frame;
        GL11.glTranslated((double)(-interpPosX), (double)(-interpPosY), (double)(-interpPosZ));
    }

    public static void drawOutlinedBoundingBox(aqx par1AxisAlignedBB) {
        bgd var2 = bgd.a;
        var2.b(3);
        var2.a(par1AxisAlignedBB.a, par1AxisAlignedBB.b, par1AxisAlignedBB.c);
        var2.a(par1AxisAlignedBB.d, par1AxisAlignedBB.b, par1AxisAlignedBB.c);
        var2.a(par1AxisAlignedBB.d, par1AxisAlignedBB.b, par1AxisAlignedBB.f);
        var2.a(par1AxisAlignedBB.a, par1AxisAlignedBB.b, par1AxisAlignedBB.f);
        var2.a(par1AxisAlignedBB.a, par1AxisAlignedBB.b, par1AxisAlignedBB.c);
        var2.a();
        var2.b(3);
        var2.a(par1AxisAlignedBB.a, par1AxisAlignedBB.e, par1AxisAlignedBB.c);
        var2.a(par1AxisAlignedBB.d, par1AxisAlignedBB.e, par1AxisAlignedBB.c);
        var2.a(par1AxisAlignedBB.d, par1AxisAlignedBB.e, par1AxisAlignedBB.f);
        var2.a(par1AxisAlignedBB.a, par1AxisAlignedBB.e, par1AxisAlignedBB.f);
        var2.a(par1AxisAlignedBB.a, par1AxisAlignedBB.e, par1AxisAlignedBB.c);
        var2.a();
        var2.b(1);
        var2.a(par1AxisAlignedBB.a, par1AxisAlignedBB.b, par1AxisAlignedBB.c);
        var2.a(par1AxisAlignedBB.a, par1AxisAlignedBB.e, par1AxisAlignedBB.c);
        var2.a(par1AxisAlignedBB.d, par1AxisAlignedBB.b, par1AxisAlignedBB.c);
        var2.a(par1AxisAlignedBB.d, par1AxisAlignedBB.e, par1AxisAlignedBB.c);
        var2.a(par1AxisAlignedBB.d, par1AxisAlignedBB.b, par1AxisAlignedBB.f);
        var2.a(par1AxisAlignedBB.d, par1AxisAlignedBB.e, par1AxisAlignedBB.f);
        var2.a(par1AxisAlignedBB.a, par1AxisAlignedBB.b, par1AxisAlignedBB.f);
        var2.a(par1AxisAlignedBB.a, par1AxisAlignedBB.e, par1AxisAlignedBB.f);
        var2.a();
    }

    public static void renderLiquidCuboid(Cuboid6 bound, lx tex, double res) {
        RenderUtils.renderLiquidQuad(new Vector3(bound.min.x, bound.min.y, bound.min.z), new Vector3(bound.max.x, bound.min.y, bound.min.z), new Vector3(bound.max.x, bound.min.y, bound.max.z), new Vector3(bound.min.x, bound.min.y, bound.max.z), tex, res);
        RenderUtils.renderLiquidQuad(new Vector3(bound.min.x, bound.max.y, bound.min.z), new Vector3(bound.min.x, bound.max.y, bound.max.z), new Vector3(bound.max.x, bound.max.y, bound.max.z), new Vector3(bound.max.x, bound.max.y, bound.min.z), tex, res);
        RenderUtils.renderLiquidQuad(new Vector3(bound.min.x, bound.max.y, bound.min.z), new Vector3(bound.min.x, bound.min.y, bound.min.z), new Vector3(bound.min.x, bound.min.y, bound.max.z), new Vector3(bound.min.x, bound.max.y, bound.max.z), tex, res);
        RenderUtils.renderLiquidQuad(new Vector3(bound.max.x, bound.max.y, bound.max.z), new Vector3(bound.max.x, bound.min.y, bound.max.z), new Vector3(bound.max.x, bound.min.y, bound.min.z), new Vector3(bound.max.x, bound.max.y, bound.min.z), tex, res);
        RenderUtils.renderLiquidQuad(new Vector3(bound.max.x, bound.max.y, bound.min.z), new Vector3(bound.max.x, bound.min.y, bound.min.z), new Vector3(bound.min.x, bound.min.y, bound.min.z), new Vector3(bound.min.x, bound.max.y, bound.min.z), tex, res);
        RenderUtils.renderLiquidQuad(new Vector3(bound.min.x, bound.max.y, bound.max.z), new Vector3(bound.min.x, bound.min.y, bound.max.z), new Vector3(bound.max.x, bound.min.y, bound.max.z), new Vector3(bound.max.x, bound.max.y, bound.max.z), tex, res);
    }

    public static void renderBlockOverlaySide(int x, int y, int z2, int side, double tx1, double tx2, double ty1, double ty2) {
        double[] points = new double[]{(double)x - 0.009, (double)x + 1.009, (double)y - 0.009, (double)y + 1.009, (double)z2 - 0.009, (double)z2 + 1.009};
        bgd tessellator = bgd.a;
        switch (side) {
            case 0: {
                tessellator.a(points[0], points[2], points[4], tx1, ty1);
                tessellator.a(points[1], points[2], points[4], tx2, ty1);
                tessellator.a(points[1], points[2], points[5], tx2, ty2);
                tessellator.a(points[0], points[2], points[5], tx1, ty2);
                break;
            }
            case 1: {
                tessellator.a(points[1], points[3], points[4], tx2, ty1);
                tessellator.a(points[0], points[3], points[4], tx1, ty1);
                tessellator.a(points[0], points[3], points[5], tx1, ty2);
                tessellator.a(points[1], points[3], points[5], tx2, ty2);
                break;
            }
            case 2: {
                tessellator.a(points[0], points[3], points[4], tx2, ty1);
                tessellator.a(points[1], points[3], points[4], tx1, ty1);
                tessellator.a(points[1], points[2], points[4], tx1, ty2);
                tessellator.a(points[0], points[2], points[4], tx2, ty2);
                break;
            }
            case 3: {
                tessellator.a(points[1], points[3], points[5], tx2, ty1);
                tessellator.a(points[0], points[3], points[5], tx1, ty1);
                tessellator.a(points[0], points[2], points[5], tx1, ty2);
                tessellator.a(points[1], points[2], points[5], tx2, ty2);
                break;
            }
            case 4: {
                tessellator.a(points[0], points[3], points[5], tx2, ty1);
                tessellator.a(points[0], points[3], points[4], tx1, ty1);
                tessellator.a(points[0], points[2], points[4], tx1, ty2);
                tessellator.a(points[0], points[2], points[5], tx2, ty2);
                break;
            }
            case 5: {
                tessellator.a(points[1], points[3], points[4], tx2, ty1);
                tessellator.a(points[1], points[3], points[5], tx1, ty1);
                tessellator.a(points[1], points[2], points[5], tx1, ty2);
                tessellator.a(points[1], points[2], points[4], tx2, ty2);
            }
        }
    }

    public static boolean shouldRenderLiquid(LiquidStack liquid) {
        return liquid.amount > 0 && liquid.asItemStack().b() != null;
    }

    public static void renderLiquidCuboid(LiquidStack liquid, Cuboid6 bound, double res) {
        if (!RenderUtils.shouldRenderLiquid(liquid)) {
            return;
        }
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        CCRenderState.setColourOpaque(liquid.asItemStack().b().a(liquid.asItemStack(), 0));
        TextureUtils.bindItemTexture(liquid.asItemStack());
        lx tex = RenderUtils.bindLiquidTexture(liquid.itemID, liquid.itemMeta);
        CCRenderState.startDrawing(7);
        RenderUtils.renderLiquidCuboid(bound, tex, res);
        CCRenderState.draw();
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
    }

    public static void renderItemUniform(wm item) {
        IItemRenderer customRenderer = MinecraftForgeClient.getItemRenderer((wm)item, (IItemRenderer.ItemRenderType)IItemRenderer.ItemRenderType.ENTITY);
        boolean is3D = customRenderer != null && customRenderer.shouldUseRenderHelper(IItemRenderer.ItemRenderType.ENTITY, item, IItemRenderer.ItemRendererHelper.BLOCK_3D);
        boolean larger = false;
        if (item.b() instanceof xn && bgf.a((int)apa.r[item.c].d())) {
            int renderType = apa.r[item.c].d();
            larger = renderType != 1 && renderType != 19 && renderType != 12 && renderType != 2;
        } else if (is3D) {
            larger = true;
        }
        double d = 2.0;
        double d1 = 1.0 / d;
        if (larger) {
            GL11.glScaled((double)d, (double)d, (double)d);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        entityItem.a(item);
        uniformRenderItem.a(entityItem, 0.0, larger ? 0.09 : 0.06, 0.0, 0.0f, 0.0f);
        if (larger) {
            GL11.glScaled((double)d1, (double)d1, (double)d1);
        }
    }

    public static void addVertexWithTransform(double x, double y, double z2, double u, double v2, Transformation t, IUVTransformation ut) {
        UV uv = new UV(u, v2).apply(ut);
        Vector3 vec = new Vector3(x, y, z2).apply(t);
        bgd.a.a(vec.x, vec.y, vec.z, uv.u, uv.v);
    }

    public static void renderBlock(Cuboid6 c, int sideMask, IFaceRenderer r) {
        double x1 = c.min.x;
        double x2 = c.max.x;
        double y1 = c.min.y;
        double y2 = c.max.y;
        double z1 = c.min.z;
        double z2 = c.max.z;
        double u1 = 0.0;
        double u2 = 0.0;
        double v1 = 0.0;
        double v2 = 0.0;
        if ((sideMask & 1) == 0) {
            u1 = x1;
            v1 = z1;
            u2 = x2;
            v2 = z2;
            face[0].set(x1, y1, z2, u1, v2);
            face[1].set(x1, y1, z1, u1, v1);
            face[2].set(x2, y1, z1, u2, v1);
            face[3].set(x2, y1, z2, u2, v2);
            r.renderFace(face, c.min.y > 0.0 ? 6 : 0);
        }
        if ((sideMask & 2) == 0) {
            u1 = x1 + 2.0;
            v1 = z1;
            u2 = x2 + 2.0;
            v2 = z2;
            face[0].set(x2, y2, z2, u2, v2);
            face[1].set(x2, y2, z1, u2, v1);
            face[2].set(x1, y2, z1, u1, v1);
            face[3].set(x1, y2, z2, u1, v2);
            r.renderFace(face, c.max.y < 1.0 ? 7 : 1);
        }
        if ((sideMask & 4) == 0) {
            u1 = 1.0 - x1 + 4.0;
            v1 = 1.0 - y2;
            u2 = 1.0 - x2 + 4.0;
            v2 = 1.0 - y1;
            face[0].set(x1, y1, z1, u1, v2);
            face[1].set(x1, y2, z1, u1, v1);
            face[2].set(x2, y2, z1, u2, v1);
            face[3].set(x2, y1, z1, u2, v2);
            r.renderFace(face, c.min.z > 0.0 ? 8 : 2);
        }
        if ((sideMask & 8) == 0) {
            u1 = x1 + 6.0;
            v1 = 1.0 - y2;
            u2 = x2 + 6.0;
            v2 = 1.0 - y1;
            face[0].set(x2, y1, z2, u2, v2);
            face[1].set(x2, y2, z2, u2, v1);
            face[2].set(x1, y2, z2, u1, v1);
            face[3].set(x1, y1, z2, u1, v2);
            r.renderFace(face, c.max.z < 1.0 ? 9 : 3);
        }
        if ((sideMask & 0x10) == 0) {
            u1 = z1 + 8.0;
            v1 = 1.0 - y2;
            u2 = z2 + 8.0;
            v2 = 1.0 - y1;
            face[0].set(x1, y1, z2, u2, v2);
            face[1].set(x1, y2, z2, u2, v1);
            face[2].set(x1, y2, z1, u1, v1);
            face[3].set(x1, y1, z1, u1, v2);
            r.renderFace(face, c.min.x > 0.0 ? 10 : 4);
        }
        if ((sideMask & 0x20) == 0) {
            u1 = 1.0 - z1 + 10.0;
            v1 = 1.0 - y2;
            u2 = 1.0 - z2 + 10.0;
            v2 = 1.0 - y1;
            face[0].set(x2, y1, z1, u1, v2);
            face[1].set(x2, y2, z1, u1, v1);
            face[2].set(x2, y2, z2, u2, v1);
            face[3].set(x2, y1, z2, u2, v2);
            r.renderFace(face, c.max.x < 1.0 ? 11 : 5);
        }
    }

    public static void renderBlock(Cuboid6 bounds, int sideMask, final Transformation t, final IUVTransformation u, final IVertexModifier m) {
        RenderUtils.renderBlock(bounds, sideMask, new IFaceRenderer(){
            boolean drawNormal = CCRenderState.useNormals();
            boolean computeNormal;
            Vector3 normal;
            Vertex5 vert;
            Vector3 vec;
            UV uv;
            {
                this.computeNormal = this.drawNormal || iVertexModifier != null && iVertexModifier.needsNormals();
                this.normal = new Vector3();
                this.vec = new Vector3();
                this.uv = new UV();
            }

            @Override
            public void renderFace(Vertex5[] face, int side) {
                bgd tess = bgd.a;
                int i = 0;
                while (i < face.length) {
                    if (this.computeNormal) {
                        if (t != null) {
                            t.applyN(this.normal.set(Rotation.axes[side % 6]));
                        } else {
                            this.normal = Rotation.axes[side % 6];
                        }
                        if (this.drawNormal) {
                            tess.b((float)this.normal.x, (float)this.normal.y, (float)this.normal.z);
                        }
                    }
                    this.vert = face[i];
                    if (t != null) {
                        t.apply(this.vec.set(this.vert.vec));
                    } else {
                        this.vec = this.vert.vec;
                    }
                    if (u != null) {
                        u.transform(this.uv.set(this.vert.uv));
                    } else {
                        this.uv = this.vert.uv;
                    }
                    if (m != null) {
                        m.applyModifiers(null, tess, this.vec, this.uv, this.normal, i);
                    }
                    tess.a(this.vec.x, this.vec.y, this.vec.z, this.uv.u, this.uv.v);
                    ++i;
                }
            }
        });
    }
}

