/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.render;

import codechicken.core.render.CCModel;
import codechicken.core.render.IUVTransformation;
import codechicken.core.render.UV;

public class MultiIconTransformation
implements IUVTransformation {
    public lx[] icons;

    public MultiIconTransformation(lx[] icons) {
        this.icons = icons;
    }

    @Override
    public void transform(UV texcoord) {
        int i = (int)texcoord.u >> 1;
        lx icon = this.icons[i % this.icons.length];
        texcoord.u = icon.a(texcoord.u % 2.0 * 16.0);
        texcoord.v = icon.b(texcoord.v % 2.0 * 16.0);
    }

    public static CCModel setIconIndex(CCModel m, int index) {
        return MultiIconTransformation.setIconIndex(m, 0, m.verts.length, index);
    }

    public static CCModel setIconIndex(CCModel m, int start, int length, int index) {
        int k = start;
        while (k < length) {
            UV uv = m.verts[k].uv;
            uv.u = uv.u % 2.0 + (double)(index * 2);
            uv.v %= 2.0;
            ++k;
        }
        return m;
    }
}

